/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ide.util.ModelUtil;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.plsql.old.PlsqlParser;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxRecognizer;
import oracle.javatools.parser.plsql.old.symbol.ErrorReporter;
import oracle.javatools.parser.plsql.old.symbol.ExpressionList;
import oracle.javatools.parser.plsql.old.symbol.ExpressionSymbol;
import oracle.jdevimpl.debugger.shared.DebugSharedPrimitives;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.runner.debug.BaseEvaluator;
import oracle.jdevimpl.runner.debug.DebugContext;
import oracle.jdevimpl.runner.debug.EvaluationInfo;

class PlsqlEvaluator
extends BaseEvaluator {
    private static final String BUILTIN_TYPE_INT = "PLS_INTEGER";
    private static final String FANCY_BUILTIN_TYPE_INT = "$Oracle.Builtin.PLS_INTEGER";
    private static final String BUILTIN_TYPE_DOUBLE = "NUMBER";
    private static final String FANCY_BUILTIN_TYPE_DOUBLE = "$Oracle.Builtin.NUMBER";
    private static final String BUILTIN_TYPE_BOOLEAN = "BOOLEAN";
    private static final String FANCY_BUILTIN_TYPE_BOOLEAN = "$Oracle.Builtin.BOOLEAN";
    private static final String BUILTIN_TYPE_STRING = "VARCHAR";
    private static final String FANCY_BUILTIN_TYPE_STRING = "$Oracle.Builtin.VARCHAR2";
    private static final String BUILTIN_TYPE_UNKNOWN = "UNKNOWN";
    private static final String FANCY_BUILTIN_TYPE_UNKNOWN = "$Oracle.Builtin.VARCHAR2";
    private static final int SIGNATURE_INT = 0;
    private static final int SIGNATURE_DOUBLE = 1;
    private static final int SIGNATURE_BOOLEAN = 2;
    private static final int SIGNATURE_STRING = 3;
    private static final int SIGNATURE_UNKNOWN = 4;

    PlsqlEvaluator(DebugContext debugContext) {
        super(debugContext);
    }

    static boolean validate(String string) {
        block3: {
            try {
                ReadTextBuffer readTextBuffer = TextBufferFactory.createReadTextBuffer((String)string);
                PlsqlParser.ParsingOptions parsingOptions = new PlsqlParser.ParsingOptions();
                parsingOptions.inputType = 2;
                parsingOptions.parseDepth = 2;
                ErrorReporter errorReporter = PlsqlParser.parse((ReadTextBuffer)readTextBuffer, (PlsqlParser.ParsingOptions)parsingOptions);
                if (errorReporter instanceof ExpressionSymbol) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)throwable;
            }
        }
        return false;
    }

    int evaluateConditionResult(Object object) {
        block4: {
            try {
                EvaluationInfo evaluationInfo = this.convertToEvaluationInfo(object);
                if (evaluationInfo != null && this.classNamesMatch(evaluationInfo.getClassInfo().getName(), BUILTIN_TYPE_BOOLEAN)) {
                    if (DebugSharedPrimitives.booleanDecode(evaluationInfo.getValue())) {
                        int n = 1;
                        return n;
                    }
                    int n = 0;
                    return n;
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block4;
                throw (ThreadDeath)throwable;
            }
        }
        return -1;
    }

    Object evaluate(String string) {
        String string2;
        Object object = this.evaluateInternal(string);
        if (object == null && !(string2 = string.toUpperCase()).equals(string)) {
            object = this.evaluateInternal(string2);
        }
        return object;
    }

    private Object evaluateInternal(String string) {
        block4: {
            try {
                ReadTextBuffer readTextBuffer = TextBufferFactory.createReadTextBuffer((String)string);
                PlsqlParser.ParsingOptions parsingOptions = new PlsqlParser.ParsingOptions();
                parsingOptions.inputType = 2;
                parsingOptions.parseDepth = 2;
                ErrorReporter errorReporter = PlsqlParser.parse((ReadTextBuffer)readTextBuffer, (PlsqlParser.ParsingOptions)parsingOptions);
                if (errorReporter instanceof ExpressionSymbol) {
                    Object object = this.processExpressionSymbol((ExpressionSymbol)errorReporter);
                    if (object instanceof String) {
                        object = this.evaluateSimple((String)object);
                    }
                    Object object2 = object;
                    return object2;
                }
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block4;
                throw (ThreadDeath)throwable;
            }
        }
        return null;
    }

    private Object processExpressionSymbol(ExpressionSymbol expressionSymbol) throws Exception {
        switch (expressionSymbol.getCategory()) {
            case 600: {
                return this.processExpressionSymbol(expressionSymbol.getFirstOperand());
            }
            case -1: {
                throw new Exception("Unable to process expression symbol: unknown");
            }
            case 610: {
                return this.processExpressionSymbol(expressionSymbol.getFirstOperand());
            }
            case 630: {
                throw new Exception("Unable to process expression symbol: sql");
            }
            case 711: {
                return this.evaluatePrefixOperator(expressionSymbol);
            }
            case 712: {
                return this.evaluateInfixOperator(expressionSymbol);
            }
            case 713: {
                return this.evaluateSpecialOperator(expressionSymbol);
            }
            case 750: {
                return this.evaluatePrimary(expressionSymbol);
            }
            case 760: {
                return this.evaluateArguments(expressionSymbol);
            }
        }
        throw new Exception("Unable to process expression symbol");
    }

    private EvaluationInfo evaluateInfixOperator(ExpressionSymbol expressionSymbol) throws Exception {
        Object object = this.processExpressionSymbol(expressionSymbol.getFirstOperand());
        EvaluationInfo evaluationInfo = this.convertToEvaluationInfo(object);
        int n = expressionSymbol.getExactCode();
        if (n == 1002 || n == 1108) {
            return this.evaluateLogicalInfixOperator(evaluationInfo, expressionSymbol, n);
        }
        Object object2 = this.processExpressionSymbol(expressionSymbol.getSecondOperand());
        EvaluationInfo evaluationInfo2 = this.convertToEvaluationInfo(object2);
        switch (n) {
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: {
                return this.evaluateComparisonOperator(object, evaluationInfo, object2, evaluationInfo2, n);
            }
            case 100: 
            case 103: 
            case 108: 
            case 111: 
            case 115: {
                return this.evaluateArithmeticInfixOperator(evaluationInfo, evaluationInfo2, n);
            }
            case 114: {
                return this.concatenate(evaluationInfo, evaluationInfo2);
            }
        }
        throw new Exception("Unable to evaluate infix operator");
    }

    private EvaluationInfo concatenate(EvaluationInfo evaluationInfo, EvaluationInfo evaluationInfo2) throws Exception {
        String string;
        EvaluationInfo evaluationInfo3;
        String string2 = evaluationInfo.getClassInfo().getName();
        EvaluationInfo evaluationInfo4 = (EvaluationInfo)this.performBuiltinPromotion(evaluationInfo, string2, BUILTIN_TYPE_STRING);
        if (evaluationInfo4 != evaluationInfo) {
            evaluationInfo.copyFrom(evaluationInfo4);
        }
        if ((evaluationInfo3 = (EvaluationInfo)this.performBuiltinPromotion(evaluationInfo2, string = evaluationInfo2.getClassInfo().getName(), BUILTIN_TYPE_STRING)) != evaluationInfo2) {
            evaluationInfo2.copyFrom(evaluationInfo3);
        }
        String string3 = evaluationInfo.getValue();
        String string4 = evaluationInfo2.getValue();
        if (string3.startsWith("'") && string3.endsWith("'")) {
            string3 = string3.substring(1, string3.length() - 1);
        }
        if (string4.startsWith("'") && string4.endsWith("'")) {
            string4 = string4.substring(1, string4.length() - 1);
        }
        String string5 = "'" + string3 + string4 + "'";
        return new EvaluationInfo(string5, this.findBuiltinStringClass());
    }

    private EvaluationInfo evaluateLogicalInfixOperator(EvaluationInfo evaluationInfo, ExpressionSymbol expressionSymbol, int n) throws Exception {
        boolean bl = false;
        Boolean bl2 = null;
        if (this.isBoolean(evaluationInfo)) {
            switch (n) {
                case 1108: {
                    Boolean bl3 = this.getBooleanValue(evaluationInfo);
                    if (bl3 == Boolean.TRUE) {
                        bl2 = Boolean.TRUE;
                        break;
                    }
                    Object object = this.processExpressionSymbol(expressionSymbol.getSecondOperand());
                    EvaluationInfo evaluationInfo2 = this.convertToEvaluationInfo(object);
                    if (this.isBoolean(evaluationInfo2)) {
                        Boolean bl4 = this.getBooleanValue(evaluationInfo2);
                        if (bl4 == Boolean.TRUE) {
                            bl2 = Boolean.TRUE;
                            break;
                        }
                        if (bl3 == null || bl4 == null) {
                            bl2 = null;
                            break;
                        }
                        bl2 = Boolean.FALSE;
                        break;
                    }
                    bl = true;
                    break;
                }
                case 1002: {
                    Boolean bl5 = this.getBooleanValue(evaluationInfo);
                    if (bl5 == Boolean.FALSE) {
                        bl2 = Boolean.FALSE;
                        break;
                    }
                    Object object = this.processExpressionSymbol(expressionSymbol.getSecondOperand());
                    EvaluationInfo evaluationInfo3 = this.convertToEvaluationInfo(object);
                    if (this.isBoolean(evaluationInfo3)) {
                        Boolean bl6 = this.getBooleanValue(evaluationInfo3);
                        if (bl6 == Boolean.FALSE) {
                            bl2 = Boolean.FALSE;
                            break;
                        }
                        if (bl5 == null || bl6 == null) {
                            bl2 = null;
                            break;
                        }
                        bl2 = Boolean.TRUE;
                        break;
                    }
                    bl = true;
                }
            }
        } else {
            bl = true;
        }
        if (!bl) {
            return this.makeBooleanValue(bl2);
        }
        throw new Exception("Unable to evaluate logical infix operator");
    }

    private EvaluationInfo evaluateComparisonOperator(Object object, EvaluationInfo evaluationInfo, Object object2, EvaluationInfo evaluationInfo2, int n) throws Exception {
        int n2 = this.comparisonPromotion(evaluationInfo, evaluationInfo2);
        switch (n2) {
            case 0: {
                int n3 = Integer.decode(evaluationInfo.getValue());
                int n4 = Integer.decode(evaluationInfo2.getValue());
                boolean bl = false;
                switch (n) {
                    case 119: {
                        bl = n3 == n4;
                        break;
                    }
                    case 122: {
                        bl = n3 != n4;
                        break;
                    }
                    case 120: {
                        bl = n3 < n4;
                        break;
                    }
                    case 121: {
                        bl = n3 > n4;
                        break;
                    }
                    case 123: {
                        bl = n3 <= n4;
                        break;
                    }
                    case 124: {
                        bl = n3 >= n4;
                    }
                }
                return this.makeBooleanValue(bl ? Boolean.TRUE : Boolean.FALSE);
            }
            case 1: {
                double d = Double.parseDouble(evaluationInfo.getValue());
                double d2 = Double.parseDouble(evaluationInfo2.getValue());
                boolean bl = false;
                switch (n) {
                    case 119: {
                        bl = d == d2;
                        break;
                    }
                    case 122: {
                        bl = d != d2;
                        break;
                    }
                    case 120: {
                        bl = d < d2;
                        break;
                    }
                    case 121: {
                        bl = d > d2;
                        break;
                    }
                    case 123: {
                        bl = d <= d2;
                        break;
                    }
                    case 124: {
                        bl = d >= d2;
                    }
                }
                return this.makeBooleanValue(bl ? Boolean.TRUE : Boolean.FALSE);
            }
            case 2: {
                boolean bl = Boolean.valueOf(evaluationInfo.getValue());
                boolean bl2 = Boolean.valueOf(evaluationInfo2.getValue());
                boolean bl3 = false;
                switch (n) {
                    case 119: {
                        bl3 = bl == bl2;
                        break;
                    }
                    case 122: {
                        bl3 = bl != bl2;
                        break;
                    }
                    case 120: 
                    case 121: 
                    case 123: 
                    case 124: {
                        throw new Exception("Unable to evaluate comparison operator");
                    }
                }
                return this.makeBooleanValue(bl3 ? Boolean.TRUE : Boolean.FALSE);
            }
            case 3: {
                String string = evaluationInfo.getValue();
                String string2 = evaluationInfo2.getValue();
                boolean bl = false;
                switch (n) {
                    case 119: {
                        bl = ModelUtil.areEqual((Object)string, (Object)string2);
                        break;
                    }
                    case 122: {
                        bl = ModelUtil.areEqual((Object)string, (Object)string2) ^ true;
                        break;
                    }
                    case 120: {
                        bl = string.compareTo(string2) < 0;
                        break;
                    }
                    case 121: {
                        bl = string.compareTo(string2) > 0;
                        break;
                    }
                    case 123: {
                        bl = string.compareTo(string2) <= 0;
                        break;
                    }
                    case 124: {
                        bl = string.compareTo(string2) >= 0;
                    }
                }
                return this.makeBooleanValue(bl ? Boolean.TRUE : Boolean.FALSE);
            }
            case 4: {
                String string = evaluationInfo.getValue();
                String string3 = evaluationInfo2.getValue();
                boolean bl = false;
                switch (n) {
                    case 119: {
                        bl = ModelUtil.areEqual((Object)string, (Object)string3);
                        break;
                    }
                    case 122: {
                        bl = ModelUtil.areEqual((Object)string, (Object)string3) ^ true;
                        break;
                    }
                    case 120: 
                    case 121: 
                    case 123: 
                    case 124: {
                        throw new Exception("Unable to evaluate comparison operator");
                    }
                }
                return this.makeBooleanValue(bl ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        throw new Exception("Unable to evaluate comparison operator");
    }

    private EvaluationInfo evaluateArithmeticInfixOperator(EvaluationInfo evaluationInfo, EvaluationInfo evaluationInfo2, int n) throws Exception {
        int n2 = this.binaryNumericPromotion(evaluationInfo, evaluationInfo2);
        switch (n2) {
            case 0: {
                int n3 = Integer.decode(evaluationInfo.getValue());
                int n4 = Integer.decode(evaluationInfo2.getValue());
                int n5 = 0;
                switch (n) {
                    case 100: {
                        n5 = n3 + n4;
                        break;
                    }
                    case 111: {
                        n5 = n3 - n4;
                        break;
                    }
                    case 108: {
                        n5 = n3 * n4;
                        break;
                    }
                    case 103: {
                        n5 = n3 / n4;
                        break;
                    }
                    case 115: {
                        n5 = (int)Math.pow(n3, n4);
                    }
                }
                return new EvaluationInfo(n5, this.findBuiltinIntClass());
            }
            case 1: {
                double d = Double.parseDouble(evaluationInfo.getValue());
                double d2 = Double.parseDouble(evaluationInfo2.getValue());
                double d3 = 0.0;
                switch (n) {
                    case 100: {
                        d3 = d + d2;
                        break;
                    }
                    case 111: {
                        d3 = d - d2;
                        break;
                    }
                    case 108: {
                        d3 = d * d2;
                        break;
                    }
                    case 103: {
                        d3 = d / d2;
                        break;
                    }
                    case 115: {
                        d3 = Math.pow(d, d2);
                    }
                }
                return new EvaluationInfo(d3, this.findBuiltinDoubleClass());
            }
        }
        throw new Exception("Unable to evaluate arithmetic infix operator");
    }

    private EvaluationInfo evaluateSpecialOperator(ExpressionSymbol expressionSymbol) throws Exception {
        int n = expressionSymbol.getExactCode();
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        switch (n) {
            case 1074: {
                Object object = this.processExpressionSymbol(expressionSymbol.getFirstOperand());
                EvaluationInfo evaluationInfo = this.convertToEvaluationInfo(object);
                boolean bl2 = PlsqlEvaluator.isNull(evaluationInfo);
                boolean bl3 = bl ? bl2 ^ true : bl2;
                return this.makeBooleanValue(bl3 ? Boolean.TRUE : Boolean.FALSE);
            }
            case 1011: {
                Object object = this.processExpressionSymbol(expressionSymbol.getFirstOperand());
                Object object2 = this.processExpressionSymbol(expressionSymbol.getSecondOperand());
                Object object3 = this.processExpressionSymbol(expressionSymbol.getThirdOperand());
                EvaluationInfo evaluationInfo = this.convertToEvaluationInfo(object);
                EvaluationInfo evaluationInfo2 = this.convertToEvaluationInfo(object2);
                EvaluationInfo evaluationInfo3 = this.convertToEvaluationInfo(object3);
                EvaluationInfo evaluationInfo4 = this.evaluateComparisonOperator(object, evaluationInfo, object2, evaluationInfo2, 124);
                EvaluationInfo evaluationInfo5 = this.evaluateComparisonOperator(object, evaluationInfo, object3, evaluationInfo3, 123);
                boolean bl4 = Boolean.valueOf(evaluationInfo4.getValue());
                boolean bl5 = Boolean.valueOf(evaluationInfo5.getValue());
                boolean bl6 = bl4 && bl5;
                return this.makeBooleanValue(bl6 ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        throw new Exception("Unable to process expression symbol: special operator");
    }

    private static boolean isNull(EvaluationInfo evaluationInfo) {
        String string = evaluationInfo.getValue(true);
        return string != null && string.equals("NULL");
    }

    private EvaluationInfo evaluatePrefixOperator(ExpressionSymbol expressionSymbol) throws Exception {
        Object object = this.processExpressionSymbol(expressionSymbol.getFirstOperand());
        EvaluationInfo evaluationInfo = this.convertToEvaluationInfo(object);
        int n = expressionSymbol.getExactCode();
        switch (n) {
            case 1096: {
                return this.evaluateLogicalPrefixOperator(evaluationInfo, n);
            }
            case 100: 
            case 111: {
                return this.evaluateArithmeticPrefixOperator(evaluationInfo, n);
            }
        }
        throw new Exception("Unable to evaluate prefix operator");
    }

    private EvaluationInfo evaluateArithmeticPrefixOperator(EvaluationInfo evaluationInfo, int n) throws Exception {
        int n2 = this.unaryNumericPromotion(evaluationInfo);
        switch (n2) {
            case 0: {
                int n3 = Integer.decode(evaluationInfo.getValue());
                int n4 = 0;
                switch (n) {
                    case 100: {
                        n4 = n3;
                        break;
                    }
                    case 111: {
                        n4 = -n3;
                    }
                }
                return new EvaluationInfo(n4, this.findBuiltinIntClass());
            }
            case 1: {
                double d = Double.parseDouble(evaluationInfo.getValue());
                double d2 = 0.0;
                switch (n) {
                    case 100: {
                        d2 = d;
                        break;
                    }
                    case 111: {
                        d2 = -d;
                    }
                }
                return new EvaluationInfo(d2, this.findBuiltinDoubleClass());
            }
        }
        throw new Exception("Unable to evaluate arithmetic prefix operator");
    }

    private EvaluationInfo evaluateLogicalPrefixOperator(EvaluationInfo evaluationInfo, int n) throws Exception {
        if (this.isBoolean(evaluationInfo)) {
            Boolean bl = Boolean.FALSE;
            switch (n) {
                case 1096: {
                    Boolean bl2 = this.getBooleanValue(evaluationInfo);
                    bl = PlsqlEvaluator.notBooleanValue(bl2);
                }
            }
            return this.makeBooleanValue(bl);
        }
        throw new Exception("Unable to evaluate logical prefix operator");
    }

    private boolean isBoolean(EvaluationInfo evaluationInfo) {
        String string = evaluationInfo.getClassInfo().getName();
        if (this.classNamesMatch(string, BUILTIN_TYPE_BOOLEAN)) {
            return true;
        }
        return this.classNamesMatch(string, BUILTIN_TYPE_UNKNOWN) && PlsqlEvaluator.isNull(evaluationInfo);
    }

    private Boolean getBooleanValue(EvaluationInfo evaluationInfo) throws Exception {
        try {
            if (PlsqlEvaluator.isNull(evaluationInfo)) {
                Boolean bl = null;
                return bl;
            }
            String string = evaluationInfo.getValue();
            if (string.equalsIgnoreCase("TRUE")) {
                Boolean bl = Boolean.TRUE;
                return bl;
            }
            if (string.equalsIgnoreCase("FALSE")) {
                Boolean bl = Boolean.FALSE;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new Exception("Unable to process boolean");
    }

    private static Boolean notBooleanValue(Boolean bl) {
        if (bl == Boolean.TRUE) {
            return Boolean.FALSE;
        }
        if (bl == Boolean.FALSE) {
            return Boolean.TRUE;
        }
        return null;
    }

    private EvaluationInfo makeBooleanValue(Boolean bl) throws Exception {
        String string = bl == Boolean.TRUE ? "TRUE" : (bl == Boolean.FALSE ? "FALSE" : "NULL");
        return new EvaluationInfo(string, this.findBuiltinBooleanClass());
    }

    private int comparisonPromotion(EvaluationInfo evaluationInfo, EvaluationInfo evaluationInfo2) throws Exception {
        String string = evaluationInfo.getClassInfo().getName();
        String string2 = evaluationInfo2.getClassInfo().getName();
        String string3 = null;
        int n = -1;
        if (this.classNamesMatch(string, BUILTIN_TYPE_DOUBLE) || this.classNamesMatch(string2, BUILTIN_TYPE_DOUBLE)) {
            string3 = BUILTIN_TYPE_DOUBLE;
            n = 1;
        } else if (this.classNamesMatch(string, BUILTIN_TYPE_INT) || this.classNamesMatch(string2, BUILTIN_TYPE_INT)) {
            string3 = BUILTIN_TYPE_INT;
            n = 0;
        } else if (this.classNamesMatch(string, BUILTIN_TYPE_BOOLEAN) || this.classNamesMatch(string2, BUILTIN_TYPE_BOOLEAN)) {
            string3 = BUILTIN_TYPE_BOOLEAN;
            n = 2;
        } else if (this.classNamesMatch(string, BUILTIN_TYPE_STRING) || this.classNamesMatch(string2, BUILTIN_TYPE_STRING)) {
            string3 = BUILTIN_TYPE_STRING;
            n = 3;
        } else if (this.classNamesMatch(string, BUILTIN_TYPE_UNKNOWN) || this.classNamesMatch(string2, BUILTIN_TYPE_UNKNOWN)) {
            string3 = BUILTIN_TYPE_UNKNOWN;
            n = 4;
        }
        if (string3 != null) {
            EvaluationInfo evaluationInfo3;
            EvaluationInfo evaluationInfo4 = (EvaluationInfo)this.performBuiltinPromotion(evaluationInfo, string, string3);
            if (evaluationInfo4 != evaluationInfo) {
                evaluationInfo.copyFrom(evaluationInfo4);
            }
            if ((evaluationInfo3 = (EvaluationInfo)this.performBuiltinPromotion(evaluationInfo2, string2, string3)) != evaluationInfo2) {
                evaluationInfo2.copyFrom(evaluationInfo3);
            }
            return n;
        }
        throw new Exception("Unable to evaluate comparison operator");
    }

    private int unaryNumericPromotion(EvaluationInfo evaluationInfo) throws Exception {
        DebugClassInfo debugClassInfo;
        String string = "";
        if (evaluationInfo != null && (debugClassInfo = evaluationInfo.getClassInfo()) != null) {
            string = debugClassInfo.getName();
        }
        return this.unaryNumericPromotion(evaluationInfo, string);
    }

    private int unaryNumericPromotion(EvaluationInfo evaluationInfo, String string) throws Exception {
        String string2 = null;
        int n = -1;
        if (this.classNamesMatch(string, BUILTIN_TYPE_DOUBLE)) {
            string2 = BUILTIN_TYPE_DOUBLE;
            n = 1;
        } else {
            string2 = BUILTIN_TYPE_INT;
            n = 0;
        }
        EvaluationInfo evaluationInfo2 = (EvaluationInfo)this.performBuiltinPromotion(evaluationInfo, string, string2);
        if (evaluationInfo2 != evaluationInfo) {
            evaluationInfo.copyFrom(evaluationInfo2);
        }
        return n;
    }

    private int binaryNumericPromotion(EvaluationInfo evaluationInfo, EvaluationInfo evaluationInfo2) throws Exception {
        DebugClassInfo debugClassInfo;
        DebugClassInfo debugClassInfo2;
        String string = "";
        String string2 = "";
        if (evaluationInfo != null && (debugClassInfo2 = evaluationInfo.getClassInfo()) != null) {
            string = debugClassInfo2.getName();
        }
        if (evaluationInfo2 != null && (debugClassInfo = evaluationInfo2.getClassInfo()) != null) {
            string2 = debugClassInfo.getName();
        }
        return this.binaryNumericPromotion(evaluationInfo, string, evaluationInfo2, string2);
    }

    private int binaryNumericPromotion(EvaluationInfo evaluationInfo, String string, EvaluationInfo evaluationInfo2, String string2) throws Exception {
        EvaluationInfo evaluationInfo3;
        String string3 = null;
        int n = -1;
        if (this.classNamesMatch(string, BUILTIN_TYPE_DOUBLE) || this.classNamesMatch(string2, BUILTIN_TYPE_DOUBLE)) {
            string3 = BUILTIN_TYPE_DOUBLE;
            n = 1;
        } else {
            string3 = BUILTIN_TYPE_INT;
            n = 0;
        }
        EvaluationInfo evaluationInfo4 = (EvaluationInfo)this.performBuiltinPromotion(evaluationInfo, string, string3);
        if (evaluationInfo4 != evaluationInfo) {
            evaluationInfo.copyFrom(evaluationInfo4);
        }
        if ((evaluationInfo3 = (EvaluationInfo)this.performBuiltinPromotion(evaluationInfo2, string2, string3)) != evaluationInfo2) {
            evaluationInfo2.copyFrom(evaluationInfo3);
        }
        return n;
    }

    private Object evaluatePrimary(ExpressionSymbol expressionSymbol) throws Exception {
        int n = expressionSymbol.getExactCode();
        if (PlsqlSyntaxRecognizer.isLiteralToken((int)n) || n == 1051 || n == 1162) {
            return this.evaluateConstant(expressionSymbol);
        }
        String string = expressionSymbol.getName().getValue();
        if (expressionSymbol instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)expressionSymbol;
            ExpressionSymbol[] expressionSymbolArray = expressionList.getExpressions();
            int n2 = expressionSymbolArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Object object = this.processExpressionSymbol(expressionSymbolArray[n3]);
                if (!(object instanceof String)) {
                    throw new Exception("Unable to process expression symbol: primary");
                }
                string = string + object;
                ++n3;
            }
        }
        return string;
    }

    private EvaluationInfo evaluateConstant(ExpressionSymbol expressionSymbol) throws Exception {
        String string = expressionSymbol.getName().getValue();
        switch (expressionSymbol.getExactCode()) {
            case 51: {
                return new EvaluationInfo(DebugSharedPrimitives.intDecode(string), this.findBuiltinIntClass());
            }
            case 52: {
                return new EvaluationInfo(DebugSharedPrimitives.doubleDecode(string), this.findBuiltinDoubleClass());
            }
            case 53: {
                return this.makeBooleanValue(DebugSharedPrimitives.booleanDecode(string) ? Boolean.TRUE : Boolean.FALSE);
            }
            case 1051: {
                return this.makeBooleanValue(Boolean.FALSE);
            }
            case 1162: {
                return this.makeBooleanValue(Boolean.TRUE);
            }
            case 54: {
                return new EvaluationInfo(string, this.findBuiltinStringClass());
            }
            case 55: {
                return new EvaluationInfo("NULL", this.findBuiltinUnknownClass(), null);
            }
        }
        throw new Exception("Evaluate Constant unknown constant type");
    }

    private Object evaluateArguments(ExpressionSymbol expressionSymbol) throws Exception {
        if (expressionSymbol instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)expressionSymbol;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            ExpressionSymbol[] expressionSymbolArray = expressionList.getExpressions();
            int n = expressionSymbolArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = this.processExpressionSymbol(expressionSymbolArray[n2]);
                if (object == null) {
                    throw new Exception("Unable to evaluate arguments");
                }
                EvaluationInfo evaluationInfo = this.convertToEvaluationInfo(object);
                stringBuffer.append(evaluationInfo.getValue());
                if (n2 < n - 1) {
                    stringBuffer.append(",");
                }
                ++n2;
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        throw new Exception("Unable to process expression symbol: arguments");
    }

    private Object performBuiltinPromotion(EvaluationInfo evaluationInfo, String string, String string2) throws Exception {
        if (this.classNamesMatch(string2, BUILTIN_TYPE_BOOLEAN)) {
            boolean bl = false;
            if (!this.classNamesMatch(string, BUILTIN_TYPE_BOOLEAN) && !this.classNamesMatch(string, BUILTIN_TYPE_UNKNOWN)) {
                throw new Exception("Unable to perform promotion from " + string + " to " + BUILTIN_TYPE_BOOLEAN);
            }
            bl = DebugSharedPrimitives.booleanDecode(evaluationInfo.getValue(true));
            return this.makeBooleanValue(bl ? Boolean.TRUE : Boolean.FALSE);
        }
        if (this.classNamesMatch(string2, BUILTIN_TYPE_STRING)) {
            String string3 = "";
            if (this.classNamesMatch(string, BUILTIN_TYPE_STRING)) {
                string3 = evaluationInfo.getValue(true);
            } else if (this.classNamesMatch(string, BUILTIN_TYPE_BOOLEAN) || this.classNamesMatch(string, BUILTIN_TYPE_INT) || this.classNamesMatch(string, BUILTIN_TYPE_DOUBLE) || this.classNamesMatch(string, BUILTIN_TYPE_UNKNOWN)) {
                string3 = "'" + evaluationInfo.getValue(true) + "'";
            } else {
                throw new Exception("Unable to perform promotion from " + string + " to " + BUILTIN_TYPE_STRING);
            }
            return new EvaluationInfo(string3, this.findBuiltinStringClass());
        }
        if (this.classNamesMatch(string2, BUILTIN_TYPE_INT)) {
            int n = 0;
            if (this.classNamesMatch(string, BUILTIN_TYPE_INT) || this.classNamesMatch(string, BUILTIN_TYPE_UNKNOWN)) {
                n = DebugSharedPrimitives.intDecode(evaluationInfo.getValue(true));
            } else if (this.classNamesMatch(string, BUILTIN_TYPE_DOUBLE)) {
                double d = DebugSharedPrimitives.doubleDecode(evaluationInfo.getValue(true));
                n = (int)d;
            } else {
                throw new Exception("Unable to perform promotion from " + string + " to " + BUILTIN_TYPE_INT);
            }
            return new EvaluationInfo(n, this.findBuiltinIntClass());
        }
        if (this.classNamesMatch(string2, BUILTIN_TYPE_DOUBLE)) {
            double d = 0.0;
            if (this.classNamesMatch(string, BUILTIN_TYPE_INT)) {
                int n = Integer.decode(evaluationInfo.getValue(true));
                d = n;
            } else if (this.classNamesMatch(string, BUILTIN_TYPE_DOUBLE) || this.classNamesMatch(string, BUILTIN_TYPE_UNKNOWN)) {
                d = DebugSharedPrimitives.doubleDecode(evaluationInfo.getValue(true));
            } else {
                throw new Exception("Unable to perform promotion from " + string + " to " + BUILTIN_TYPE_DOUBLE);
            }
            return new EvaluationInfo(d, this.findBuiltinDoubleClass());
        }
        if (this.classNamesMatch(string2, BUILTIN_TYPE_UNKNOWN)) {
            throw new Exception("Unable to perform promotion from " + string + " to " + BUILTIN_TYPE_UNKNOWN);
        }
        throw new Exception("Unable to perform promotion from " + string + " to " + string2);
    }

    private EvaluationInfo convertToEvaluationInfo(Object object) throws Exception {
        DebugDataInfo debugDataInfo;
        if (object instanceof EvaluationInfo) {
            return (EvaluationInfo)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.equalsIgnoreCase("NULL")) {
                return new EvaluationInfo("NULL", this.findBuiltinUnknownClass(), null);
            }
            Object object2 = this.evaluateSimple(string);
            if (object2 != null) {
                object = object2;
            }
            if (object instanceof EvaluationInfo) {
                return (EvaluationInfo)object;
            }
        }
        if ((debugDataInfo = PlsqlEvaluator.getDataInfo(object)) != null) {
            return new EvaluationInfo(debugDataInfo.getValue(), debugDataInfo.getClassInfo(), debugDataInfo);
        }
        throw new Exception("Unable to evaluate: " + object);
    }

    private String getBuiltinClass(String string) {
        if (string.equals(FANCY_BUILTIN_TYPE_INT)) {
            return BUILTIN_TYPE_INT;
        }
        if (string.equals(FANCY_BUILTIN_TYPE_DOUBLE)) {
            return BUILTIN_TYPE_DOUBLE;
        }
        if (string.equals(FANCY_BUILTIN_TYPE_BOOLEAN)) {
            return BUILTIN_TYPE_BOOLEAN;
        }
        if (string.equals("$Oracle.Builtin.VARCHAR2")) {
            return BUILTIN_TYPE_STRING;
        }
        String string2 = string.toUpperCase();
        if (string2.equals("BINARY_INTEGER") || string2.equals("INT") || string2.equals("INTEGER") || string2.equals("NATURAL") || string2.equals("NATURALN") || string2.equals(BUILTIN_TYPE_INT) || string2.equals("POSITIVE") || string2.equals("POSITIVEN") || string2.equals("SIGNTYPE") || string2.equals("SMALLINT")) {
            return BUILTIN_TYPE_INT;
        }
        if (string2.equals("DEC") || string2.equals("DECIMAL") || string2.equals("DOUBLE PRECISION") || string2.equals("FLOAT") || string2.startsWith(BUILTIN_TYPE_DOUBLE) || string2.equals("NUMERIC") || string2.equals("REAL")) {
            return BUILTIN_TYPE_DOUBLE;
        }
        if (string2.equals(BUILTIN_TYPE_BOOLEAN)) {
            return BUILTIN_TYPE_BOOLEAN;
        }
        if (string2.startsWith("VARCHAR2") || string2.startsWith("CHAR") || string2.startsWith("LONG") || string2.startsWith("NCHAR") || string2.startsWith("NVARCHAR2") || string2.startsWith(BUILTIN_TYPE_STRING)) {
            return BUILTIN_TYPE_STRING;
        }
        if (string2.equals(BUILTIN_TYPE_UNKNOWN)) {
            return BUILTIN_TYPE_UNKNOWN;
        }
        return null;
    }

    private boolean classNamesMatch(String string, String string2) {
        String string3;
        String string4 = this.getBuiltinClass(string);
        if (string4 != null && (string3 = this.getBuiltinClass(string2)) != null) {
            return string4 == string3;
        }
        return false;
    }

    protected DebugClassInfo findPrimitiveIntClass() {
        return this.findBuiltinIntClass();
    }

    private DebugClassInfo findBuiltinIntClass() {
        DebugClassInfo debugClassInfo = this.findClass(BUILTIN_TYPE_INT);
        if (debugClassInfo == null) {
            debugClassInfo = this.findClass(FANCY_BUILTIN_TYPE_INT);
        }
        return debugClassInfo;
    }

    private DebugClassInfo findBuiltinDoubleClass() {
        DebugClassInfo debugClassInfo = this.findClass(BUILTIN_TYPE_DOUBLE);
        if (debugClassInfo == null) {
            debugClassInfo = this.findClass(FANCY_BUILTIN_TYPE_DOUBLE);
        }
        return debugClassInfo;
    }

    private DebugClassInfo findBuiltinBooleanClass() {
        DebugClassInfo debugClassInfo = this.findClass(BUILTIN_TYPE_BOOLEAN);
        if (debugClassInfo == null) {
            debugClassInfo = this.findClass(FANCY_BUILTIN_TYPE_BOOLEAN);
        }
        return debugClassInfo;
    }

    private DebugClassInfo findBuiltinStringClass() {
        DebugClassInfo debugClassInfo = this.findClass(BUILTIN_TYPE_STRING);
        if (debugClassInfo == null) {
            debugClassInfo = this.findClass("$Oracle.Builtin.VARCHAR2");
        }
        return debugClassInfo;
    }

    private DebugClassInfo findBuiltinUnknownClass() {
        DebugClassInfo debugClassInfo = this.findClass(BUILTIN_TYPE_UNKNOWN);
        if (debugClassInfo == null) {
            debugClassInfo = this.findClass("$Oracle.Builtin.VARCHAR2");
        }
        return debugClassInfo;
    }
}

