/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.runner.Debugger;
import oracle.jdeveloper.JDeveloperMenuConstants;

public final class PolygonViewer
implements ContextMenuListener,
Controller,
Addin {
    private static PolygonViewer instance;
    private static final int VIEW_POLYGON_CMD_ID;
    private static IdeAction actionViewPolygon;
    private static JMenuItem menuitemViewPolygon;

    static {
        VIEW_POLYGON_CMD_ID = Ide.findOrCreateCmdID((String)"DebuggerViewPolygon");
    }

    public PolygonViewer() throws SingletonClassException {
        if (instance != null) {
            throw new SingletonClassException("oracle.jdevimpl.runner.debug.PolygonViewer");
        }
        instance = this;
    }

    public void initialize() {
        actionViewPolygon = IdeAction.get((int)VIEW_POLYGON_CMD_ID, (String)"View Polygon...", (Integer)new Integer(83));
        actionViewPolygon.addController((Controller)this);
        Debugger debugger = Debugger.getDebugger();
        ContextMenu contextMenu = debugger.getContextMenu();
        contextMenu.addContextMenuListener((ContextMenuListener)this);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == VIEW_POLYGON_CMD_ID) {
            Polygon polygon;
            if (ideAction.isEnabled() && (polygon = PolygonViewer.getPolygon(context)) != null) {
                PolygonViewer.showViewer(polygon);
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == VIEW_POLYGON_CMD_ID) {
            ideAction.setEnabled(PolygonViewer.isPolygon(context));
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        this.update(actionViewPolygon, context);
        if (actionViewPolygon.isEnabled()) {
            if (menuitemViewPolygon == null) {
                menuitemViewPolygon = contextMenu.createMenuItem((ToggleAction)actionViewPolygon);
            }
            contextMenu.add((Component)menuitemViewPolygon, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private static boolean isPolygon(Context context) {
        try {
            ObjectReference objectReference;
            ReferenceType referenceType;
            Object object;
            if (context != null && (object = context.getProperty("com.sun.jdi.Value")) instanceof ObjectReference && (referenceType = (objectReference = (ObjectReference)object).referenceType()) instanceof ClassType) {
                ClassType classType = (ClassType)referenceType;
                do {
                    if (!classType.name().equals("java.awt.Polygon")) continue;
                    boolean bl = true;
                    return bl;
                } while ((classType = classType.superclass()) != null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private static Polygon getPolygon(Context context) {
        try {
            if (PolygonViewer.isPolygon(context)) {
                ObjectReference objectReference = (ObjectReference)context.getProperty("com.sun.jdi.Value");
                ReferenceType referenceType = objectReference.referenceType();
                int n = PolygonViewer.getIntField(objectReference, referenceType, "npoints");
                int[] nArray = PolygonViewer.getIntArrayField(objectReference, referenceType, "xpoints");
                int[] nArray2 = PolygonViewer.getIntArrayField(objectReference, referenceType, "ypoints");
                Polygon polygon = new Polygon(nArray, nArray2, n);
                return polygon;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static int getIntField(ObjectReference objectReference, ReferenceType referenceType, String string) throws Exception {
        return ((IntegerValue)objectReference.getValue(referenceType.fieldByName(string))).value();
    }

    private static int[] getIntArrayField(ObjectReference objectReference, ReferenceType referenceType, String string) throws Exception {
        ArrayReference arrayReference = (ArrayReference)objectReference.getValue(referenceType.fieldByName(string));
        List<Value> list = arrayReference.getValues();
        int[] nArray = new int[list.size()];
        int n = 0;
        for (IntegerValue integerValue : list) {
            nArray[n++] = integerValue.value();
        }
        return nArray;
    }

    private static void showViewer(Polygon polygon) {
        int n = 10;
        Rectangle rectangle = polygon.getBounds();
        polygon.translate(-rectangle.x + 10, -rectangle.y + 10);
        Rectangle rectangle2 = polygon.getBounds();
        Dimension dimension = new Dimension(rectangle2.x + rectangle2.width + 10, rectangle2.y + rectangle2.height + 10);
        1 var5_5 = new 1(polygon);
        var5_5.setPreferredSize(dimension);
        JScrollPane jScrollPane = new JScrollPane(var5_5);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        OnePageWizardDialogFactory.runDialog((Component)jPanel, null, (String)"Polygon Viewer", (int)1);
    }

    public static final class 1
    extends JComponent {
        private final /* synthetic */ Polygon v$polygon;

        public boolean isFocusTraversable() {
            return false;
        }

        protected void paintComponent(Graphics graphics) {
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(Color.BLACK);
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).fill(this.v$polygon);
            }
        }

        public 1(Polygon polygon) {
            this.v$polygon = polygon;
        }
    }
}

