/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurationEditorUtil;
import oracle.jdevimpl.debugger.support.DebugConnectArg;
import oracle.jdevimpl.debugger.support.DebugFactory;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugConfiguration;

public final class RemoteDebugSettingsPanel
extends DefaultTraversablePanel
implements ItemListener {
    private static final int INDEX_OJVM = 0;
    private static final int INDEX_JPDA = 1;
    private static final int INDEX_JPDALISTEN = 2;
    private static final int COUNT = 3;
    private final Protocol[] protocols;
    private final JComboBox protocolComboBox;
    private final CardLayout cardLayout;
    private final JPanel cardPanel;
    private final JCheckBox promptCheckBox;

    public RemoteDebugSettingsPanel() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_remotesetpanel_html");
        this.protocols = new Protocol[3];
        this.protocols[0] = new Protocol(0, "ojvm", DbgArb.getString(366));
        this.protocols[1] = new Protocol(1, "jpda", DbgArb.getString(367));
        this.protocols[2] = new Protocol(2, "jpdaListen", DbgArb.getString(368));
        JLabel jLabel = new JLabel();
        this.protocolComboBox = new JComboBox();
        this.protocolComboBox.setModel(new NonNullableComboBoxModel((Object[])this.protocols));
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.fillCardPanel();
        this.promptCheckBox = new JCheckBox();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.protocolComboBox, (String)DbgArb.getString(365));
        ResourceUtils.resButton((AbstractButton)this.promptCheckBox, (String)DbgArb.getString(375));
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add(jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.protocolComboBox, new GridBagConstraints(1, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add(this.cardPanel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 2, new Insets(5, 20, 0, 0), 0, 0));
        this.add(this.promptCheckBox, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, n, 0, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.protocolComboBox.addItemListener(this);
    }

    public void onEntry(TraversableContext traversableContext) {
        DebugConfiguration debugConfiguration = RemoteDebugSettingsPanel.getDebugConfiguration(traversableContext);
        this.loadFrom(debugConfiguration);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DebugConfiguration debugConfiguration = RemoteDebugSettingsPanel.getDebugConfiguration(traversableContext);
        this.commitTo(debugConfiguration);
    }

    private static DebugConfiguration getDebugConfiguration(TraversableContext traversableContext) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)traversableContext);
        return DebugConfiguration.getInstance(runConfiguration);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this.protocolComboBox.getSelectedItem().toString();
        this.cardLayout.show(this.cardPanel, string);
    }

    private void loadFrom(DebugConfiguration debugConfiguration) {
        String string = debugConfiguration.getRemoteProtocol();
        int n = string.equals("ojvm") ? 0 : (string.equals("jpda") ? 1 : (string.equals("jpdaListen") ? 2 : 0));
        this.protocolComboBox.setSelectedIndex(n);
        int n2 = this.protocols.length;
        int n3 = 0;
        while (n3 < n2) {
            this.protocols[n3].loadFrom(debugConfiguration);
            ++n3;
        }
        this.promptCheckBox.setSelected(debugConfiguration.isPromptForRemoteDebugging());
    }

    private void commitTo(DebugConfiguration debugConfiguration) {
        int n = this.protocolComboBox.getSelectedIndex();
        debugConfiguration.setRemoteProtocol(this.protocols[n].getProtocol());
        int n2 = this.protocols.length;
        int n3 = 0;
        while (n3 < n2) {
            this.protocols[n3].commitTo(debugConfiguration);
            ++n3;
        }
        debugConfiguration.setPromptForRemoteDebugging(this.promptCheckBox.isSelected());
    }

    private void fillCardPanel() {
        int n = this.protocols.length;
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                Protocol protocol = this.protocols[n2];
                this.cardPanel.add((Component)protocol.getPanel(), protocol.toString());
                ++n2;
            }
            this.cardLayout.first(this.cardPanel);
        }
    }

    public static class Protocol {
        private final String protocol;
        private final String label;
        private final DebugConnectArg[] connectArgs;
        private final JLabel[] connectParamLabels;
        private final JTextField[] connectParams;
        private final JLabel info1;
        private final JTextArea info2;
        private final JPanel panel;

        Protocol(int n, String string, String string2) {
            this.protocol = string;
            this.label = string2;
            this.connectArgs = DebugFactory.newInstance(n).getConnectArgs();
            int n2 = this.connectArgs.length;
            this.connectParamLabels = new JLabel[n2];
            this.connectParams = new JTextField[n2];
            int n3 = 0;
            while (n3 < n2) {
                DebugConnectArg debugConnectArg = this.connectArgs[n3];
                this.connectParamLabels[n3] = new JLabel(debugConnectArg.getLabel());
                this.connectParams[n3] = new JTextField(debugConnectArg.getValue());
                ++n3;
            }
            this.info1 = new JLabel();
            this.info1.setHorizontalAlignment(2);
            this.info2 = new JTextArea();
            this.info2.setBackground(this.info1.getBackground());
            this.info2.setEditable(false);
            this.info2.setLineWrap(true);
            this.info2.setWrapStyleWord(true);
            switch (n) {
                case 0: {
                    this.info1.setText(DbgArb.getString(369));
                    this.info2.setText(DbgArb.getString(370));
                    break;
                }
                case 1: {
                    this.info1.setText(DbgArb.getString(371));
                    this.info2.setText(DbgArb.getString(372));
                    break;
                }
                case 2: {
                    this.info1.setText(DbgArb.getString(373));
                    this.info2.setText(DbgArb.getString(374));
                }
            }
            this.panel = new JPanel(new GridBagLayout());
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.connectArgs.length) {
                this.panel.add((Component)this.connectParamLabels[n5], new GridBagConstraints(0, n4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
                this.panel.add((Component)this.connectParams[n5], new GridBagConstraints(1, n4++, 0, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
                ++n5;
            }
            this.panel.add((Component)this.info1, new GridBagConstraints(0, n4++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.panel.add((Component)this.info2, new GridBagConstraints(0, n4++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel(), new GridBagConstraints(0, n4, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        String getProtocol() {
            return this.protocol;
        }

        public String toString() {
            return this.label;
        }

        JPanel getPanel() {
            return this.panel;
        }

        void loadFrom(DebugConfiguration debugConfiguration) {
            int n = 0;
            while (n < this.connectArgs.length) {
                DebugConnectArg debugConnectArg = this.connectArgs[n];
                String string = debugConfiguration.getRemoteParameterValue(this.protocol, debugConnectArg.getName());
                this.connectParams[n].setText(string);
                ++n;
            }
        }

        void commitTo(DebugConfiguration debugConfiguration) {
            int n = 0;
            while (n < this.connectArgs.length) {
                DebugConnectArg debugConnectArg = this.connectArgs[n];
                String string = this.connectParams[n].getText();
                debugConfiguration.putRemoteParameterValue(this.protocol, debugConnectArg.getName(), string);
                ++n;
            }
        }
    }
}

