/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.model.Node;
import oracle.ide.runner.SmartDataProvider;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceHasType;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.model.JavaSourceNode;

public class SmartJava
implements SmartDataProvider {
    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            System.out.println("................................................................................");
            System.out.println("exp is \"" + string + "\"");
            String[] stringArray2 = SmartJava.test(string);
            int n2 = 0;
            while (n2 < stringArray2.length) {
                System.out.println("expressions " + n2 + " is \"" + stringArray2[n2] + "\"");
                ++n2;
            }
            System.out.println();
            ++n;
        }
    }

    public static String[] test(String string) {
        SmartJava smartJava = new SmartJava();
        ArrayList arrayList = new ArrayList();
        ReadTextBuffer readTextBuffer = TextBufferFactory.createReadTextBuffer((String)string);
        smartJava.getExpressions(readTextBuffer, 0, string.length(), arrayList);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean canUnderstand(Node node) {
        return node instanceof JavaSourceNode;
    }

    public void getExpressions(ReadTextBuffer readTextBuffer, int n, int n2, List list) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        ExpressionGatherer expressionGatherer = new ExpressionGatherer(linkedHashSet, null);
        try {
            int n3;
            int n4;
            JavaLexer javaLexer = new JavaLexer();
            LexerToken lexerToken = javaLexer.createLexerToken();
            javaLexer.setTextBuffer(readTextBuffer);
            javaLexer.setPosition(n);
            javaLexer.setSkipComments(true);
            while ((n4 = javaLexer.lex(lexerToken)) != 0 && (n3 = lexerToken.getStartOffset()) <= n2) {
                switch (n4) {
                    case 4: 
                    case 136: {
                        int n5 = SmartJava.useJavaParser(readTextBuffer, n3, n2, expressionGatherer);
                        javaLexer.setPosition(n5);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        list.addAll(linkedHashSet);
    }

    private static int useJavaParser(ReadTextBuffer readTextBuffer, int n, int n2, ExpressionGatherer expressionGatherer) {
        readTextBuffer.readLock();
        try {
            int n3;
            String string = readTextBuffer.getString(n, n2 - n);
            SourceFile sourceFile = SourceFactory.createFile((int)3);
            SourceFactory sourceFactory = sourceFile.getFactory();
            SourceExpression sourceExpression = sourceFactory.createExpressionFromText(string);
            ExpressionGatherer.mav$gatherExpressions(expressionGatherer, sourceExpression);
            int n4 = n2;
            String string2 = sourceExpression.getText();
            if (string2 != null && string2.length() > 0 && (n3 = string.indexOf(string2)) != -1) {
                n4 = n + n3 + string2.length();
            }
            int n5 = n4;
            readTextBuffer.readUnlock();
            return n5;
        }
        catch (Throwable throwable) {
            readTextBuffer.readUnlock();
            throw throwable;
        }
    }

    public static class ExpressionGatherer {
        private final Set setOfExpressions;
        private final Map mapResults;

        private ExpressionGatherer(Set set) {
            this.setOfExpressions = set;
            this.mapResults = new HashMap();
        }

        private void gatherExpressions(SourceExpression sourceExpression) {
            this.processSourceExpression(sourceExpression);
            this.mapResults.clear();
        }

        private void processSourceExpression(SourceExpression sourceExpression) {
            if (sourceExpression != null) {
                int n = sourceExpression.getOperandCount();
                int n2 = 0;
                while (n2 < n) {
                    this.processSourceExpression(sourceExpression.getOperandAt(n2));
                    ++n2;
                }
                StringBuffer[] stringBufferArray = null;
                switch (sourceExpression.getOperatorCode()) {
                    case 45: 
                    case 46: {
                        stringBufferArray = (StringBuffer[])this.mapResults.get(sourceExpression.getFirstOperand());
                        break;
                    }
                    case 41: {
                        stringBufferArray = this.prependOperatorToEachResult(sourceExpression.getFirstOperand(), "!");
                        break;
                    }
                    case 9: {
                        stringBufferArray = this.prependOperatorToEachResult(sourceExpression.getFirstOperand(), "~");
                        break;
                    }
                    case 44: {
                        stringBufferArray = this.prependOperatorToEachResult(sourceExpression.getFirstOperand(), "+");
                        break;
                    }
                    case 37: {
                        stringBufferArray = this.prependOperatorToEachResult(sourceExpression.getFirstOperand(), "-");
                        break;
                    }
                    case 47: {
                        stringBufferArray = this.appendToEachResult(sourceExpression.getFirstOperand(), "-1");
                        break;
                    }
                    case 48: {
                        stringBufferArray = this.appendToEachResult(sourceExpression.getFirstOperand(), "+1");
                        break;
                    }
                    case 19: {
                        stringBufferArray = this.appendToEachResult(sourceExpression.getFirstOperand(), "." + ((SourceHasName)sourceExpression).getName());
                        break;
                    }
                    case 27: {
                        stringBufferArray = this.processLiteral(sourceExpression);
                        break;
                    }
                    case 53: {
                        stringBufferArray = this.processSimpleName(sourceExpression);
                        break;
                    }
                    case 24: {
                        stringBufferArray = this.processMethodCall(sourceExpression);
                        break;
                    }
                    case 16: {
                        stringBufferArray = this.processArrayAccess(sourceExpression);
                        break;
                    }
                    case 40: {
                        this.processNewObject(sourceExpression);
                        break;
                    }
                    case 38: {
                        stringBufferArray = (StringBuffer[])this.mapResults.get(sourceExpression.getFirstOperand());
                    }
                }
                this.mapResults.put(sourceExpression, stringBufferArray);
            }
        }

        private StringBuffer[] appendToEachResult(SourceExpression sourceExpression, String string) {
            StringBuffer[] stringBufferArray = (StringBuffer[])this.mapResults.get(sourceExpression);
            if (stringBufferArray != null) {
                return SmartJavaOperator.performSingleOperation(stringBufferArray, new 4(this, string));
            }
            return null;
        }

        private StringBuffer[] prependOperatorToEachResult(SourceExpression sourceExpression, String string) {
            StringBuffer[] stringBufferArray = (StringBuffer[])this.mapResults.get(sourceExpression);
            if (stringBufferArray != null) {
                return SmartJavaOperator.performSingleOperation(stringBufferArray, new 3(this, string));
            }
            return null;
        }

        private StringBuffer[] processLiteral(SourceExpression sourceExpression) {
            String string = sourceExpression.getText();
            return new StringBuffer[]{new StringBuffer(string)};
        }

        private StringBuffer[] processSimpleName(SourceExpression sourceExpression) {
            String string = ((SourceHasName)sourceExpression).getName();
            this.addExpression(string);
            return new StringBuffer[]{new StringBuffer(string)};
        }

        private StringBuffer[] processMethodCall(SourceExpression sourceExpression) {
            StringBuffer[] stringBufferArray;
            String string = ((SourceHasName)sourceExpression).getName();
            StringBuffer[] stringBufferArray2 = this.getFieldNamesFromMethodName(string);
            StringBuffer[] stringBufferArray3 = stringBufferArray = sourceExpression.getOperandCount() > 1 ? (StringBuffer[])this.mapResults.get(sourceExpression.getFirstOperand()) : null;
            if (stringBufferArray != null) {
                return SmartJavaOperator.performDoubleOperation(stringBufferArray, stringBufferArray2, new 2());
            }
            this.addExpressions(stringBufferArray2);
            return stringBufferArray2;
        }

        private StringBuffer[] getFieldNamesFromMethodName(String string) {
            String string2;
            boolean bl = false;
            int n = string.lastIndexOf(46) + 1;
            if (string.regionMatches(n, "get", 0, 3)) {
                string2 = string.substring(n + 3);
            } else if (string.regionMatches(n, "set", 0, 3)) {
                string2 = string.substring(n + 3);
            } else if (string.regionMatches(n, "is", 0, 2)) {
                string2 = string.substring(n + 2);
                bl = true;
            } else {
                return null;
            }
            if (string2.length() == 0) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(string2);
            char c = stringBuffer.charAt(0);
            if (!Character.isLowerCase(c)) {
                stringBuffer.setCharAt(0, Character.toLowerCase(c));
            }
            String string3 = stringBuffer.toString();
            if (bl) {
                return new StringBuffer[]{new StringBuffer(string), new StringBuffer(string3), new StringBuffer('_' + string3)};
            }
            return new StringBuffer[]{new StringBuffer(string3), new StringBuffer('_' + string3)};
        }

        private StringBuffer[] processArrayAccess(SourceExpression sourceExpression) {
            StringBuffer[] stringBufferArray = (StringBuffer[])this.mapResults.get(sourceExpression.getFirstOperand());
            SourceExpression sourceExpression2 = sourceExpression.getSecondOperand();
            int n = sourceExpression2.getOperandCount();
            int n2 = 0;
            while (n2 < n) {
                SourceExpression sourceExpression3 = sourceExpression2.getOperandAt(n2);
                StringBuffer[] stringBufferArray2 = (StringBuffer[])this.mapResults.get(sourceExpression3);
                stringBufferArray = SmartJavaOperator.performDoubleOperation(stringBufferArray, stringBufferArray2, new 1());
                ++n2;
            }
            return stringBufferArray;
        }

        private void processNewObject(SourceExpression sourceExpression) {
            if (sourceExpression instanceof SourceHasType) {
                String string = ((SourceHasType)sourceExpression).getSourceType().getName();
                this.addExpression(string);
            }
        }

        private void addExpressions(StringBuffer[] stringBufferArray) {
            int n = stringBufferArray.length - 1;
            while (n >= 0) {
                this.addExpression(stringBufferArray[n].toString());
                --n;
            }
        }

        private void addExpression(StringBuffer stringBuffer) {
            this.addExpression(stringBuffer.toString());
        }

        private void addExpression(String string) {
            this.setOfExpressions.add(string);
        }

        static void mav$gatherExpressions(ExpressionGatherer expressionGatherer, SourceExpression sourceExpression) {
            expressionGatherer.gatherExpressions(sourceExpression);
        }

        ExpressionGatherer(Set set, 1 var2_2) {
            this(set);
        }

        static void mav$addExpression(ExpressionGatherer expressionGatherer, StringBuffer stringBuffer) {
            expressionGatherer.addExpression(stringBuffer);
        }

        public final class 4
        extends SmartJavaOperator {
            private final /* synthetic */ String v$text;
            final /* synthetic */ ExpressionGatherer this$0;

            public void operateSingle(StringBuffer stringBuffer) {
                stringBuffer.append(this.v$text);
                ExpressionGatherer.mav$addExpression(this.this$0, stringBuffer);
            }

            public 4(ExpressionGatherer expressionGatherer, String string) {
                this.v$text = string;
                this.this$0 = expressionGatherer;
            }
        }

        public final class 3
        extends SmartJavaOperator {
            private final /* synthetic */ String v$operator;
            final /* synthetic */ ExpressionGatherer this$0;

            public void operateSingle(StringBuffer stringBuffer) {
                boolean bl = Character.isJavaIdentifierStart(stringBuffer.charAt(0));
                stringBuffer.insert(0, this.v$operator);
                if (bl) {
                    ExpressionGatherer.mav$addExpression(this.this$0, stringBuffer);
                }
            }

            public 3(ExpressionGatherer expressionGatherer, String string) {
                this.v$operator = string;
                this.this$0 = expressionGatherer;
            }
        }

        public final class 2
        extends SmartJavaOperator {
            public void operateDouble(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
                stringBuffer.append(".").append(stringBuffer2);
                ExpressionGatherer.mav$addExpression(ExpressionGatherer.this, stringBuffer);
            }
        }

        public final class 1
        extends SmartJavaOperator {
            public void operateDouble(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
                stringBuffer.append("[").append(stringBuffer2).append("]");
                ExpressionGatherer.mav$addExpression(ExpressionGatherer.this, stringBuffer);
            }
        }
    }

    public static abstract class SmartJavaOperator {
        static StringBuffer[] performSingleOperation(StringBuffer[] stringBufferArray, SmartJavaOperator smartJavaOperator) {
            StringBuffer[] stringBufferArray2 = null;
            if (stringBufferArray != null) {
                int n = stringBufferArray.length;
                stringBufferArray2 = new StringBuffer[n];
                int n2 = 0;
                while (n2 < n) {
                    stringBufferArray2[n2] = new StringBuffer(stringBufferArray[n2].toString());
                    smartJavaOperator.operateSingle(stringBufferArray2[n2]);
                    ++n2;
                }
            }
            return stringBufferArray2;
        }

        public void operateSingle(StringBuffer stringBuffer) {
        }

        static StringBuffer[] performDoubleOperation(StringBuffer[] stringBufferArray, StringBuffer[] stringBufferArray2, SmartJavaOperator smartJavaOperator) {
            StringBuffer[] stringBufferArray3 = null;
            if (stringBufferArray != null && stringBufferArray2 != null) {
                int n = stringBufferArray.length;
                int n2 = stringBufferArray2.length;
                stringBufferArray3 = new StringBuffer[n * n2];
                int n3 = 0;
                while (n3 < n) {
                    int n4 = 0;
                    while (n4 < n2) {
                        int n5 = n3 * n2 + n4;
                        stringBufferArray3[n5] = new StringBuffer(stringBufferArray[n3].toString());
                        smartJavaOperator.operateDouble(stringBufferArray3[n5], stringBufferArray2[n4]);
                        ++n4;
                    }
                    ++n3;
                }
            }
            return stringBufferArray3;
        }

        public void operateDouble(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        }

        SmartJavaOperator() {
        }
    }
}

