/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.layout.Layout;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.EvaluatorPanel;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.LocationInfo;
import oracle.jdevimpl.runner.debug.ProfilingEvents;
import oracle.jdevimpl.runner.debug.SmartWindowSettings;

final class SmartWindow
extends DataWindow {
    private SmartWindowSettings smartWindowSettings = SmartWindowSettings.getInstance();
    private static IdeAction actionViewWhole;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatch;
    private static IdeAction actionInspect;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemSettings;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CMD_ID;
    private static final int INSPECT_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final String SMART_WINDOW_ID = "Debugger.SmartWindow";
    private static Icon smartTabIcon;

    static {
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartViewWhole");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartModifyValue");
        WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartWatch");
        INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartInspect");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartGotoField");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugSmartSettings");
        smartTabIcon = null;
    }

    SmartWindow() {
        super(SMART_WINDOW_ID, DbgArb.getString(653), "f1_deb_smartdatawindow_html");
        SmartWindow.makeActions();
        this.setDataPanel(new SmartPanel());
        this.setControllerForActions();
    }

    public Icon getTabIcon() {
        if (smartTabIcon == null) {
            smartTabIcon = DbgArb.getIcon(69);
        }
        return smartTabIcon;
    }

    public int getDefaultVisibility(Layout layout) {
        return super.getDefaultVisibility(layout) | 4;
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu jMenu) {
        SmartWindow.makeActions();
        float f = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewWhole), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAdjustRange), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionToggleValue), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionModifyValue), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatch), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspect), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoto), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoDeclared), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoField), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUseFilters), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionObjectPreferences), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), jMenu, f);
    }

    private static void makeActions() {
        if (actionViewWhole == null) {
            actionViewWhole = IdeAction.get((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(317), null, (Integer)DbgArb.getInteger(318), null, (int)-1, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionAdjustRange = IdeAction.get((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(319), null, (Integer)DbgArb.getInteger(320), null, (int)-1, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.get((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(321), null, (Integer)DbgArb.getInteger(322), null, (int)-1, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.get((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(323), null, (Integer)DbgArb.getInteger(324), null, (int)-1, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatch = IdeAction.get((int)WATCH_CMD_ID, null, (String)DbgArb.getString(325), null, (Integer)DbgArb.getInteger(326), null, (int)-1, null, (boolean)false);
            actionWatch.setEnabled(false);
            actionInspect = IdeAction.get((int)INSPECT_CMD_ID, null, (String)DbgArb.getString(327), null, (Integer)DbgArb.getInteger(328), null, (int)-1, null, (boolean)false);
            actionInspect.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(341), null, (Integer)DbgArb.getInteger(342), null, (int)-1, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(343), null, (Integer)DbgArb.getInteger(344), null, (int)-1, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(329), null, (Integer)DbgArb.getInteger(331), null, (int)-1, null, (boolean)false);
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.get((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(332), null, (Integer)DbgArb.getInteger(334), null, (int)-1, null, (boolean)false);
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.get((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(335), null, (Integer)DbgArb.getInteger(337), null, (int)-1, null, (boolean)false);
            actionGotoField.setEnabled(false);
            actionUseFilters = IdeAction.get((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(345), null, (Integer)DbgArb.getInteger(346), null, (int)-1, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.get((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(347, ""), null, (Integer)DbgArb.getInteger(348), null, (int)-1, null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(101), null, (Integer)RunMgrArb.getInteger(102), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(97), null, (Integer)RunMgrArb.getInteger(98), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(99), null, (Integer)RunMgrArb.getInteger(100), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] ideActionArray = new IdeAction[]{actionViewWhole, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatch, actionInspect, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(ideActionArray, this.dataPanel);
    }

    static SmartWindowSettings ra$smartWindowSettings(SmartWindow smartWindow) {
        return smartWindow.smartWindowSettings;
    }

    static int ra$SETTINGS_CMD_ID() {
        return SETTINGS_CMD_ID;
    }

    static IdeAction ra$actionSettings() {
        return actionSettings;
    }

    static JMenuItem ra$menuitemSettings() {
        return menuitemSettings;
    }

    static void wa$menuitemSettings(JMenuItem jMenuItem) {
        menuitemSettings = jMenuItem;
    }

    static IdeAction ra$actionViewWhole() {
        return actionViewWhole;
    }

    static IdeAction ra$actionAdjustRange() {
        return actionAdjustRange;
    }

    static IdeAction ra$actionToggleValue() {
        return actionToggleValue;
    }

    static IdeAction ra$actionModifyValue() {
        return actionModifyValue;
    }

    static IdeAction ra$actionWatch() {
        return actionWatch;
    }

    static IdeAction ra$actionInspect() {
        return actionInspect;
    }

    static IdeAction ra$actionWatchClassLoader() {
        return actionWatchClassLoader;
    }

    static IdeAction ra$actionInspectClassLoader() {
        return actionInspectClassLoader;
    }

    static IdeAction ra$actionGoto() {
        return actionGoto;
    }

    static IdeAction ra$actionGotoDeclared() {
        return actionGotoDeclared;
    }

    static IdeAction ra$actionGotoField() {
        return actionGotoField;
    }

    static IdeAction ra$actionUseFilters() {
        return actionUseFilters;
    }

    static IdeAction ra$actionObjectPreferences() {
        return actionObjectPreferences;
    }

    static IdeAction ra$actionCollapseAll() {
        return actionCollapseAll;
    }

    static IdeAction ra$actionSave() {
        return actionSave;
    }

    static int ra$VIEW_WHOLE_CMD_ID() {
        return VIEW_WHOLE_CMD_ID;
    }

    static int ra$ADJUST_RANGE_CMD_ID() {
        return ADJUST_RANGE_CMD_ID;
    }

    static int ra$TOGGLE_VALUE_CMD_ID() {
        return TOGGLE_VALUE_CMD_ID;
    }

    static int ra$MODIFY_VALUE_CMD_ID() {
        return MODIFY_VALUE_CMD_ID;
    }

    static int ra$WATCH_CMD_ID() {
        return WATCH_CMD_ID;
    }

    static int ra$INSPECT_CMD_ID() {
        return INSPECT_CMD_ID;
    }

    static int ra$WATCH_CLASSLOADER_CMD_ID() {
        return WATCH_CLASSLOADER_CMD_ID;
    }

    static int ra$INSPECT_CLASSLOADER_CMD_ID() {
        return INSPECT_CLASSLOADER_CMD_ID;
    }

    static int ra$GOTO_CMD_ID() {
        return GOTO_CMD_ID;
    }

    static int ra$GOTO_DECLARED_CMD_ID() {
        return GOTO_DECLARED_CMD_ID;
    }

    static int ra$GOTO_FIELD_CMD_ID() {
        return GOTO_FIELD_CMD_ID;
    }

    static int ra$USE_FILTERS_CMD_ID() {
        return USE_FILTERS_CMD_ID;
    }

    static int ra$OBJECT_PREFERENCES_CMD_ID() {
        return OBJECT_PREFERENCES_CMD_ID;
    }

    static int ra$COLLAPSE_ALL_CMD_ID() {
        return COLLAPSE_ALL_CMD_ID;
    }

    static int ra$SAVE_CMD_ID() {
        return SAVE_CMD_ID;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class SmartPanel
    extends EvaluatorPanel {
        private Map map;

        SmartPanel() {
            super(SmartWindow.this, SmartWindow.ra$smartWindowSettings(SmartWindow.this).getDataPanelSettings());
            this.map = new HashMap();
            this._actionPin = null;
            this._actionUnpin = null;
            this._actionViewWhole = SmartWindow.ra$actionViewWhole();
            this._actionAdjustRange = SmartWindow.ra$actionAdjustRange();
            this._actionToggleValue = SmartWindow.ra$actionToggleValue();
            this._actionModifyValue = SmartWindow.ra$actionModifyValue();
            this._actionWatch = SmartWindow.ra$actionWatch();
            this._actionInspect = SmartWindow.ra$actionInspect();
            this._actionWatchClassLoader = SmartWindow.ra$actionWatchClassLoader();
            this._actionInspectClassLoader = SmartWindow.ra$actionInspectClassLoader();
            this._actionGoto = SmartWindow.ra$actionGoto();
            this._actionGotoDeclared = SmartWindow.ra$actionGotoDeclared();
            this._actionGotoField = SmartWindow.ra$actionGotoField();
            this._actionUseFilters = SmartWindow.ra$actionUseFilters();
            this._actionObjectPreferences = SmartWindow.ra$actionObjectPreferences();
            this._actionCollapseAll = SmartWindow.ra$actionCollapseAll();
            this._actionSave = SmartWindow.ra$actionSave();
            this._PIN_CMD_ID = -1;
            this._UNPIN_CMD_ID = -1;
            this._VIEW_WHOLE_CMD_ID = SmartWindow.ra$VIEW_WHOLE_CMD_ID();
            this._ADJUST_RANGE_CMD_ID = SmartWindow.ra$ADJUST_RANGE_CMD_ID();
            this._TOGGLE_VALUE_CMD_ID = SmartWindow.ra$TOGGLE_VALUE_CMD_ID();
            this._MODIFY_VALUE_CMD_ID = SmartWindow.ra$MODIFY_VALUE_CMD_ID();
            this._WATCH_CMD_ID = SmartWindow.ra$WATCH_CMD_ID();
            this._INSPECT_CMD_ID = SmartWindow.ra$INSPECT_CMD_ID();
            this._WATCH_CLASSLOADER_CMD_ID = SmartWindow.ra$WATCH_CLASSLOADER_CMD_ID();
            this._INSPECT_CLASSLOADER_CMD_ID = SmartWindow.ra$INSPECT_CLASSLOADER_CMD_ID();
            this._GOTO_CMD_ID = SmartWindow.ra$GOTO_CMD_ID();
            this._GOTO_DECLARED_CMD_ID = SmartWindow.ra$GOTO_DECLARED_CMD_ID();
            this._GOTO_FIELD_CMD_ID = SmartWindow.ra$GOTO_FIELD_CMD_ID();
            this._USE_FILTERS_CMD_ID = SmartWindow.ra$USE_FILTERS_CMD_ID();
            this._OBJECT_PREFERENCES_CMD_ID = SmartWindow.ra$OBJECT_PREFERENCES_CMD_ID();
            this._COLLAPSE_ALL_CMD_ID = SmartWindow.ra$COLLAPSE_ALL_CMD_ID();
            this._SAVE_CMD_ID = SmartWindow.ra$SAVE_CMD_ID();
        }

        @Override
        protected void addPopupMenuItemsForCommon(ContextMenu contextMenu, Context context) {
            super.addPopupMenuItemsForCommon(contextMenu, context);
            this.update(SmartWindow.ra$actionSettings(), context);
            if (SmartWindow.ra$actionSettings().isEnabled()) {
                if (SmartWindow.ra$menuitemSettings() == null) {
                    SmartWindow.wa$menuitemSettings(contextMenu.createMenuItem((ToggleAction)SmartWindow.ra$actionSettings()));
                }
                contextMenu.add((Component)SmartWindow.ra$menuitemSettings(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        @Override
        public boolean update(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (ideAction.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    ideAction.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || n == SmartWindow.ra$SETTINGS_CMD_ID())) {
                    ideAction.setEnabled(false);
                    return true;
                }
            }
            if (n == SmartWindow.ra$SETTINGS_CMD_ID()) {
                ideAction.setEnabled(true);
                return true;
            }
            return super.update(ideAction, context);
        }

        @Override
        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == SmartWindow.ra$SETTINGS_CMD_ID()) {
                String[] stringArray = new String[]{DbgArb.getString(716), DbgArb.getString(782)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
                return true;
            }
            return super.handleEvent(ideAction, context);
        }

        @Override
        void processFinished(DebuggingProcess debuggingProcess) {
            super.processFinished(debuggingProcess);
            this.map.remove(debuggingProcess);
        }

        @Override
        void updateData(DebuggingProcess debuggingProcess, DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo debugStackFrameInfo) {
            int n = -1;
            if (ProfilingEvents.eventOn[11]) {
                n = IdeProfile.startEvent((int)ProfilingEvents.eventId[11], (String)this.dockableWindow.getTitleName());
            }
            if (debuggingProcess != null && debugVirtualMachine != null && debugThreadInfo != null && debugStackFrameInfo != null && !this.sameAsLastFrame(debuggingProcess, debugStackFrameInfo)) {
                this.insertCurrent(debuggingProcess, debugVirtualMachine, debugThreadInfo, debugStackFrameInfo);
            }
            super.updateData(debuggingProcess, debugVirtualMachine, debugThreadInfo, debugStackFrameInfo);
            if (ProfilingEvents.eventOn[11]) {
                IdeProfile.endEvent((int)n);
            }
        }

        private boolean sameAsLastFrame(DebuggingProcess debuggingProcess, DebugStackFrameInfo debugStackFrameInfo) {
            LocationInfo locationInfo;
            List list = (List)this.map.get(debuggingProcess);
            return list != null && list.size() > 0 && (locationInfo = (LocationInfo)list.get(0)).isSameFrame(debugStackFrameInfo);
        }

        private void insertCurrent(DebuggingProcess debuggingProcess, DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo, DebugStackFrameInfo debugStackFrameInfo) {
            ArrayList<LocationInfo> arrayList = (ArrayList<LocationInfo>)this.map.get(debuggingProcess);
            if (arrayList == null) {
                arrayList = new ArrayList<LocationInfo>();
                this.map.put(debuggingProcess, arrayList);
            }
            LocationInfo locationInfo = new LocationInfo(debuggingProcess, debugStackFrameInfo);
            arrayList.add(0, locationInfo);
            int n = 10;
            while (arrayList.size() > 10) {
                arrayList.remove(10);
            }
        }

        private List<String> getExpressions(DebuggingProcess debuggingProcess) {
            int n;
            ArrayList<String> arrayList = new ArrayList<String>();
            List list = (List)this.map.get(debuggingProcess);
            if (list != null && (n = list.size()) > 0) {
                int n2 = SmartWindow.ra$smartWindowSettings(SmartWindow.this).getNumberOfLocations();
                ArrayList<LocationInfo> arrayList2 = new ArrayList<LocationInfo>();
                int n3 = 0;
                LocationInfo locationInfo = (LocationInfo)list.get(0);
                DebugMethodInfo debugMethodInfo = locationInfo.getMethod();
                arrayList2.add(locationInfo);
                if (++n3 < n2) {
                    int n4 = 1;
                    while (n4 < n) {
                        LocationInfo locationInfo2 = (LocationInfo)list.get(n4);
                        DebugMethodInfo debugMethodInfo2 = locationInfo2.getMethod();
                        if (ModelUtil.areEqual((Object)debugMethodInfo2, (Object)debugMethodInfo)) {
                            arrayList2.add(locationInfo2);
                            if (++n3 >= n2) break;
                        }
                        ++n4;
                    }
                }
                int n5 = n3 - 1;
                while (n5 >= 0) {
                    LocationInfo locationInfo3 = (LocationInfo)arrayList2.get(n5);
                    List list2 = locationInfo3.getExpressions(SmartWindow.ra$smartWindowSettings(SmartWindow.this), this.vm, this.thread, this.frame);
                    if (list2 != null) {
                        int n6 = list2.size();
                        int n7 = 0;
                        while (n7 < n6) {
                            String string = (String)list2.get(n7);
                            if (!arrayList.contains(string)) {
                                arrayList.add(string);
                            }
                            ++n7;
                        }
                    }
                    --n5;
                }
            }
            return arrayList;
        }

        @Override
        protected void addDataItems() {
            List<String> list;
            int n;
            if (this.frame != null && (n = (list = this.getExpressions(this.debuggingProcess)).size()) > 0) {
                if (SmartWindow.ra$smartWindowSettings(SmartWindow.this).isSortExpressions()) {
                    Collections.sort(list);
                }
                List list2 = this.getRoot();
                int n2 = 0;
                while (n2 < n) {
                    String string = list.get(n2);
                    EvaluatorItem evaluatorItem = new EvaluatorItem(string);
                    this.addDataItem(list2, evaluatorItem, true, true);
                    ++n2;
                }
            }
        }
    }
}

