/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import oracle.ide.config.ClientSetting;
import oracle.ide.util.ModelUtil;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.runner.debug.DataPanelSettings;
import oracle.jdevimpl.runner.debug.JDebugger;

public final class SmartWindowSettings
implements Copyable {
    public static final String KEY_SETTINGS = "SmartWindowOptions";
    private DataPanelSettings _dataPanelSettings = new DataPanelSettings();
    private boolean _sortExpressions;
    private int _numberOfLocations;
    static final int MIN_NUMBEROFLOCATIONS = 1;
    static final int MAX_NUMBEROFLOCATIONS = 10;
    private int _numberOfLines;
    static final int MIN_NUMBEROFLINES = 1;
    static final int MAX_NUMBEROFLINES = 10;

    static SmartWindowSettings getInstance() {
        return (SmartWindowSettings)ClientSetting.findOrCreate((String)JDebugger.getExtensionID()).getData(KEY_SETTINGS);
    }

    public SmartWindowSettings() {
        this.defaultInit();
    }

    public SmartWindowSettings(SmartWindowSettings smartWindowSettings) {
        if (smartWindowSettings == null) {
            this.defaultInit();
        } else {
            smartWindowSettings.copyTo(this);
        }
    }

    private void defaultInit() {
        this._sortExpressions = true;
        this._numberOfLocations = 2;
        this._numberOfLines = 1;
    }

    public Object copyTo(Object object) {
        SmartWindowSettings smartWindowSettings = object != null ? (SmartWindowSettings)object : new SmartWindowSettings();
        smartWindowSettings._sortExpressions = this._sortExpressions;
        smartWindowSettings._numberOfLocations = this._numberOfLocations;
        smartWindowSettings._numberOfLines = this._numberOfLines;
        this._dataPanelSettings.copyTo((Object)smartWindowSettings._dataPanelSettings);
        return smartWindowSettings;
    }

    public DataPanelSettings getDataPanelSettings() {
        return this._dataPanelSettings;
    }

    public void setDataPanelSettings(DataPanelSettings dataPanelSettings) {
        dataPanelSettings.copyTo((Object)this._dataPanelSettings);
    }

    public boolean isSortExpressions() {
        return this._sortExpressions;
    }

    public void setSortExpressions(boolean bl) {
        this._sortExpressions = bl;
    }

    public int getNumberOfLocations() {
        return this._numberOfLocations;
    }

    public void setNumberOfLocations(int n) {
        if (1 <= n && n <= 10) {
            this._numberOfLocations = n;
        }
    }

    public int getNumberOfLines() {
        return this._numberOfLines;
    }

    public void setNumberOfLines(int n) {
        if (1 <= n && n <= 10) {
            this._numberOfLines = n;
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((SmartWindowSettings)object);
    }

    protected final boolean equalsImpl(SmartWindowSettings smartWindowSettings) {
        return ModelUtil.areEqual((Object)((Object)this._dataPanelSettings), (Object)((Object)smartWindowSettings._dataPanelSettings)) && this._sortExpressions == smartWindowSettings._sortExpressions && this._numberOfLocations == smartWindowSettings._numberOfLocations && this._numberOfLines == smartWindowSettings._numberOfLines;
    }
}

