/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.debug.DataPanelSettingsPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.SmartWindowSettings;

public final class SmartWindowSettingsPanel
extends DefaultTraversablePanel {
    private DataPanelSettingsPanel dataPanel;
    private JCheckBox sortExpressionsCheckBox;
    private JLabel locationsLabel;
    private NumericSpinBox locationsBox;
    private JLabel linesLabel;
    private NumericSpinBox linesBox;
    private JLabel spacerLabel;

    void $init$() {
        this.dataPanel = new DataPanelSettingsPanel();
        this.sortExpressionsCheckBox = new JCheckBox();
        this.locationsLabel = new JLabel();
        this.locationsBox = new NumericSpinBox(1, 10);
        this.linesLabel = new JLabel();
        this.linesBox = new NumericSpinBox(1, 10);
        this.spacerLabel = new JLabel();
    }

    public SmartWindowSettingsPanel() {
        this.$init$();
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_smartdatawinsetpanel_html");
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.sortExpressionsCheckBox, (String)DbgArb.getString(783));
        ResourceUtils.resLabel((JLabel)this.locationsLabel, (Component)this.locationsBox, (String)DbgArb.getString(784));
        ResourceUtils.resLabel((JLabel)this.linesLabel, (Component)this.linesBox, (String)DbgArb.getString(785));
        SpinBuddy spinBuddy = this.locationsBox.getSpinBuddy();
        if (spinBuddy instanceof JTextField) {
            ((JTextField)spinBuddy).setHorizontalAlignment(4);
        }
        if ((spinBuddy = this.linesBox.getSpinBuddy()) instanceof JTextField) {
            ((JTextField)spinBuddy).setHorizontalAlignment(4);
        }
        this.spacerLabel.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
        Insets insets = new Insets(0, 0, 0, 0);
        this.add(this.dataPanel.makeChooseColumnsPanel(insets), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 8;
        this.add(this.dataPanel.makeSortPanel(this.sortExpressionsCheckBox), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add(this.dataPanel.makeShowPanel(null), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add(this.dataPanel.makeHidePanel(null), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add(this.makeSmartPanel(insets), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        this.add(this.spacerLabel, gridBagConstraints);
    }

    private JPanel makeSmartPanel(Insets insets) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, insets.left, 0, insets.right));
        int n = 0;
        jPanel.add((Component)this.locationsLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        jPanel.add((Component)this.locationsBox, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.linesLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 2, 0, 0), 0, 0));
        jPanel.add((Component)this.linesBox, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(), new GridBagConstraints(2, n, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public void onEntry(TraversableContext traversableContext) {
        SmartWindowSettings smartWindowSettings = (SmartWindowSettings)traversableContext.find("SmartWindowOptions");
        this.dataPanel.onEntry(smartWindowSettings.getDataPanelSettings());
        this.sortExpressionsCheckBox.setSelected(smartWindowSettings.isSortExpressions());
        this.locationsBox.setIntValue(smartWindowSettings.getNumberOfLocations());
        this.linesBox.setIntValue(smartWindowSettings.getNumberOfLines());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        SmartWindowSettings smartWindowSettings = (SmartWindowSettings)traversableContext.find("SmartWindowOptions");
        this.dataPanel.onExit(smartWindowSettings.getDataPanelSettings());
        smartWindowSettings.setSortExpressions(this.sortExpressionsCheckBox.isSelected());
        try {
            int n = this.locationsBox.getIntValue();
            smartWindowSettings.setNumberOfLocations(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n = this.linesBox.getIntValue();
            smartWindowSettings.setNumberOfLines(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

