/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ArrayResourceBundle;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.FileOverviewMark;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.runner.debug.Breakpoint;
import oracle.jdevimpl.runner.debug.BytecodeFileSystemHelper;
import oracle.jdevimpl.runner.debug.DbgArb;

final class SourceIcon
implements FileOverviewMark {
    static HighlightStyle disabledBPStyle;
    static HighlightStyle enabledBPStyle;
    static HighlightStyle ipStyle;
    static final int TYPE_BREAKPOINT = 0;
    static final int TYPE_WATCHPOINT = 1;
    static final int TYPE_IP = 2;
    private static final String[] columnNames;
    private static final int[] markOrder;
    private static final int[] markOptions;
    private static Map mapGutterToCodeEditor;
    private static List shownIcons;
    private final URL workspaceURL;
    private final URL projectURL;
    private final String pkg;
    private final String filename;
    private final URL url;
    private int line;
    private final String className;
    private final String fieldName;
    private final String fqMethodName;
    private final int offset;
    private final Node nodeToMatch;
    private ArrayResourceBundle iconBundle;
    private int iconKey;
    private HighlightStyle style;
    private final int type;
    private final Breakpoint breakpoint;
    private Map gutterMarks;
    private static final String disabledBPStyleName = "disabled-breakpoint";
    private static final String enabledBPStyleName = "enabled-breakpoint";
    private static final String ipStyleName = "execution-point";
    private static final Map mapStyleToCategory;

    static {
        columnNames = new String[]{"breakpoint", "watchpoint", "ip"};
        markOrder = new int[]{0, 1000, 7000};
        markOptions = new int[]{1, 3, 2};
        mapGutterToCodeEditor = new HashMap();
        shownIcons = new ArrayList();
        mapStyleToCategory = new HashMap();
    }

    SourceIcon(URL uRL, URL uRL2, String string, String string2, int n, Node node, ArrayResourceBundle arrayResourceBundle, int n2, HighlightStyle highlightStyle, int n3, Breakpoint breakpoint) {
        this.workspaceURL = uRL;
        this.projectURL = uRL2;
        this.pkg = string;
        this.filename = string2;
        this.url = null;
        this.line = n;
        this.className = null;
        this.fieldName = null;
        this.fqMethodName = null;
        this.offset = -1;
        this.nodeToMatch = node;
        this.iconBundle = arrayResourceBundle;
        this.iconKey = n2;
        this.style = highlightStyle;
        this.type = n3;
        this.breakpoint = breakpoint;
        this.show();
    }

    SourceIcon(URL uRL, URL uRL2, URL uRL3, int n, Node node, ArrayResourceBundle arrayResourceBundle, int n2, HighlightStyle highlightStyle, int n3, Breakpoint breakpoint) {
        this.workspaceURL = uRL;
        this.projectURL = uRL2;
        this.pkg = null;
        this.filename = null;
        this.url = uRL3;
        this.line = n;
        this.className = null;
        this.fieldName = null;
        this.fqMethodName = null;
        this.offset = -1;
        this.nodeToMatch = node;
        this.iconBundle = arrayResourceBundle;
        this.iconKey = n2;
        this.style = highlightStyle;
        this.type = n3;
        this.breakpoint = breakpoint;
        this.show();
    }

    SourceIcon(URL uRL, URL uRL2, String string, String string2, Node node, ArrayResourceBundle arrayResourceBundle, int n, HighlightStyle highlightStyle, int n2, Breakpoint breakpoint) {
        this.workspaceURL = uRL;
        this.projectURL = uRL2;
        this.pkg = null;
        this.filename = null;
        this.url = null;
        this.line = 0;
        this.className = string;
        this.fieldName = string2;
        this.fqMethodName = null;
        this.offset = -1;
        this.nodeToMatch = node;
        this.iconBundle = arrayResourceBundle;
        this.iconKey = n;
        this.style = highlightStyle;
        this.type = n2;
        this.breakpoint = breakpoint;
        this.show();
    }

    SourceIcon(URL uRL, URL uRL2, String string, int n, Node node, ArrayResourceBundle arrayResourceBundle, int n2, HighlightStyle highlightStyle, int n3, Breakpoint breakpoint) {
        this.workspaceURL = uRL;
        this.projectURL = uRL2;
        this.pkg = null;
        this.filename = null;
        this.url = null;
        this.line = 0;
        this.className = null;
        this.fieldName = null;
        this.fqMethodName = string;
        this.offset = n;
        this.nodeToMatch = node;
        this.iconBundle = arrayResourceBundle;
        this.iconKey = n2;
        this.style = highlightStyle;
        this.type = n3;
        this.breakpoint = breakpoint;
        this.show();
    }

    Breakpoint getBreakpoint() {
        return this.breakpoint;
    }

    void show() {
        this.gutterMarks = new HashMap();
        for (CodeEditorGutter codeEditorGutter : mapGutterToCodeEditor.keySet()) {
            CodeEditor codeEditor = (CodeEditor)mapGutterToCodeEditor.get(codeEditorGutter);
            if (!this.matchesGutter(codeEditorGutter)) continue;
            this.makeMark(codeEditor, codeEditorGutter);
        }
        shownIcons.add(this);
    }

    void hide() {
        shownIcons.remove(this);
        for (CodeEditor codeEditor : this.gutterMarks.keySet()) {
            GutterMark gutterMark = (GutterMark)this.gutterMarks.get(codeEditor);
            this.removeMark(codeEditor, gutterMark, false);
        }
        this.gutterMarks.clear();
        this.gutterMarks = null;
    }

    private void removedDuringEdit(CodeEditor codeEditor, int n) {
        this.removeFileOverviewMark(codeEditor, n);
        this.gutterMarks.remove(codeEditor);
    }

    private void removeMark(CodeEditor codeEditor, GutterMark gutterMark, boolean bl) {
        this.removeFileOverviewMark(codeEditor, gutterMark.getLine());
        gutterMark.getGutterColumn().removeGutterMark(gutterMark);
        if (bl) {
            this.gutterMarks.remove(codeEditor);
        }
    }

    private void makeMark(CodeEditor codeEditor, CodeEditorGutter codeEditorGutter) {
        int n;
        GutterColumn gutterColumn = SourceIcon.createGutterColumn(codeEditorGutter, this.type);
        Icon icon = this.iconBundle.getIconImpl(this.iconKey);
        int[] nArray = this.getLineAndOffset(codeEditor);
        int n2 = nArray[0];
        GutterMark gutterMark = gutterColumn.addGutterMark(n2, icon, this.style, markOrder[this.type] + (n = nArray[1]), markOptions[this.type]);
        if (gutterMark != null) {
            gutterMark.setUserData((Object)this);
            this.gutterMarks.put(codeEditor, gutterMark);
            this.addFileOverviewMark(codeEditor, n2);
        }
    }

    private void addFileOverviewMark(CodeEditor codeEditor, int n) {
        String string = (String)mapStyleToCategory.get(this.style.getName());
        this.addFileOverviewMark(codeEditor, n, string);
    }

    private void removeFileOverviewMark(CodeEditor codeEditor, int n) {
        String string = (String)mapStyleToCategory.get(this.style.getName());
        this.removeFileOverviewMark(codeEditor, n, string);
    }

    private void addFileOverviewMark(CodeEditor codeEditor, int n, String string) {
        FileOverviewMargin fileOverviewMargin = codeEditor.getFileOverviewMargin();
        fileOverviewMargin.addMark(string, n, (FileOverviewMark)this);
    }

    private void removeFileOverviewMark(CodeEditor codeEditor, int n, String string) {
        FileOverviewMargin fileOverviewMargin = codeEditor.getFileOverviewMargin();
        fileOverviewMargin.removeMark(string, n, (FileOverviewMark)this);
    }

    private static GutterColumn createGutterColumn(CodeEditorGutter codeEditorGutter, int n) {
        String string = columnNames[n];
        GutterColumn gutterColumn = codeEditorGutter.lookupGutterColumn(string);
        if (gutterColumn == null) {
            SourceIconGutterColumnListener sourceIconGutterColumnListener = new SourceIconGutterColumnListener();
            gutterColumn = codeEditorGutter.createGutterColumn(string, (GutterColumnListener)sourceIconGutterColumnListener);
            switch (n) {
                default: {
                    throw new IllegalArgumentException("type is invalid");
                }
                case 0: {
                    int n2 = Math.max(DbgArb.getIcon(401).getIconWidth(), Math.max(DbgArb.getIcon(400).getIconWidth(), DbgArb.getIcon(403).getIconWidth()));
                    gutterColumn.setReservedWidth(n2);
                    break;
                }
                case 1: {
                    int n3 = Math.max(DbgArb.getIcon(405).getIconWidth(), DbgArb.getIcon(404).getIconWidth());
                    gutterColumn.setReservedWidth(n3);
                    gutterColumn.setLayoutConstraint("breakpoint", 1);
                    break;
                }
                case 2: {
                    int n4 = DbgArb.getIcon(567).getIconWidth();
                    gutterColumn.setReservedWidth(n4);
                    gutterColumn.setLayoutConstraint("lightbulb", 2);
                }
            }
        }
        return gutterColumn;
    }

    private void handleGutterDestroyed(CodeEditor codeEditor, CodeEditorGutter codeEditorGutter) {
        GutterMark gutterMark = (GutterMark)this.gutterMarks.get(codeEditor);
        if (gutterMark != null) {
            this.removeMark(codeEditor, gutterMark, true);
        }
    }

    boolean matchesIconLocation(CodeEditor codeEditor, int n) {
        GutterMark gutterMark = (GutterMark)this.gutterMarks.get(codeEditor);
        return gutterMark != null && gutterMark.getLine() == n;
    }

    void changeIcon(ArrayResourceBundle arrayResourceBundle, int n, HighlightStyle highlightStyle) {
        String string = (String)mapStyleToCategory.get(this.style.getName());
        String string2 = (String)mapStyleToCategory.get(highlightStyle.getName());
        this.iconBundle = arrayResourceBundle;
        this.iconKey = n;
        this.style = highlightStyle;
        for (CodeEditor codeEditor : this.gutterMarks.keySet()) {
            GutterMark gutterMark = (GutterMark)this.gutterMarks.get(codeEditor);
            Icon icon = arrayResourceBundle.getIconImpl(n);
            gutterMark.setIcon(icon);
            if (string == string2) continue;
            this.removeFileOverviewMark(codeEditor, gutterMark.getLine(), string);
            this.addFileOverviewMark(codeEditor, gutterMark.getLine(), string2);
        }
    }

    CodeEditor getCodeEditor() {
        Iterator iterator;
        if (this.gutterMarks.size() > 0 && (iterator = this.gutterMarks.keySet().iterator()).hasNext()) {
            return (CodeEditor)iterator.next();
        }
        return null;
    }

    private JavaField getJavaField(Project project, URL uRL) {
        JavaManager javaManager = JavaManager.getJavaManager(project);
        SourceFile sourceFile = javaManager.getSourceFile(uRL);
        if (sourceFile != null) {
            String string = sourceFile.getPackageName();
            if (string == null) {
                string = "";
            }
            if (string.equals(DebugShared.getPackage(this.className))) {
                List list = sourceFile.getSourceClasses();
                for (SourceClass sourceClass : list) {
                    if (!this.className.equals(sourceClass.getQualifiedName())) continue;
                    JavaField javaField = sourceClass.getDeclaredField(this.fieldName);
                    return javaField;
                }
            }
        }
        return null;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.breakpoint != null) {
            return this.breakpoint.getMarkToolTip(null, mouseEvent);
        }
        if (this.type == 2) {
            return DbgArb.getString(568);
        }
        return null;
    }

    public int getSelectionStart() {
        return -1;
    }

    public int getSelectionLength() {
        return 0;
    }

    public int getSeverity() {
        return 0;
    }

    int getLine() {
        return this.line;
    }

    private int[] getLineAndOffset(CodeEditor codeEditor) {
        int[] nArray = new int[2];
        if (codeEditor != null) {
            int n;
            BytecodeFileSystemHelper bytecodeFileSystemHelper;
            Node node;
            Context context;
            Node node2;
            Context context2;
            if (this.className != null && this.fieldName != null && (context2 = codeEditor.getContext()) != null && (node2 = context2.getNode()) != null) {
                JavaField javaField;
                Project project = context2.getProject();
                if (project == null) {
                    project = Ide.getActiveProject();
                }
                if ((javaField = this.getJavaField(project, node2.getURL())) instanceof SourceElement) {
                    SourceName sourceName;
                    SourceElement sourceElement = (SourceElement)javaField;
                    int n2 = sourceElement.getStartOffset();
                    if (sourceElement instanceof SourceHasName && (sourceName = ((SourceHasName)sourceElement).getNameElement()) != null) {
                        n2 = sourceName.getStartOffset();
                    }
                    nArray[0] = codeEditor.getLineFromOffset(n2);
                    nArray[1] = n2 - codeEditor.getLineStartOffset(nArray[0]);
                    return nArray;
                }
            }
            if (this.fqMethodName != null && (context = codeEditor.getContext()) != null && (node = context.getNode()) != null && (bytecodeFileSystemHelper = BytecodeFileSystemHelper.getInstance(false)) != null && (n = bytecodeFileSystemHelper.getLineFromBytecodeOffset(node.getURL(), this.offset)) != 0) {
                nArray[0] = n;
                nArray[1] = 0;
                return nArray;
            }
        }
        nArray[0] = this.line;
        nArray[1] = 0;
        return nArray;
    }

    private boolean matchesGutter(CodeEditorGutter codeEditorGutter) {
        Context context = codeEditorGutter.getContext();
        if (context != null) {
            URL uRL;
            Workspace workspace = context.getWorkspace();
            URL uRL2 = uRL = workspace != null ? workspace.getURL() : null;
            if (this.workspaceURL == null || uRL == null || URLFileSystem.equals((URL)this.workspaceURL, (URL)uRL)) {
                Node node;
                URL uRL3;
                Project project = context.getProject();
                URL uRL4 = uRL3 = project != null ? project.getURL() : null;
                if ((this.projectURL == null || uRL3 == null || URLFileSystem.equals((URL)this.projectURL, (URL)uRL3)) && (node = context.getNode()) != null) {
                    if (this.nodeToMatch != null) {
                        if (this.nodeToMatch.equals((Object)node)) {
                            return true;
                        }
                    } else {
                        URL uRL5;
                        String string;
                        BytecodeFileSystemHelper bytecodeFileSystemHelper;
                        JavaField javaField;
                        if (this.url != null && this.url.equals(node.getURL())) {
                            return true;
                        }
                        Project project2 = project;
                        if (project2 == null) {
                            project2 = Ide.getActiveProject();
                        }
                        if (this.filename != null && this.filename.equals(Source.getFilenameFromNode(node)) && Source.packageMatches(this.pkg, node, project2)) {
                            return true;
                        }
                        if (this.className != null && (javaField = this.getJavaField(project2, node.getURL())) != null) {
                            return true;
                        }
                        if (this.fqMethodName != null && (bytecodeFileSystemHelper = BytecodeFileSystemHelper.getInstance(false)) != null && (string = BytecodeFileSystemHelper.getMethodName(uRL5 = node.getURL())) != null && this.fqMethodName.equals(string)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    static void gutterCreated(CodeEditor codeEditor) {
        CodeEditorGutter codeEditorGutter = codeEditor.getGutter();
        mapGutterToCodeEditor.put(codeEditorGutter, codeEditor);
        SourceIcon.createGutterColumn(codeEditorGutter, 0);
        SourceIcon.createGutterColumn(codeEditorGutter, 1);
        try {
            Context context = codeEditor.getContext();
            if (context != null) {
                int n = shownIcons.size() - 1;
                while (n >= 0) {
                    SourceIcon sourceIcon = (SourceIcon)shownIcons.get(n);
                    if (sourceIcon.matchesGutter(codeEditorGutter)) {
                        sourceIcon.makeMark(codeEditor, codeEditorGutter);
                    }
                    --n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void gutterDestroyed(CodeEditor codeEditor) {
        try {
            CodeEditorGutter codeEditorGutter = codeEditor.getGutter();
            mapGutterToCodeEditor.remove(codeEditorGutter);
            int n = shownIcons.size() - 1;
            while (n >= 0) {
                SourceIcon sourceIcon = (SourceIcon)shownIcons.get(n);
                sourceIcon.handleGutterDestroyed(codeEditor, codeEditorGutter);
                --n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static CodeEditor[] getOpenCodeEditors() {
        ArrayList<CodeEditor> arrayList = new ArrayList<CodeEditor>();
        for (CodeEditor codeEditor : mapGutterToCodeEditor.values()) {
            Context context = codeEditor.getContext();
            if (context == null) continue;
            arrayList.add(codeEditor);
        }
        return arrayList.toArray(new CodeEditor[arrayList.size()]);
    }

    static void removeColumn(int n) {
        if (!columnNames[n].equals("breakpoint")) {
            for (CodeEditorGutter codeEditorGutter : mapGutterToCodeEditor.keySet()) {
                GutterColumn gutterColumn = codeEditorGutter.lookupGutterColumn(columnNames[n]);
                if (gutterColumn == null) continue;
                codeEditorGutter.removeGutterColumn(gutterColumn);
            }
        }
    }

    static void createHighlightStyles() {
        disabledBPStyle = CodeEditor.createHighlightStyle((String)disabledBPStyleName, (String)DbgArb.getString(847), (int)25, (Color)Color.black, (Color)Color.green);
        enabledBPStyle = CodeEditor.createHighlightStyle((String)enabledBPStyleName, (String)DbgArb.getString(848), (int)30, (Color)Color.white, (Color)Color.red);
        ipStyle = CodeEditor.createHighlightStyle((String)ipStyleName, (String)DbgArb.getString(849), (int)40, (Color)Color.white, (Color)Color.blue);
        int n = 0;
        String string = n++ + ipStyleName;
        mapStyleToCategory.put(ipStyleName, string);
        String string2 = n++ + enabledBPStyleName;
        mapStyleToCategory.put(enabledBPStyleName, string2);
        String string3 = n + disabledBPStyleName;
        mapStyleToCategory.put(disabledBPStyleName, string3);
        FileOverviewMargin.setMarkColor((String)string3, (HighlightStyle)disabledBPStyle);
        FileOverviewMargin.setMarkColor((String)string2, (HighlightStyle)enabledBPStyle);
        FileOverviewMargin.setMarkColor((String)string, (HighlightStyle)ipStyle);
    }

    static Breakpoint ra$breakpoint(SourceIcon sourceIcon) {
        return sourceIcon.breakpoint;
    }

    static Map ra$mapGutterToCodeEditor() {
        return mapGutterToCodeEditor;
    }

    static void mav$removedDuringEdit(SourceIcon sourceIcon, CodeEditor codeEditor, int n) {
        sourceIcon.removedDuringEdit(codeEditor, n);
    }

    static void mav$removeFileOverviewMark(SourceIcon sourceIcon, CodeEditor codeEditor, int n) {
        sourceIcon.removeFileOverviewMark(codeEditor, n);
    }

    static int ra$line(SourceIcon sourceIcon) {
        return sourceIcon.line;
    }

    static void wa$line(SourceIcon sourceIcon, int n) {
        sourceIcon.line = n;
    }

    static void mav$addFileOverviewMark(SourceIcon sourceIcon, CodeEditor codeEditor, int n) {
        sourceIcon.addFileOverviewMark(codeEditor, n);
    }

    public static class SourceIconGutterColumnListener
    implements GutterColumnListener {
        public void markMoved(GutterMark gutterMark, int n, int n2) {
            SourceIcon sourceIcon = (SourceIcon)gutterMark.getUserData();
            CodeEditor codeEditor = (CodeEditor)SourceIcon.ra$mapGutterToCodeEditor().get(gutterMark.getGutter());
            SourceIcon.mav$removeFileOverviewMark(sourceIcon, codeEditor, n);
            if (SourceIcon.ra$line(sourceIcon) != 0) {
                SourceIcon.wa$line(sourceIcon, n2);
            }
            SourceIcon.mav$addFileOverviewMark(sourceIcon, codeEditor, n2);
            if (SourceIcon.ra$breakpoint(sourceIcon) != null) {
                SourceIcon.ra$breakpoint(sourceIcon).markMoved(gutterMark, n, n2);
            }
        }

        public void markRemoved(GutterMark gutterMark, int n) {
            SourceIcon sourceIcon = (SourceIcon)gutterMark.getUserData();
            SourceIcon.mav$removedDuringEdit(sourceIcon, (CodeEditor)SourceIcon.ra$mapGutterToCodeEditor().get(gutterMark.getGutter()), gutterMark.getLine());
            if (SourceIcon.ra$breakpoint(sourceIcon) != null) {
                SourceIcon.ra$breakpoint(sourceIcon).markRemoved(gutterMark, n);
            }
        }

        public void markClicked(GutterMark gutterMark, int n, MouseEvent mouseEvent) {
            SourceIcon sourceIcon = (SourceIcon)gutterMark.getUserData();
            if (SourceIcon.ra$breakpoint(sourceIcon) != null) {
                SourceIcon.ra$breakpoint(sourceIcon).markClicked(gutterMark, n, mouseEvent);
            }
        }

        public String getMarkToolTip(GutterMark gutterMark, MouseEvent mouseEvent) {
            SourceIcon sourceIcon = (SourceIcon)gutterMark.getUserData();
            return sourceIcon.getToolTipText(mouseEvent);
        }
    }
}

