/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.model.Element;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.InspectorWindow;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.LocalsWindow;
import oracle.jdevimpl.runner.debug.ProfilingEvents;
import oracle.jdevimpl.runner.debug.StackWindowSettings;
import oracle.jdevimpl.runner.debug.WatchWindow;

final class StackWindow
extends DockableWindow
implements ColumnMenuListener,
ContextMenuListener,
Controller,
ListSelectionListener {
    private List tableData;
    private JTable table;
    private StackTableCellRenderer stackTableCellRenderer;
    private StackTableModel model;
    private DebugStackFrameInfo highlightStackFrame;
    private LocalsWindow localsWindow;
    private WatchWindow watchWindow;
    private boolean skippedUpdate;
    private DebuggingProcess debuggingProcess;
    private DebugVirtualMachine vm;
    private DebugThreadInfo thread;
    private int languages;
    private String title;
    private JScrollPane scrollPane;
    private StackWindowSettings stackSettings;
    private int preferredVisibleRowCount;
    private static IdeAction actionPopToHere;
    private static IdeAction actionGoTo;
    private static IdeAction actionBytecode;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemPopToHere;
    private static JMenuItem menuitemGoTo;
    private static JMenuItem menuitemBytecode;
    private static JMenuItem menuitemSave;
    private static JMenuItem menuitemSettings;
    private static final int POPTOHERE_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int BYTECODE_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final int COLUMN_CLASS = 0;
    static final int COLUMN_METHOD = 1;
    static final int COLUMN_FILENAME = 2;
    static final int COLUMN_LINE = 3;
    static final int COLUMN_OFFSET = 4;
    static final int NUMBER_OF_COLUMNS = 5;
    private TableColumn[] column;
    private int[] columnDefaultWidth;
    private boolean[] columnShowing;
    static final String STACK_WINDOW_ID = "Debugger.StackWindow";
    private static Icon stackTabIcon;
    private static Icon methodIcon;
    private static final String NOT_AVAILABLE = "";
    private boolean adjustColumnsAlreadyDone;

    void $init$() {
        this.skippedUpdate = true;
        this.preferredVisibleRowCount = 6;
        this.column = new TableColumn[5];
        this.columnDefaultWidth = new int[5];
        this.columnShowing = new boolean[5];
        this.adjustColumnsAlreadyDone = false;
    }

    static {
        POPTOHERE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackPopToHere");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackGoTo");
        BYTECODE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackBytecode");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugStackSettings");
        stackTabIcon = null;
        methodIcon = null;
    }

    StackWindow() {
        super(STACK_WINDOW_ID);
        this.$init$();
        this.title = DbgArb.getString(282);
        JDebugger.getInstance().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        StackWindow.makeActions();
        this.setControllerForActions();
    }

    void setLocalsWindow(LocalsWindow localsWindow) {
        this.localsWindow = localsWindow;
        this.updateData(localsWindow);
    }

    void setWatchWindow(WatchWindow watchWindow) {
        this.watchWindow = watchWindow;
        this.updateData(watchWindow);
    }

    void newInspectorWindow(InspectorWindow inspectorWindow) {
        this.updateData(inspectorWindow);
    }

    void shutDown() {
        this.saveSettings();
    }

    private void loadSettings() {
        int[] nArray = this.stackSettings.getColumnWidth();
        int n = 0;
        while (n < 5) {
            if (nArray[n] != 0) {
                this.adjustColumnsAlreadyDone = true;
                this.column[n].setPreferredWidth(nArray[n]);
            }
            ++n;
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        String string = this.stackSettings.getColumnOrder();
        if (string != null) {
            int n2 = 0;
            while (n2 < 5) {
                String string2;
                int n3 = string.indexOf(44);
                if (n3 != -1) {
                    string2 = string.substring(0, n3);
                    string = string.substring(n3 + 1);
                } else {
                    string2 = string;
                }
                if (string2.length() == 0) break;
                try {
                    int n4 = tableColumnModel.getColumnIndex(string2);
                    if (n4 != n2) {
                        this.table.moveColumn(n4, n2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    void stackWindowSettingsChanged(boolean bl) {
        if (this.table == null) {
            return;
        }
        boolean[] blArray = this.stackSettings.getColumnVisible();
        int n = 0;
        while (n < 5) {
            if (this.columnShowing[n] != blArray[n]) {
                this.columnShowing[n] = blArray[n];
                if (blArray[n]) {
                    this.table.addColumn(this.column[n]);
                } else {
                    this.table.removeColumn(this.column[n]);
                }
            }
            ++n;
        }
        if (bl && this.table.isEnabled()) {
            SwingUtilities.invokeLater(new 9());
        }
        Dimension dimension = this.table.getPreferredSize();
        dimension.height = this.table.getTableHeader().getPreferredSize().height + this.preferredVisibleRowCount * this.table.getRowHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        this.scrollPane.setPreferredSize(dimension);
    }

    private void saveSettings() {
        if (this.table == null) {
            return;
        }
        int[] nArray = this.stackSettings.getColumnWidth();
        int n = 0;
        while (n < 5) {
            nArray[n] = this.column[n].getWidth();
            ++n;
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        String string = NOT_AVAILABLE;
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            string = string + tableColumn.getIdentifier() + ",";
        }
        this.stackSettings.setColumnOrder(string);
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu jMenu) {
        StackWindow.makeActions();
        float f = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionPopToHere), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoTo), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionBytecode), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), jMenu, f);
    }

    private static void makeActions() {
        if (actionGoTo == null) {
            actionGoTo = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(293), null, (Integer)DbgArb.getInteger(294), null, (int)-1, null, (boolean)false);
            actionGoTo.setEnabled(false);
            actionBytecode = IdeAction.get((int)BYTECODE_CMD_ID, null, (String)DbgArb.getString(295), null, (Integer)DbgArb.getInteger(296), null, (int)-1, null, (boolean)false);
            actionBytecode.setEnabled(false);
            actionPopToHere = IdeAction.get((int)POPTOHERE_CMD_ID, null, (String)DbgArb.getString(297), null, (Integer)DbgArb.getInteger(298), null, (int)-1, null, (boolean)false);
            actionPopToHere.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(101), null, (Integer)RunMgrArb.getInteger(102), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(99), null, (Integer)RunMgrArb.getInteger(100), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] ideActionArray = new IdeAction[]{actionGoTo, actionBytecode, actionPopToHere, actionSettings, actionSave};
        JDebugger.setControllerForActions(ideActionArray, this);
    }

    public Component getGUI() {
        if (this.scrollPane == null) {
            this.stackSettings = StackWindowSettings.getInstance();
            this.createGUI();
            this.loadSettings();
            this.stackWindowSettingsChanged(false);
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            this.everythingChanged();
            this.stackSettings.addChangeListener(new 8());
        }
        return this.scrollPane;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_stackwindow_html");
    }

    public Controller getController() {
        return this;
    }

    public Context getContext(EventObject eventObject) {
        DebugStackFrameInfo debugStackFrameInfo;
        StackItem stackItem = this.getSelectedStackItem();
        JDIInformationProvider jDIInformationProvider = null;
        if (stackItem != null && (debugStackFrameInfo = stackItem.getStackFrameInfo()) instanceof JDIInformationProvider) {
            jDIInformationProvider = (JDIInformationProvider)((Object)debugStackFrameInfo);
        }
        return ContextBuilder.buildContext((Element)stackItem, (View)this, eventObject, this.debuggingProcess, jDIInformationProvider);
    }

    public int getDefaultVisibility(Layout layout) {
        boolean bl = JDebugger.getInstance().canShowDebuggingWindows(layout);
        return bl ? 5 : 0;
    }

    public String getTabName() {
        return this.title;
    }

    public Icon getTabIcon() {
        if (stackTabIcon == null) {
            stackTabIcon = DbgArb.getIcon(66);
        }
        return stackTabIcon;
    }

    public String getTitleName() {
        return this.title;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting() && this.table.isShowing()) {
            this.highlightStackFrame = this.getSelectedStackFrameInfo();
            this.updateData();
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == GOTO_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                stackItem.showInSource();
            }
            return true;
        }
        if (n == BYTECODE_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                stackItem.showBytecode();
            }
            return true;
        }
        if (n == POPTOHERE_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                stackItem.popToHere();
            }
            return true;
        }
        if (n == SETTINGS_CMD_ID) {
            String[] stringArray = new String[]{DbgArb.getString(716), DbgArb.getString(756)};
            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
            return true;
        }
        if (n == SAVE_CMD_ID) {
            this.saveToFile();
            return true;
        }
        if (n == 18) {
            Object object;
            int n2;
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null && (n2 = this.table.getSelectedColumn()) != -1 && (object = stackItem.getValueOfColumn(n2)) != null) {
                IdeUtil.copyToClipboard((String)object.toString());
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (ideAction.getValue("Debugger.actionOwner") == this) {
            if (this.table == null || !this.isVisible()) {
                ideAction.setEnabled(false);
                return true;
            }
            if (!(this.table.isEnabled() && this.debuggingProcess != null && this.vm != null || n == SETTINGS_CMD_ID)) {
                ideAction.setEnabled(false);
                return true;
            }
        }
        if (n == GOTO_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                ideAction.setEnabled(stackItem.canShowInSource());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == BYTECODE_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                ideAction.setEnabled(stackItem.canShowBytecode());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == POPTOHERE_CMD_ID) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                ideAction.setEnabled(stackItem.canPopToHere());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == SETTINGS_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == SAVE_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == 18) {
            StackItem stackItem = this.getSelectedStackItem();
            int n2 = this.table.getSelectedColumn();
            ideAction.setEnabled(stackItem != null && n2 != -1);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (this.table != null && (Helpers.contextMatchesSource(context, this.table) || Helpers.contextMatchesSource(context, this.scrollPane))) {
            StackItem stackItem = this.getSelectedStackItem();
            if (stackItem != null) {
                this.addPopupMenuItemsForStackItem(contextMenu, context);
            }
            this.addPopupMenuItemsForStack(contextMenu, context);
            this.addPopupMenuItemsForCommon(contextMenu, context);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void showColumn(int n) {
        this.columnShowing[n] = true;
        if (this.stackSettings != null) {
            boolean[] blArray = this.stackSettings.getColumnVisible();
            blArray[n] = true;
        }
        this.table.addColumn(this.column[n]);
    }

    public void hideColumn(int n) {
        this.columnShowing[n] = false;
        if (this.stackSettings != null) {
            boolean[] blArray = this.stackSettings.getColumnVisible();
            blArray[n] = false;
        }
        this.table.removeColumn(this.column[n]);
    }

    private void createGUI() {
        this.tableData = new ArrayList();
        this.model = new StackTableModel(null);
        this.table = new JTable(this.model);
        this.table.getAccessibleContext().setAccessibleName(this.getTitleName());
        this.table.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        Set set = Collections.emptySet();
        this.table.setFocusTraversalKeys(0, set);
        this.table.setFocusTraversalKeys(1, set);
        Dimension dimension = new Dimension(0, 0);
        this.table.setIntercellSpacing(dimension);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = 0;
        while (n < 5) {
            this.column[n] = tableColumnModel.getColumn(n);
            this.columnDefaultWidth[n] = this.column[n].getPreferredWidth();
            this.columnShowing[n] = true;
            ++n;
        }
        boolean[] blArray = new boolean[5];
        Arrays.fill(blArray, true);
        if (Product.isRaptor()) {
            blArray[0] = false;
            blArray[4] = false;
        }
        JDebugger.addColumnsMenu(this.table, this, blArray);
        this.columnDefaultWidth[3] = this.columnDefaultWidth[3] / 2;
        this.column[3].setPreferredWidth(this.columnDefaultWidth[3]);
        this.columnDefaultWidth[4] = this.columnDefaultWidth[4] / 2;
        this.column[4].setPreferredWidth(this.columnDefaultWidth[4]);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(this);
        this.stackTableCellRenderer = new StackTableCellRenderer();
        this.table.setDefaultRenderer(String.class, this.stackTableCellRenderer);
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer(new 7(this, tableCellRenderer));
        this.table.addMouseListener(new 6());
        jTableHeader.addMouseListener(new 5());
        this.table.addKeyListener(new 4());
        this.scrollPane = new JScrollPane(this.table);
        Color color = this.table.getBackground();
        this.scrollPane.setBackground(color);
        this.scrollPane.getViewport().setBackground(color);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.addMouseListener(new 3());
        this.scrollPane.addComponentListener(new 2());
        this.table.addHierarchyListener(new 1());
    }

    private void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.scrollPane, this.table);
    }

    void showPopup(MouseEvent mouseEvent) {
        JDebugger.getInstance().showContextMenu(mouseEvent, this, this.table);
    }

    private void addPopupMenuItemsForStackItem(ContextMenu contextMenu, Context context) {
        this.update(actionPopToHere, context);
        if (actionPopToHere.isEnabled()) {
            if (menuitemPopToHere == null) {
                menuitemPopToHere = contextMenu.createMenuItem((ToggleAction)actionPopToHere);
            }
            contextMenu.add((Component)menuitemPopToHere, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
        }
        this.update(actionGoTo, context);
        if (actionGoTo.isEnabled()) {
            if (menuitemGoTo == null) {
                menuitemGoTo = contextMenu.createMenuItem((ToggleAction)actionGoTo);
            }
            contextMenu.add((Component)menuitemGoTo, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
        this.update(actionBytecode, context);
        if (actionBytecode.isEnabled()) {
            if (menuitemBytecode == null) {
                menuitemBytecode = contextMenu.createMenuItem((ToggleAction)actionBytecode);
            }
            contextMenu.add((Component)menuitemBytecode, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
    }

    private void addPopupMenuItemsForStack(ContextMenu contextMenu, Context context) {
    }

    private void addPopupMenuItemsForCommon(ContextMenu contextMenu, Context context) {
        this.update(actionSave, context);
        if (actionSave.isEnabled()) {
            if (menuitemSave == null) {
                menuitemSave = contextMenu.createMenuItem((ToggleAction)actionSave);
            }
            contextMenu.add((Component)menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
        this.update(actionSettings, context);
        if (actionSettings.isEnabled()) {
            if (menuitemSettings == null) {
                menuitemSettings = contextMenu.createMenuItem((ToggleAction)actionSettings);
            }
            contextMenu.add((Component)menuitemSettings, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
    }

    private void selectRow(int n) {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.clearSelection();
        listSelectionModel.addSelectionInterval(n, n);
    }

    private void saveToFile() {
        URL uRL;
        String string = RunMgrArb.format(103, this.getTitleName());
        URLChooser uRLChooser = DialogUtil.newURLChooser((Context)this.getContext());
        if (JDebugger.lastSavedFile != null) {
            uRLChooser.setSelectedURL(JDebugger.lastSavedFile);
        }
        if (uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), string) == 0 && (uRL = uRLChooser.getSelectedURL()) != null) {
            JDebugger.lastSavedFile = uRL;
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            Exception exception = null;
            try {
                PrintWriter printWriter;
                String string2 = URLFileSystem.getSuffix((URL)uRL).toUpperCase();
                boolean bl = string2.equals(".HTML") || string2.equals(".HTM");
                PrintWriter printWriter2 = printWriter = bl ? JDebugger.printHtmlHeader(uRL, this.getTitleName()) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)uRL)));
                if (bl) {
                    printWriter.println("<table border=\"1\">");
                }
                TableColumnModel tableColumnModel = this.table.getColumnModel();
                int n = tableColumnModel.getColumnCount();
                int[] nArray = new int[n];
                int n2 = 0;
                Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
                while (enumeration.hasMoreElements()) {
                    TableColumn tableColumn = enumeration.nextElement();
                    nArray[n2++] = tableColumn.getModelIndex();
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                if (bl) {
                    stringBuffer.append("<tr>");
                }
                n2 = 0;
                while (n2 < n) {
                    String string3 = this.model.getColumnName(nArray[n2]);
                    if (bl) {
                        stringBuffer.append("<th>");
                        string3 = IdeUtil.replaceHTMLReservedCharacters((String)string3.toString());
                        stringBuffer.append(string3);
                        stringBuffer.append("</th>");
                    } else {
                        stringBuffer.append(string3);
                        int n3 = string3.length();
                        while (n3 >= 0) {
                            stringBuffer2.append('-');
                            --n3;
                        }
                        if (n2 < n - 1) {
                            stringBuffer.append('\t');
                            stringBuffer2.append('\t');
                        }
                    }
                    ++n2;
                }
                if (bl) {
                    stringBuffer.append("</tr>");
                }
                printWriter.println(stringBuffer.toString());
                if (!bl) {
                    printWriter.println(stringBuffer2.toString());
                }
                int n4 = this.tableData.size();
                int n5 = 0;
                while (n5 < n4) {
                    stringBuffer.setLength(0);
                    if (bl) {
                        stringBuffer.append("<tr>");
                    }
                    n2 = 0;
                    while (n2 < n) {
                        Object object = this.model.getValueAt(n5, nArray[n2]);
                        if (bl) {
                            stringBuffer.append("<td>");
                            String string4 = IdeUtil.replaceHTMLReservedCharacters((String)object.toString());
                            if (string4.length() > 0) {
                                stringBuffer.append(string4);
                            } else {
                                stringBuffer.append("&nbsp;");
                            }
                            stringBuffer.append("</td>");
                        } else {
                            stringBuffer.append(object);
                            if (n2 < n - 1) {
                                stringBuffer.append('\t');
                            }
                        }
                        ++n2;
                    }
                    if (bl) {
                        stringBuffer.append("</tr>");
                    }
                    printWriter.println(stringBuffer.toString());
                    ++n5;
                }
                if (bl) {
                    printWriter.println("</table>");
                    JDebugger.printHtmlFooter(printWriter);
                }
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            waitCursor.hide();
            if (exception != null) {
                String string5 = DbgArb.format(858, DbgArb.getString(282), URLFileSystem.getPlatformPathName((URL)uRL));
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)string, (String)string5, null);
            }
        }
    }

    private void nowShown() {
        if (this.skippedUpdate && this.table.isEnabled()) {
            this.updateModel();
        }
    }

    void everythingChanged() {
        this.highlightStackFrame = null;
        this.updateModel();
    }

    void updateStack(DebuggingProcess debuggingProcess, DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo) {
        int n = -1;
        if (ProfilingEvents.eventOn[3]) {
            n = IdeProfile.startEvent((int)ProfilingEvents.eventId[3]);
        }
        this.debuggingProcess = debuggingProcess;
        this.vm = debugVirtualMachine;
        this.thread = debugThreadInfo;
        this.highlightStackFrame = null;
        this.updateModel();
        if (ProfilingEvents.eventOn[3]) {
            IdeProfile.endEvent((int)n);
        }
    }

    private void updateModel() {
        if (this.table == null) {
            return;
        }
        boolean bl = true;
        this.stackTableCellRenderer.clear();
        DebugStackFrameInfo debugStackFrameInfo = this.highlightStackFrame;
        this.table.getSelectionModel().clearSelection();
        this.highlightStackFrame = debugStackFrameInfo;
        if (this.highlightStackFrame == null && this.thread != null) {
            this.highlightStackFrame = this.thread.getStackFrame(0);
        }
        this.table.setEnabled(true);
        if (this.table.isShowing()) {
            this.skippedUpdate = false;
            if (this.debuggingProcess != null && this.vm != null && this.thread != null) {
                int n = this.vm.getLanguages();
                if (this.languages != n) {
                    this.languages = n;
                    int n2 = 0;
                    while (n2 < 5) {
                        this.column[n2].setHeaderValue(this.model.getColumnName(n2));
                        ++n2;
                    }
                    this.table.getTableHeader().repaint();
                }
                DebugStackFrameInfo[] debugStackFrameInfoArray = this.thread != null ? this.thread.listStack() : new DebugStackFrameInfo[]{};
                int n3 = debugStackFrameInfoArray.length;
                ArrayList<StackItem> arrayList = new ArrayList<StackItem>();
                int n4 = 0;
                while (n4 < n3) {
                    arrayList.add(new StackItem(debugStackFrameInfoArray[n4]));
                    ++n4;
                }
                this.updateTable(arrayList);
                if (this.highlightStackFrame != null) {
                    int n5 = this.highlightStackFrame.getFrameNumber();
                    this.selectRow(n5);
                    bl = false;
                }
            } else {
                this.updateTable(new ArrayList());
            }
        } else {
            this.skippedUpdate = true;
        }
        if (bl) {
            this.updateData();
        }
    }

    void clearStack() {
        if (this.table == null) {
            return;
        }
        int n = -1;
        if (ProfilingEvents.eventOn[8]) {
            n = IdeProfile.startEvent((int)ProfilingEvents.eventId[8]);
        }
        this.table.setEnabled(false);
        int n2 = this.tableData.size();
        int n3 = 0;
        while (n3 < n2) {
            StackItem stackItem = (StackItem)this.tableData.get(n3);
            stackItem.clearStack();
            ++n3;
        }
        this.vm = null;
        this.thread = null;
        this.updateData();
        if (ProfilingEvents.eventOn[8]) {
            IdeProfile.endEvent((int)n);
        }
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        if (this.debuggingProcess == debuggingProcess) {
            this.debuggingProcess = null;
            this.highlightStackFrame = null;
            this.table.setEnabled(true);
            this.updateTable(new ArrayList());
        }
        if (this.localsWindow != null) {
            this.localsWindow.processFinished(debuggingProcess);
        }
        if (this.watchWindow != null) {
            this.watchWindow.processFinished(debuggingProcess);
        }
        Iterator iterator = JDebugger.getInstance().getInspectorWindows();
        while (iterator.hasNext()) {
            InspectorWindow inspectorWindow = (InspectorWindow)((Object)iterator.next());
            inspectorWindow.processFinished(debuggingProcess);
        }
    }

    private void updateData() {
        this.updateData(this.localsWindow);
        this.updateData(this.watchWindow);
        Iterator iterator = JDebugger.getInstance().getInspectorWindows();
        while (iterator.hasNext()) {
            InspectorWindow inspectorWindow = (InspectorWindow)((Object)iterator.next());
            this.updateData(inspectorWindow);
        }
    }

    void updateEvaluator(Evaluator evaluator) {
        if (this.table.isEnabled() && this.debuggingProcess != null && this.vm != null && this.thread != null) {
            evaluator.setDebugContext(this.vm, this.thread, this.highlightStackFrame);
        } else {
            evaluator.setDebugContext(null, null, null);
        }
    }

    private void updateData(DataWindow dataWindow) {
        if (dataWindow != null) {
            if (this.table != null && this.table.isEnabled()) {
                if (this.debuggingProcess != null && this.vm != null && this.thread != null) {
                    dataWindow.updateData(this.debuggingProcess, this.vm, this.thread, this.highlightStackFrame);
                } else {
                    dataWindow.updateData(null, null, null, null);
                }
            } else {
                dataWindow.clearData();
            }
        }
    }

    private void updateTable(List list) {
        this.tableData = list;
        this.model.fireTableChanged(new TableModelEvent(this.model));
    }

    private void updateColumn(int n) {
        this.clearCacheForColumn(n);
        this.model.fireTableChanged(new TableModelEvent(this.model, 0, this.tableData.size() - 1, n));
    }

    void clearCacheForColumn(int n) {
        int n2 = this.tableData.size();
        int n3 = 0;
        while (n3 < n2) {
            StackItem stackItem = (StackItem)this.tableData.get(n3);
            stackItem.clearCacheForColumn(n);
            ++n3;
        }
    }

    private StackItem getSelectedStackItem() {
        int n;
        if (this.table != null && 0 <= (n = this.table.getSelectedRow()) && n < this.tableData.size()) {
            return (StackItem)this.tableData.get(n);
        }
        return null;
    }

    private DebugStackFrameInfo getSelectedStackFrameInfo() {
        StackItem stackItem = this.getSelectedStackItem();
        if (stackItem != null) {
            return stackItem.getStackFrameInfo();
        }
        return null;
    }

    static void mav$updateColumn(StackWindow stackWindow, int n) {
        stackWindow.updateColumn(n);
    }

    static DebuggingProcess ra$debuggingProcess(StackWindow stackWindow) {
        return stackWindow.debuggingProcess;
    }

    static IdeAction ra$actionGoTo() {
        return actionGoTo;
    }

    static void mav$adjustColumnsAfterResize(StackWindow stackWindow) {
        stackWindow.adjustColumnsAfterResize();
    }

    static JTable ra$table(StackWindow stackWindow) {
        return stackWindow.table;
    }

    static void mav$nowShown(StackWindow stackWindow) {
        stackWindow.nowShown();
    }

    static List ra$tableData(StackWindow stackWindow) {
        return stackWindow.tableData;
    }

    static StackTableModel ra$model(StackWindow stackWindow) {
        return stackWindow.model;
    }

    static int ra$languages(StackWindow stackWindow) {
        return stackWindow.languages;
    }

    static DebugVirtualMachine ra$vm(StackWindow stackWindow) {
        return stackWindow.vm;
    }

    static DebugThreadInfo ra$thread(StackWindow stackWindow) {
        return stackWindow.thread;
    }

    static StackWindowSettings ra$stackSettings(StackWindow stackWindow) {
        return stackWindow.stackSettings;
    }

    static Icon ra$methodIcon() {
        return methodIcon;
    }

    static void wa$methodIcon(Icon icon) {
        methodIcon = icon;
    }

    final class 9
    implements Runnable {
        public void run() {
            StackWindow.mav$updateColumn(StackWindow.this, 0);
        }
    }

    final class 8
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            StackWindow.this.stackWindowSettingsChanged(true);
        }
    }

    final class 7
    extends DefaultTableCellRenderer {
        private final /* synthetic */ TableCellRenderer v$headerRenderer;
        final /* synthetic */ StackWindow this$0;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.v$headerRenderer instanceof DefaultTableCellRenderer) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this.v$headerRenderer;
                int n3 = jTable.convertColumnIndexToModel(n2);
                int n4 = 2;
                if (n3 == 3 || n3 == 4) {
                    n4 = 4;
                }
                defaultTableCellRenderer.setHorizontalAlignment(n4);
            }
            return this.v$headerRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public 7(StackWindow stackWindow, TableCellRenderer tableCellRenderer) {
            this.v$headerRenderer = tableCellRenderer;
            this.this$0 = stackWindow;
        }
    }

    final class 6
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                StackWindow.this.showPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                StackWindow.this.showPopup(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (StackWindow.ra$debuggingProcess(StackWindow.this) == null || !StackWindow.ra$debuggingProcess(StackWindow.this).isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(354, StackWindow.this.getTitleName()));
            }
            if ((mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getClickCount() == 2) {
                Context context = StackWindow.this.getContext(mouseEvent);
                StackWindow.this.update(StackWindow.ra$actionGoTo(), context);
                if (StackWindow.ra$actionGoTo().isEnabled()) {
                    StackWindow.this.handleEvent(StackWindow.ra$actionGoTo(), context);
                }
            }
        }
    }

    final class 5
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (StackWindow.ra$debuggingProcess(StackWindow.this) == null || !StackWindow.ra$debuggingProcess(StackWindow.this).isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(354, StackWindow.this.getTitleName()));
            }
        }
    }

    final class 4
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 10: {
                    Context context = StackWindow.this.getContext(keyEvent);
                    StackWindow.this.update(StackWindow.ra$actionGoTo(), context);
                    if (!StackWindow.ra$actionGoTo().isEnabled()) break;
                    StackWindow.this.handleEvent(StackWindow.ra$actionGoTo(), context);
                    keyEvent.consume();
                }
            }
        }
    }

    final class 3
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                StackWindow.this.showPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                StackWindow.this.showPopup(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (StackWindow.ra$debuggingProcess(StackWindow.this) == null || !StackWindow.ra$debuggingProcess(StackWindow.this).isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(354, StackWindow.this.getTitleName()));
            }
        }
    }

    final class 2
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            StackWindow.mav$adjustColumnsAfterResize(StackWindow.this);
        }
    }

    final class 1
    implements HierarchyListener {
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & (long)4) != 0L && StackWindow.ra$table(StackWindow.this).isShowing()) {
                StackWindow.mav$nowShown(StackWindow.this);
            }
        }
    }

    class StackTableCellRenderer
    extends DefaultTableCellRenderer {
        private StackItem stackItem;
        private int modelColumn;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.stackItem = (StackItem)StackWindow.ra$tableData(StackWindow.this).get(n);
            this.modelColumn = jTable.convertColumnIndexToModel(n2);
            int n3 = 2;
            if (this.modelColumn == 3 || this.modelColumn == 4) {
                n3 = 4;
            }
            this.setHorizontalAlignment(n3);
            if (n2 == 0) {
                this.setIcon(this.stackItem.getIcon());
            } else {
                this.setIcon(null);
            }
            AccessibleContext accessibleContext = this.getAccessibleContext();
            String string = StackTableModel.mav$getAccessibleNameAt(StackWindow.ra$model(StackWindow.this), n, this.modelColumn);
            if (string != null) {
                accessibleContext.setAccessibleName(string);
            }
            return this;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            return this.stackItem.getToolTip(this.modelColumn);
        }

        void clear() {
            this.stackItem = null;
        }

        StackTableCellRenderer() {
        }
    }

    private final class StackTableModel
    extends AbstractTableModel {
        public int getRowCount() {
            return StackWindow.ra$tableData(StackWindow.this).size();
        }

        public int getColumnCount() {
            return 5;
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    if (StackWindow.ra$languages(StackWindow.this) == 8) {
                        return DbgArb.getString(895);
                    }
                    if (StackWindow.ra$languages(StackWindow.this) == 4) {
                        return DbgArb.getString(285);
                    }
                    return DbgArb.getString(284);
                }
                case 1: {
                    if (Product.isRaptor()) {
                        return DbgArb.getString(288);
                    }
                    if (StackWindow.ra$languages(StackWindow.this) == 8) {
                        return DbgArb.getString(896);
                    }
                    if (StackWindow.ra$languages(StackWindow.this) == 4) {
                        return DbgArb.getString(287);
                    }
                    return DbgArb.getString(286);
                }
                case 2: {
                    return DbgArb.getString(290);
                }
                case 3: {
                    return DbgArb.getString(291);
                }
                case 4: {
                    return DbgArb.getString(292);
                }
            }
            return StackWindow.NOT_AVAILABLE;
        }

        public Object getValueAt(int n, int n2) {
            try {
                StackItem stackItem = (StackItem)StackWindow.ra$tableData(StackWindow.this).get(n);
                Object object = stackItem.getValueOfColumn(n2);
                return object;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        private String getAccessibleNameAt(int n, int n2) {
            int n3 = 283;
            String string = this.getColumnName(n2);
            String string2 = (String)this.getValueAt(n, n2);
            if (string2.length() == 0) {
                string2 = DbgArb.getString(884);
            }
            return DbgArb.format(n3, string, string2);
        }

        private StackTableModel() {
        }

        StackTableModel(1 var2_2) {
            this();
        }

        static String mav$getAccessibleNameAt(StackTableModel stackTableModel, int n, int n2) {
            return stackTableModel.getAccessibleNameAt(n, n2);
        }

        public final class 1 {
        }
    }

    private final class StackItem
    extends BaseElement {
        private DebugStackFrameInfo stackFrame;
        private DebugLocation location;
        private DebugClassInfo clazz;
        private DebugMethodInfo method;
        private String filename;
        private int line;
        private int bc;
        private String cachedMethodName;
        private String cachedClassName;

        StackItem(DebugStackFrameInfo debugStackFrameInfo) {
            this.stackFrame = debugStackFrameInfo;
            this.location = debugStackFrameInfo.getLocation();
            if (this.location != null) {
                this.clazz = this.location.getClassInfo();
                this.method = this.location.getMethod();
                this.filename = this.location.getFilename();
                if (Product.isRaptor() && this.filename != null && this.filename.endsWith(".pls")) {
                    this.filename = this.filename.substring(0, this.filename.length() - 4);
                }
                this.line = this.location.getLine();
                this.bc = this.location.getBytecodeOffset();
            }
            if (StackWindow.ra$methodIcon() == null) {
                StackWindow.wa$methodIcon(JavaIcons.getIcon(3));
            }
            this.setIcon(StackWindow.ra$methodIcon());
        }

        void clearStack() {
            this.stackFrame = null;
            this.location = null;
            this.clazz = null;
            this.method = null;
        }

        void clearCacheForColumn(int n) {
            switch (n) {
                case 0: {
                    this.cachedClassName = null;
                    break;
                }
                case 1: {
                    this.cachedMethodName = null;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }

        Object getValueOfColumn(int n) {
            switch (n) {
                case 0: {
                    return this.getClassName();
                }
                case 1: {
                    return this.getMethodName();
                }
                case 2: {
                    return this.getFilename();
                }
                case 3: {
                    return this.getLine();
                }
                case 4: {
                    return this.getOffset();
                }
            }
            return null;
        }

        String getToolTip(int n) {
            String string = null;
            if (!Product.isRaptor()) {
                switch (n) {
                    case 0: {
                        if (this.clazz == null) break;
                        string = DebugShared.makeCourtesyClassName(this.clazz, true);
                        break;
                    }
                    case 1: {
                        if (this.method == null) break;
                        string = DebugShared.makeCourtesyMethodName(this.method, false, true, this.stackFrame);
                    }
                }
            }
            if (string == null) {
                string = (String)this.getValueOfColumn(n);
            }
            if (string != null && string.length() > 0) {
                return string;
            }
            return null;
        }

        public String getShortLabel() {
            return this.getMethodName();
        }

        public Object getData() {
            return this;
        }

        DebugStackFrameInfo getStackFrameInfo() {
            return this.stackFrame;
        }

        String getClassName() {
            if (this.cachedClassName == null && StackWindow.ra$table(StackWindow.this).isEnabled() && this.clazz != null) {
                this.cachedClassName = DebugShared.makeCourtesyClassName(this.clazz, StackWindow.ra$stackSettings(StackWindow.this).isShowPackages());
            }
            if (this.cachedClassName != null) {
                return this.cachedClassName;
            }
            return StackWindow.NOT_AVAILABLE;
        }

        String getMethodName() {
            if (this.cachedMethodName == null && StackWindow.ra$table(StackWindow.this).isEnabled()) {
                if (Product.isRaptor()) {
                    int n;
                    int n2;
                    String string;
                    int n3;
                    if (this.stackFrame != null && this.stackFrame.getLanguage() == 2 && this.clazz != null && this.method != null && (n3 = (string = this.clazz.getName()).indexOf(".")) != -1 && (n2 = string.indexOf(".", 8)) != -1 && (n = string.indexOf(".", n2 + 1)) != -1) {
                        String string2 = string.substring(n3 + 1, n2);
                        String string3 = string.substring(n2 + 1, n) + ".";
                        if (string2.equals("Block")) {
                            string3 = string3 + DbgArb.getString(289);
                        } else {
                            if (string2.equals("PackageBody") || string2.equals("TypeBody")) {
                                String string4 = string.substring(n + 1);
                                string3 = string3 + string4 + ".";
                            }
                            string3 = string3 + this.method.getNameWithoutClassOrSignature();
                        }
                        this.cachedMethodName = string3;
                    }
                    if (this.cachedMethodName == null && this.method != null) {
                        this.cachedMethodName = this.method.getNameWithoutSignature();
                    }
                } else if (this.method != null) {
                    this.cachedMethodName = DebugShared.makeCourtesyMethodName(this.method, false, false, this.stackFrame);
                }
            }
            if (this.cachedMethodName != null) {
                return this.cachedMethodName;
            }
            return StackWindow.NOT_AVAILABLE;
        }

        String getFilename() {
            if (this.filename != null) {
                return this.filename;
            }
            return StackWindow.NOT_AVAILABLE;
        }

        String getLine() {
            if (this.line > 0) {
                return Integer.toString(this.line);
            }
            return StackWindow.NOT_AVAILABLE;
        }

        String getOffset() {
            if (this.bc >= 0) {
                return Integer.toString(this.bc);
            }
            return StackWindow.NOT_AVAILABLE;
        }

        boolean canShowInSource() {
            return this.location != null || this.clazz != null;
        }

        void showInSource() {
            if (this.location != null) {
                StackWindow.ra$debuggingProcess(StackWindow.this).showSourceFile(this.location, true);
            } else if (this.clazz != null) {
                StackWindow.ra$debuggingProcess(StackWindow.this).showSourceFile(this.clazz);
            }
        }

        boolean canPopToHere() {
            if (StackWindow.ra$debuggingProcess(StackWindow.this) != null && StackWindow.ra$vm(StackWindow.this) != null && StackWindow.ra$thread(StackWindow.this) != null && StackWindow.ra$vm(StackWindow.this).getCapabilities().canPopFrames() && this.stackFrame.getFrameNumber() != 0) {
                int n = StackWindow.ra$tableData(StackWindow.this).indexOf(this);
                while (n >= 0) {
                    StackItem stackItem = (StackItem)StackWindow.ra$tableData(StackWindow.this).get(n);
                    if (stackItem.method == null) {
                        return false;
                    }
                    if ((stackItem.method.getAccess() & 0x100) != 0) {
                        return false;
                    }
                    --n;
                }
                return true;
            }
            return false;
        }

        void popToHere() {
            if (this.canPopToHere()) {
                this.stackFrame.popBackToHere();
                StackWindow.ra$debuggingProcess(StackWindow.this).stackFramesPopped(StackWindow.ra$thread(StackWindow.this));
            }
        }

        boolean canShowBytecode() {
            return StackWindow.ra$vm(StackWindow.this) != null && StackWindow.ra$vm(StackWindow.this).getCapabilities().canDisassembleMethod() && this.stackFrame.getLanguage() == 1 && this.method != null;
        }

        void showBytecode() {
            if (this.canShowBytecode()) {
                StackWindow.ra$debuggingProcess(StackWindow.this).showBytecode(this.method, this.bc);
            }
        }
    }
}

