/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.Arrays;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.config.ClientSetting;
import oracle.ide.util.ModelUtil;
import oracle.ideri.util.Product;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.runner.debug.JDebugger;

public final class StackWindowSettings
extends ChangeEventSource
implements Copyable {
    public static final String KEY_SETTINGS = "StackWindowOptions";
    private boolean _showPackages;
    private final boolean[] _columnVisible;
    private final int[] _columnWidth;
    private String _columnOrder;

    static StackWindowSettings getInstance() {
        return (StackWindowSettings)ClientSetting.findOrCreate((String)JDebugger.getExtensionID()).getData(KEY_SETTINGS);
    }

    void $init$() {
        this._columnVisible = new boolean[5];
        this._columnWidth = new int[5];
    }

    public StackWindowSettings() {
        this.$init$();
        this.defaultInit();
    }

    public StackWindowSettings(StackWindowSettings stackWindowSettings) {
        this.$init$();
        if (stackWindowSettings == null) {
            this.defaultInit();
        } else {
            stackWindowSettings.copyToImpl(this);
        }
    }

    private void defaultInit() {
        this._showPackages = false;
        Arrays.fill(this._columnVisible, false);
        if (Product.isRaptor()) {
            this._columnVisible[1] = true;
        } else {
            this._columnVisible[0] = true;
            this._columnVisible[1] = true;
        }
        Arrays.fill(this._columnWidth, 0);
        this._columnOrder = null;
    }

    public Object copyTo(Object object) {
        StackWindowSettings stackWindowSettings = object != null ? (StackWindowSettings)((Object)object) : new StackWindowSettings();
        this.copyToImpl(stackWindowSettings);
        return stackWindowSettings;
    }

    protected final void copyToImpl(StackWindowSettings stackWindowSettings) {
        stackWindowSettings._showPackages = this._showPackages;
        System.arraycopy(this._columnVisible, 0, stackWindowSettings._columnVisible, 0, this._columnVisible.length);
        System.arraycopy(this._columnWidth, 0, stackWindowSettings._columnWidth, 0, this._columnWidth.length);
        stackWindowSettings._columnOrder = this._columnOrder;
        stackWindowSettings.fireChangeEvent();
    }

    public boolean isShowPackages() {
        return this._showPackages;
    }

    public void setShowPackages(boolean bl) {
        this._showPackages = bl;
    }

    public boolean[] getColumnVisible() {
        return this._columnVisible;
    }

    public void setColumnVisible(boolean[] blArray) {
        System.arraycopy(blArray, 0, this._columnVisible, 0, blArray.length);
    }

    public int[] getColumnWidth() {
        return this._columnWidth;
    }

    public void setColumnWidth(int[] nArray) {
        System.arraycopy(nArray, 0, this._columnWidth, 0, nArray.length);
    }

    public String getColumnOrder() {
        return this._columnOrder;
    }

    public void setColumnOrder(String string) {
        this._columnOrder = string;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((StackWindowSettings)((Object)object));
    }

    protected final boolean equalsImpl(StackWindowSettings stackWindowSettings) {
        return this._showPackages == stackWindowSettings._showPackages && Arrays.equals(this._columnVisible, stackWindowSettings._columnVisible) && Arrays.equals(this._columnWidth, stackWindowSettings._columnWidth) && ModelUtil.areEqual((Object)this._columnOrder, (Object)stackWindowSettings._columnOrder);
    }
}

