/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.StackWindowSettings;

public final class StackWindowSettingsPanel
extends DefaultTraversablePanel {
    private JCheckBox showColumnClassCheckBox;
    private JCheckBox showColumnMethodCheckBox;
    private JCheckBox showColumnFilenameCheckBox;
    private JCheckBox showColumnLineCheckBox;
    private JCheckBox showPackagesCheckBox;
    private JLabel spacerLabel;

    void $init$() {
        this.showColumnClassCheckBox = new JCheckBox();
        this.showColumnMethodCheckBox = new JCheckBox();
        this.showColumnFilenameCheckBox = new JCheckBox();
        this.showColumnLineCheckBox = new JCheckBox();
        this.showPackagesCheckBox = new JCheckBox();
        this.spacerLabel = new JLabel();
    }

    public StackWindowSettingsPanel() {
        this.$init$();
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_deb_stackwindowsetpanel_html");
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.showColumnClassCheckBox, (String)DbgArb.getString(758));
        ResourceUtils.resButton((AbstractButton)this.showColumnMethodCheckBox, (String)DbgArb.getString(759));
        ResourceUtils.resButton((AbstractButton)this.showColumnFilenameCheckBox, (String)DbgArb.getString(760));
        ResourceUtils.resButton((AbstractButton)this.showColumnLineCheckBox, (String)DbgArb.getString(761));
        ResourceUtils.resButton((AbstractButton)this.showPackagesCheckBox, (String)DbgArb.getString(757));
        this.spacerLabel.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0);
        Insets insets = new Insets(0, 0, 0, 0);
        this.add(this.makeChooseColumnsPanel(insets), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 10;
        this.add(this.makeMiscPanel(insets), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        this.add(this.spacerLabel, gridBagConstraints);
    }

    private JPanel makeChooseColumnsPanel(Insets insets) {
        JPanel jPanel = new JPanel(new GridLayout(0, 2, 0, 0));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(RunMgrArb.getString(94));
        jPanel.setBorder(titledBorder);
        if (insets != null) {
            Insets insets2 = titledBorder.getBorderInsets(jPanel);
            insets.top = insets2.top;
            insets.left = insets2.left;
            insets.bottom = insets2.bottom;
            insets.right = insets2.right;
        }
        jPanel.add(this.showColumnClassCheckBox);
        jPanel.add(this.showColumnMethodCheckBox);
        jPanel.add(this.showColumnFilenameCheckBox);
        jPanel.add(this.showColumnLineCheckBox);
        return jPanel;
    }

    private JPanel makeMiscPanel(Insets insets) {
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, insets.left, 0, insets.right));
        jPanel.add(this.showPackagesCheckBox);
        return jPanel;
    }

    public void onEntry(TraversableContext traversableContext) {
        StackWindowSettings stackWindowSettings = (StackWindowSettings)((Object)traversableContext.find("StackWindowOptions"));
        boolean[] blArray = stackWindowSettings.getColumnVisible();
        this.showColumnClassCheckBox.setSelected(blArray[0]);
        this.showColumnMethodCheckBox.setSelected(blArray[1]);
        this.showColumnFilenameCheckBox.setSelected(blArray[2]);
        this.showColumnLineCheckBox.setSelected(blArray[3]);
        this.showPackagesCheckBox.setSelected(stackWindowSettings.isShowPackages());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        StackWindowSettings stackWindowSettings = (StackWindowSettings)((Object)traversableContext.find("StackWindowOptions"));
        boolean[] blArray = stackWindowSettings.getColumnVisible();
        blArray[0] = this.showColumnClassCheckBox.isSelected();
        blArray[1] = this.showColumnMethodCheckBox.isSelected();
        blArray[2] = this.showColumnFilenameCheckBox.isSelected();
        blArray[3] = this.showColumnLineCheckBox.isSelected();
        stackWindowSettings.setShowPackages(this.showPackagesCheckBox.isSelected());
    }
}

