/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.DockableWindow;
import oracle.ide.model.Element;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeProfile;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassLoaderInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.JDIInformationProvider;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.BaseElement;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.ColumnMenuListener;
import oracle.jdevimpl.runner.debug.ContextBuilder;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ProfilingEvents;
import oracle.jdevimpl.runner.debug.ThreadsPanelSettings;

abstract class ThreadsPanel
implements ColumnMenuListener,
Comparator,
ContextMenuListener,
Controller,
TreeSelectionListener,
TreeExpansionListener {
    protected DockableWindow dockableWindow;
    protected ThreadTreeTableModel model;
    protected JFastTreeTable treeTable;
    private JScrollPane scrollPane;
    private boolean skippedUpdate;
    protected DebuggingProcess debuggingProcess;
    protected DebugVirtualMachine vm;
    private ThreadsPanelSettings threadsPanelSettings;
    protected int preferredVisibleRowCount;
    protected boolean boldCurrentThreadName;
    protected boolean boldDeadlockedThreadStatus;
    protected IdeAction _actionGoTo;
    protected IdeAction _actionSave;
    protected JMenuItem _menuitemGoTo;
    protected JMenuItem _menuitemSave;
    protected int _GOTO_CMD_ID;
    protected int _SAVE_CMD_ID;
    static final int COLUMN_NAME = 0;
    static final int COLUMN_STATUS = 1;
    static final int COLUMN_GROUP = 2;
    static final int COLUMN_PRIORITY = 3;
    static final int COLUMN_DAEMON = 4;
    static final int NUMBER_OF_COLUMNS = 5;
    protected TableColumn[] column;
    protected int[] columnDefaultWidth;
    private boolean[] columnShowing;
    private static Icon threadGroupIcon = null;
    private static Icon threadIcon = null;
    private static Icon threadIconGray = null;
    private static Icon currentThreadIcon = null;
    private static Icon currentThreadIconGray = null;
    private static final String NOT_AVAILABLE = "";
    private boolean adjustColumnsAlreadyDone;
    private Font normalFont;
    private Font boldFont;

    void $init$() {
        this.skippedUpdate = true;
        this.preferredVisibleRowCount = 6;
        this.boldCurrentThreadName = true;
        this.boldDeadlockedThreadStatus = true;
        this.column = new TableColumn[5];
        this.columnDefaultWidth = new int[5];
        this.columnShowing = new boolean[5];
        this.adjustColumnsAlreadyDone = false;
    }

    ThreadsPanel(DockableWindow dockableWindow, ThreadsPanelSettings threadsPanelSettings) {
        this.$init$();
        this.dockableWindow = dockableWindow;
        this.threadsPanelSettings = threadsPanelSettings;
        JDebugger.getInstance().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        threadsPanelSettings.addChangeListener(new 11());
    }

    public void showColumn(int n) {
        if (n != 0) {
            this.columnShowing[n] = true;
            if (this.threadsPanelSettings != null) {
                boolean[] blArray = this.threadsPanelSettings.getColumnVisible();
                blArray[n] = true;
            }
            this.treeTable.addColumn(this.column[n]);
        }
    }

    public void hideColumn(int n) {
        if (n != 0) {
            this.columnShowing[n] = false;
            if (this.threadsPanelSettings != null) {
                boolean[] blArray = this.threadsPanelSettings.getColumnVisible();
                blArray[n] = false;
            }
            this.treeTable.removeColumn(this.column[n]);
        }
    }

    private void createGUI() {
        this.model = new ThreadTreeTableModel(new ArrayList());
        this.treeTable = new JFastTreeTable((TreeTableModel)this.model);
        this.treeTable.setKeySearchNavigable(true);
        this.treeTable.getAccessibleContext().setAccessibleName(this.dockableWindow.getTitleName());
        this.treeTable.setAutoResizeMode(DebugWindowSettings.getInstance().getTableResizeMode());
        Set set = Collections.emptySet();
        this.treeTable.setFocusTraversalKeys(0, set);
        this.treeTable.setFocusTraversalKeys(1, set);
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        int n = 0;
        while (n < 5) {
            this.column[n] = tableColumnModel.getColumn(n);
            this.columnDefaultWidth[n] = this.column[n].getPreferredWidth();
            this.columnShowing[n] = true;
            ++n;
        }
        boolean[] blArray = new boolean[5];
        Arrays.fill(blArray, true);
        blArray[0] = false;
        JDebugger.addColumnsMenu((JTable)this.treeTable, this, blArray);
        this.columnDefaultWidth[0] = this.columnDefaultWidth[0] * 2;
        this.column[0].setPreferredWidth(this.columnDefaultWidth[0]);
        this.columnDefaultWidth[4] = this.columnDefaultWidth[4] / 2;
        this.column[4].setPreferredWidth(this.columnDefaultWidth[4]);
        ListSelectionModel listSelectionModel = this.treeTable.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        JTree jTree = this.treeTable.getTree();
        jTree.setRootVisible(false);
        TreeSelectionModel treeSelectionModel = jTree.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        jTree.addTreeExpansionListener(this);
        jTree.addTreeSelectionListener(this);
        jTree.setCellRenderer(new 10());
        this.treeTable.setDefaultRenderer(String.class, (TableCellRenderer)new 9());
        TableCellRenderer tableCellRenderer = this.treeTable.getDefaultRenderer(Boolean.class);
        if (tableCellRenderer instanceof JCheckBox) {
            JCheckBox jCheckBox = (JCheckBox)((Object)tableCellRenderer);
            jCheckBox.setBorderPaintedFlat(true);
        }
        JTableHeader jTableHeader = this.treeTable.getTableHeader();
        TableCellRenderer tableCellRenderer2 = jTableHeader.getDefaultRenderer();
        jTableHeader.setDefaultRenderer(new 8(this, tableCellRenderer2));
        this.treeTable.addMouseListener((MouseListener)new 7());
        jTableHeader.addMouseListener(new 6());
        this.treeTable.addKeyListener((KeyListener)new 5());
        this.scrollPane = new JScrollPane((Component)this.treeTable);
        Color color = this.treeTable.getBackground();
        this.scrollPane.setBackground(color);
        this.scrollPane.getViewport().setBackground(color);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.addMouseListener(new 4());
        this.scrollPane.addComponentListener(new 3());
        this.treeTable.addHierarchyListener((HierarchyListener)new 2());
        this.adjustGUI();
    }

    protected void adjustGUI() {
    }

    private void adjustColumnsAfterResize() {
        if (this.adjustColumnsAlreadyDone) {
            return;
        }
        this.adjustColumnsAlreadyDone = true;
        JDebugger.adjustColumnsAfterResize(this.scrollPane, (JTable)this.treeTable);
    }

    private Font getNormalFont() {
        if (this.normalFont == null) {
            this.normalFont = this.treeTable.getTree().getFont();
        }
        return this.normalFont;
    }

    private Font getBoldFont() {
        if (this.boldFont == null) {
            this.boldFont = this.getNormalFont().deriveFont(1);
        }
        return this.boldFont;
    }

    Component getGUI() {
        if (this.scrollPane == null) {
            this.createGUI();
        }
        return this.scrollPane;
    }

    void loadSettings() {
        int[] nArray = this.threadsPanelSettings.getColumnWidth();
        int n = 0;
        while (n < 5) {
            if (nArray[n] != 0) {
                this.adjustColumnsAlreadyDone = true;
                this.column[n].setPreferredWidth(nArray[n]);
            }
            ++n;
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String string = this.threadsPanelSettings.getColumnOrder();
        if (string != null) {
            int n2 = 0;
            while (n2 < 5) {
                String string2;
                int n3 = string.indexOf(44);
                if (n3 != -1) {
                    string2 = string.substring(0, n3);
                    string = string.substring(n3 + 1);
                } else {
                    string2 = string;
                }
                if (string2.length() == 0) break;
                try {
                    int n4 = tableColumnModel.getColumnIndex(string2);
                    if (n4 != n2) {
                        this.treeTable.moveColumn(n4, n2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    void threadsPanelSettingsChanged(boolean bl) {
        if (this.treeTable == null) {
            return;
        }
        boolean[] blArray = this.threadsPanelSettings.getColumnVisible();
        int n = 0;
        while (n < 5) {
            if (this.columnShowing[n] != blArray[n]) {
                this.columnShowing[n] = blArray[n];
                if (blArray[n]) {
                    this.treeTable.addColumn(this.column[n]);
                } else {
                    this.treeTable.removeColumn(this.column[n]);
                }
            }
            ++n;
        }
        if (bl && this.treeTable.isEnabled()) {
            SwingUtilities.invokeLater(new 1());
        }
        Dimension dimension = this.treeTable.getPreferredSize();
        dimension.height = this.treeTable.getTableHeader().getPreferredSize().height + this.preferredVisibleRowCount * this.treeTable.getRowHeight() + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height;
        this.scrollPane.setPreferredSize(dimension);
    }

    void saveSettings() {
        if (this.treeTable == null) {
            return;
        }
        int[] nArray = this.threadsPanelSettings.getColumnWidth();
        int n = 0;
        while (n < 5) {
            nArray[n] = this.column[n].getWidth();
            ++n;
        }
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        String string = NOT_AVAILABLE;
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            string = string + tableColumn.getIdentifier() + ",";
        }
        this.threadsPanelSettings.setColumnOrder(string);
    }

    Context getContext() {
        return this.getContext(null);
    }

    Context getContext(EventObject eventObject) {
        Object object;
        ThreadItem threadItem = this.getSelectedThreadItem();
        JDIInformationProvider jDIInformationProvider = null;
        if (threadItem != null && (object = threadItem.getInfo()) instanceof JDIInformationProvider) {
            jDIInformationProvider = (JDIInformationProvider)object;
        }
        return ContextBuilder.buildContext((Element)threadItem, (View)this.dockableWindow, eventObject, this.debuggingProcess, jDIInformationProvider);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.model.branchExpanded(treeExpansionEvent.getPath());
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.model.branchCollapsed(treeExpansionEvent.getPath());
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == this._GOTO_CMD_ID) {
            ThreadItem threadItem = this.getSelectedThreadItem();
            if (threadItem != null) {
                threadItem.showInSource();
            }
            return true;
        }
        if (n == this._SAVE_CMD_ID) {
            this.saveToFile();
            return true;
        }
        if (n == 18) {
            Object object;
            int n2;
            ThreadItem threadItem = this.getSelectedThreadItem();
            if (threadItem != null && (n2 = this.treeTable.getSelectedColumn()) != -1 && (object = this.model.getValueAt(threadItem, n2)) != null) {
                IdeUtil.copyToClipboard((String)object.toString());
            }
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (ideAction.getValue("Debugger.actionOwner") == this) {
            if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                ideAction.setEnabled(false);
                return true;
            }
            if (!this.treeTable.isEnabled() || this.debuggingProcess == null || this.vm == null) {
                ideAction.setEnabled(false);
                return true;
            }
        }
        if (n == this._GOTO_CMD_ID) {
            ThreadItem threadItem = this.getSelectedThreadItem();
            if (threadItem != null) {
                ideAction.setEnabled(threadItem.canShowInSource());
            } else {
                ideAction.setEnabled(false);
            }
            return true;
        }
        if (n == this._SAVE_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (n == 18) {
            ThreadItem threadItem = this.getSelectedThreadItem();
            int n2 = this.treeTable.getSelectedColumn();
            ideAction.setEnabled(threadItem != null && n2 != -1);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        if (this.treeTable != null && context.getView() == this.dockableWindow && (Helpers.contextMatchesSource(context, this.treeTable) || Helpers.contextMatchesSource(context, this.scrollPane))) {
            ThreadItem threadItem = this.getSelectedThreadItem();
            if (threadItem != null) {
                this.addPopupMenuItemsForThreadItem(contextMenu, context);
            }
            this.addPopupMenuItemsForThreads(contextMenu, context);
            this.addPopupMenuItemsForTreeTable(contextMenu, context);
            this.addPopupMenuItemsForCommon(contextMenu, context);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public int compare(Object object, Object object2) {
        if (object instanceof DebugThreadGroupInfo) {
            DebugThreadGroupInfo debugThreadGroupInfo = (DebugThreadGroupInfo)object;
            DebugThreadGroupInfo debugThreadGroupInfo2 = (DebugThreadGroupInfo)object2;
            return debugThreadGroupInfo.getName().compareToIgnoreCase(debugThreadGroupInfo2.getName());
        }
        DebugThreadInfo debugThreadInfo = (DebugThreadInfo)object;
        DebugThreadInfo debugThreadInfo2 = (DebugThreadInfo)object2;
        return debugThreadInfo.getName().compareToIgnoreCase(debugThreadInfo2.getName());
    }

    protected void addPopupMenuItemsForThreadItem(ContextMenu contextMenu, Context context) {
        this.update(this._actionGoTo, context);
        if (this._actionGoTo.isEnabled()) {
            if (this._menuitemGoTo == null) {
                this._menuitemGoTo = contextMenu.createMenuItem((ToggleAction)this._actionGoTo);
            }
            contextMenu.add((Component)this._menuitemGoTo, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
    }

    protected void addPopupMenuItemsForThreads(ContextMenu contextMenu, Context context) {
    }

    protected void addPopupMenuItemsForTreeTable(ContextMenu contextMenu, Context context) {
    }

    protected void addPopupMenuItemsForCommon(ContextMenu contextMenu, Context context) {
        this.update(this._actionSave, context);
        if (this._actionSave.isEnabled()) {
            if (this._menuitemSave == null) {
                this._menuitemSave = contextMenu.createMenuItem((ToggleAction)this._actionSave);
            }
            contextMenu.add((Component)this._menuitemSave, JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
        }
    }

    void showPopup(MouseEvent mouseEvent) {
        JDebugger.getInstance().showContextMenu(mouseEvent, this.dockableWindow, (JComponent)this.treeTable);
    }

    private void saveToFile() {
        URL uRL;
        String string = RunMgrArb.format(103, this.dockableWindow.getTitleName());
        URLChooser uRLChooser = DialogUtil.newURLChooser((Context)this.getContext());
        if (JDebugger.lastSavedFile != null) {
            uRLChooser.setSelectedURL(JDebugger.lastSavedFile);
        }
        if (uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), string) == 0 && (uRL = uRLChooser.getSelectedURL()) != null) {
            JDebugger.lastSavedFile = uRL;
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            Exception exception = null;
            try {
                String string2 = URLFileSystem.getSuffix((URL)uRL).toUpperCase();
                boolean bl = string2.equals(".HTML") || string2.equals(".HTM");
                PrintWriter printWriter = bl ? JDebugger.printHtmlHeader(uRL, this.dockableWindow.getTitleName()) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)uRL)));
                ThreadTreeTableModel.mav$save(this.model, printWriter, bl);
                if (bl) {
                    JDebugger.printHtmlFooter(printWriter);
                }
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            waitCursor.hide();
            if (exception != null) {
                String string3 = DbgArb.format(858, this.dockableWindow.getTitleName(), URLFileSystem.getPlatformPathName((URL)uRL));
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)string, (String)string3, null);
            }
        }
    }

    void nowShown() {
        if (this.skippedUpdate && this.treeTable.isEnabled()) {
            this.everythingChanged();
        }
    }

    void everythingChanged() {
        if (this.model != null) {
            ThreadInfoPath threadInfoPath = this.getCurrentHighlight();
            this.model.updateThreads(threadInfoPath);
        }
    }

    void updateCell(int n, int n2) {
        TableModel tableModel = this.treeTable.getModel();
        TableModelEvent tableModelEvent = new TableModelEvent(tableModel, n, n, n2);
        if (tableModel instanceof AbstractTableModel) {
            ((AbstractTableModel)tableModel).fireTableChanged(tableModelEvent);
        }
    }

    protected ThreadInfoPath getCurrentHighlight() {
        return this.model.getCurrentHighlight();
    }

    void updateThreads(DebuggingProcess debuggingProcess, DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo) {
        int n = -1;
        if (ProfilingEvents.eventOn[2]) {
            n = IdeProfile.startEvent((int)ProfilingEvents.eventId[2], (String)this.dockableWindow.getTitleName());
        }
        this.debuggingProcess = debuggingProcess;
        this.vm = debugVirtualMachine;
        ThreadInfoPath threadInfoPath = null;
        if (debugThreadInfo != null) {
            threadInfoPath = new ThreadInfoPath(debuggingProcess, debugThreadInfo);
        }
        if (this.model != null) {
            this.model.updateThreads(threadInfoPath);
        }
        if (ProfilingEvents.eventOn[2]) {
            IdeProfile.endEvent((int)n);
        }
    }

    void clearThreads() {
        if (this.treeTable == null) {
            return;
        }
        int n = -1;
        if (ProfilingEvents.eventOn[7]) {
            n = IdeProfile.startEvent((int)ProfilingEvents.eventId[7], (String)this.dockableWindow.getTitleName());
        }
        this.treeTable.setEnabled(false);
        this.model.clearThreads();
        this.vm = null;
        if (ProfilingEvents.eventOn[7]) {
            IdeProfile.endEvent((int)n);
        }
    }

    protected abstract void addThreadItems();

    void processFinished(DebuggingProcess debuggingProcess) {
        if (this.model != null) {
            this.model.processFinished(debuggingProcess);
        }
        if (this.debuggingProcess == debuggingProcess) {
            this.debuggingProcess = null;
            this.vm = null;
            if (this.treeTable != null) {
                this.treeTable.setEnabled(true);
                this.model.updateThreads(null);
            }
        }
    }

    ThreadItem getThreadItemForTreePath(TreePath treePath) {
        Object object;
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof ThreadItem) {
            return (ThreadItem)object;
        }
        return null;
    }

    ThreadItem getSelectedThreadItem() {
        if (this.treeTable != null) {
            TreePath treePath = this.treeTable.getTree().getSelectionPath();
            return this.getThreadItemForTreePath(treePath);
        }
        return null;
    }

    DebugThreadInfo getSelectedThreadInfo() {
        ThreadItem threadItem = this.getSelectedThreadItem();
        if (threadItem != null) {
            return threadItem.getThreadInfo();
        }
        return null;
    }

    protected List getRoot() {
        return (List)this.model.getRoot();
    }

    void resetIcons() {
        ThreadTreeTableModel.mav$resetIcons(this.model);
    }

    protected static String getThreadStatus(int n) {
        switch (n) {
            default: {
                return DbgArb.getString(252);
            }
            case 1: {
                return DbgArb.getString(253);
            }
            case 2: {
                return DbgArb.getString(254);
            }
            case 3: {
                return DbgArb.getString(255);
            }
            case 4: {
                return DbgArb.getString(256);
            }
            case 5: {
                return DbgArb.getString(257);
            }
            case 6: 
        }
        return DbgArb.getString(258);
    }

    protected static boolean isDeadlocked(DebugThreadInfo debugThreadInfo, DebuggingProcess debuggingProcess) {
        DebugThreadInfo[][] debugThreadInfoArray = debuggingProcess.getDeadlocks();
        int n = debugThreadInfoArray.length;
        if (n != 0) {
            int n2 = 0;
            while (n2 < n) {
                int n3 = debugThreadInfoArray[n2].length;
                int n4 = 0;
                while (n4 < n3) {
                    DebugThreadInfo debugThreadInfo2 = debugThreadInfoArray[n2][n4];
                    if (debugThreadInfo2.equals(debugThreadInfo)) {
                        return true;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return false;
    }

    protected static String[] getPriorityDaemon(DebugThreadInfo debugThreadInfo) {
        String[] stringArray = new String[2];
        DebugDataObjectInfo debugDataObjectInfo = debugThreadInfo.getThreadObject();
        if (debugDataObjectInfo != null && !debugDataObjectInfo.isNull()) {
            DebugDataInfo debugDataInfo = DebugShared.findFieldData(debugDataObjectInfo, "priority", "int", "java.lang.Thread");
            if (debugDataInfo != null) {
                stringArray[0] = debugDataInfo.getValue();
            }
            if ((debugDataInfo = DebugShared.findFieldData(debugDataObjectInfo, "daemon", "boolean", "java.lang.Thread")) != null) {
                stringArray[1] = debugDataInfo.getValue();
            }
        }
        return stringArray;
    }

    protected static String[] getMaxPriorityDaemon(DebugThreadGroupInfo debugThreadGroupInfo) {
        String[] stringArray = new String[2];
        DebugDataObjectInfo debugDataObjectInfo = debugThreadGroupInfo.getThreadGroupObject();
        if (debugDataObjectInfo != null && !debugDataObjectInfo.isNull()) {
            DebugDataInfo debugDataInfo = DebugShared.findFieldData(debugDataObjectInfo, "maxPriority", "int", "java.lang.ThreadGroup");
            if (debugDataInfo != null) {
                stringArray[0] = debugDataInfo.getValue();
            }
            if ((debugDataInfo = DebugShared.findFieldData(debugDataObjectInfo, "daemon", "boolean", "java.lang.ThreadGroup")) != null) {
                stringArray[1] = debugDataInfo.getValue();
            }
        }
        return stringArray;
    }

    private static Icon getThreadGroupIcon() {
        if (threadGroupIcon == null) {
            threadGroupIcon = DbgArb.getIcon(249);
        }
        return threadGroupIcon;
    }

    private static Icon getThreadIcon() {
        if (threadIcon == null) {
            threadIcon = DbgArb.getIcon(250);
        }
        return threadIcon;
    }

    private static Icon getThreadIconGray() {
        if (threadIconGray == null) {
            threadIconGray = IdeUtil.grayIcon((Icon)ThreadsPanel.getThreadIcon());
        }
        return threadIconGray;
    }

    private static Icon getCurrentThreadIcon() {
        if (currentThreadIcon == null) {
            currentThreadIcon = DbgArb.getIcon(251);
        }
        return currentThreadIcon;
    }

    private static Icon getCurrentThreadIconGray() {
        if (currentThreadIconGray == null) {
            currentThreadIconGray = IdeUtil.grayIcon((Icon)ThreadsPanel.getCurrentThreadIcon());
        }
        return currentThreadIconGray;
    }

    static Font mav$getNormalFont(ThreadsPanel threadsPanel) {
        return threadsPanel.getNormalFont();
    }

    static void mav$adjustColumnsAfterResize(ThreadsPanel threadsPanel) {
        threadsPanel.adjustColumnsAfterResize();
    }

    static void wa$skippedUpdate(ThreadsPanel threadsPanel, boolean bl) {
        threadsPanel.skippedUpdate = bl;
    }

    static Font mav$getBoldFont(ThreadsPanel threadsPanel) {
        return threadsPanel.getBoldFont();
    }

    static Icon maS$getThreadGroupIcon() {
        return ThreadsPanel.getThreadGroupIcon();
    }

    static Icon maS$getCurrentThreadIconGray() {
        return ThreadsPanel.getCurrentThreadIconGray();
    }

    static Icon maS$getCurrentThreadIcon() {
        return ThreadsPanel.getCurrentThreadIcon();
    }

    static Icon maS$getThreadIconGray() {
        return ThreadsPanel.getThreadIconGray();
    }

    static Icon maS$getThreadIcon() {
        return ThreadsPanel.getThreadIcon();
    }

    final class 11
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            ThreadsPanel.this.threadsPanelSettingsChanged(true);
        }
    }

    final class 10
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object instanceof ThreadItem) {
                String string;
                ThreadItem threadItem = (ThreadItem)object;
                this.setIcon(threadItem.getIcon());
                this.setFont(ThreadItem.mav$getFont(threadItem, 0));
                String string2 = threadItem.getName();
                this.setToolTipText(string2);
                AccessibleContext accessibleContext = this.getAccessibleContext();
                String string3 = ThreadTreeTableModel.mav$getAccessibleNameAt(ThreadsPanel.this.model, threadItem, 0);
                if (threadItem.mayHaveChildren()) {
                    string3 = JDebugger.fixTreeCellAccessibleName(string3, bl2);
                }
                if (string3 != null) {
                    accessibleContext.setAccessibleName(string3);
                }
                if ((string = string2) != null) {
                    accessibleContext.setAccessibleDescription(string);
                }
            } else {
                this.setIcon(null);
                this.setFont(ThreadsPanel.mav$getNormalFont(ThreadsPanel.this));
                this.setToolTipText(null);
            }
            return this;
        }
    }

    final class 9
    extends DefaultTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            String string2;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = jTable.convertColumnIndexToModel(n2);
            TreePath treePath = ThreadsPanel.this.treeTable.getTree().getPathForRow(n);
            ThreadItem threadItem = ThreadsPanel.this.getThreadItemForTreePath(treePath);
            this.setFont(ThreadItem.mav$getFont(threadItem, n3));
            int n4 = 2;
            if (n3 == 3) {
                n4 = 4;
            }
            this.setHorizontalAlignment(n4);
            String string3 = string2 = object instanceof String ? (String)object : null;
            if (string2 != null) {
                this.setToolTipText(string2);
            }
            AccessibleContext accessibleContext = this.getAccessibleContext();
            String string4 = ThreadTreeTableModel.mav$getAccessibleNameAt(ThreadsPanel.this.model, threadItem, n3);
            if (string4 != null) {
                accessibleContext.setAccessibleName(string4);
            }
            if ((string = string2) != null) {
                accessibleContext.setAccessibleDescription(string);
            }
            return this;
        }
    }

    final class 8
    extends DefaultTableCellRenderer {
        private final /* synthetic */ TableCellRenderer v$headerRenderer;
        final /* synthetic */ ThreadsPanel this$0;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (this.v$headerRenderer instanceof DefaultTableCellRenderer) {
                DefaultTableCellRenderer defaultTableCellRenderer = (DefaultTableCellRenderer)this.v$headerRenderer;
                int n3 = jTable.convertColumnIndexToModel(n2);
                int n4 = 2;
                if (n3 == 3) {
                    n4 = 4;
                }
                defaultTableCellRenderer.setHorizontalAlignment(n4);
            }
            return this.v$headerRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public 8(ThreadsPanel threadsPanel, TableCellRenderer tableCellRenderer) {
            this.v$headerRenderer = tableCellRenderer;
            this.this$0 = threadsPanel;
        }
    }

    final class 7
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ThreadsPanel.this.showPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ThreadsPanel.this.showPopup(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (ThreadsPanel.this.debuggingProcess == null || !ThreadsPanel.this.debuggingProcess.isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(354, ThreadsPanel.this.dockableWindow.getTitleName()));
            }
            if (JDebugger.isDoubleClickInTreeTable(ThreadsPanel.this.treeTable, mouseEvent)) {
                Context context = ThreadsPanel.this.getContext(mouseEvent);
                ThreadsPanel.this.update(ThreadsPanel.this._actionGoTo, context);
                if (ThreadsPanel.this._actionGoTo.isEnabled()) {
                    ThreadsPanel.this.handleEvent(ThreadsPanel.this._actionGoTo, context);
                }
            }
        }
    }

    final class 6
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (ThreadsPanel.this.debuggingProcess == null || !ThreadsPanel.this.debuggingProcess.isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(354, ThreadsPanel.this.dockableWindow.getTitleName()));
            }
        }
    }

    final class 5
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 10: {
                    ThreadsPanel.this.update(ThreadsPanel.this._actionGoTo, null);
                    if (!ThreadsPanel.this._actionGoTo.isEnabled()) break;
                    ThreadsPanel.this.handleEvent(ThreadsPanel.this._actionGoTo, null);
                    keyEvent.consume();
                }
            }
        }
    }

    final class 4
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ThreadsPanel.this.showPopup(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                ThreadsPanel.this.showPopup(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (ThreadsPanel.this.debuggingProcess == null || !ThreadsPanel.this.debuggingProcess.isStopped()) {
                Toolkit.getDefaultToolkit().beep();
                DebuggingProcess.showStatus(DbgArb.format(354, ThreadsPanel.this.dockableWindow.getTitleName()));
            }
        }
    }

    final class 3
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            ThreadsPanel.mav$adjustColumnsAfterResize(ThreadsPanel.this);
        }
    }

    final class 2
    implements HierarchyListener {
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & (long)4) != 0L && ThreadsPanel.this.treeTable.isShowing()) {
                ThreadsPanel.this.nowShown();
            }
        }
    }

    final class 1
    implements Runnable {
        public void run() {
            ThreadsPanel.this.everythingChanged();
        }
    }

    final class ThreadTreeTableModel
    extends AbstractTreeTableModel {
        private List root;
        private List expanded;

        ThreadTreeTableModel(List list) {
            super((Object)list);
            this.root = list;
            this.expanded = new ArrayList();
        }

        void updateThreads(ThreadInfoPath threadInfoPath) {
            ThreadsPanel.this.treeTable.getSelectionModel().clearSelection();
            ThreadsPanel.this.treeTable.setEnabled(true);
            this.root.clear();
            if (ThreadsPanel.this.treeTable.isShowing()) {
                ThreadsPanel.wa$skippedUpdate(ThreadsPanel.this, false);
                if (ThreadsPanel.this.debuggingProcess != null && ThreadsPanel.this.vm != null) {
                    ThreadsPanel.this.addThreadItems();
                }
            } else {
                ThreadsPanel.wa$skippedUpdate(ThreadsPanel.this, true);
            }
            this.fireChanged(new TreePath(this.root));
            this.restoreExpanded();
            this.restoreHighlight(threadInfoPath);
        }

        private void fireChanged(TreePath treePath) {
            this.fireTreeStructureChanged((Object)this, treePath.getPath(), null, null);
        }

        void clearThreads() {
            this.clearAll();
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            int n = this.expanded.size() - 1;
            while (n >= 0) {
                ThreadInfoPath threadInfoPath = (ThreadInfoPath)this.expanded.get(n);
                if (threadInfoPath.getDebuggingProcess() == debuggingProcess) {
                    this.expanded.remove(n);
                }
                --n;
            }
        }

        private void clearAll() {
            this.clearAll(ThreadsPanel.this.treeTable.getTree(), new TreePath(this.root));
        }

        private void clearAll(JTree jTree, TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            if (object instanceof ThreadItem) {
                ((ThreadItem)object).clearThread();
            }
            int n = this.getChildCount(object);
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.getChild(object, n2);
                this.clearAll(jTree, treePath.pathByAddingChild(object2));
                ++n2;
            }
        }

        private void restoreExpanded() {
            int n = this.expanded.size();
            if (n == 0) {
                this.expandAll();
            } else {
                ThreadInfoPath[] threadInfoPathArray = this.expanded.toArray(new ThreadInfoPath[n]);
                int n2 = 0;
                while (n2 < n) {
                    this.expandBranch(threadInfoPathArray[n2]);
                    ++n2;
                }
            }
        }

        private void restoreHighlight(ThreadInfoPath threadInfoPath) {
            if (threadInfoPath != null) {
                TreePath treePath = this.makeVisible(threadInfoPath);
                JDebugger.getInstance().selectTreeTablePath(ThreadsPanel.this.treeTable, treePath, false);
            }
        }

        private TreePath expandBranch(ThreadInfoPath threadInfoPath) {
            return this.expandBranch(new TreePath(this.root), threadInfoPath);
        }

        private TreePath expandBranch(TreePath treePath, ThreadInfoPath threadInfoPath) {
            JTree jTree = ThreadsPanel.this.treeTable.getTree();
            Object object = treePath.getLastPathComponent();
            if (object instanceof ThreadItem) {
                ThreadItem threadItem = (ThreadItem)object;
                if (threadInfoPath.getInfo().equals(threadItem.getInfo())) {
                    jTree.expandPath(treePath);
                    return treePath;
                }
            }
            int n = this.getChildCount(object);
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.getChild(object, n2);
                TreePath treePath2 = this.expandBranch(treePath.pathByAddingChild(object2), threadInfoPath);
                if (treePath2 != null) {
                    return treePath2;
                }
                ++n2;
            }
            return null;
        }

        TreePath makeVisible(ThreadInfoPath threadInfoPath) {
            return this.makeVisible(new TreePath(this.root), threadInfoPath);
        }

        private TreePath makeVisible(TreePath treePath, ThreadInfoPath threadInfoPath) {
            Object object = treePath.getLastPathComponent();
            if (object instanceof ThreadItem) {
                ThreadItem threadItem = (ThreadItem)object;
                if (threadInfoPath.getInfo().equals(threadItem.getInfo())) {
                    ThreadsPanel.this.treeTable.getTree().makeVisible(treePath);
                    return treePath;
                }
            }
            int n = this.getChildCount(object);
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.getChild(object, n2);
                TreePath treePath2 = this.makeVisible(treePath.pathByAddingChild(object2), threadInfoPath);
                if (treePath2 != null) {
                    return treePath2;
                }
                ++n2;
            }
            return null;
        }

        void branchExpanded(TreePath treePath) {
            ThreadInfoPath threadInfoPath = this.convertTreePathToThreadInfoPath(treePath);
            if (threadInfoPath != null) {
                int n = this.expanded.indexOf(threadInfoPath);
                if (n != -1) {
                    this.expanded.remove(n);
                }
                this.expanded.add(0, threadInfoPath);
            }
        }

        void branchCollapsed(TreePath treePath) {
            ThreadInfoPath threadInfoPath = this.convertTreePathToThreadInfoPath(treePath);
            if (threadInfoPath != null) {
                this.expanded.remove(threadInfoPath);
            }
        }

        ThreadInfoPath getCurrentHighlight() {
            TreePath treePath = ThreadsPanel.this.treeTable.getTree().getSelectionPath();
            if (treePath != null) {
                return this.convertTreePathToThreadInfoPath(treePath);
            }
            return null;
        }

        ThreadInfoPath convertTreePathToThreadInfoPath(TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            if (object instanceof ThreadItem) {
                ThreadItem threadItem = (ThreadItem)object;
                return threadItem.getThreadInfoPath();
            }
            return null;
        }

        private void resetIcons() {
            this.resetIcons(new TreePath(this.root));
            ThreadsPanel.this.treeTable.repaint(ThreadsPanel.this.treeTable.getVisibleRect());
        }

        private void resetIcons(TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            if (object instanceof ThreadItem) {
                ThreadItem.mav$setIconAppropriately((ThreadItem)object);
            }
            int n = this.getChildCount(object);
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.getChild(object, n2);
                this.resetIcons(treePath.pathByAddingChild(object2));
                ++n2;
            }
        }

        void expandAll() {
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            this.expandAll(ThreadsPanel.this.treeTable.getTree(), new TreePath(this.root));
            waitCursor.hide();
        }

        private void expandAll(JTree jTree, TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            jTree.expandPath(treePath);
            int n = this.getChildCount(object);
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.getChild(object, n2);
                this.expandAll(jTree, treePath.pathByAddingChild(object2));
                ++n2;
            }
        }

        void collapseAll() {
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            this.collapseAll(ThreadsPanel.this.treeTable.getTree(), new TreePath(this.root));
            waitCursor.hide();
        }

        private void collapseAll(JTree jTree, TreePath treePath) {
            Object object = treePath.getLastPathComponent();
            int n = this.getChildCount(object);
            int n2 = 0;
            while (n2 < n) {
                Object object2 = this.getChild(object, n2);
                this.collapseAll(jTree, treePath.pathByAddingChild(object2));
                ++n2;
            }
            if (!object.equals(this.root)) {
                jTree.collapsePath(treePath);
            }
        }

        private void save(PrintWriter printWriter, boolean bl) {
            if (bl) {
                printWriter.println("<table border=\"1\">");
            }
            this.saveHeader(printWriter, bl);
            this.save(ThreadsPanel.this.treeTable.getTree(), new TreePath(this.root), printWriter, bl, ThreadsPanel.NOT_AVAILABLE);
            if (bl) {
                printWriter.println("</table>");
            }
        }

        private void saveHeader(PrintWriter printWriter, boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            if (bl) {
                stringBuffer.append("<tr>");
            }
            TableColumnModel tableColumnModel = ThreadsPanel.this.treeTable.getColumnModel();
            Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                int n = tableColumn.getModelIndex();
                String string = this.getColumnName(n);
                if (bl) {
                    stringBuffer.append("<th>");
                    string = IdeUtil.replaceHTMLReservedCharacters((String)string.toString());
                    stringBuffer.append(string);
                    stringBuffer.append("</th>");
                    continue;
                }
                stringBuffer.append(string);
                int n2 = string.length();
                while (n2 >= 0) {
                    stringBuffer2.append('-');
                    --n2;
                }
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append('\t');
                stringBuffer2.append('\t');
            }
            if (bl) {
                stringBuffer.append("</tr>");
            }
            printWriter.println(stringBuffer.toString());
            if (!bl) {
                printWriter.println(stringBuffer2.toString());
            }
        }

        private void save(JTree jTree, TreePath treePath, PrintWriter printWriter, boolean bl, String string) {
            if (jTree.isVisible(treePath)) {
                Object object = treePath.getLastPathComponent();
                if (object instanceof ThreadItem) {
                    ThreadItem threadItem = (ThreadItem)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    if (bl) {
                        stringBuffer.append("<tr>");
                    }
                    TableColumnModel tableColumnModel = ThreadsPanel.this.treeTable.getColumnModel();
                    Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
                    while (enumeration.hasMoreElements()) {
                        TableColumn tableColumn = enumeration.nextElement();
                        int n = tableColumn.getModelIndex();
                        Object object2 = this.getValueAt(object, n);
                        if (object2 instanceof Boolean) {
                            object2 = (Boolean)object2 != false ? "true" : "false";
                        }
                        if (bl) {
                            String string2;
                            stringBuffer.append("<td>");
                            if (n == 0) {
                                stringBuffer.append("<tt>");
                                if (string != null) {
                                    stringBuffer.append(string);
                                }
                                if (jTree.isExpanded(treePath)) {
                                    stringBuffer.append("-&nbsp;");
                                } else if (threadItem.mayHaveChildren()) {
                                    stringBuffer.append("+&nbsp;");
                                } else {
                                    stringBuffer.append("&nbsp;&nbsp;");
                                }
                                stringBuffer.append("</tt>");
                            }
                            if ((string2 = IdeUtil.replaceHTMLReservedCharacters((String)object2.toString())).length() > 0) {
                                stringBuffer.append(string2);
                            } else {
                                stringBuffer.append("&nbsp;");
                            }
                            stringBuffer.append("</td>");
                            continue;
                        }
                        if (n == 0) {
                            if (string != null) {
                                stringBuffer.append(string);
                            }
                            if (jTree.isExpanded(treePath)) {
                                stringBuffer.append("- ");
                            } else if (threadItem.mayHaveChildren()) {
                                stringBuffer.append("+ ");
                            } else {
                                stringBuffer.append("  ");
                            }
                        }
                        stringBuffer.append(object2);
                        if (!enumeration.hasMoreElements()) continue;
                        stringBuffer.append('\t');
                    }
                    if (bl) {
                        stringBuffer.append("</tr>");
                    }
                    printWriter.println(stringBuffer.toString());
                }
                if (object != this.root) {
                    string = bl ? string + "&nbsp;&nbsp;&nbsp;&nbsp;" : string + "    ";
                }
                int n = this.getChildCount(object);
                int n2 = 0;
                while (n2 < n) {
                    Object object3 = this.getChild(object, n2);
                    this.save(jTree, treePath.pathByAddingChild(object3), printWriter, bl, string);
                    ++n2;
                }
            }
        }

        public boolean isLeaf(Object object) {
            try {
                if (object instanceof List) {
                    boolean bl = false;
                    return bl;
                }
                ThreadItem threadItem = (ThreadItem)object;
                boolean bl = threadItem.mayHaveChildren() ^ true;
                return bl;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return true;
            }
        }

        public Object getChild(Object object, int n) {
            try {
                if (object instanceof List) {
                    Object e = ((List)object).get(n);
                    return e;
                }
                ThreadItem threadItem = (ThreadItem)object;
                ThreadItem threadItem2 = threadItem.getChildNodes()[n];
                return threadItem2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        public int getChildCount(Object object) {
            try {
                if (object instanceof List) {
                    int n = ((List)object).size();
                    return n;
                }
                ThreadItem threadItem = (ThreadItem)object;
                int n = threadItem.countChildNodes();
                return n;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 0;
            }
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return DbgArb.getString(243);
                }
                case 1: {
                    return DbgArb.getString(244);
                }
                case 2: {
                    return DbgArb.getString(245);
                }
                case 3: {
                    return DbgArb.getString(246);
                }
                case 4: {
                    return DbgArb.getString(247);
                }
            }
            return ThreadsPanel.NOT_AVAILABLE;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return TreeTableModel.class;
            }
            if (n == 4) {
                return Boolean.class;
            }
            return String.class;
        }

        public Object getValueAt(Object object, int n) {
            try {
                if (object instanceof List) {
                    switch (n) {
                        case 0: {
                            String string = "root";
                            return string;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            String string = ThreadsPanel.NOT_AVAILABLE;
                            return string;
                        }
                        case 4: {
                            Boolean bl = Boolean.FALSE;
                            return bl;
                        }
                    }
                    Object var8_6 = null;
                    return var8_6;
                }
                ThreadItem threadItem = (ThreadItem)object;
                switch (n) {
                    case 0: {
                        String string = threadItem.getName();
                        return string;
                    }
                    case 1: {
                        String string = threadItem.getStatus();
                        return string;
                    }
                    case 2: {
                        String string = threadItem.getGroup();
                        return string;
                    }
                    case 3: {
                        String string = threadItem.getPriority();
                        return string;
                    }
                    case 4: {
                        Boolean bl = threadItem.getDaemon();
                        return bl;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }

        private String getAccessibleNameAt(ThreadItem threadItem, int n) {
            int n2;
            if (threadItem.isThread()) {
                n2 = 241;
            } else if (threadItem.isThreadGroup()) {
                n2 = 242;
            } else {
                return null;
            }
            String string = this.getColumnName(n);
            String string2 = (String)this.getValueAt(threadItem, n);
            if (string2.length() == 0) {
                string2 = DbgArb.getString(884);
            }
            return DbgArb.format(n2, string, string2);
        }

        static void mav$resetIcons(ThreadTreeTableModel threadTreeTableModel) {
            threadTreeTableModel.resetIcons();
        }

        static void mav$save(ThreadTreeTableModel threadTreeTableModel, PrintWriter printWriter, boolean bl) {
            threadTreeTableModel.save(printWriter, bl);
        }

        static String mav$getAccessibleNameAt(ThreadTreeTableModel threadTreeTableModel, ThreadItem threadItem, int n) {
            return threadTreeTableModel.getAccessibleNameAt(threadItem, n);
        }
    }

    protected final class ThreadItem
    extends BaseElement {
        private Object info;
        private String accessiblePrefix;
        private DebugThreadGroupInfo[] groups;
        private DebugThreadInfo[] threads;
        private DebugLocation location;
        private int status;
        private boolean deadlocked;
        private ThreadItem[] children;
        private Boolean cachedMayHaveChildren;
        private String cachedName;
        private String cachedGroup;
        private String cachedStatus;
        private String cachedPriority;
        private Boolean cachedDaemon;

        ThreadItem(Object object) {
            this.info = object;
            if (object instanceof DebugThreadGroupInfo) {
                DebugThreadGroupInfo debugThreadGroupInfo = (DebugThreadGroupInfo)object;
                this.groups = debugThreadGroupInfo.listGroups();
                Arrays.sort(this.groups, ThreadsPanel.this);
                this.threads = debugThreadGroupInfo.listThreads();
                Arrays.sort(this.threads, ThreadsPanel.this);
                this.accessiblePrefix = DbgArb.getString(242);
            } else {
                this.groups = new DebugThreadGroupInfo[0];
                this.threads = new DebugThreadInfo[0];
                this.accessiblePrefix = DbgArb.getString(241);
            }
            this.setStatusAndDeadlock();
            this.setIconAppropriately();
        }

        boolean isThreadGroup() {
            return this.info instanceof DebugThreadGroupInfo;
        }

        boolean isThread() {
            return this.info instanceof DebugThreadInfo;
        }

        String getAccessiblePrefix() {
            return this.accessiblePrefix;
        }

        private void setStatusAndDeadlock() {
            if (this.info instanceof DebugThreadInfo) {
                DebugThreadInfo debugThreadInfo = (DebugThreadInfo)this.info;
                this.status = debugThreadInfo.getStatus();
                this.deadlocked = this.status == 2 ? ThreadsPanel.isDeadlocked(debugThreadInfo, ThreadsPanel.this.debuggingProcess) : false;
            }
        }

        private void setIconAppropriately() {
            if (this.info instanceof DebugThreadGroupInfo) {
                this.setIcon(ThreadsPanel.maS$getThreadGroupIcon());
            } else if (this.info instanceof DebugThreadInfo) {
                DebugThreadInfo debugThreadInfo = (DebugThreadInfo)this.info;
                if (ThreadsPanel.this.debuggingProcess.isCurrentThread(debugThreadInfo)) {
                    if (this.status == 6) {
                        this.setIcon(ThreadsPanel.maS$getCurrentThreadIconGray());
                    } else {
                        this.setIcon(ThreadsPanel.maS$getCurrentThreadIcon());
                    }
                } else if (this.status == 6) {
                    this.setIcon(ThreadsPanel.maS$getThreadIconGray());
                } else {
                    this.setIcon(ThreadsPanel.maS$getThreadIcon());
                }
            }
        }

        private Font getFont(int n) {
            if (n == 0 ? ThreadsPanel.this.boldCurrentThreadName && this.info instanceof DebugThreadInfo && ThreadsPanel.this.debuggingProcess.isCurrentThread((DebugThreadInfo)this.info) : n == 1 && ThreadsPanel.this.boldDeadlockedThreadStatus && this.deadlocked) {
                return ThreadsPanel.mav$getBoldFont(ThreadsPanel.this);
            }
            return ThreadsPanel.mav$getNormalFont(ThreadsPanel.this);
        }

        void clearThread() {
            this.info = null;
            this.groups = null;
            this.threads = null;
            this.location = null;
        }

        Object getInfo() {
            return this.info;
        }

        ThreadInfoPath getThreadInfoPath() {
            return new ThreadInfoPath(ThreadsPanel.this.debuggingProcess, this.info);
        }

        DebugThreadGroupInfo getThreadGroupInfo() {
            if (this.info instanceof DebugThreadGroupInfo) {
                return (DebugThreadGroupInfo)this.info;
            }
            return null;
        }

        DebugThreadInfo getThreadInfo() {
            if (this.info instanceof DebugThreadInfo) {
                return (DebugThreadInfo)this.info;
            }
            return null;
        }

        public String getShortLabel() {
            return this.getName();
        }

        public Object getData() {
            return this;
        }

        public boolean mayHaveChildren() {
            if (this.cachedMayHaveChildren == null && ThreadsPanel.this.treeTable.isEnabled()) {
                this.cachedMayHaveChildren = this.info instanceof DebugThreadGroupInfo ? Boolean.TRUE : Boolean.FALSE;
            }
            if (this.cachedMayHaveChildren != null) {
                return this.cachedMayHaveChildren;
            }
            return false;
        }

        public Iterator getChildren() {
            return Arrays.asList(this.getChildNodes()).iterator();
        }

        public String getName() {
            if (this.cachedName == null && ThreadsPanel.this.treeTable.isEnabled()) {
                this.cachedName = this.info instanceof DebugThreadGroupInfo ? ((DebugThreadGroupInfo)this.info).getName() : (this.info instanceof DebugThreadInfo ? ((DebugThreadInfo)this.info).getName() : ThreadsPanel.NOT_AVAILABLE);
            }
            if (this.cachedName != null) {
                return this.cachedName;
            }
            return ThreadsPanel.NOT_AVAILABLE;
        }

        public String getGroup() {
            if (this.cachedGroup == null && ThreadsPanel.this.treeTable.isEnabled()) {
                this.cachedGroup = this.info instanceof DebugThreadInfo ? ((DebugThreadInfo)this.info).getGroupName() : ThreadsPanel.NOT_AVAILABLE;
            }
            if (this.cachedGroup != null) {
                return this.cachedGroup;
            }
            return ThreadsPanel.NOT_AVAILABLE;
        }

        public String getStatus() {
            if (this.cachedStatus == null && ThreadsPanel.this.treeTable.isEnabled()) {
                if (this.info instanceof DebugThreadInfo) {
                    String string = ThreadsPanel.getThreadStatus(this.status);
                    if (((DebugThreadInfo)this.info).isThreadSuspended()) {
                        string = string + " " + DbgArb.getString(259);
                    }
                    if (this.deadlocked) {
                        string = string + " " + DbgArb.getString(260);
                    }
                    this.cachedStatus = string;
                } else {
                    this.cachedStatus = ThreadsPanel.NOT_AVAILABLE;
                }
            }
            if (this.cachedStatus != null) {
                return this.cachedStatus;
            }
            return ThreadsPanel.NOT_AVAILABLE;
        }

        public String getPriority() {
            if (this.cachedPriority == null && ThreadsPanel.this.treeTable.isEnabled()) {
                this.getPriorityAndDaemon();
            }
            if (this.cachedPriority != null) {
                return this.cachedPriority;
            }
            return ThreadsPanel.NOT_AVAILABLE;
        }

        public Boolean getDaemon() {
            if (this.cachedDaemon == null && ThreadsPanel.this.treeTable.isEnabled()) {
                this.getPriorityAndDaemon();
            }
            if (this.cachedDaemon != null) {
                return this.cachedDaemon;
            }
            return Boolean.FALSE;
        }

        private void getPriorityAndDaemon() {
            this.cachedPriority = ThreadsPanel.NOT_AVAILABLE;
            this.cachedDaemon = Boolean.FALSE;
            if (this.info instanceof DebugThreadGroupInfo) {
                String[] stringArray = ThreadsPanel.getMaxPriorityDaemon((DebugThreadGroupInfo)this.info);
                if (stringArray[0] != null) {
                    this.cachedPriority = DbgArb.format(248, stringArray[0]);
                }
                if (stringArray[1] != null) {
                    this.cachedDaemon = stringArray[1].equals("true") ? Boolean.TRUE : Boolean.FALSE;
                }
            } else if (this.info instanceof DebugThreadInfo) {
                String[] stringArray = ThreadsPanel.getPriorityDaemon((DebugThreadInfo)this.info);
                if (stringArray[0] != null) {
                    this.cachedPriority = stringArray[0];
                }
                if (stringArray[1] != null) {
                    this.cachedDaemon = stringArray[1].equals("true") ? Boolean.TRUE : Boolean.FALSE;
                }
            }
        }

        int countChildNodes() {
            if (this.children != null) {
                return this.children.length;
            }
            if (this.groups != null && this.threads != null) {
                return this.groups.length + this.threads.length;
            }
            return 0;
        }

        ThreadItem[] getChildNodes() {
            if (this.children == null) {
                int n = this.groups.length + this.threads.length;
                this.children = new ThreadItem[n];
                int n2 = 0;
                int n3 = 0;
                while (n3 < this.groups.length) {
                    this.children[n2++] = new ThreadItem(this.groups[n3]);
                    ++n3;
                }
                int n4 = 0;
                while (n4 < this.threads.length) {
                    this.children[n2++] = new ThreadItem(this.threads[n4]);
                    ++n4;
                }
            }
            return this.children;
        }

        DebugLocation getLocation() {
            if (this.location == null && this.info instanceof DebugThreadInfo) {
                this.location = DebuggingProcess.getNonNativeLocation((DebugThreadInfo)this.info);
            }
            return this.location;
        }

        boolean canShowInSource() {
            DebugLocation debugLocation = this.getLocation();
            return debugLocation != null;
        }

        void showInSource() {
            DebugLocation debugLocation = this.getLocation();
            if (debugLocation != null) {
                ThreadsPanel.this.debuggingProcess.showSourceFile(debugLocation, true);
            }
        }

        boolean canMakeCurrentThread() {
            DebugThreadInfo debugThreadInfo;
            return this.info instanceof DebugThreadInfo && !ThreadsPanel.this.debuggingProcess.isCurrentThread(debugThreadInfo = (DebugThreadInfo)this.info) && this.status != 6;
        }

        void makeCurrentThread() {
            if (this.info instanceof DebugThreadInfo) {
                ThreadsPanel.this.debuggingProcess.setCurrentThread((DebugThreadInfo)this.info);
                ThreadsPanel.this.resetIcons();
                this.showInSource();
            }
        }

        boolean canSuspendThread() {
            DebugThreadInfo debugThreadInfo;
            return this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canSuspendThread() && ThreadsPanel.this.vm.getCapabilities().canResumeThread() && !(debugThreadInfo = (DebugThreadInfo)this.info).isThreadSuspended();
        }

        void suspendThread() {
            DebugThreadInfo debugThreadInfo;
            if (this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canSuspendThread() && ThreadsPanel.this.vm.getCapabilities().canResumeThread() && !(debugThreadInfo = (DebugThreadInfo)this.info).isThreadSuspended()) {
                debugThreadInfo.suspendThread();
                this.cachedStatus = null;
                ThreadsPanel.this.updateCell(ThreadsPanel.this.treeTable.getSelectedRow(), 1);
            }
        }

        boolean canResumeThread() {
            DebugThreadInfo debugThreadInfo;
            return this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canSuspendThread() && ThreadsPanel.this.vm.getCapabilities().canResumeThread() && (debugThreadInfo = (DebugThreadInfo)this.info).isThreadSuspended();
        }

        void resumeThread() {
            DebugThreadInfo debugThreadInfo;
            if (this.info instanceof DebugThreadInfo && ThreadsPanel.this.vm != null && ThreadsPanel.this.vm.getCapabilities().canSuspendThread() && ThreadsPanel.this.vm.getCapabilities().canResumeThread() && (debugThreadInfo = (DebugThreadInfo)this.info).isThreadSuspended()) {
                debugThreadInfo.resumeThread();
                this.cachedStatus = null;
                ThreadsPanel.this.updateCell(ThreadsPanel.this.treeTable.getSelectedRow(), 1);
            }
        }

        boolean canWatchInspectThread() {
            DebugThreadInfo debugThreadInfo;
            DebugDataObjectInfo debugDataObjectInfo;
            return this.info instanceof DebugThreadInfo && (debugDataObjectInfo = (debugThreadInfo = (DebugThreadInfo)this.info).getThreadObject()) != null && !debugDataObjectInfo.isNull() && debugDataObjectInfo.getFieldCount(-1, false, true) > 0;
        }

        void watchThread() {
            DebugThreadInfo debugThreadInfo;
            DebugDataObjectInfo debugDataObjectInfo;
            if (this.info instanceof DebugThreadInfo && (debugDataObjectInfo = (debugThreadInfo = (DebugThreadInfo)this.info).getThreadObject()) != null && !debugDataObjectInfo.isNull() && debugDataObjectInfo.getFieldCount(-1, false, true) > 0) {
                String string = DbgArb.format(280, Long.toString(JDebugger.getObjectNumber(debugDataObjectInfo)));
                EvaluatorItem evaluatorItem = ThreadsPanel.this.debuggingProcess.makeTemporaryEvaluatorItem(string, debugDataObjectInfo);
                JDebugger.getInstance().addWatch(evaluatorItem);
            }
        }

        void inspectThread() {
            DebugThreadInfo debugThreadInfo;
            DebugDataObjectInfo debugDataObjectInfo;
            if (this.info instanceof DebugThreadInfo && (debugDataObjectInfo = (debugThreadInfo = (DebugThreadInfo)this.info).getThreadObject()) != null && !debugDataObjectInfo.isNull() && debugDataObjectInfo.getFieldCount(-1, false, true) > 0) {
                String string = DbgArb.format(280, Long.toString(JDebugger.getObjectNumber(debugDataObjectInfo)));
                EvaluatorItem evaluatorItem = ThreadsPanel.this.debuggingProcess.makeTemporaryEvaluatorItem(string, debugDataObjectInfo);
                JDebugger.getInstance().inspect(evaluatorItem);
            }
        }

        boolean canWatchInspectClassLoader() {
            DebugDataObjectInfo debugDataObjectInfo;
            DebugThreadInfo debugThreadInfo;
            DebugClassLoaderInfo debugClassLoaderInfo;
            return this.info instanceof DebugThreadInfo && (debugClassLoaderInfo = (debugThreadInfo = (DebugThreadInfo)this.info).getContextClassLoader()) != null && (debugDataObjectInfo = debugClassLoaderInfo.getClassLoaderObject()) != null && !debugDataObjectInfo.isNull();
        }

        void watchClassLoader() {
            DebugDataObjectInfo debugDataObjectInfo;
            DebugThreadInfo debugThreadInfo;
            DebugClassLoaderInfo debugClassLoaderInfo;
            if (this.info instanceof DebugThreadInfo && (debugClassLoaderInfo = (debugThreadInfo = (DebugThreadInfo)this.info).getContextClassLoader()) != null && (debugDataObjectInfo = debugClassLoaderInfo.getClassLoaderObject()) != null && !debugDataObjectInfo.isNull()) {
                String string = ClassesWindow.makeClassLoaderName(debugClassLoaderInfo);
                EvaluatorItem evaluatorItem = ThreadsPanel.this.debuggingProcess.makeTemporaryEvaluatorItem(string, debugDataObjectInfo);
                JDebugger.getInstance().addWatch(evaluatorItem);
            }
        }

        void inspectClassLoader() {
            DebugDataObjectInfo debugDataObjectInfo;
            DebugThreadInfo debugThreadInfo;
            DebugClassLoaderInfo debugClassLoaderInfo;
            if (this.info instanceof DebugThreadInfo && (debugClassLoaderInfo = (debugThreadInfo = (DebugThreadInfo)this.info).getContextClassLoader()) != null && (debugDataObjectInfo = debugClassLoaderInfo.getClassLoaderObject()) != null) {
                String string = ClassesWindow.makeClassLoaderName(debugClassLoaderInfo);
                EvaluatorItem evaluatorItem = ThreadsPanel.this.debuggingProcess.makeTemporaryEvaluatorItem(string, debugDataObjectInfo);
                JDebugger.getInstance().inspect(evaluatorItem);
            }
        }

        static Font mav$getFont(ThreadItem threadItem, int n) {
            return threadItem.getFont(n);
        }

        static void mav$setIconAppropriately(ThreadItem threadItem) {
            threadItem.setIconAppropriately();
        }
    }

    protected final class ThreadInfoPath {
        private DebuggingProcess debuggingProcess;
        private Object info;

        ThreadInfoPath(DebuggingProcess debuggingProcess, Object object) {
            this.debuggingProcess = debuggingProcess;
            this.info = object;
        }

        DebuggingProcess getDebuggingProcess() {
            return this.debuggingProcess;
        }

        Object getInfo() {
            return this.info;
        }

        public int hashCode() {
            return this.debuggingProcess.hashCode() + this.info.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof ThreadInfoPath) {
                ThreadInfoPath threadInfoPath = (ThreadInfoPath)object;
                return this.debuggingProcess == threadInfoPath.debuggingProcess && this.info.equals(threadInfoPath.info);
            }
            return false;
        }
    }
}

