/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.Layout;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadGroupInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebugDockableFactory;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.StackWindow;
import oracle.jdevimpl.runner.debug.ThreadsPanel;
import oracle.jdevimpl.runner.debug.ThreadsWindowSettings;

final class ThreadsWindow
extends DockableWindow {
    private String title;
    private AllThreadsPanel threadsPanel;
    private Component gui;
    private ThreadsWindowSettings threadsWindowSettings = ThreadsWindowSettings.getInstance();
    private static IdeAction actionMakeCurrent;
    private static IdeAction actionSuspend;
    private static IdeAction actionResume;
    private static IdeAction actionWatchThread;
    private static IdeAction actionInspectThread;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoTo;
    private static IdeAction actionDump;
    private static IdeAction actionExpandAll;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemMakeCurrent;
    private static JMenuItem menuitemSuspend;
    private static JMenuItem menuitemResume;
    private static JMenuItem menuitemWatchThread;
    private static JMenuItem menuitemInspectThread;
    private static JMenuItem menuitemWatchClassLoader;
    private static JMenuItem menuitemInspectClassLoader;
    private static JMenuItem menuitemDump;
    private static JMenuItem menuitemExpandAll;
    private static JMenuItem menuitemCollapseAll;
    private static JMenuItem menuitemSettings;
    private static final int MAKE_CURRENT_CMD_ID;
    private static final int SUSPEND_CMD_ID;
    private static final int RESUME_CMD_ID;
    private static final int WATCH_THREAD_CMD_ID;
    private static final int INSPECT_THREAD_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int DUMP_CMD_ID;
    private static final int EXPAND_ALL_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final String THREADS_WINDOW_ID = "Debugger.ThreadsWindow";
    private static Icon threadsTabIcon;

    static {
        MAKE_CURRENT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsMakeCurrent");
        SUSPEND_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsSuspend");
        RESUME_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsResume");
        WATCH_THREAD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsWatchThread");
        INSPECT_THREAD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsInspectThread");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsGoTo");
        DUMP_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsDump");
        EXPAND_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsExpandAll");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugThreadsSettings");
        threadsTabIcon = null;
    }

    ThreadsWindow() {
        super(THREADS_WINDOW_ID);
        this.title = DbgArb.getString(240);
        ThreadsWindow.makeActions();
        this.threadsPanel = new AllThreadsPanel();
        this.setControllerForActions();
    }

    void setStackWindow(StackWindow stackWindow) {
        this.threadsPanel.setStackWindow(stackWindow);
    }

    void shutDown() {
        this.threadsPanel.saveSettings();
    }

    void threadsWindowSettingsChanged(boolean bl) {
        if (this.threadsPanel.treeTable == null) {
            return;
        }
        this.threadsPanel.treeTable.getTree().setShowsRootHandles(this.threadsWindowSettings.isShowThreadGroupStructure());
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu jMenu) {
        ThreadsWindow.makeActions();
        float f = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionMakeCurrent), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSuspend), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionResume), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchThread), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectThread), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoTo), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionDump), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionExpandAll), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), jMenu, f);
    }

    private static void makeActions() {
        if (actionGoTo == null) {
            actionGoTo = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(261), null, (Integer)DbgArb.getInteger(262), null, (int)-1, null, (boolean)false);
            actionGoTo.setEnabled(false);
            actionMakeCurrent = IdeAction.get((int)MAKE_CURRENT_CMD_ID, null, (String)DbgArb.getString(263), null, (Integer)DbgArb.getInteger(264), null, (int)-1, null, (boolean)false);
            actionMakeCurrent.setEnabled(false);
            actionSuspend = IdeAction.get((int)SUSPEND_CMD_ID, null, (String)DbgArb.getString(265), null, (Integer)DbgArb.getInteger(266), null, (int)-1, null, (boolean)false);
            actionSuspend.setEnabled(false);
            actionResume = IdeAction.get((int)RESUME_CMD_ID, null, (String)DbgArb.getString(267), null, (Integer)DbgArb.getInteger(268), null, (int)-1, null, (boolean)false);
            actionResume.setEnabled(false);
            actionWatchThread = IdeAction.get((int)WATCH_THREAD_CMD_ID, null, (String)DbgArb.getString(269), null, (Integer)DbgArb.getInteger(270), null, (int)-1, null, (boolean)false);
            actionWatchThread.setEnabled(false);
            actionInspectThread = IdeAction.get((int)INSPECT_THREAD_CMD_ID, null, (String)DbgArb.getString(271), null, (Integer)DbgArb.getInteger(272), null, (int)-1, null, (boolean)false);
            actionInspectThread.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(273), null, (Integer)DbgArb.getInteger(274), null, (int)-1, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(275), null, (Integer)DbgArb.getInteger(276), null, (int)-1, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(101), null, (Integer)RunMgrArb.getInteger(102), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionExpandAll = IdeAction.get((int)EXPAND_ALL_CMD_ID, null, (String)RunMgrArb.getString(95), null, (Integer)RunMgrArb.getInteger(96), null, (int)-1, null, (boolean)false);
            actionExpandAll.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(97), null, (Integer)RunMgrArb.getInteger(98), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(99), null, (Integer)RunMgrArb.getInteger(100), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
            actionDump = IdeAction.get((int)DUMP_CMD_ID, null, (String)DbgArb.getString(277), null, (Integer)DbgArb.getInteger(278), null, (int)-1, null, (boolean)false);
            actionDump.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] ideActionArray = new IdeAction[]{actionGoTo, actionMakeCurrent, actionSuspend, actionResume, actionWatchThread, actionInspectThread, actionWatchClassLoader, actionInspectClassLoader, actionSettings, actionExpandAll, actionCollapseAll, actionSave, actionDump};
        JDebugger.setControllerForActions(ideActionArray, this.threadsPanel);
    }

    public Component getGUI() {
        if (this.gui == null) {
            this.gui = this.threadsPanel.getGUI();
            this.threadsPanel.loadSettings();
            this.threadsWindowSettingsChanged(false);
            this.threadsPanel.threadsPanelSettingsChanged(false);
            DebugDockableFactory.updateSiteGeometry((Dockable)this);
            this.everythingChanged();
            this.threadsWindowSettings.addChangeListener(new 1());
        }
        return this.gui;
    }

    public ContextMenu getContextMenu() {
        return JDebugger.getInstance().getContextMenu();
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_deb_threadswindow_html");
    }

    public Controller getController() {
        return this.threadsPanel;
    }

    public Context getContext(EventObject eventObject) {
        return this.threadsPanel.getContext(eventObject);
    }

    public int getDefaultVisibility(Layout layout) {
        return 0;
    }

    public String getTabName() {
        return this.title;
    }

    public Icon getTabIcon() {
        if (threadsTabIcon == null) {
            threadsTabIcon = DbgArb.getIcon(63);
        }
        return threadsTabIcon;
    }

    public String getTitleName() {
        return this.title;
    }

    void everythingChanged() {
        this.threadsPanel.everythingChanged();
    }

    void updateThreads(DebuggingProcess debuggingProcess, DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo) {
        this.threadsPanel.updateThreads(debuggingProcess, debugVirtualMachine, debugThreadInfo);
    }

    void clearThreads() {
        this.threadsPanel.clearThreads();
    }

    void processFinished(DebuggingProcess debuggingProcess) {
        this.threadsPanel.processFinished(debuggingProcess);
    }

    static ThreadsWindowSettings ra$threadsWindowSettings(ThreadsWindow threadsWindow) {
        return threadsWindow.threadsWindowSettings;
    }

    static int ra$SETTINGS_CMD_ID() {
        return SETTINGS_CMD_ID;
    }

    static int ra$MAKE_CURRENT_CMD_ID() {
        return MAKE_CURRENT_CMD_ID;
    }

    static int ra$SUSPEND_CMD_ID() {
        return SUSPEND_CMD_ID;
    }

    static int ra$RESUME_CMD_ID() {
        return RESUME_CMD_ID;
    }

    static int ra$WATCH_THREAD_CMD_ID() {
        return WATCH_THREAD_CMD_ID;
    }

    static int ra$INSPECT_THREAD_CMD_ID() {
        return INSPECT_THREAD_CMD_ID;
    }

    static int ra$WATCH_CLASSLOADER_CMD_ID() {
        return WATCH_CLASSLOADER_CMD_ID;
    }

    static int ra$INSPECT_CLASSLOADER_CMD_ID() {
        return INSPECT_CLASSLOADER_CMD_ID;
    }

    static int ra$EXPAND_ALL_CMD_ID() {
        return EXPAND_ALL_CMD_ID;
    }

    static int ra$COLLAPSE_ALL_CMD_ID() {
        return COLLAPSE_ALL_CMD_ID;
    }

    static int ra$DUMP_CMD_ID() {
        return DUMP_CMD_ID;
    }

    static IdeAction ra$actionSettings() {
        return actionSettings;
    }

    static JMenuItem ra$menuitemSettings() {
        return menuitemSettings;
    }

    static void wa$menuitemSettings(JMenuItem jMenuItem) {
        menuitemSettings = jMenuItem;
    }

    static IdeAction ra$actionExpandAll() {
        return actionExpandAll;
    }

    static JMenuItem ra$menuitemExpandAll() {
        return menuitemExpandAll;
    }

    static void wa$menuitemExpandAll(JMenuItem jMenuItem) {
        menuitemExpandAll = jMenuItem;
    }

    static IdeAction ra$actionCollapseAll() {
        return actionCollapseAll;
    }

    static JMenuItem ra$menuitemCollapseAll() {
        return menuitemCollapseAll;
    }

    static void wa$menuitemCollapseAll(JMenuItem jMenuItem) {
        menuitemCollapseAll = jMenuItem;
    }

    static IdeAction ra$actionDump() {
        return actionDump;
    }

    static JMenuItem ra$menuitemDump() {
        return menuitemDump;
    }

    static void wa$menuitemDump(JMenuItem jMenuItem) {
        menuitemDump = jMenuItem;
    }

    static IdeAction ra$actionMakeCurrent() {
        return actionMakeCurrent;
    }

    static JMenuItem ra$menuitemMakeCurrent() {
        return menuitemMakeCurrent;
    }

    static void wa$menuitemMakeCurrent(JMenuItem jMenuItem) {
        menuitemMakeCurrent = jMenuItem;
    }

    static IdeAction ra$actionSuspend() {
        return actionSuspend;
    }

    static JMenuItem ra$menuitemSuspend() {
        return menuitemSuspend;
    }

    static void wa$menuitemSuspend(JMenuItem jMenuItem) {
        menuitemSuspend = jMenuItem;
    }

    static IdeAction ra$actionResume() {
        return actionResume;
    }

    static JMenuItem ra$menuitemResume() {
        return menuitemResume;
    }

    static void wa$menuitemResume(JMenuItem jMenuItem) {
        menuitemResume = jMenuItem;
    }

    static IdeAction ra$actionWatchThread() {
        return actionWatchThread;
    }

    static JMenuItem ra$menuitemWatchThread() {
        return menuitemWatchThread;
    }

    static void wa$menuitemWatchThread(JMenuItem jMenuItem) {
        menuitemWatchThread = jMenuItem;
    }

    static IdeAction ra$actionInspectThread() {
        return actionInspectThread;
    }

    static JMenuItem ra$menuitemInspectThread() {
        return menuitemInspectThread;
    }

    static void wa$menuitemInspectThread(JMenuItem jMenuItem) {
        menuitemInspectThread = jMenuItem;
    }

    static IdeAction ra$actionWatchClassLoader() {
        return actionWatchClassLoader;
    }

    static JMenuItem ra$menuitemWatchClassLoader() {
        return menuitemWatchClassLoader;
    }

    static void wa$menuitemWatchClassLoader(JMenuItem jMenuItem) {
        menuitemWatchClassLoader = jMenuItem;
    }

    static IdeAction ra$actionInspectClassLoader() {
        return actionInspectClassLoader;
    }

    static JMenuItem ra$menuitemInspectClassLoader() {
        return menuitemInspectClassLoader;
    }

    static void wa$menuitemInspectClassLoader(JMenuItem jMenuItem) {
        menuitemInspectClassLoader = jMenuItem;
    }

    static IdeAction ra$actionGoTo() {
        return actionGoTo;
    }

    static IdeAction ra$actionSave() {
        return actionSave;
    }

    static int ra$GOTO_CMD_ID() {
        return GOTO_CMD_ID;
    }

    static int ra$SAVE_CMD_ID() {
        return SAVE_CMD_ID;
    }

    final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            ThreadsWindow.this.threadsWindowSettingsChanged(true);
        }
    }

    final class AllThreadsPanel
    extends ThreadsPanel {
        private DebugThreadInfo highlightThread;
        private StackWindow stackWindow;

        AllThreadsPanel() {
            super(ThreadsWindow.this, ThreadsWindow.ra$threadsWindowSettings(ThreadsWindow.this).getThreadsPanelSettings());
            this._actionGoTo = ThreadsWindow.ra$actionGoTo();
            this._actionSave = ThreadsWindow.ra$actionSave();
            this._GOTO_CMD_ID = ThreadsWindow.ra$GOTO_CMD_ID();
            this._SAVE_CMD_ID = ThreadsWindow.ra$SAVE_CMD_ID();
        }

        void setStackWindow(StackWindow stackWindow) {
            this.stackWindow = stackWindow;
            this.updateStack();
        }

        protected void addPopupMenuItemsForThreadItem(ContextMenu contextMenu, Context context) {
            this.update(ThreadsWindow.ra$actionMakeCurrent(), context);
            if (ThreadsWindow.ra$actionMakeCurrent().isEnabled()) {
                if (ThreadsWindow.ra$menuitemMakeCurrent() == null) {
                    ThreadsWindow.wa$menuitemMakeCurrent(contextMenu.createMenuItem((ToggleAction)ThreadsWindow.ra$actionMakeCurrent()));
                }
                contextMenu.add((Component)ThreadsWindow.ra$menuitemMakeCurrent(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(ThreadsWindow.ra$actionSuspend(), context);
            if (ThreadsWindow.ra$actionSuspend().isEnabled()) {
                if (ThreadsWindow.ra$menuitemSuspend() == null) {
                    ThreadsWindow.wa$menuitemSuspend(contextMenu.createMenuItem((ToggleAction)ThreadsWindow.ra$actionSuspend()));
                }
                contextMenu.add((Component)ThreadsWindow.ra$menuitemSuspend(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(ThreadsWindow.ra$actionResume(), context);
            if (ThreadsWindow.ra$actionResume().isEnabled()) {
                if (ThreadsWindow.ra$menuitemResume() == null) {
                    ThreadsWindow.wa$menuitemResume(contextMenu.createMenuItem((ToggleAction)ThreadsWindow.ra$actionResume()));
                }
                contextMenu.add((Component)ThreadsWindow.ra$menuitemResume(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(ThreadsWindow.ra$actionWatchThread(), context);
            if (ThreadsWindow.ra$actionWatchThread().isEnabled()) {
                if (ThreadsWindow.ra$menuitemWatchThread() == null) {
                    ThreadsWindow.wa$menuitemWatchThread(contextMenu.createMenuItem((ToggleAction)ThreadsWindow.ra$actionWatchThread()));
                }
                contextMenu.add((Component)ThreadsWindow.ra$menuitemWatchThread(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(ThreadsWindow.ra$actionInspectThread(), context);
            if (ThreadsWindow.ra$actionInspectThread().isEnabled()) {
                if (ThreadsWindow.ra$menuitemInspectThread() == null) {
                    ThreadsWindow.wa$menuitemInspectThread(contextMenu.createMenuItem((ToggleAction)ThreadsWindow.ra$actionInspectThread()));
                }
                contextMenu.add((Component)ThreadsWindow.ra$menuitemInspectThread(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(ThreadsWindow.ra$actionWatchClassLoader(), context);
            if (ThreadsWindow.ra$actionWatchClassLoader().isEnabled()) {
                if (ThreadsWindow.ra$menuitemWatchClassLoader() == null) {
                    ThreadsWindow.wa$menuitemWatchClassLoader(contextMenu.createMenuItem((ToggleAction)ThreadsWindow.ra$actionWatchClassLoader()));
                }
                contextMenu.add((Component)ThreadsWindow.ra$menuitemWatchClassLoader(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(ThreadsWindow.ra$actionInspectClassLoader(), context);
            if (ThreadsWindow.ra$actionInspectClassLoader().isEnabled()) {
                if (ThreadsWindow.ra$menuitemInspectClassLoader() == null) {
                    ThreadsWindow.wa$menuitemInspectClassLoader(contextMenu.createMenuItem((ToggleAction)ThreadsWindow.ra$actionInspectClassLoader()));
                }
                contextMenu.add((Component)ThreadsWindow.ra$menuitemInspectClassLoader(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            super.addPopupMenuItemsForThreadItem(contextMenu, context);
        }

        protected void addPopupMenuItemsForThreads(ContextMenu contextMenu, Context context) {
            this.update(ThreadsWindow.ra$actionDump(), context);
            if (ThreadsWindow.ra$actionDump().isEnabled()) {
                if (ThreadsWindow.ra$menuitemDump() == null) {
                    ThreadsWindow.wa$menuitemDump(contextMenu.createMenuItem((ToggleAction)ThreadsWindow.ra$actionDump()));
                }
                contextMenu.add((Component)ThreadsWindow.ra$menuitemDump(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
            }
            super.addPopupMenuItemsForThreads(contextMenu, context);
        }

        protected void addPopupMenuItemsForTreeTable(ContextMenu contextMenu, Context context) {
            this.update(ThreadsWindow.ra$actionExpandAll(), context);
            if (ThreadsWindow.ra$actionExpandAll().isEnabled()) {
                if (ThreadsWindow.ra$menuitemExpandAll() == null) {
                    ThreadsWindow.wa$menuitemExpandAll(contextMenu.createMenuItem((ToggleAction)ThreadsWindow.ra$actionExpandAll()));
                }
                contextMenu.add((Component)ThreadsWindow.ra$menuitemExpandAll(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
            }
            this.update(ThreadsWindow.ra$actionCollapseAll(), context);
            if (ThreadsWindow.ra$actionCollapseAll().isEnabled()) {
                if (ThreadsWindow.ra$menuitemCollapseAll() == null) {
                    ThreadsWindow.wa$menuitemCollapseAll(contextMenu.createMenuItem((ToggleAction)ThreadsWindow.ra$actionCollapseAll()));
                }
                contextMenu.add((Component)ThreadsWindow.ra$menuitemCollapseAll(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_TREE_CTXT_MENU);
            }
            super.addPopupMenuItemsForTreeTable(contextMenu, context);
        }

        protected void addPopupMenuItemsForCommon(ContextMenu contextMenu, Context context) {
            super.addPopupMenuItemsForCommon(contextMenu, context);
            this.update(ThreadsWindow.ra$actionSettings(), context);
            if (ThreadsWindow.ra$actionSettings().isEnabled()) {
                if (ThreadsWindow.ra$menuitemSettings() == null) {
                    ThreadsWindow.wa$menuitemSettings(contextMenu.createMenuItem((ToggleAction)ThreadsWindow.ra$actionSettings()));
                }
                contextMenu.add((Component)ThreadsWindow.ra$menuitemSettings(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == ThreadsWindow.ra$MAKE_CURRENT_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.makeCurrentThread();
                }
                return true;
            }
            if (n == ThreadsWindow.ra$SUSPEND_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.suspendThread();
                }
                return true;
            }
            if (n == ThreadsWindow.ra$RESUME_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.resumeThread();
                }
                return true;
            }
            if (n == ThreadsWindow.ra$WATCH_THREAD_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.watchThread();
                }
                return true;
            }
            if (n == ThreadsWindow.ra$INSPECT_THREAD_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.inspectThread();
                }
                return true;
            }
            if (n == ThreadsWindow.ra$WATCH_CLASSLOADER_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.watchClassLoader();
                }
                return true;
            }
            if (n == ThreadsWindow.ra$INSPECT_CLASSLOADER_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    threadItem.inspectClassLoader();
                }
                return true;
            }
            if (n == ThreadsWindow.ra$SETTINGS_CMD_ID()) {
                String[] stringArray = new String[]{DbgArb.getString(716), DbgArb.getString(749)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
                return true;
            }
            if (n == ThreadsWindow.ra$EXPAND_ALL_CMD_ID()) {
                this.model.expandAll();
                return true;
            }
            if (n == ThreadsWindow.ra$COLLAPSE_ALL_CMD_ID()) {
                this.model.collapseAll();
                return true;
            }
            if (n == ThreadsWindow.ra$DUMP_CMD_ID()) {
                this.fullThreadDump();
                return true;
            }
            return super.handleEvent(ideAction, context);
        }

        public boolean update(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (ideAction.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    ideAction.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || n == ThreadsWindow.ra$SETTINGS_CMD_ID())) {
                    ideAction.setEnabled(false);
                    return true;
                }
            }
            if (n == ThreadsWindow.ra$MAKE_CURRENT_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    ideAction.setEnabled(threadItem.canMakeCurrentThread());
                } else {
                    ideAction.setEnabled(false);
                }
                return true;
            }
            if (n == ThreadsWindow.ra$SUSPEND_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    ideAction.setEnabled(threadItem.canSuspendThread());
                } else {
                    ideAction.setEnabled(false);
                }
                return true;
            }
            if (n == ThreadsWindow.ra$RESUME_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    ideAction.setEnabled(threadItem.canResumeThread());
                } else {
                    ideAction.setEnabled(false);
                }
                return true;
            }
            if (n == ThreadsWindow.ra$WATCH_THREAD_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    ideAction.setEnabled(threadItem.canWatchInspectThread());
                } else {
                    ideAction.setEnabled(false);
                }
                return true;
            }
            if (n == ThreadsWindow.ra$INSPECT_THREAD_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    ideAction.setEnabled(threadItem.canWatchInspectThread());
                } else {
                    ideAction.setEnabled(false);
                }
                return true;
            }
            if (n == ThreadsWindow.ra$WATCH_CLASSLOADER_CMD_ID() || n == ThreadsWindow.ra$INSPECT_CLASSLOADER_CMD_ID()) {
                ThreadsPanel.ThreadItem threadItem = this.getSelectedThreadItem();
                if (threadItem != null) {
                    ideAction.setEnabled(threadItem.canWatchInspectClassLoader());
                } else {
                    ideAction.setEnabled(false);
                }
                return true;
            }
            if (n == ThreadsWindow.ra$SETTINGS_CMD_ID()) {
                ideAction.setEnabled(true);
                return true;
            }
            if (n == ThreadsWindow.ra$EXPAND_ALL_CMD_ID() || n == ThreadsWindow.ra$COLLAPSE_ALL_CMD_ID()) {
                ideAction.setEnabled(ThreadsWindow.ra$threadsWindowSettings(ThreadsWindow.this).isShowThreadGroupStructure());
                return true;
            }
            if (n == ThreadsWindow.ra$DUMP_CMD_ID()) {
                ideAction.setEnabled(true);
                return true;
            }
            return super.update(ideAction, context);
        }

        protected void addThreadItems() {
            List list = this.getRoot();
            if (ThreadsWindow.ra$threadsWindowSettings(ThreadsWindow.this).isShowThreadGroupStructure()) {
                DebugThreadGroupInfo[] debugThreadGroupInfoArray = this.vm.listTopThreadGroups();
                Arrays.sort(debugThreadGroupInfoArray, this);
                int n = 0;
                while (n < debugThreadGroupInfoArray.length) {
                    list.add(new ThreadsPanel.ThreadItem(debugThreadGroupInfoArray[n]));
                    ++n;
                }
            } else {
                DebugThreadInfo[] debugThreadInfoArray = this.vm.listThreads();
                Arrays.sort(debugThreadInfoArray, this);
                int n = 0;
                while (n < debugThreadInfoArray.length) {
                    list.add(new ThreadsPanel.ThreadItem(debugThreadInfoArray[n]));
                    ++n;
                }
            }
        }

        private void fullThreadDump() {
            URL uRL;
            String string = DbgArb.getString(279);
            URLChooser uRLChooser = DialogUtil.newURLChooser((Context)this.getContext());
            if (JDebugger.lastSavedFile != null) {
                uRLChooser.setSelectedURL(JDebugger.lastSavedFile);
            }
            if (uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), string) == 0 && (uRL = uRLChooser.getSelectedURL()) != null) {
                JDebugger.lastSavedFile = uRL;
                WaitCursor waitCursor = Ide.getWaitCursor();
                waitCursor.show();
                Exception exception = null;
                try {
                    PrintWriter printWriter;
                    String string2 = URLFileSystem.getSuffix((URL)uRL).toUpperCase();
                    boolean bl = string2.equals(".HTML") || string2.equals(".HTM");
                    PrintWriter printWriter2 = printWriter = bl ? JDebugger.printHtmlHeader(uRL, DbgArb.getString(860)) : new PrintWriter(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)uRL)));
                    if (this.vm != null) {
                        String string3 = this.getThreadsHeader(bl);
                        String string4 = this.getStackHeader(bl);
                        if (bl) {
                            printWriter.println("<table border=\"1\">");
                        }
                        printWriter.println(string3);
                        StringBuffer stringBuffer = new StringBuffer();
                        DebugThreadInfo[] debugThreadInfoArray = this.vm.listThreads();
                        Arrays.sort(debugThreadInfoArray, this);
                        int n = debugThreadInfoArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DebugThreadInfo debugThreadInfo = debugThreadInfoArray[n2];
                            stringBuffer.setLength(0);
                            if (bl) {
                                stringBuffer.append("<tr>");
                            }
                            int n3 = 0;
                            TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
                            Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
                            while (enumeration.hasMoreElements()) {
                                ++n3;
                                TableColumn tableColumn = enumeration.nextElement();
                                int n4 = tableColumn.getModelIndex();
                                String string5 = null;
                                String[] stringArray = null;
                                switch (n4) {
                                    case 0: {
                                        string5 = debugThreadInfo.getName();
                                        break;
                                    }
                                    case 1: {
                                        string5 = AllThreadsPanel.getThreadStatus(debugThreadInfo.getStatus());
                                        if (debugThreadInfo.isThreadSuspended()) {
                                            string5 = string5 + ' ' + DbgArb.getString(259);
                                        }
                                        if (!AllThreadsPanel.isDeadlocked(debugThreadInfo, this.debuggingProcess)) break;
                                        string5 = string5 + ' ' + DbgArb.getString(260);
                                        break;
                                    }
                                    case 2: {
                                        string5 = debugThreadInfo.getGroupName();
                                        break;
                                    }
                                    case 3: {
                                        if (stringArray == null) {
                                            stringArray = AllThreadsPanel.getPriorityDaemon(debugThreadInfo);
                                        }
                                        string5 = stringArray[0];
                                        break;
                                    }
                                    case 4: {
                                        if (stringArray == null) {
                                            stringArray = AllThreadsPanel.getPriorityDaemon(debugThreadInfo);
                                        }
                                        string5 = stringArray[1];
                                    }
                                }
                                if (bl) {
                                    stringBuffer.append("<td>");
                                    if (string5 != null) {
                                        String string6 = IdeUtil.replaceHTMLReservedCharacters((String)string5);
                                        if (string6.length() > 0) {
                                            stringBuffer.append(string6);
                                        } else {
                                            stringBuffer.append("&nbsp;");
                                        }
                                    } else {
                                        stringBuffer.append("&nbsp;");
                                    }
                                    stringBuffer.append("</td>");
                                    continue;
                                }
                                if (string5 != null) {
                                    stringBuffer.append(string5);
                                }
                                if (!enumeration.hasMoreElements()) continue;
                                stringBuffer.append('\t');
                            }
                            if (bl) {
                                stringBuffer.append("</tr>");
                            }
                            printWriter.println(stringBuffer.toString());
                            DebugStackFrameInfo[] debugStackFrameInfoArray = debugThreadInfo.listStack();
                            int n5 = debugStackFrameInfoArray.length;
                            if (n5 > 0) {
                                if (bl) {
                                    printWriter.println("<tr><td></td><td colspan=" + (n3 - 1) + "><table border=\"1\">");
                                }
                                printWriter.println(string4);
                                int n6 = 0;
                                while (n6 < n5) {
                                    DebugMethodInfo debugMethodInfo;
                                    DebugStackFrameInfo debugStackFrameInfo = debugStackFrameInfoArray[n6];
                                    DebugLocation debugLocation = debugStackFrameInfo.getLocation();
                                    if (debugLocation != null && (debugMethodInfo = debugLocation.getMethod()) != null) {
                                        String string7 = DebugShared.makeCourtesyMethodName(debugMethodInfo, true, true, debugStackFrameInfo);
                                        String string8 = debugLocation.getFilename();
                                        int n7 = debugLocation.getLine();
                                        stringBuffer.setLength(0);
                                        if (bl) {
                                            stringBuffer.append("<tr><td>");
                                            string7 = IdeUtil.replaceHTMLReservedCharacters((String)string7);
                                            stringBuffer.append(string7);
                                            stringBuffer.append("</td><td>");
                                            if (string8 != null) {
                                                string8 = IdeUtil.replaceHTMLReservedCharacters((String)string8);
                                                stringBuffer.append(string8);
                                            } else {
                                                stringBuffer.append("&nbsp;");
                                            }
                                            stringBuffer.append("</td><td>");
                                            if (n7 > 0) {
                                                stringBuffer.append(n7);
                                            } else {
                                                stringBuffer.append("&nbsp;");
                                            }
                                            stringBuffer.append("</td></tr>");
                                        } else {
                                            stringBuffer.append('\t');
                                            stringBuffer.append(string7);
                                            stringBuffer.append('\t');
                                            if (string8 != null) {
                                                stringBuffer.append(string8);
                                            }
                                            stringBuffer.append('\t');
                                            if (n7 > 0) {
                                                stringBuffer.append(n7);
                                            }
                                        }
                                        printWriter.println(stringBuffer.toString());
                                    }
                                    ++n6;
                                }
                                if (bl) {
                                    printWriter.println("</table></td><tr>");
                                }
                            }
                            if (!bl) {
                                printWriter.println();
                            }
                            ++n2;
                        }
                        if (bl) {
                            printWriter.println("</table>");
                        }
                    }
                    if (bl) {
                        JDebugger.printHtmlFooter(printWriter);
                    }
                    printWriter.flush();
                    printWriter.close();
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
                waitCursor.hide();
                if (exception != null) {
                    String string9 = DbgArb.format(859, URLFileSystem.getPlatformPathName((URL)uRL));
                    ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)exception, (String)string, (String)string9, null);
                }
            }
        }

        private String getThreadsHeader(boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            if (bl) {
                stringBuffer.append("<tr>");
            }
            TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
            Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
            while (enumeration.hasMoreElements()) {
                String string;
                TableColumn tableColumn = enumeration.nextElement();
                int n = tableColumn.getModelIndex();
                String string2 = string = n == 0 ? DbgArb.getString(861) : this.model.getColumnName(n);
                if (bl) {
                    stringBuffer.append("<th>");
                    string = IdeUtil.replaceHTMLReservedCharacters((String)string.toString());
                    stringBuffer.append(string);
                    stringBuffer.append("</th>");
                    continue;
                }
                stringBuffer.append(string);
                int n2 = string.length();
                while (n2 >= 0) {
                    stringBuffer2.append('-');
                    --n2;
                }
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append('\t');
                stringBuffer2.append('\t');
            }
            if (bl) {
                stringBuffer.append("</tr>");
            }
            if (!bl) {
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append(stringBuffer2.toString());
            }
            return stringBuffer.toString();
        }

        private String getStackHeader(boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            if (bl) {
                stringBuffer.append("<tr><th colspan=3>");
                stringBuffer.append(DbgArb.getString(862));
                stringBuffer.append("</th></tr>");
                stringBuffer.append("<tr>");
            }
            int n = 3;
            String[] stringArray = new String[]{DbgArb.getString(286), DbgArb.getString(290), DbgArb.getString(291)};
            int n2 = 0;
            while (n2 < 3) {
                String string = stringArray[n2];
                if (bl) {
                    stringBuffer.append("<th>");
                    string = IdeUtil.replaceHTMLReservedCharacters((String)string.toString());
                    stringBuffer.append(string);
                    stringBuffer.append("</th>");
                } else {
                    stringBuffer.append('\t');
                    stringBuffer.append(string);
                    stringBuffer2.append('\t');
                    int n3 = string.length();
                    while (n3 >= 0) {
                        stringBuffer2.append('-');
                        --n3;
                    }
                }
                ++n2;
            }
            if (bl) {
                stringBuffer.append("</tr>");
            }
            if (!bl) {
                stringBuffer.append(System.getProperty("line.separator"));
                stringBuffer.append(stringBuffer2.toString());
            }
            return stringBuffer.toString();
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            super.valueChanged(treeSelectionEvent);
            if (this.treeTable.isShowing()) {
                this.highlightThread = this.getSelectedThreadInfo();
                if (this.highlightThread != null) {
                    this.updateStack();
                }
            }
        }

        protected ThreadsPanel.ThreadInfoPath getCurrentHighlight() {
            if (this.debuggingProcess != null && this.highlightThread != null) {
                return new ThreadsPanel.ThreadInfoPath(this.debuggingProcess, this.highlightThread);
            }
            return super.getCurrentHighlight();
        }

        void updateThreads(DebuggingProcess debuggingProcess, DebugVirtualMachine debugVirtualMachine, DebugThreadInfo debugThreadInfo) {
            this.highlightThread = debugThreadInfo;
            super.updateThreads(debuggingProcess, debugVirtualMachine, debugThreadInfo);
            if (!this.treeTable.isShowing() || debugThreadInfo == null) {
                this.updateStack();
            }
        }

        void clearThreads() {
            super.clearThreads();
            this.updateStack();
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            if (this.debuggingProcess == debuggingProcess) {
                this.highlightThread = null;
            }
            super.processFinished(debuggingProcess);
            if (this.stackWindow != null) {
                this.stackWindow.processFinished(debuggingProcess);
            }
        }

        void updateStack() {
            if (this.stackWindow != null) {
                if (this.treeTable != null && this.treeTable.isEnabled()) {
                    if (this.debuggingProcess != null && this.vm != null) {
                        this.stackWindow.updateStack(this.debuggingProcess, this.vm, this.highlightThread);
                    } else {
                        this.stackWindow.updateStack(null, null, null);
                    }
                } else {
                    this.stackWindow.clearStack();
                }
            }
        }
    }
}

