/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Node;
import oracle.ide.runner.ToolTipExpressionProvider;
import oracle.jdevimpl.debugger.shared.DebugShared;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.Evaluator;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.StackWindow;

class ToolTipEvaluator {
    private JDebugger jdebugger;
    private Evaluator evaluator;

    ToolTipEvaluator(JDebugger jDebugger) {
        this.jdebugger = jDebugger;
        this.evaluator = new Evaluator(false);
    }

    String getToolTip(CodeEditor codeEditor, int n) {
        try {
            Node node = codeEditor.getContext().getNode();
            ArrayList arrayList = new ArrayList();
            this.getExpressions(codeEditor, node, n, arrayList);
            if (!arrayList.isEmpty()) {
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    String string;
                    String string2 = JDebugger.trimExpression((String)arrayList.get(n2));
                    if (string2.length() > 0 && (string = this.evaluate(string2)) != null && string.length() > 0) {
                        String string3 = DbgArb.format(834, string2, string);
                        return string3;
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private void getExpressions(CodeEditor codeEditor, Node node, int n, List list) {
        String string;
        int n2;
        String string2 = null;
        int n3 = codeEditor.getSelectionStart();
        if (n3 != (n2 = codeEditor.getSelectionEnd()) && n3 <= n && n <= n2) {
            string2 = codeEditor.getSelectedText();
        }
        int n4 = codeEditor.getLineFromOffset(n);
        int n5 = codeEditor.getLineStartOffset(n4);
        int n6 = codeEditor.getLineEndOffset(n4);
        int n7 = n - n5;
        try {
            string = codeEditor.getText(n5, n6 - n5);
        }
        catch (Exception exception) {
            string = "";
        }
        int n8 = string.length();
        List<ToolTipExpressionProvider> list2 = JDebugger.getToolTipExpressionProviders();
        int n9 = 0;
        while (n9 < list2.size()) {
            ToolTipExpressionProvider toolTipExpressionProvider = list2.get(n9);
            try {
                if (toolTipExpressionProvider.canUnderstand(node)) {
                    String string3;
                    boolean bl = toolTipExpressionProvider.isLanguageCaseInsensitive();
                    if (string2 != null) {
                        String string4;
                        if (!list.contains(string2)) {
                            list.add(string2);
                        }
                        if (bl && !(string4 = string2.toUpperCase()).equals(string2) && !list.contains(string4)) {
                            list.add(string4);
                        }
                    }
                    if (n8 > 0 && (string3 = toolTipExpressionProvider.getExpression(string, n7)) != null) {
                        String string5;
                        if (!list.contains(string3)) {
                            list.add(string3);
                        }
                        if (bl && !(string5 = string3.toUpperCase()).equals(string3) && !list.contains(string5)) {
                            list.add(string5);
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n9;
        }
        if (list.isEmpty() && n8 > 0 && 0 <= n7 && n7 < n8) {
            char[] cArray = new char[n8];
            string.getChars(0, n8, cArray, 0);
            int n10 = ToolTipEvaluator.findStartOfUnknownExpression(cArray, n8, n7);
            int n11 = ToolTipEvaluator.findEndOfUnknownExpression(cArray, n8, n10);
            String string6 = string.substring(n10, n11);
            if (string6.length() > 0 && !list.contains(string6)) {
                list.add(string6);
            }
        }
    }

    private static int findStartOfUnknownExpression(char[] cArray, int n, int n2) {
        int n3 = n2;
        while (0 <= n3 && n3 < n) {
            if (!ToolTipEvaluator.isUnknownExpressionPart(cArray[n3])) {
                return n3 + 1;
            }
            --n3;
        }
        return 0;
    }

    private static int findEndOfUnknownExpression(char[] cArray, int n, int n2) {
        int n3 = n2;
        while (0 <= n3 && n3 < n) {
            if (!ToolTipEvaluator.isUnknownExpressionPart(cArray[n3])) {
                return n3;
            }
            ++n3;
        }
        return n;
    }

    private static boolean isUnknownExpressionPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '.' || c == '[' || c == ']';
    }

    private String evaluate(String string) {
        StackWindow stackWindow = this.jdebugger.getStackWindow(true);
        stackWindow.updateEvaluator(this.evaluator);
        Object object = this.evaluator.evaluate(string);
        if (object != null) {
            DebugDataInfo debugDataInfo = Evaluator.getDataInfo(object);
            String string2 = DataPanel.makeDataValue(object, debugDataInfo);
            if ((string2 == null || string2.length() == 0) && debugDataInfo instanceof DebugDataCompositeInfo && !((DebugDataCompositeInfo)debugDataInfo).isNull()) {
                DebugClassInfo debugClassInfo = debugDataInfo.getClassInfo();
                string2 = "( " + DebugShared.makeCourtesyClassName(debugClassInfo, true) + " )";
            }
            return string2;
        }
        return null;
    }

    void clearEvaluator() {
        StackWindow stackWindow = this.jdebugger.getStackWindow(true);
        stackWindow.updateEvaluator(this.evaluator);
    }
}

