/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.Component;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Project;
import oracle.ide.util.PropertyAccess;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.ClassesWindow;
import oracle.jdevimpl.runner.debug.DataPanel;
import oracle.jdevimpl.runner.debug.DataWindow;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EditWatchDialog;
import oracle.jdevimpl.runner.debug.EvaluatorItem;
import oracle.jdevimpl.runner.debug.EvaluatorPanel;
import oracle.jdevimpl.runner.debug.Expression;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.WatchWindowSettings;

final class WatchWindow
extends DataWindow {
    private WatchWindowSettings watchWindowSettings = WatchWindowSettings.getInstance();
    private static IdeAction actionAddNewWatch;
    private static IdeAction actionEditWatch;
    private static IdeAction actionRemoveWatch;
    private static IdeAction actionPin;
    private static IdeAction actionUnpin;
    private static IdeAction actionViewWhole;
    private static IdeAction actionAdjustRange;
    private static IdeAction actionToggleValue;
    private static IdeAction actionModifyValue;
    private static IdeAction actionWatch;
    private static IdeAction actionInspect;
    private static IdeAction actionWatchClassLoader;
    private static IdeAction actionInspectClassLoader;
    private static IdeAction actionGoto;
    private static IdeAction actionGotoDeclared;
    private static IdeAction actionGotoField;
    private static IdeAction actionRemoveAllWatches;
    private static IdeAction actionUseFilters;
    private static IdeAction actionObjectPreferences;
    private static IdeAction actionCollapseAll;
    private static IdeAction actionSave;
    private static IdeAction actionSettings;
    private static JMenuItem menuitemAddNewWatch;
    private static JMenuItem menuitemEditWatch;
    private static JMenuItem menuitemRemoveWatch;
    private static JMenuItem menuitemRemoveAllWatches;
    private static JMenuItem menuitemSettings;
    private static final int ADD_NEW_WATCH_CMD_ID;
    private static final int EDIT_WATCH_CMD_ID;
    private static final int REMOVE_WATCH_CMD_ID;
    private static final int PIN_CMD_ID;
    private static final int UNPIN_CMD_ID;
    private static final int VIEW_WHOLE_CMD_ID;
    private static final int ADJUST_RANGE_CMD_ID;
    private static final int TOGGLE_VALUE_CMD_ID;
    private static final int MODIFY_VALUE_CMD_ID;
    private static final int WATCH_CMD_ID;
    private static final int INSPECT_CMD_ID;
    private static final int WATCH_CLASSLOADER_CMD_ID;
    private static final int INSPECT_CLASSLOADER_CMD_ID;
    private static final int GOTO_CMD_ID;
    private static final int GOTO_DECLARED_CMD_ID;
    private static final int GOTO_FIELD_CMD_ID;
    private static final int REMOVE_ALL_WATCHES_CMD_ID;
    private static final int USE_FILTERS_CMD_ID;
    private static final int OBJECT_PREFERENCES_CMD_ID;
    private static final int COLLAPSE_ALL_CMD_ID;
    private static final int SAVE_CMD_ID;
    private static final int SETTINGS_CMD_ID;
    static final String WATCH_WINDOW_ID = "Debugger.WatchWindow";
    private static Icon watchTabIcon;
    private static final String expHistoryName = "DebuggerWatch";
    private static final String WATCH_KEY_COUNT = "Watch.Count";
    private static final String WATCH_KEY_PREFIX = "Watch.";
    private static final String WATCH_KEY_DOT = ".";
    private static final String WATCH_KEY_SCOPE = "scope";
    private static final String WATCH_KEY_EXPRESSION = "expression";
    private static final String WATCH_KEY_NAME = "name";
    private static final String WATCH_KEY_SHOWPINNEDDISCARDED = "showPinnedDiscarded";
    private static final String GlobalWatchScope = "GlobalWatchScope";

    static {
        ADD_NEW_WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchAddNewWatch");
        EDIT_WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchEditWatch");
        REMOVE_WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchRemoveWatch");
        PIN_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchPin");
        UNPIN_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchUnpin");
        VIEW_WHOLE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchViewWhole");
        ADJUST_RANGE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchAdjustRange");
        TOGGLE_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchToggleValue");
        MODIFY_VALUE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchModifyValue");
        WATCH_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchWatch");
        INSPECT_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchInspect");
        WATCH_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchWatchClassLoader");
        INSPECT_CLASSLOADER_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchInspectClassLoader");
        GOTO_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchGoto");
        GOTO_DECLARED_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchGotoDeclared");
        GOTO_FIELD_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchGotoField");
        REMOVE_ALL_WATCHES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchRemoveAllWatches");
        USE_FILTERS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchUseFilters");
        OBJECT_PREFERENCES_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchObjectPreferences");
        COLLAPSE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchCollapseAll");
        SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchSave");
        SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"DebugWatchSettings");
        watchTabIcon = null;
    }

    WatchWindow() {
        super(WATCH_WINDOW_ID, DbgArb.getString(640), "f1_deb_watchwindow_html");
        WatchWindow.makeActions();
        this.setDataPanel(new WatchPanel());
        this.setControllerForActions();
    }

    public Icon getTabIcon() {
        if (watchTabIcon == null) {
            watchTabIcon = DbgArb.getIcon(74);
        }
        return watchTabIcon;
    }

    EvaluatorItem addWatch(Object object) {
        return ((WatchPanel)this.dataPanel).addWatch(object);
    }

    boolean removeWatch(EvaluatorItem evaluatorItem) {
        return ((WatchPanel)this.dataPanel).removeWatch(evaluatorItem);
    }

    boolean addWatchDialog(String string) {
        return ((WatchPanel)this.dataPanel).addWatchDialog(string);
    }

    void shutDown() {
        this.saveSettings();
        WatchPanel.mav$saveWatches((WatchPanel)this.dataPanel, (PropertyAccess)Ide.getIdeProperties());
    }

    static void addContextMenuToMainMenu(Menubar menubar, JMenu jMenu) {
        WatchWindow.makeActions();
        float f = 1.0f;
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAddNewWatch), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionEditWatch), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionRemoveWatch), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionPin), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUnpin), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionViewWhole), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionAdjustRange), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionToggleValue), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionModifyValue), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatch), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspect), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionWatchClassLoader), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionInspectClassLoader), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGoto), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoDeclared), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionGotoField), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionRemoveAllWatches), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionUseFilters), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionObjectPreferences), jMenu, f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionCollapseAll), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSave), jMenu, f += 1.0f);
        menubar.add((Component)menubar.createMenuItem((ToggleAction)actionSettings), jMenu, f);
    }

    private static void makeActions() {
        if (actionEditWatch == null) {
            actionEditWatch = IdeAction.get((int)EDIT_WATCH_CMD_ID, null, (String)DbgArb.getString(641), null, (Integer)DbgArb.getInteger(642), null, (int)-1, null, (boolean)false);
            actionEditWatch.setEnabled(false);
            actionRemoveWatch = IdeAction.get((int)REMOVE_WATCH_CMD_ID, null, (String)DbgArb.getString(643), null, (Integer)DbgArb.getInteger(644), null, (int)-1, null, (boolean)false);
            actionRemoveWatch.setEnabled(false);
            actionPin = IdeAction.get((int)PIN_CMD_ID, null, (String)DbgArb.getString(682), null, (Integer)DbgArb.getInteger(683), null, (int)-1, null, (boolean)false);
            actionPin.setEnabled(false);
            actionUnpin = IdeAction.get((int)UNPIN_CMD_ID, null, (String)DbgArb.getString(684), null, (Integer)DbgArb.getInteger(685), null, (int)-1, null, (boolean)false);
            actionUnpin.setEnabled(false);
            actionViewWhole = IdeAction.get((int)VIEW_WHOLE_CMD_ID, null, (String)DbgArb.getString(317), null, (Integer)DbgArb.getInteger(318), null, (int)-1, null, (boolean)false);
            actionViewWhole.setEnabled(false);
            actionAdjustRange = IdeAction.get((int)ADJUST_RANGE_CMD_ID, null, (String)DbgArb.getString(319), null, (Integer)DbgArb.getInteger(320), null, (int)-1, null, (boolean)false);
            actionAdjustRange.setEnabled(false);
            actionToggleValue = IdeAction.get((int)TOGGLE_VALUE_CMD_ID, null, (String)DbgArb.getString(321), null, (Integer)DbgArb.getInteger(322), null, (int)-1, null, (boolean)false);
            actionToggleValue.setEnabled(false);
            actionModifyValue = IdeAction.get((int)MODIFY_VALUE_CMD_ID, null, (String)DbgArb.getString(323), null, (Integer)DbgArb.getInteger(324), null, (int)-1, null, (boolean)false);
            actionModifyValue.setEnabled(false);
            actionWatch = IdeAction.get((int)WATCH_CMD_ID, null, (String)DbgArb.getString(325), null, (Integer)DbgArb.getInteger(326), null, (int)-1, null, (boolean)false);
            actionWatch.setEnabled(false);
            actionInspect = IdeAction.get((int)INSPECT_CMD_ID, null, (String)DbgArb.getString(327), null, (Integer)DbgArb.getInteger(328), null, (int)-1, null, (boolean)false);
            actionInspect.setEnabled(false);
            actionWatchClassLoader = IdeAction.get((int)WATCH_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(341), null, (Integer)DbgArb.getInteger(342), null, (int)-1, null, (boolean)false);
            actionWatchClassLoader.setEnabled(false);
            actionInspectClassLoader = IdeAction.get((int)INSPECT_CLASSLOADER_CMD_ID, null, (String)DbgArb.getString(343), null, (Integer)DbgArb.getInteger(344), null, (int)-1, null, (boolean)false);
            actionInspectClassLoader.setEnabled(false);
            actionGoto = IdeAction.get((int)GOTO_CMD_ID, null, (String)DbgArb.getString(329), null, (Integer)DbgArb.getInteger(331), null, (int)-1, null, (boolean)false);
            actionGoto.setEnabled(false);
            actionGotoDeclared = IdeAction.get((int)GOTO_DECLARED_CMD_ID, null, (String)DbgArb.getString(332), null, (Integer)DbgArb.getInteger(334), null, (int)-1, null, (boolean)false);
            actionGotoDeclared.setEnabled(false);
            actionGotoField = IdeAction.get((int)GOTO_FIELD_CMD_ID, null, (String)DbgArb.getString(335), null, (Integer)DbgArb.getInteger(337), null, (int)-1, null, (boolean)false);
            actionGotoField.setEnabled(false);
            actionAddNewWatch = IdeAction.get((int)ADD_NEW_WATCH_CMD_ID, null, (String)DbgArb.getString(645), null, (Integer)DbgArb.getInteger(646), null, (int)-1, null, (boolean)false);
            actionAddNewWatch.setEnabled(false);
            actionRemoveAllWatches = IdeAction.get((int)REMOVE_ALL_WATCHES_CMD_ID, null, (String)DbgArb.getString(647), null, (Integer)DbgArb.getInteger(648), null, (int)-1, null, (boolean)false);
            actionRemoveAllWatches.setEnabled(false);
            actionUseFilters = IdeAction.get((int)USE_FILTERS_CMD_ID, null, (String)DbgArb.getString(345), null, (Integer)DbgArb.getInteger(346), null, (int)-1, null, (boolean)false);
            actionUseFilters.putValue("Check", (Object)Boolean.TRUE);
            actionUseFilters.setEnabled(false);
            actionObjectPreferences = IdeAction.get((int)OBJECT_PREFERENCES_CMD_ID, null, (String)DbgArb.format(347, ""), null, (Integer)DbgArb.getInteger(348), null, (int)-1, null, (boolean)false);
            actionObjectPreferences.setEnabled(false);
            actionSettings = IdeAction.get((int)SETTINGS_CMD_ID, null, (String)RunMgrArb.getString(101), null, (Integer)RunMgrArb.getInteger(102), null, (int)-1, null, (boolean)false);
            actionSettings.setEnabled(false);
            actionCollapseAll = IdeAction.get((int)COLLAPSE_ALL_CMD_ID, null, (String)RunMgrArb.getString(97), null, (Integer)RunMgrArb.getInteger(98), null, (int)-1, null, (boolean)false);
            actionCollapseAll.setEnabled(false);
            actionSave = IdeAction.get((int)SAVE_CMD_ID, null, (String)RunMgrArb.getString(99), null, (Integer)RunMgrArb.getInteger(100), null, (int)-1, null, (boolean)false);
            actionSave.setEnabled(false);
        }
    }

    private void setControllerForActions() {
        IdeAction[] ideActionArray = new IdeAction[]{actionEditWatch, actionRemoveWatch, actionPin, actionUnpin, actionViewWhole, actionAdjustRange, actionToggleValue, actionModifyValue, actionWatch, actionInspect, actionWatchClassLoader, actionInspectClassLoader, actionGoto, actionGotoDeclared, actionGotoField, actionAddNewWatch, actionRemoveAllWatches, actionUseFilters, actionObjectPreferences, actionSettings, actionCollapseAll, actionSave};
        JDebugger.setControllerForActions(ideActionArray, this.dataPanel);
    }

    static int ra$EDIT_WATCH_CMD_ID() {
        return EDIT_WATCH_CMD_ID;
    }

    static int ra$REMOVE_WATCH_CMD_ID() {
        return REMOVE_WATCH_CMD_ID;
    }

    static int ra$ADD_NEW_WATCH_CMD_ID() {
        return ADD_NEW_WATCH_CMD_ID;
    }

    static int ra$REMOVE_ALL_WATCHES_CMD_ID() {
        return REMOVE_ALL_WATCHES_CMD_ID;
    }

    static int ra$SETTINGS_CMD_ID() {
        return SETTINGS_CMD_ID;
    }

    static IdeAction ra$actionSettings() {
        return actionSettings;
    }

    static JMenuItem ra$menuitemSettings() {
        return menuitemSettings;
    }

    static void wa$menuitemSettings(JMenuItem jMenuItem) {
        menuitemSettings = jMenuItem;
    }

    static IdeAction ra$actionRemoveAllWatches() {
        return actionRemoveAllWatches;
    }

    static JMenuItem ra$menuitemRemoveAllWatches() {
        return menuitemRemoveAllWatches;
    }

    static void wa$menuitemRemoveAllWatches(JMenuItem jMenuItem) {
        menuitemRemoveAllWatches = jMenuItem;
    }

    static IdeAction ra$actionEditWatch() {
        return actionEditWatch;
    }

    static JMenuItem ra$menuitemEditWatch() {
        return menuitemEditWatch;
    }

    static void wa$menuitemEditWatch(JMenuItem jMenuItem) {
        menuitemEditWatch = jMenuItem;
    }

    static IdeAction ra$actionRemoveWatch() {
        return actionRemoveWatch;
    }

    static JMenuItem ra$menuitemRemoveWatch() {
        return menuitemRemoveWatch;
    }

    static void wa$menuitemRemoveWatch(JMenuItem jMenuItem) {
        menuitemRemoveWatch = jMenuItem;
    }

    static IdeAction ra$actionAddNewWatch() {
        return actionAddNewWatch;
    }

    static JMenuItem ra$menuitemAddNewWatch() {
        return menuitemAddNewWatch;
    }

    static void wa$menuitemAddNewWatch(JMenuItem jMenuItem) {
        menuitemAddNewWatch = jMenuItem;
    }

    static WatchWindowSettings ra$watchWindowSettings(WatchWindow watchWindow) {
        return watchWindow.watchWindowSettings;
    }

    static IdeAction ra$actionPin() {
        return actionPin;
    }

    static IdeAction ra$actionUnpin() {
        return actionUnpin;
    }

    static IdeAction ra$actionViewWhole() {
        return actionViewWhole;
    }

    static IdeAction ra$actionAdjustRange() {
        return actionAdjustRange;
    }

    static IdeAction ra$actionToggleValue() {
        return actionToggleValue;
    }

    static IdeAction ra$actionModifyValue() {
        return actionModifyValue;
    }

    static IdeAction ra$actionWatch() {
        return actionWatch;
    }

    static IdeAction ra$actionInspect() {
        return actionInspect;
    }

    static IdeAction ra$actionWatchClassLoader() {
        return actionWatchClassLoader;
    }

    static IdeAction ra$actionInspectClassLoader() {
        return actionInspectClassLoader;
    }

    static IdeAction ra$actionGoto() {
        return actionGoto;
    }

    static IdeAction ra$actionGotoDeclared() {
        return actionGotoDeclared;
    }

    static IdeAction ra$actionGotoField() {
        return actionGotoField;
    }

    static IdeAction ra$actionUseFilters() {
        return actionUseFilters;
    }

    static IdeAction ra$actionObjectPreferences() {
        return actionObjectPreferences;
    }

    static IdeAction ra$actionCollapseAll() {
        return actionCollapseAll;
    }

    static IdeAction ra$actionSave() {
        return actionSave;
    }

    static int ra$PIN_CMD_ID() {
        return PIN_CMD_ID;
    }

    static int ra$UNPIN_CMD_ID() {
        return UNPIN_CMD_ID;
    }

    static int ra$VIEW_WHOLE_CMD_ID() {
        return VIEW_WHOLE_CMD_ID;
    }

    static int ra$ADJUST_RANGE_CMD_ID() {
        return ADJUST_RANGE_CMD_ID;
    }

    static int ra$TOGGLE_VALUE_CMD_ID() {
        return TOGGLE_VALUE_CMD_ID;
    }

    static int ra$MODIFY_VALUE_CMD_ID() {
        return MODIFY_VALUE_CMD_ID;
    }

    static int ra$WATCH_CMD_ID() {
        return WATCH_CMD_ID;
    }

    static int ra$INSPECT_CMD_ID() {
        return INSPECT_CMD_ID;
    }

    static int ra$WATCH_CLASSLOADER_CMD_ID() {
        return WATCH_CLASSLOADER_CMD_ID;
    }

    static int ra$INSPECT_CLASSLOADER_CMD_ID() {
        return INSPECT_CLASSLOADER_CMD_ID;
    }

    static int ra$GOTO_CMD_ID() {
        return GOTO_CMD_ID;
    }

    static int ra$GOTO_DECLARED_CMD_ID() {
        return GOTO_DECLARED_CMD_ID;
    }

    static int ra$GOTO_FIELD_CMD_ID() {
        return GOTO_FIELD_CMD_ID;
    }

    static int ra$USE_FILTERS_CMD_ID() {
        return USE_FILTERS_CMD_ID;
    }

    static int ra$OBJECT_PREFERENCES_CMD_ID() {
        return OBJECT_PREFERENCES_CMD_ID;
    }

    static int ra$COLLAPSE_ALL_CMD_ID() {
        return COLLAPSE_ALL_CMD_ID;
    }

    static int ra$SAVE_CMD_ID() {
        return SAVE_CMD_ID;
    }

    final class WatchPanel
    extends EvaluatorPanel {
        private Map allWatches;

        WatchPanel() {
            super(WatchWindow.this, WatchWindow.ra$watchWindowSettings(WatchWindow.this).getDataPanelSettings());
            this.loadWatches((PropertyAccess)Ide.getIdeProperties());
            this._actionPin = WatchWindow.ra$actionPin();
            this._actionUnpin = WatchWindow.ra$actionUnpin();
            this._actionViewWhole = WatchWindow.ra$actionViewWhole();
            this._actionAdjustRange = WatchWindow.ra$actionAdjustRange();
            this._actionToggleValue = WatchWindow.ra$actionToggleValue();
            this._actionModifyValue = WatchWindow.ra$actionModifyValue();
            this._actionWatch = WatchWindow.ra$actionWatch();
            this._actionInspect = WatchWindow.ra$actionInspect();
            this._actionWatchClassLoader = WatchWindow.ra$actionWatchClassLoader();
            this._actionInspectClassLoader = WatchWindow.ra$actionInspectClassLoader();
            this._actionGoto = WatchWindow.ra$actionGoto();
            this._actionGotoDeclared = WatchWindow.ra$actionGotoDeclared();
            this._actionGotoField = WatchWindow.ra$actionGotoField();
            this._actionUseFilters = WatchWindow.ra$actionUseFilters();
            this._actionObjectPreferences = WatchWindow.ra$actionObjectPreferences();
            this._actionCollapseAll = WatchWindow.ra$actionCollapseAll();
            this._actionSave = WatchWindow.ra$actionSave();
            this._PIN_CMD_ID = WatchWindow.ra$PIN_CMD_ID();
            this._UNPIN_CMD_ID = WatchWindow.ra$UNPIN_CMD_ID();
            this._VIEW_WHOLE_CMD_ID = WatchWindow.ra$VIEW_WHOLE_CMD_ID();
            this._ADJUST_RANGE_CMD_ID = WatchWindow.ra$ADJUST_RANGE_CMD_ID();
            this._TOGGLE_VALUE_CMD_ID = WatchWindow.ra$TOGGLE_VALUE_CMD_ID();
            this._MODIFY_VALUE_CMD_ID = WatchWindow.ra$MODIFY_VALUE_CMD_ID();
            this._WATCH_CMD_ID = WatchWindow.ra$WATCH_CMD_ID();
            this._INSPECT_CMD_ID = WatchWindow.ra$INSPECT_CMD_ID();
            this._WATCH_CLASSLOADER_CMD_ID = WatchWindow.ra$WATCH_CLASSLOADER_CMD_ID();
            this._INSPECT_CLASSLOADER_CMD_ID = WatchWindow.ra$INSPECT_CLASSLOADER_CMD_ID();
            this._GOTO_CMD_ID = WatchWindow.ra$GOTO_CMD_ID();
            this._GOTO_DECLARED_CMD_ID = WatchWindow.ra$GOTO_DECLARED_CMD_ID();
            this._GOTO_FIELD_CMD_ID = WatchWindow.ra$GOTO_FIELD_CMD_ID();
            this._USE_FILTERS_CMD_ID = WatchWindow.ra$USE_FILTERS_CMD_ID();
            this._OBJECT_PREFERENCES_CMD_ID = WatchWindow.ra$OBJECT_PREFERENCES_CMD_ID();
            this._COLLAPSE_ALL_CMD_ID = WatchWindow.ra$COLLAPSE_ALL_CMD_ID();
            this._SAVE_CMD_ID = WatchWindow.ra$SAVE_CMD_ID();
        }

        protected void adjustGUI() {
            this.treeTable.addKeyListener((KeyListener)new 1());
        }

        void processFinished(DebuggingProcess debuggingProcess) {
            List list = this.getWatchesForProject(debuggingProcess);
            if (list != null) {
                int n = list.size();
                int n2 = n - 1;
                while (n2 >= 0) {
                    EvaluatorItem evaluatorItem = (EvaluatorItem)list.get(n2);
                    if (evaluatorItem.isPinned(debuggingProcess)) {
                        evaluatorItem.unpin(debuggingProcess);
                    }
                    if (evaluatorItem.getTemporary() == debuggingProcess) {
                        list.remove(n2);
                    }
                    --n2;
                }
            }
            super.processFinished(debuggingProcess);
        }

        protected void checkDrag(DropTargetDragEvent dropTargetDragEvent) {
            int n;
            if ((dropTargetDragEvent.isDataFlavorSupported(ClassesWindow.getClassFlavor()) || dropTargetDragEvent.isDataFlavorSupported(ClassesWindow.getInterfaceFlavor()) || dropTargetDragEvent.isDataFlavorSupported(DataPanel.getExpressionFlavor()) || dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) && ((n = dropTargetDragEvent.getSourceActions()) == 1 || n == 3)) {
                dropTargetDragEvent.acceptDrag(n);
                return;
            }
            super.checkDrag(dropTargetDragEvent);
        }

        protected void checkDrop(DropTargetDropEvent dropTargetDropEvent) {
            if (dropTargetDropEvent.isLocalTransfer()) {
                if (dropTargetDropEvent.isDataFlavorSupported(ClassesWindow.getClassFlavor())) {
                    try {
                        Transferable transferable = dropTargetDropEvent.getTransferable();
                        ClassesWindow.ClassFlavorData classFlavorData = (ClassesWindow.ClassFlavorData)transferable.getTransferData(ClassesWindow.getClassFlavor());
                        JDebugger.getInstance().addWatch(classFlavorData.getName());
                        dropTargetDropEvent.acceptDrop(1);
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception exception) {}
                } else if (dropTargetDropEvent.isDataFlavorSupported(ClassesWindow.getInterfaceFlavor())) {
                    try {
                        Transferable transferable = dropTargetDropEvent.getTransferable();
                        ClassesWindow.ClassFlavorData classFlavorData = (ClassesWindow.ClassFlavorData)transferable.getTransferData(ClassesWindow.getInterfaceFlavor());
                        JDebugger.getInstance().addWatch(classFlavorData.getName());
                        dropTargetDropEvent.acceptDrop(1);
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception exception) {}
                } else if (dropTargetDropEvent.isDataFlavorSupported(DataPanel.getExpressionFlavor())) {
                    try {
                        Transferable transferable = dropTargetDropEvent.getTransferable();
                        Expression expression = (Expression)transferable.getTransferData(DataPanel.getExpressionFlavor());
                        JDebugger.getInstance().addWatch(new EvaluatorItem(expression));
                        dropTargetDropEvent.acceptDrop(1);
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception exception) {}
                } else if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        Transferable transferable = dropTargetDropEvent.getTransferable();
                        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        JDebugger.getInstance().addWatch(string);
                        dropTargetDropEvent.acceptDrop(1);
                        dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            super.checkDrop(dropTargetDropEvent);
        }

        private void loadWatches(PropertyAccess propertyAccess) {
            this.allWatches = new HashMap();
            String string = propertyAccess.getProperty(WatchWindow.WATCH_KEY_COUNT, null);
            if (string != null) {
                try {
                    int n = Integer.parseInt(string);
                    int n2 = 0;
                    while (n2 < n) {
                        this.loadWatch(propertyAccess, n2);
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void loadWatch(PropertyAccess propertyAccess, int n) {
            String string = WatchWindow.WATCH_KEY_PREFIX + n + WatchWindow.WATCH_KEY_DOT;
            String string2 = propertyAccess.getProperty(string + WatchWindow.WATCH_KEY_SCOPE, WatchWindow.GlobalWatchScope);
            String string3 = propertyAccess.getProperty(string + WatchWindow.WATCH_KEY_EXPRESSION, null);
            if (string3 != null && string3.length() > 0) {
                ArrayList<EvaluatorItem> arrayList = (ArrayList<EvaluatorItem>)this.allWatches.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<EvaluatorItem>();
                    this.allWatches.put(string2, arrayList);
                }
                EvaluatorItem evaluatorItem = new EvaluatorItem(string3);
                String string4 = propertyAccess.getProperty(string + WatchWindow.WATCH_KEY_NAME, null);
                if (string4 != null) {
                    String string5 = propertyAccess.getProperty(string + WatchWindow.WATCH_KEY_SHOWPINNEDDISCARDED, null);
                    boolean bl = Boolean.valueOf(string5);
                    evaluatorItem.setOptions(string4, bl, null);
                }
                arrayList.add(evaluatorItem);
            }
        }

        private void saveWatches(PropertyAccess propertyAccess) {
            int n = 0;
            String string = propertyAccess.getProperty(WatchWindow.WATCH_KEY_COUNT, null);
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int n2 = 0;
            for (String string2 : this.allWatches.keySet()) {
                List list = (List)this.allWatches.get(string2);
                for (EvaluatorItem evaluatorItem : list) {
                    String string3 = evaluatorItem.getExpression();
                    if (string3 == null) continue;
                    this.saveWatch(propertyAccess, n2, string2, evaluatorItem);
                    ++n2;
                }
            }
            int n3 = n2;
            while (n3 < n) {
                this.removeSavedWatch(propertyAccess, n3);
                ++n3;
            }
            propertyAccess.setProperty(WatchWindow.WATCH_KEY_COUNT, Integer.toString(n2));
        }

        private void saveWatch(PropertyAccess propertyAccess, int n, String string, EvaluatorItem evaluatorItem) {
            String string2 = WatchWindow.WATCH_KEY_PREFIX + n + WatchWindow.WATCH_KEY_DOT;
            propertyAccess.setProperty(string2 + WatchWindow.WATCH_KEY_SCOPE, string);
            propertyAccess.setProperty(string2 + WatchWindow.WATCH_KEY_EXPRESSION, evaluatorItem.getExpression());
            String string3 = evaluatorItem.getName();
            if (string3 != null) {
                propertyAccess.setProperty(string2 + WatchWindow.WATCH_KEY_NAME, string3);
                if (evaluatorItem.isShowPinnedDiscarded()) {
                    propertyAccess.setProperty(string2 + WatchWindow.WATCH_KEY_SHOWPINNEDDISCARDED, Boolean.toString(true));
                } else {
                    propertyAccess.setProperty(string2 + WatchWindow.WATCH_KEY_SHOWPINNEDDISCARDED, null);
                }
            } else {
                propertyAccess.setProperty(string2 + WatchWindow.WATCH_KEY_SHOWPINNEDDISCARDED, null);
            }
        }

        private void removeSavedWatch(PropertyAccess propertyAccess, int n) {
            String string = WatchWindow.WATCH_KEY_PREFIX + n + WatchWindow.WATCH_KEY_DOT;
            propertyAccess.setProperty(string + WatchWindow.WATCH_KEY_SCOPE, null);
            propertyAccess.setProperty(string + WatchWindow.WATCH_KEY_EXPRESSION, null);
            propertyAccess.setProperty(string + WatchWindow.WATCH_KEY_NAME, null);
            propertyAccess.setProperty(string + WatchWindow.WATCH_KEY_SHOWPINNEDDISCARDED, null);
        }

        protected void addPopupMenuItemsForNew(ContextMenu contextMenu, Context context) {
            this.update(WatchWindow.ra$actionAddNewWatch(), context);
            if (WatchWindow.ra$actionAddNewWatch().isEnabled()) {
                if (WatchWindow.ra$menuitemAddNewWatch() == null) {
                    WatchWindow.wa$menuitemAddNewWatch(contextMenu.createMenuItem((ToggleAction)WatchWindow.ra$actionAddNewWatch()));
                }
                contextMenu.add((Component)WatchWindow.ra$menuitemAddNewWatch(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_NEW_ITEM_CTXT_MENU);
            }
            super.addPopupMenuItemsForNew(contextMenu, context);
        }

        protected void addPopupMenuItemsForDataItem(ContextMenu contextMenu, Context context) {
            this.update(WatchWindow.ra$actionEditWatch(), context);
            if (WatchWindow.ra$actionEditWatch().isEnabled()) {
                if (WatchWindow.ra$menuitemEditWatch() == null) {
                    WatchWindow.wa$menuitemEditWatch(contextMenu.createMenuItem((ToggleAction)WatchWindow.ra$actionEditWatch()));
                }
                contextMenu.add((Component)WatchWindow.ra$menuitemEditWatch(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            this.update(WatchWindow.ra$actionRemoveWatch(), context);
            if (WatchWindow.ra$actionRemoveWatch().isEnabled()) {
                if (WatchWindow.ra$menuitemRemoveWatch() == null) {
                    WatchWindow.wa$menuitemRemoveWatch(contextMenu.createMenuItem((ToggleAction)WatchWindow.ra$actionRemoveWatch()));
                }
                contextMenu.add((Component)WatchWindow.ra$menuitemRemoveWatch(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_ITEM_CTXT_MENU);
            }
            super.addPopupMenuItemsForDataItem(contextMenu, context);
        }

        protected void addPopupMenuItemsForData(ContextMenu contextMenu, Context context) {
            this.update(WatchWindow.ra$actionRemoveAllWatches(), context);
            if (WatchWindow.ra$actionRemoveAllWatches().isEnabled()) {
                if (WatchWindow.ra$menuitemRemoveAllWatches() == null) {
                    WatchWindow.wa$menuitemRemoveAllWatches(contextMenu.createMenuItem((ToggleAction)WatchWindow.ra$actionRemoveAllWatches()));
                }
                contextMenu.add((Component)WatchWindow.ra$menuitemRemoveAllWatches(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_SPECIFIC_CTXT_MENU);
            }
            super.addPopupMenuItemsForData(contextMenu, context);
        }

        protected void addPopupMenuItemsForCommon(ContextMenu contextMenu, Context context) {
            super.addPopupMenuItemsForCommon(contextMenu, context);
            this.update(WatchWindow.ra$actionSettings(), context);
            if (WatchWindow.ra$actionSettings().isEnabled()) {
                if (WatchWindow.ra$menuitemSettings() == null) {
                    WatchWindow.wa$menuitemSettings(contextMenu.createMenuItem((ToggleAction)WatchWindow.ra$actionSettings()));
                }
                contextMenu.add((Component)WatchWindow.ra$menuitemSettings(), JDeveloperMenuConstants.SECTION_DEBUGBER_VIEW_COMMON_CTXT_MENU);
            }
        }

        public boolean update(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (ideAction.getValue("Debugger.actionOwner") == this) {
                if (this.treeTable == null || !this.dockableWindow.isVisible()) {
                    ideAction.setEnabled(false);
                    return true;
                }
                if (!(this.treeTable.isEnabled() && this.debuggingProcess != null && this.vm != null || n == WatchWindow.ra$SETTINGS_CMD_ID())) {
                    ideAction.setEnabled(false);
                    return true;
                }
            }
            if (n == WatchWindow.ra$EDIT_WATCH_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem instanceof EvaluatorPanel.EvaluatorDataItem && treePath != null) {
                    EvaluatorPanel.EvaluatorDataItem evaluatorDataItem = (EvaluatorPanel.EvaluatorDataItem)dataItem;
                    ideAction.setEnabled(evaluatorDataItem.canEditExpression());
                } else {
                    ideAction.setEnabled(false);
                }
                return true;
            }
            if (n == WatchWindow.ra$REMOVE_WATCH_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                if (dataItem instanceof EvaluatorPanel.EvaluatorDataItem) {
                    ideAction.setEnabled(true);
                } else {
                    ideAction.setEnabled(false);
                }
                return true;
            }
            if (n == WatchWindow.ra$ADD_NEW_WATCH_CMD_ID()) {
                ideAction.setEnabled(true);
                return true;
            }
            if (n == WatchWindow.ra$REMOVE_ALL_WATCHES_CMD_ID()) {
                ideAction.setEnabled(this.canRemoveAllWatches());
                return true;
            }
            if (n == WatchWindow.ra$SETTINGS_CMD_ID()) {
                ideAction.setEnabled(true);
                return true;
            }
            return super.update(ideAction, context);
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == WatchWindow.ra$EDIT_WATCH_CMD_ID()) {
                EvaluatorPanel.EvaluatorDataItem evaluatorDataItem;
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                TreePath treePath = this.getSelectedTreePath();
                if (dataItem instanceof EvaluatorPanel.EvaluatorDataItem && treePath != null && (evaluatorDataItem = (EvaluatorPanel.EvaluatorDataItem)dataItem).canEditExpression()) {
                    this.editWatch(evaluatorDataItem, treePath);
                }
                return true;
            }
            if (n == WatchWindow.ra$REMOVE_WATCH_CMD_ID()) {
                DataPanel.DataItem dataItem = this.getSelectedDataItem();
                if (dataItem instanceof EvaluatorPanel.EvaluatorDataItem) {
                    this.removeWatch(((EvaluatorPanel.EvaluatorDataItem)dataItem).ei);
                }
                return true;
            }
            if (n == WatchWindow.ra$ADD_NEW_WATCH_CMD_ID()) {
                this.addWatchDialog(null);
                return true;
            }
            if (n == WatchWindow.ra$REMOVE_ALL_WATCHES_CMD_ID()) {
                this.removeAllWatches();
                return true;
            }
            if (n == WatchWindow.ra$SETTINGS_CMD_ID()) {
                String[] stringArray = new String[]{DbgArb.getString(716), DbgArb.getString(781)};
                Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
                return true;
            }
            return super.handleEvent(ideAction, context);
        }

        protected void addDataItems() {
            EvaluatorItem[] evaluatorItemArray = this.getWatchesForProcess(this.debuggingProcess);
            if (evaluatorItemArray != null) {
                List list = this.getRoot();
                int n = evaluatorItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    this.addDataItem(list, evaluatorItemArray[n2], false, false);
                    ++n2;
                }
            }
        }

        private List getWatchesForProject(DebuggingProcess debuggingProcess) {
            if (debuggingProcess != null) {
                Project project = debuggingProcess.getProject();
                String string = project != null && project != Ide.getDefaultProject() ? project.getURL().toString() : WatchWindow.GlobalWatchScope;
                ArrayList arrayList = (ArrayList)this.allWatches.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    this.allWatches.put(string, arrayList);
                }
                return arrayList;
            }
            return null;
        }

        private EvaluatorItem[] getWatchesForProcess(DebuggingProcess debuggingProcess) {
            List list = this.getWatchesForProject(debuggingProcess);
            if (list != null) {
                ArrayList<EvaluatorItem> arrayList = new ArrayList<EvaluatorItem>();
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    EvaluatorItem evaluatorItem = (EvaluatorItem)list.get(n2);
                    DebuggingProcess debuggingProcess2 = evaluatorItem.getTemporary();
                    if (debuggingProcess2 == debuggingProcess || debuggingProcess2 == null) {
                        arrayList.add(evaluatorItem);
                    }
                    ++n2;
                }
                return arrayList.toArray(new EvaluatorItem[arrayList.size()]);
            }
            return null;
        }

        private void editWatch(EvaluatorPanel.EvaluatorDataItem evaluatorDataItem, TreePath treePath) {
            evaluatorDataItem.editExpression(DbgArb.getString(649), DbgArb.getString(650), WatchWindow.expHistoryName, treePath);
        }

        boolean addWatchDialog(String string) {
            String string2;
            String string3 = DbgArb.getString(651);
            string = EditWatchDialog.showEditWatchDialog(string3, string2 = DbgArb.getString(652), WatchWindow.expHistoryName, string);
            if (string != null) {
                this.addWatch(string);
                return true;
            }
            return false;
        }

        EvaluatorItem addWatch(Object object) {
            List list = this.getWatchesForProject(this.debuggingProcess);
            if (list != null) {
                EvaluatorItem evaluatorItem = null;
                if (object instanceof EvaluatorItem) {
                    evaluatorItem = (EvaluatorItem)object;
                } else if (object instanceof String) {
                    evaluatorItem = new EvaluatorItem((String)object);
                }
                if (evaluatorItem != null) {
                    list.add(evaluatorItem);
                    this.addDataItem(null, evaluatorItem, false, false);
                    return evaluatorItem;
                }
            }
            return null;
        }

        boolean removeWatch(EvaluatorItem evaluatorItem) {
            List list = this.getWatchesForProject(this.debuggingProcess);
            if (list.remove(evaluatorItem)) {
                if (evaluatorItem.isPinned(this.debuggingProcess)) {
                    evaluatorItem.unpin(this.debuggingProcess);
                }
                List list2 = this.getRoot();
                int n = list2.size();
                int n2 = 0;
                while (n2 < n) {
                    Object e = list2.get(n2);
                    if (e instanceof EvaluatorPanel.EvaluatorDataItem && ((EvaluatorPanel.EvaluatorDataItem)e).ei == evaluatorItem) {
                        this.removeTopDataItem(n2);
                        if (n2 < --n) {
                            this.selectTopDataItem(n2);
                            break;
                        }
                        if (0 > --n2 || n2 >= n) break;
                        this.selectTopDataItem(n2);
                        break;
                    }
                    ++n2;
                }
                return true;
            }
            return false;
        }

        private boolean canRemoveAllWatches() {
            List list = this.getWatchesForProject(this.debuggingProcess);
            return list != null && list.size() > 0;
        }

        private void removeAllWatches() {
            List list = this.getWatchesForProject(this.debuggingProcess);
            if (list != null) {
                list.clear();
                this.everythingChanged();
            }
        }

        static void mav$saveWatches(WatchPanel watchPanel, PropertyAccess propertyAccess) {
            watchPanel.saveWatches(propertyAccess);
        }

        final class 1
        extends KeyAdapter {
            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                switch (n) {
                    case 127: {
                        Context context = WatchPanel.this.getContext(keyEvent);
                        WatchPanel.this.update(WatchWindow.ra$actionRemoveWatch(), context);
                        if (!WatchWindow.ra$actionRemoveWatch().isEnabled()) break;
                        WatchPanel.this.handleEvent(WatchWindow.ra$actionRemoveWatch(), context);
                        keyEvent.consume();
                    }
                }
            }
        }
    }
}

