/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.util.TriStateBoolean;
import oracle.jdevimpl.runner.profile.BaseSavable;

class BasicEvent
extends JMutableTreeNode
implements BaseSavable,
Transferable {
    public static final int DMS_ID = -99;
    static final DataFlavor eventFlavor = new DataFlavor("application/x-myobject; class=oracle.jdevimpl.runner.profile.BasicEvent", "Event");
    static final DataFlavor[] transferFlavors = new DataFlavor[]{eventFlavor, DataFlavor.stringFlavor};
    String _key;
    int _id;
    Color _color;
    private static char[] currentArr;
    private static int cpos;

    public BasicEvent(int n, String string, Color color, TriStateBoolean triStateBoolean) {
        super(new JTreeCellData(null, string, true, triStateBoolean));
        if (color != null) {
            JTreeCellData jTreeCellData = (JTreeCellData)this.getUserObject();
            jTreeCellData.setIcon((Icon)new ColorIcon());
            this._color = color;
        }
        this._id = n;
        this._key = string;
        this.updateText();
    }

    public BasicEvent(BasicEvent basicEvent) {
        this(basicEvent._id, basicEvent._key, basicEvent._color, basicEvent.getModel().getCheckBoxState());
        Enumeration enumeration = basicEvent.children();
        while (enumeration.hasMoreElements()) {
            this.add((MutableTreeNode)((Object)new BasicEvent((BasicEvent)enumeration.nextElement())));
        }
    }

    public BasicEvent(String string) {
        this(-1, string, null, TriStateBoolean.TRUE);
    }

    public BasicEvent(String string, TriStateBoolean triStateBoolean) {
        this(-1, string, null, triStateBoolean);
    }

    public void saveToFile(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this._id);
        dataOutputStream.writeUTF(this._key);
        dataOutputStream.writeInt(this._color.getRGB());
    }

    public static BasicEvent readFromFile(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        String string = dataInputStream.readUTF();
        Color color = new Color(dataInputStream.readInt());
        return new BasicEvent(n, string, color, TriStateBoolean.TRUE);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return transferFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(eventFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (dataFlavor.equals(eventFlavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public static BasicEvent parseFromArray() {
        BasicEvent basicEvent;
        block7: {
            char[] cArray;
            block6: {
                basicEvent = null;
                cArray = currentArr;
                while (cArray[cpos] == '\n' || cArray[cpos] == ' ' || cArray[cpos] == '\r' || cArray[cpos] == '\t') {
                    ++cpos;
                }
                if (cArray[cpos] != 'G') break block6;
                int n = cpos += 2;
                while (cArray[n] != ';') {
                    ++n;
                }
                String string = new String(cArray, cpos, n - cpos);
                cpos = ++n;
                basicEvent = new BasicEvent(string);
                ++cpos;
                while (cArray[cpos] != ')') {
                    basicEvent.add((MutableTreeNode)((Object)BasicEvent.parseFromArray()));
                }
                cpos += 3;
                break block7;
            }
            if (cArray[cpos] != 'E') break block7;
            int n = cpos += 2;
            while (cArray[n] != ';') {
                ++n;
            }
            int n2 = Integer.parseInt(new String(cArray, cpos, n - cpos));
            cpos = ++n;
            while (cArray[n] != ';') {
                ++n;
            }
            String string = new String(cArray, cpos, n - cpos);
            cpos = ++n;
            while (cArray[n] != ';') {
                ++n;
            }
            Color color = new Color(Integer.parseInt(new String(cArray, cpos, n - cpos)));
            cpos = ++n;
            basicEvent = new BasicEvent(n2, string, color, cArray[n] == '1' ? TriStateBoolean.TRUE : TriStateBoolean.FALSE);
            cpos += 3;
        }
        return basicEvent;
    }

    static synchronized BasicEvent parseFromString(String string) {
        cpos = 0;
        currentArr = string.toCharArray();
        BasicEvent basicEvent = BasicEvent.parseFromArray();
        return basicEvent;
    }

    private void updateText() {
        if (this._color != null) {
            this.getModel().setText(Integer.toString(this._id) + " : " + this._key);
        } else {
            this.getModel().setText(this._key);
        }
    }

    public int getId() {
        return this._id;
    }

    public void setId(int n) {
        this._id = n;
        this.updateText();
    }

    public String getName() {
        return this._key;
    }

    public void setName(String string) {
        this._key = string;
        this.updateText();
    }

    public Color getColor() {
        return this._color;
    }

    public boolean getSelected() {
        return this.getModel().getCheckBoxState() == TriStateBoolean.TRUE;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public void checkSelected() {
        TriStateBoolean triStateBoolean = TriStateBoolean.UNDEF;
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            BasicEvent basicEvent = (BasicEvent)enumeration.nextElement();
            basicEvent.checkSelected();
            if (triStateBoolean == TriStateBoolean.UNDEF) {
                triStateBoolean = basicEvent.getModel().getCheckBoxState();
                continue;
            }
            if (triStateBoolean == TriStateBoolean.TRI_STATE || triStateBoolean == basicEvent.getModel().getCheckBoxState()) continue;
            triStateBoolean = TriStateBoolean.TRI_STATE;
        }
        if (triStateBoolean != TriStateBoolean.UNDEF) {
            this.getModel().setCheckBoxState(triStateBoolean);
        }
    }

    public void initSelected() {
        Enumeration enumeration;
        if (this.getModel().getCheckBoxState() == TriStateBoolean.TRUE) {
            enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                BasicEvent basicEvent = (BasicEvent)enumeration.nextElement();
                basicEvent.getModel().setCheckBoxState(TriStateBoolean.TRUE);
            }
        }
        enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            BasicEvent basicEvent = (BasicEvent)enumeration.nextElement();
            basicEvent.initSelected();
        }
    }

    public String getStringValue() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._color == null) {
            stringBuffer.append("G(");
            stringBuffer.append(this._key);
            stringBuffer.append(";(");
            Enumeration enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                BasicEvent basicEvent = (BasicEvent)enumeration.nextElement();
                stringBuffer.append(basicEvent.getStringValue());
            }
            stringBuffer.append("));");
        } else {
            stringBuffer.append("E(");
            stringBuffer.append(this._id);
            stringBuffer.append(";");
            stringBuffer.append(this._key);
            stringBuffer.append(";");
            stringBuffer.append(this._color.getRGB());
            if (this.getModel().getCheckBoxState() == TriStateBoolean.TRUE) {
                stringBuffer.append(";1);");
            } else {
                stringBuffer.append(";0);");
            }
        }
        return stringBuffer.toString();
    }

    class ColorIcon
    implements Icon {
        private static final int SMALL_SIZE = 12;

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (BasicEvent.this._color != null) {
                Color color = graphics.getColor();
                graphics.setColor(Color.black);
                graphics.drawRect(n, n2, 11, 11);
                graphics.setColor(BasicEvent.this._color);
                graphics.fillRect(n + 1, n2 + 1, 10, 10);
                graphics.setColor(color);
            }
        }

        public int getIconWidth() {
            return 12;
        }

        public int getIconHeight() {
            return 12;
        }

        ColorIcon() {
        }
    }
}

