/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import oracle.ide.util.IntHashMap;
import oracle.jdevimpl.runner.profile.FileSaver;
import oracle.jdevimpl.runner.profile.MethodCallCountItem;
import oracle.jdevimpl.runner.profile.RootCallCountItem;
import oracle.jdevimpl.runner.profile.SubCallCount;
import oracle.jdevimpl.runner.profile.ThreadCallCountItem;
import oracle.jdevimpl.runner.profile.VMTypes;

class CallCountItem
extends VMTypes {
    private static SubCallCountComparator sccComp = new SubCallCountComparator();
    int ref;
    ArrayList calledList;
    ArrayList callerList;
    boolean callSorted;
    int calledTotal;
    int callerTotal;

    CallCountItem(int n) {
        this.ref = n;
        this.calledTotal = 0;
        this.callerTotal = 0;
        this.callSorted = false;
        this.callerList = new ArrayList(5);
    }

    CallCountItem() {
        this.callerList = new ArrayList(5);
    }

    public void saveToFile(DataOutputStream dataOutputStream) throws IOException {
        super.saveToFile(dataOutputStream);
        dataOutputStream.writeInt(this.ref);
        dataOutputStream.writeInt(this.calledTotal);
        dataOutputStream.writeInt(this.callerTotal);
        FileSaver.saveVMObjectToFile(this.calledList, dataOutputStream);
    }

    public void initFromFile(DataInputStream dataInputStream) throws IOException {
        super.initFromFile(dataInputStream);
        this.ref = dataInputStream.readInt();
        this.calledTotal = dataInputStream.readInt();
        this.callerTotal = dataInputStream.readInt();
        int n = dataInputStream.readInt();
        this.calledList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            this.calledList.add(SubCallCount.readFromFile(dataInputStream));
            ++n2;
        }
    }

    public static CallCountItem readFromFile(DataInputStream dataInputStream, IntHashMap intHashMap) throws IOException {
        byte by = dataInputStream.readByte();
        CallCountItem callCountItem = null;
        switch (by) {
            case 0: {
                MethodCallCountItem methodCallCountItem = new MethodCallCountItem();
                methodCallCountItem.initFromFile(dataInputStream, intHashMap);
                callCountItem = methodCallCountItem;
                break;
            }
            case 1: {
                ThreadCallCountItem threadCallCountItem = new ThreadCallCountItem();
                threadCallCountItem.initFromFile(dataInputStream);
                callCountItem = threadCallCountItem;
                break;
            }
            case 2: {
                RootCallCountItem rootCallCountItem = new RootCallCountItem();
                rootCallCountItem.initFromFile(dataInputStream);
                callCountItem = rootCallCountItem;
            }
        }
        return callCountItem;
    }

    private static ArrayList sortCallList(ArrayList arrayList) {
        Object[] objectArray = arrayList.toArray();
        Arrays.sort(objectArray, sccComp);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            arrayList2.add(objectArray[n]);
            ++n;
        }
        return arrayList2;
    }

    void sortCalls() {
        if (this.callSorted) {
            return;
        }
        this.callSorted = true;
        this.callerList = CallCountItem.sortCallList(this.callerList);
        this.calledList = CallCountItem.sortCallList(this.calledList);
    }

    ArrayList getCalledList() {
        return this.calledList;
    }

    ArrayList getCallerList() {
        return this.callerList;
    }

    void setCalledList(ArrayList arrayList) {
        this.calledList = arrayList;
    }

    void setCallerList(ArrayList arrayList) {
        this.callerList = arrayList;
    }

    String getPseudoClass() {
        return "";
    }

    String getPseudoName() {
        return "";
    }

    String getNiceSignature() {
        return "";
    }

    String getFileName() {
        return null;
    }

    int getLine() {
        return -1;
    }

    String getPackage() {
        return null;
    }

    int getCallCount() {
        return 0;
    }

    int getOnStackCount() {
        return 0;
    }

    int getRef() {
        return this.ref;
    }

    static class SubCallCountComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            SubCallCount subCallCount = (SubCallCount)object;
            SubCallCount subCallCount2 = (SubCallCount)object2;
            return subCallCount2.count - subCallCount.count;
        }

        SubCallCountComparator() {
        }
    }
}

