/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.ide.controls.CustomJSplitPane;
import oracle.ide.controls.SortedJTable;
import oracle.ide.controls.SortedTableModel;
import oracle.jdevimpl.runner.profile.EventProfModel;
import oracle.jdevimpl.runner.profile.ProfHistPanel;

public class EventProfPanel
extends JPanel {
    private JSplitPane _splitPane;
    private EventProfModel _histModel;
    private ProfHistPanel _php;
    private JTable _table;
    private int _nScrollGraph;
    private JScrollPane _spTable;

    void $init$() {
        this._nScrollGraph = 0;
    }

    public EventProfPanel(EventProfModel eventProfModel) {
        super(new BorderLayout());
        this.$init$();
        this.setBorder(BorderFactory.createEmptyBorder());
        this._histModel = eventProfModel;
        this._php = new ProfHistPanel(this._histModel);
        this._php.setBorder(BorderFactory.createEmptyBorder());
        this._table = new SortedJTable((SortedTableModel)this._histModel, 3, true);
        this._spTable = new JScrollPane(this._table);
        this._spTable.setBorder(BorderFactory.createEmptyBorder());
        this._spTable.setBorder(BorderFactory.createEmptyBorder());
        this._spTable.setHorizontalScrollBarPolicy(32);
        this._splitPane = new CustomJSplitPane(1, (Component)this._spTable, (Component)this._php);
        this._splitPane.setDividerLocation(0.5);
        this._php.setVerticalScrollBar(this._spTable.getVerticalScrollBar());
        this._php.setRowHeight(this._table.getRowHeight());
        this._php.addSelectionListener(new 3());
        this._table.getSelectionModel().addListSelectionListener(new 2());
        this._histModel.addTableModelListener(new 1());
        this.add((Component)this._splitPane, "Center");
        Dimension dimension = this._table.getTableHeader().getPreferredSize();
        Dimension dimension2 = this._php.getColumnHeader().getPreferredSize();
        dimension2.height = dimension.height - 1;
        this._php.getColumnHeader().setPreferredSize(dimension2);
    }

    public ProfHistPanel getHistoryPanel() {
        return this._php;
    }

    public JTable getTable() {
        return this._table;
    }

    public JScrollPane getScrollPane() {
        return this._spTable;
    }

    private void graphSelectionChange(PropertyChangeEvent propertyChangeEvent) {
        int[] nArray = (int[])propertyChangeEvent.getNewValue();
        ++this._nScrollGraph;
        this._table.clearSelection();
        int n = 0;
        while (n < nArray.length) {
            this._table.addRowSelectionInterval(nArray[n], nArray[n]);
            ++n;
        }
        --this._nScrollGraph;
    }

    private void tableSelectionChange(ListSelectionEvent listSelectionEvent) {
        int[] nArray = this._table.getSelectedRows();
        this._php.setSelected(nArray);
        this.scrollGraphToVisible();
    }

    public void scrollGraphToVisible() {
        if (this._nScrollGraph == 0) {
            this._php.scrollGraphToVisible();
        }
    }

    static void mav$graphSelectionChange(EventProfPanel eventProfPanel, PropertyChangeEvent propertyChangeEvent) {
        eventProfPanel.graphSelectionChange(propertyChangeEvent);
    }

    static void mav$tableSelectionChange(EventProfPanel eventProfPanel, ListSelectionEvent listSelectionEvent) {
        eventProfPanel.tableSelectionChange(listSelectionEvent);
    }

    static ProfHistPanel ra$_php(EventProfPanel eventProfPanel) {
        return eventProfPanel._php;
    }

    public final class 3
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EventProfPanel.mav$graphSelectionChange(EventProfPanel.this, propertyChangeEvent);
        }
    }

    public final class 2
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            EventProfPanel.mav$tableSelectionChange(EventProfPanel.this, listSelectionEvent);
        }
    }

    public final class 1
    implements TableModelListener {
        public void tableChanged(TableModelEvent tableModelEvent) {
            EventProfPanel.ra$_php(EventProfPanel.this).updateDatas();
            EventProfPanel.ra$_php(EventProfPanel.this).repaint();
        }
    }
}

