/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Context;
import oracle.ide.IdeConstants;
import oracle.ide.controller.Controller;
import oracle.ide.controls.CustomJSplitPane;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.IntHashMap;
import oracle.ide.util.Pair;
import oracle.ide.view.View;
import oracle.jdeveloper.profiler.EventTester;
import oracle.jdeveloper.runner.Source;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.profile.BaseSavable;
import oracle.jdevimpl.runner.profile.BasicEvent;
import oracle.jdevimpl.runner.profile.DefaultAllignRenderer;
import oracle.jdevimpl.runner.profile.EventProfModel;
import oracle.jdevimpl.runner.profile.EventProfPanel;
import oracle.jdevimpl.runner.profile.FileSavable;
import oracle.jdevimpl.runner.profile.FileSaver;
import oracle.jdevimpl.runner.profile.HTMLSavable;
import oracle.jdevimpl.runner.profile.HTMLSaver;
import oracle.jdevimpl.runner.profile.JProfiler;
import oracle.jdevimpl.runner.profile.LocationProvider;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfWindow;
import oracle.jdevimpl.runner.profile.ProfileEvent;
import oracle.jdevimpl.runner.profile.ProfilerSettings;
import oracle.jdevimpl.runner.profile.ProfilingProcess;
import oracle.jdevimpl.runner.profile.RightAllignRenderer;
import oracle.jdevimpl.runner.profile.UpdatableSettings;
import oracle.jdevimpl.runner.run.RunArb;

public final class EventTable
extends ProfWindow
implements FileSavable,
HTMLSavable,
UpdatableSettings,
ActionListener,
LocationProvider {
    public static final int MAX_COLUMNS = 6;
    public static final int COL_EVENT = 0;
    public static final int COL_MESS = 1;
    public static final int COL_LOC = 2;
    public static final int COL_START = 3;
    public static final int COL_END = 4;
    public static final int COL_DUR = 5;
    private static final String PROFILES_EVENT_TABLE_ID = "Profiler.EventTable";
    private ProfilingProcess process;
    private String title;
    private boolean[] columnShowing;
    private TableColumn[] column;
    private JPanel mainPanel;
    private boolean isAutoSelect;
    private ProfileEvent[] eventArray;
    private ProfileEvent[] currentItems;
    private EventsArrayModel dataModel;
    private EventProfPanel epp;
    private JButton buttonRestart;
    private JButton buttonSnapshot;
    private JButton buttonTerminate;
    private JButton buttonRun;
    private JButton buttonPause;
    private JButton buttonClear;
    private JLabel samplesLabel;
    private JLabel codePosLabel;
    private JTextArea commentArea;
    private JButton testButton;
    private EventTester curTester;
    private String curDetail;
    private JPanel detailPanel;
    private JPanel sumPanel;
    private JLabel startLabel;
    private JLabel startValue;
    private JLabel endLabel;
    private JLabel endValue;
    private JLabel durLabel;
    private JLabel durValue;
    private JLabel countLabel;
    private JLabel countValue;
    private JLabel cumtimeLabel;
    private JLabel cumtimeValue;
    private JLabel avgLabel;
    private JLabel avgValue;
    private JLabel medianLabel;
    private JLabel medianValue;
    private JLabel uniqueLabel;
    private JLabel uniqueValue;
    private JLabel minLabel;
    private JLabel minValue;
    private JLabel maxLabel;
    private JLabel maxValue;
    private JLabel devLabel;
    private JLabel devValue;
    private static final HelpInfo HELP_TOPIC = new HelpInfo(ProfArb.getString(5));

    void $init$() {
        this.columnShowing = new boolean[6];
        this.column = new TableColumn[6];
        this.isAutoSelect = false;
    }

    public EventTable(ProfilingProcess profilingProcess) {
        this.$init$();
        this.process = profilingProcess;
        this.eventArray = new ProfileEvent[0];
        this.initialize();
    }

    public void resetProcess(ProfilingProcess profilingProcess) {
        this.process = profilingProcess;
        this.buttonRestart.setEnabled(true);
        this.buttonSnapshot.setEnabled(true);
        this.buttonTerminate.setEnabled(true);
        this.buttonRun.setEnabled(false);
        this.buttonPause.setEnabled(true);
        this.buttonClear.setEnabled(false);
        this.setData(new ProfileEvent[0]);
    }

    public void saveToHTML(boolean bl) {
        HTMLSaver hTMLSaver = new HTMLSaver(this.eventArray);
        hTMLSaver.SaveToFile(this.getContext());
    }

    public void saveToFile() {
        FileSaver fileSaver = new FileSaver(this);
        fileSaver.save(this.getContext());
    }

    public void saveToFile(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(1);
        this.process.saveMapsToFile(dataOutputStream);
        IntHashMap intHashMap = new IntHashMap(10);
        int n = 0;
        while (n < this.eventArray.length) {
            BasicEvent basicEvent = this.eventArray[n].getEvent();
            intHashMap.put(basicEvent._id, (Object)basicEvent);
            ++n;
        }
        dataOutputStream.writeInt(intHashMap.size());
        for (BaseSavable baseSavable : intHashMap) {
            baseSavable.saveToFile(dataOutputStream);
        }
        dataOutputStream.writeInt(this.eventArray.length);
        int n2 = 0;
        while (n2 < this.eventArray.length) {
            this.eventArray[n2].saveToFile(dataOutputStream);
            ++n2;
        }
    }

    public void setData(ProfileEvent[] profileEventArray) {
        this.eventArray = profileEventArray;
        this.dataModel.setDatas(profileEventArray);
        if (profileEventArray.length > 0) {
            this.selectByRow(0);
        }
    }

    public void notifyProcessEnd() {
        SwingUtilities.invokeLater(new EventRunner(0));
    }

    public Component getGUI() {
        return this.mainPanel;
    }

    public Controller getController() {
        return null;
    }

    public Context getContext(EventObject eventObject) {
        Context context = this.process.getContext();
        context.setView((View)this);
        context.setEvent(eventObject);
        return context;
    }

    public void initialize() {
        this.title = ProfArb.getString(256) + this.process.getRunTitle();
        JToolBar jToolBar = this.createToolBar();
        JComponent jComponent = this.createTablePanel();
        JPanel jPanel = this.createBottomPanel();
        CustomJSplitPane customJSplitPane = new CustomJSplitPane(0, true, (Component)jComponent, (Component)jPanel);
        customJSplitPane.setBorder(BorderFactory.createEmptyBorder());
        customJSplitPane.setDividerLocation(0.8);
        customJSplitPane.setResizeWeight(1.0);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder());
        this.mainPanel.add((Component)jToolBar, "North");
        this.mainPanel.add((Component)customJSplitPane, "Center");
        this.updateSettings();
    }

    public String getTabName() {
        return this.process.getTabName();
    }

    public Icon getTabIcon() {
        return this.process.getIcon();
    }

    public String getTitleName() {
        return this.title;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.whenActionPerformed(object);
    }

    private void whenActionPerformed(Object object) {
        if (object == this.buttonRun) {
            this.process.performRunCommand();
            this.buttonRun.setEnabled(false);
            this.buttonClear.setEnabled(false);
            this.buttonPause.setEnabled(true);
            this.buttonSnapshot.setEnabled(true);
            this.buttonPause.requestFocus();
        } else if (object == this.buttonPause) {
            this.process.performPauseCommand();
            this.buttonRun.setEnabled(true);
            this.buttonRun.requestFocus();
            this.buttonClear.setEnabled(true);
            this.buttonSnapshot.setEnabled(false);
            this.buttonPause.setEnabled(false);
        } else if (object == this.buttonClear) {
            this.process.performClearSampleCommand();
        } else if (object == this.buttonSnapshot) {
            this.process.performSnapshotCommand();
        } else if (object == this.buttonRestart) {
            this.process.performRestartCommand();
        } else if (object == this.buttonTerminate) {
            this.process.performTerminateCommand();
        } else if (object == this.testButton) {
            this.doTestOnCurEvent();
        }
    }

    public void changeSettings() {
        this.process.showSettings();
    }

    public void updateSettings() {
        ProfilerSettings profilerSettings = ProfilerSettings.getInstance();
        JTable jTable = this.epp.getTable();
        boolean[] blArray = profilerSettings.getEventColumnVisible();
        boolean bl = false;
        int n = 0;
        while (n < 6) {
            if (this.columnShowing[n] != blArray[n]) {
                bl = true;
                this.columnShowing[n] = blArray[n];
                if (blArray[n]) {
                    jTable.addColumn(this.column[n]);
                } else {
                    jTable.removeColumn(this.column[n]);
                }
            }
            ++n;
        }
        if (bl) {
            this.dataModel.fireTableChanged(new TableModelEvent(this.dataModel, 0, this.eventArray.length - 1, -1));
        }
    }

    private JPanel createDetailPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        int n = 0;
        int n2 = 0;
        JLabel jLabel = new JLabel(ProfArb.getString(276));
        jPanel.add((Component)jLabel, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.codePosLabel = new JLabel("");
        jPanel.add((Component)this.codePosLabel, new GridBagConstraints(n++, n2, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        this.testButton = new JButton(ProfArb.getString(277));
        this.testButton.addActionListener(this);
        this.testButton.setVisible(false);
        jPanel.add((Component)this.testButton, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 5, 2, 5), 0, 0));
        Dimension dimension = jLabel.getPreferredSize();
        Dimension dimension2 = this.testButton.getPreferredSize();
        if (dimension.height < dimension2.height) {
            dimension.height = dimension2.height;
            jLabel.setPreferredSize(dimension);
        }
        n = 0;
        ++n2;
        this.commentArea = new JTextArea();
        this.commentArea.setBackground(this.codePosLabel.getBackground());
        this.commentArea.setLineWrap(true);
        this.commentArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.commentArea);
        jScrollPane.setBorder(new TitledBorder(ProfArb.getString(278)));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(n++, n2, 0, 1, 1.0, 1.0, 17, 1, new Insets(2, 5, 2, 5), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, ProfArb.getString(5));
        return jPanel;
    }

    private JPanel createSumPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        int n = 0;
        int n2 = 0;
        this.startLabel = new JLabel();
        this.startValue = new JLabel();
        this.endLabel = new JLabel();
        this.endValue = new JLabel();
        this.durLabel = new JLabel();
        this.durValue = new JLabel();
        this.countLabel = new JLabel();
        this.countValue = new JLabel();
        this.cumtimeLabel = new JLabel();
        this.cumtimeValue = new JLabel();
        this.avgLabel = new JLabel();
        this.avgValue = new JLabel();
        this.medianLabel = new JLabel();
        this.medianValue = new JLabel();
        this.uniqueLabel = new JLabel();
        this.uniqueValue = new JLabel();
        this.minLabel = new JLabel();
        this.minValue = new JLabel();
        this.maxLabel = new JLabel();
        this.maxValue = new JLabel();
        this.devLabel = new JLabel();
        this.devValue = new JLabel();
        this.startLabel.setText(ProfArb.getString(279));
        this.startValue.setText("999.9999");
        this.startValue.setMinimumSize(new Dimension(50, 16));
        this.endLabel.setText(ProfArb.getString(280));
        this.endValue.setText("999.9999");
        this.durLabel.setText(ProfArb.getString(281));
        this.durValue.setText("999.9999");
        this.countLabel.setText(ProfArb.getString(282));
        this.countValue.setText("999.9999");
        this.countValue.setMinimumSize(new Dimension(50, 16));
        this.cumtimeLabel.setText(ProfArb.getString(283));
        this.cumtimeValue.setText("999.9999");
        this.avgLabel.setText(ProfArb.getString(284));
        this.avgValue.setText("999.9999");
        this.medianLabel.setText(ProfArb.getString(285));
        this.medianValue.setText("999.9999");
        this.uniqueLabel.setText(ProfArb.getString(289));
        this.uniqueValue.setText("999.9999");
        this.minLabel.setText(ProfArb.getString(286));
        this.minValue.setText("999.9999");
        this.maxLabel.setText(ProfArb.getString(287));
        this.maxValue.setText("999.9999");
        this.devLabel.setText(ProfArb.getString(288));
        this.devValue.setText("999.9999");
        Font font = this.startLabel.getFont();
        Font font2 = font.deriveFont(1);
        this.startLabel.setFont(font2);
        this.endLabel.setFont(font2);
        this.durLabel.setFont(font2);
        this.countLabel.setFont(font2);
        this.avgLabel.setFont(font2);
        this.cumtimeLabel.setFont(font2);
        this.minLabel.setFont(font2);
        this.maxLabel.setFont(font2);
        this.medianLabel.setFont(font2);
        this.devLabel.setFont(font2);
        this.uniqueLabel.setFont(font2);
        jPanel.add((Component)this.startLabel, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)this.startValue, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        jPanel.add((Component)this.endLabel, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)this.endValue, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        jPanel.add((Component)this.durLabel, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)this.durValue, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        jPanel.add((Component)new JLabel(), new GridBagConstraints(n++, n2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        n = 0;
        jPanel.add((Component)this.countLabel, new GridBagConstraints(n++, ++n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)this.countValue, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        jPanel.add((Component)this.cumtimeLabel, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)this.cumtimeValue, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        jPanel.add((Component)this.avgLabel, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)this.avgValue, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        n = 0;
        jPanel.add((Component)this.minLabel, new GridBagConstraints(n++, ++n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)this.minValue, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        jPanel.add((Component)this.maxLabel, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)this.maxValue, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        jPanel.add((Component)this.medianLabel, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)this.medianValue, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        n = 0;
        jPanel.add((Component)this.devLabel, new GridBagConstraints(n++, ++n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)this.devValue, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        jPanel.add((Component)this.uniqueLabel, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        jPanel.add((Component)this.uniqueValue, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 4, 0, 20), 0, 0));
        n = 0;
        jPanel.add((Component)new JLabel(), new GridBagConstraints(n++, ++n2, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, ProfArb.getString(5));
        return jPanel;
    }

    private JPanel createBottomPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        this.detailPanel = this.createDetailPanel();
        this.sumPanel = this.createSumPanel();
        this.sumPanel.setVisible(false);
        jPanel.add((Component)this.detailPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.sumPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public HelpInfo getHelpInfo() {
        return HELP_TOPIC;
    }

    public void findSource() {
        if (this.currentItems[0].isCodePosition()) {
            Context context = this.getContext();
            Source.showSourceFile(context.getWorkspace(), context.getProject(), this.currentItems[0].getPackage(), null, this.currentItems[0].getFileName(), this.currentItems[0].getLine(), true);
        }
    }

    public boolean canFindSource() {
        return this.currentItems[0].isCodePosition();
    }

    private void setAllSizes(JComponent jComponent, Dimension dimension) {
        jComponent.setMinimumSize(dimension);
        Border border = jComponent.getBorder();
        jComponent.setBorder(border);
        jComponent.setMaximumSize(dimension);
        jComponent.setPreferredSize(dimension);
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        jToolBar.setBorder(IdeConstants.TOOLBAR_EMPTY_BORDER);
        this.buttonRestart = new JButton(RunArb.getIcon(3));
        this.buttonRestart.setToolTipText(ProfArb.getString(25));
        this.registerActionMnemonic(jToolBar, this.buttonRestart, ProfArb.getMnemonic(31));
        this.buttonRestart.addActionListener(this);
        jToolBar.add(this.buttonRestart);
        this.buttonRestart.setEnabled(true);
        this.buttonRun = new JButton(DbgArb.getIcon(15));
        this.buttonRun.setToolTipText(ProfArb.getString(28));
        this.registerActionMnemonic(jToolBar, this.buttonRun, ProfArb.getMnemonic(34));
        this.buttonRun.addActionListener(this);
        jToolBar.add(this.buttonRun);
        this.buttonRun.setEnabled(false);
        this.buttonPause = new JButton(DbgArb.getIcon(12));
        this.buttonPause.setToolTipText(ProfArb.getString(29));
        this.registerActionMnemonic(jToolBar, this.buttonPause, ProfArb.getMnemonic(35));
        this.buttonPause.addActionListener(this);
        jToolBar.add(this.buttonPause);
        this.buttonPause.setEnabled(true);
        this.buttonSnapshot = new JButton(IdeArb.getIcon((int)387));
        this.buttonSnapshot.setToolTipText(ProfArb.getString(26));
        this.registerActionMnemonic(jToolBar, this.buttonSnapshot, ProfArb.getMnemonic(32));
        this.buttonSnapshot.addActionListener(this);
        jToolBar.add(this.buttonSnapshot);
        this.buttonSnapshot.setEnabled(true);
        this.buttonClear = new JButton(VCSIconArb.getIcon((int)8));
        this.buttonClear.setToolTipText(ProfArb.getString(30));
        this.registerActionMnemonic(jToolBar, this.buttonClear, ProfArb.getMnemonic(36));
        this.buttonClear.addActionListener(this);
        jToolBar.add(this.buttonClear);
        this.buttonClear.setEnabled(false);
        this.buttonTerminate = new JButton(IdeArb.getIcon((int)150));
        this.buttonTerminate.setToolTipText(ProfArb.getString(27));
        this.registerActionMnemonic(jToolBar, this.buttonTerminate, ProfArb.getMnemonic(33));
        this.buttonTerminate.addActionListener(this);
        jToolBar.add(this.buttonTerminate);
        this.buttonTerminate.setEnabled(true);
        return jToolBar;
    }

    void registerActionMnemonic(JToolBar jToolBar, JButton jButton, char c) {
        InputMap inputMap = jToolBar.getInputMap(1);
        ActionMap actionMap = jToolBar.getActionMap();
        MyAction myAction = new MyAction(jButton);
        KeyStroke keyStroke = KeyStroke.getKeyStroke((int)c, 2);
        inputMap.put(keyStroke, myAction);
        actionMap.put(myAction, myAction);
    }

    private void setSumPanelContent() {
        if (this.currentItems != null) {
            int n;
            int n2 = n = this.currentItems.length;
            int n3 = Integer.MAX_VALUE;
            int n4 = 0;
            int n5 = Integer.MAX_VALUE;
            int n6 = 0;
            int n7 = 0;
            boolean bl = false;
            int[] nArray = new int[n];
            Object[] objectArray = new Pair[n * 2];
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n10 < n) {
                ProfileEvent profileEvent = this.currentItems[n10];
                int n11 = profileEvent.getStart();
                int n12 = profileEvent.getEnd();
                if (n3 > n11) {
                    n3 = n11;
                }
                if (n12 != -1) {
                    int n13 = n12 - n11;
                    nArray[n8++] = n13;
                    objectArray[n9++] = new Pair((Object)new Integer(n11), (Object)Boolean.TRUE);
                    objectArray[n9++] = new Pair((Object)new Integer(n12), (Object)Boolean.FALSE);
                    if (n4 < n12) {
                        n4 = n12;
                    }
                    if (n6 < n13) {
                        n6 = n13;
                    }
                    if (n5 > n13) {
                        n5 = n13;
                    }
                    n7 += n13;
                } else {
                    --n2;
                    bl = true;
                }
                ++n10;
            }
            int n14 = n7 / n2;
            if (n8 > 0) {
                long l = 0L;
                int n15 = 0;
                while (n15 < n8) {
                    long l2 = nArray[n15] - n14;
                    l += l2 * l2;
                    ++n15;
                }
                int n16 = (int)Math.round(Math.sqrt(l / (long)n8));
                this.devValue.setText(ProfileEvent.timeFormater(n16));
            } else {
                this.devValue.setText(ProfArb.getString(317));
            }
            if (n8 > 0) {
                Arrays.sort(nArray, 0, n8);
                int n17 = n8 % 1 == 0 ? (nArray[n8 /= 2] + nArray[n8 - 1]) / 2 : nArray[n8 / 2];
                this.medianValue.setText(ProfileEvent.timeFormater(n17));
            } else {
                this.medianValue.setText(ProfArb.getString(317));
            }
            if (n9 > 0) {
                Arrays.sort(objectArray, 0, n9);
                int n18 = 0;
                int n19 = 0;
                int n20 = 0;
                int n21 = 0;
                while (n21 < n9) {
                    int n22 = (Integer)objectArray[n21].getFirst();
                    boolean bl2 = (Boolean)objectArray[n21].getSecond();
                    if (bl2) {
                        if (n18 == 0) {
                            n20 = n22;
                        }
                        ++n18;
                    } else if (--n18 == 0) {
                        n19 += n22 - n20;
                    }
                    ++n21;
                }
                this.uniqueValue.setText(ProfileEvent.timeFormater(n19));
            } else {
                this.uniqueValue.setText(ProfArb.getString(317));
            }
            this.countValue.setText(Integer.toString(n));
            this.startValue.setText(ProfileEvent.timeFormater(n3));
            if (bl) {
                this.endValue.setText(ProfArb.getString(309));
                this.durValue.setText(ProfArb.getString(309));
            } else {
                this.endValue.setText(ProfileEvent.timeFormater(n4));
                this.durValue.setText(ProfileEvent.timeFormater(n4 - n3));
            }
            this.cumtimeValue.setText(ProfileEvent.timeFormater(n7));
            if (n2 != 0) {
                this.minValue.setText(ProfileEvent.timeFormater(n5));
                this.maxValue.setText(ProfileEvent.timeFormater(n6));
                this.avgValue.setText(ProfileEvent.timeFormater(n7 / n2));
            } else {
                this.minValue.setText(ProfArb.getString(317));
                this.maxValue.setText(ProfArb.getString(317));
                this.avgValue.setText(ProfArb.getString(317));
            }
        }
    }

    private void setDetailPanelContent() {
        if (this.currentItems != null && this.currentItems.length > 0) {
            ProfileEvent profileEvent = this.currentItems[0];
            this.codePosLabel.setText(profileEvent.getPosS());
            this.commentArea.setText(profileEvent.getCommentS());
            String string = profileEvent.getHelperClassS();
            boolean bl = false;
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    this.curTester = (EventTester)clazz.newInstance();
                    this.curDetail = profileEvent.getDetailS();
                    bl = true;
                }
                catch (Exception exception) {
                    System.err.println("Got " + exception + " while getting EventTester");
                }
                if (!bl) {
                    System.err.println("Missing or bad class in ActionTag");
                }
            }
            if (!bl) {
                this.testButton.setVisible(false);
                this.curTester = null;
                this.curDetail = null;
            } else {
                this.testButton.setText(this.curTester.getButtonName());
                this.testButton.setVisible(true);
            }
        }
    }

    private void doTestOnCurEvent() {
        if (this.curTester != null) {
            ProfileEvent profileEvent = this.currentItems[0];
            this.curTester.doTest(this.getContext(), profileEvent.getId(), profileEvent.getFileName(), profileEvent.getLine(), profileEvent.getStartF(), profileEvent.getEndF(), this.commentArea.getText(), this.curDetail);
        }
    }

    private JComponent createTablePanel() {
        this.dataModel = new EventsArrayModel();
        this.epp = new EventProfPanel(this.dataModel);
        JTable jTable = this.epp.getTable();
        jTable.addMouseListener(new 2());
        RightAllignRenderer rightAllignRenderer = new RightAllignRenderer(this.process);
        DefaultAllignRenderer defaultAllignRenderer = new DefaultAllignRenderer(this.process);
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = 0;
        while (n < 6) {
            this.column[n] = tableColumnModel.getColumn(n);
            this.columnShowing[n] = true;
            ++n;
        }
        this.column[0].setCellRenderer(defaultAllignRenderer);
        this.column[0].setPreferredWidth(200);
        this.column[1].setCellRenderer(defaultAllignRenderer);
        this.column[1].setPreferredWidth(300);
        this.column[2].setCellRenderer(defaultAllignRenderer);
        this.column[2].setPreferredWidth(300);
        this.column[3].setCellRenderer(rightAllignRenderer);
        this.column[3].setPreferredWidth(100);
        this.column[4].setCellRenderer(rightAllignRenderer);
        this.column[4].setPreferredWidth(100);
        this.column[5].setCellRenderer(rightAllignRenderer);
        this.column[5].setPreferredWidth(100);
        Dimension dimension = new Dimension(0, 0);
        jTable.setIntercellSpacing(dimension);
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.setSelectionMode(2);
        listSelectionModel.addListSelectionListener(new 1());
        return this.epp;
    }

    private void selectByRow(int n) {
        ListSelectionModel listSelectionModel = this.epp.getTable().getSelectionModel();
        listSelectionModel.clearSelection();
        listSelectionModel.addSelectionInterval(n, n);
        JViewport jViewport = this.epp.getScrollPane().getViewport();
        Rectangle rectangle = this.epp.getTable().getCellRect(n, 0, true);
        Rectangle rectangle2 = jViewport.getViewRect();
        rectangle.y -= rectangle2.y;
        jViewport.scrollRectToVisible(rectangle);
    }

    private void selectByObjects(ProfileEvent[] profileEventArray) {
        ListSelectionModel listSelectionModel = this.epp.getTable().getSelectionModel();
        listSelectionModel.clearSelection();
        HashSet<ProfileEvent> hashSet = new HashSet<ProfileEvent>();
        int n = 0;
        while (n < profileEventArray.length) {
            hashSet.add(profileEventArray[n]);
            ++n;
        }
        int n2 = this.eventArray.length;
        int n3 = 0;
        int n4 = 0;
        n = 0;
        while (n < this.eventArray.length) {
            if (hashSet.contains(this.eventArray[n])) {
                if (n2 > n) {
                    n2 = n;
                }
                profileEventArray[n4++] = this.eventArray[n];
                listSelectionModel.addSelectionInterval(n, n);
                n3 = n;
            }
            ++n;
        }
        JViewport jViewport = this.epp.getScrollPane().getViewport();
        Rectangle rectangle = this.epp.getTable().getCellRect(n3, 0, true);
        Rectangle rectangle2 = jViewport.getViewRect();
        rectangle.y -= rectangle2.y;
        jViewport.scrollRectToVisible(rectangle);
        rectangle = this.epp.getTable().getCellRect(n2, 0, true);
        rectangle2 = jViewport.getViewRect();
        rectangle.y -= rectangle2.y;
        jViewport.scrollRectToVisible(rectangle);
    }

    public void stateChange(int n) {
        switch (n) {
            case 3: {
                this.process.terminateProcess();
                this.eventArray = null;
                this.currentItems = null;
            }
        }
        super.stateChange(n);
    }

    static void wa$isAutoSelect(EventTable eventTable, boolean bl) {
        eventTable.isAutoSelect = bl;
    }

    static ProfileEvent[] ra$currentItems(EventTable eventTable) {
        return eventTable.currentItems;
    }

    static void mav$selectByObjects(EventTable eventTable, ProfileEvent[] profileEventArray) {
        eventTable.selectByObjects(profileEventArray);
    }

    static ProfilingProcess ra$process(EventTable eventTable) {
        return eventTable.process;
    }

    static JButton ra$buttonRestart(EventTable eventTable) {
        return eventTable.buttonRestart;
    }

    static JButton ra$buttonSnapshot(EventTable eventTable) {
        return eventTable.buttonSnapshot;
    }

    static JButton ra$buttonTerminate(EventTable eventTable) {
        return eventTable.buttonTerminate;
    }

    static JButton ra$buttonRun(EventTable eventTable) {
        return eventTable.buttonRun;
    }

    static JButton ra$buttonPause(EventTable eventTable) {
        return eventTable.buttonPause;
    }

    static JButton ra$buttonClear(EventTable eventTable) {
        return eventTable.buttonClear;
    }

    static void mav$whenActionPerformed(EventTable eventTable, Object object) {
        eventTable.whenActionPerformed(object);
    }

    static boolean ra$isAutoSelect(EventTable eventTable) {
        return eventTable.isAutoSelect;
    }

    static EventProfPanel ra$epp(EventTable eventTable) {
        return eventTable.epp;
    }

    static void wa$currentItems(EventTable eventTable, ProfileEvent[] profileEventArray) {
        eventTable.currentItems = profileEventArray;
    }

    static ProfileEvent[] ra$eventArray(EventTable eventTable) {
        return eventTable.eventArray;
    }

    static JPanel ra$detailPanel(EventTable eventTable) {
        return eventTable.detailPanel;
    }

    static JPanel ra$sumPanel(EventTable eventTable) {
        return eventTable.sumPanel;
    }

    static void mav$setDetailPanelContent(EventTable eventTable) {
        eventTable.setDetailPanelContent();
    }

    static void mav$setSumPanelContent(EventTable eventTable) {
        eventTable.setSumPanelContent();
    }

    public class EventsArrayModel
    extends AbstractTableModel
    implements EventProfModel {
        int _compareField;
        boolean _ascending;
        private ProfileEvent[] _eventArray;
        private EventComparator _scomp;

        void $init$() {
            this._compareField = 0;
            this._scomp = new EventComparator();
        }

        public EventsArrayModel() {
            this.$init$();
        }

        public void setDatas(ProfileEvent[] profileEventArray) {
            this._eventArray = profileEventArray;
            Arrays.sort(this._eventArray, this._scomp);
            this.fireTableDataChanged();
        }

        public String getToolTipText(int n) {
            if (EventTable.ra$process(EventTable.this).isPopupActive()) {
                return null;
            }
            switch (n) {
                case 0: {
                    return ProfArb.getString(263);
                }
                case 1: {
                    return ProfArb.getString(266);
                }
                case 2: {
                    return ProfArb.getString(264);
                }
                case 3: {
                    return ProfArb.getString(265);
                }
                case 4: {
                    return ProfArb.getString(267);
                }
                case 5: {
                    return ProfArb.getString(268);
                }
            }
            return "Error";
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return ProfArb.getString(257);
                }
                case 1: {
                    return ProfArb.getString(260);
                }
                case 2: {
                    return ProfArb.getString(258);
                }
                case 3: {
                    return ProfArb.getString(259);
                }
                case 4: {
                    return ProfArb.getString(261);
                }
                case 5: {
                    return ProfArb.getString(262);
                }
            }
            return "Error";
        }

        public int getRowCount() {
            if (this._eventArray != null) {
                return this._eventArray.length;
            }
            return 0;
        }

        public Object getValueAt(int n, int n2) {
            if (this._eventArray == null || n >= this._eventArray.length) {
                return "";
            }
            switch (n2) {
                case 0: {
                    return this._eventArray[n].getIdS();
                }
                case 1: {
                    return this._eventArray[n].getShortCommentS();
                }
                case 2: {
                    return this._eventArray[n].getPosS();
                }
                case 3: {
                    return this._eventArray[n].getStartS();
                }
                case 4: {
                    return this._eventArray[n].getEndS();
                }
                case 5: {
                    return this._eventArray[n].getDurationS();
                }
            }
            return "";
        }

        public int getEventStart(int n) {
            if (this._eventArray == null || n >= this._eventArray.length) {
                return 0;
            }
            return this._eventArray[n].getStart();
        }

        public int getEventElapsed(int n) {
            if (this._eventArray == null || n >= this._eventArray.length) {
                return 0;
            }
            return this._eventArray[n].getDuration();
        }

        public Color getEventColor(int n) {
            if (this._eventArray == null || n >= this._eventArray.length) {
                return Color.black;
            }
            return this._eventArray[n].getColor();
        }

        public String getEventLabel(int n) {
            return "";
        }

        public boolean sortByColumn(int n, boolean bl) {
            this._compareField = n;
            this._ascending = bl;
            EventTable.wa$isAutoSelect(EventTable.this, true);
            if (this._eventArray != null) {
                Arrays.sort(this._eventArray, this._scomp);
            }
            this.fireTableDataChanged();
            if (EventTable.ra$currentItems(EventTable.this) != null) {
                EventTable.mav$selectByObjects(EventTable.this, EventTable.ra$currentItems(EventTable.this));
            }
            EventTable.wa$isAutoSelect(EventTable.this, false);
            return false;
        }

        public boolean isColVisible(int n) {
            return true;
        }

        public class EventComparator
        implements Comparator {
            public int compare(Object object, Object object2) {
                int n;
                ProfileEvent profileEvent = (ProfileEvent)object;
                ProfileEvent profileEvent2 = (ProfileEvent)object2;
                switch (EventsArrayModel.this._compareField) {
                    default: {
                        n = profileEvent.getIdS().compareTo(profileEvent2.getIdS());
                        break;
                    }
                    case 1: {
                        n = profileEvent.getShortCommentS().compareTo(profileEvent2.getShortCommentS());
                        break;
                    }
                    case 2: {
                        n = profileEvent.getPosS().compareTo(profileEvent2.getPosS());
                        break;
                    }
                    case 3: {
                        n = profileEvent.getStart() - profileEvent2.getStart();
                        break;
                    }
                    case 4: {
                        n = profileEvent.getEnd() - profileEvent2.getEnd();
                        break;
                    }
                    case 5: {
                        n = profileEvent.getDuration() - profileEvent2.getDuration();
                    }
                }
                if (!EventsArrayModel.this._ascending) {
                    n = 0 - n;
                }
                return n;
            }

            EventComparator() {
            }
        }
    }

    public class EventRunner
    implements Runnable {
        static final int PROC_END_ACTION = 0;
        int _type;

        EventRunner(int n) {
            this._type = n;
        }

        public void run() {
            switch (this._type) {
                case 0: {
                    EventTable.ra$buttonRestart(EventTable.this).setEnabled(true);
                    EventTable.ra$buttonSnapshot(EventTable.this).setEnabled(false);
                    EventTable.ra$buttonTerminate(EventTable.this).setEnabled(false);
                    EventTable.ra$buttonRun(EventTable.this).setEnabled(false);
                    EventTable.ra$buttonPause(EventTable.this).setEnabled(false);
                    EventTable.ra$buttonClear(EventTable.this).setEnabled(false);
                }
            }
        }
    }

    public class MyAction
    extends AbstractAction {
        JButton _src;

        MyAction(JButton jButton) {
            this._src = jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EventTable.mav$whenActionPerformed(EventTable.this, this._src);
        }
    }

    public final class 2
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                Context context = EventTable.this.getContext(mouseEvent);
                JProfiler.contextMenu.show(context);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                EventTable.this.findSource();
            }
        }
    }

    public final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting() || EventTable.ra$isAutoSelect(EventTable.this)) {
                return;
            }
            int[] nArray = EventTable.ra$epp(EventTable.this).getTable().getSelectedRows();
            EventTable.wa$currentItems(EventTable.this, new ProfileEvent[nArray.length]);
            int n = 0;
            while (n < nArray.length) {
                EventTable.ra$currentItems((EventTable)EventTable.this)[n] = EventTable.ra$eventArray(EventTable.this)[nArray[n]];
                ++n;
            }
            if (EventTable.ra$currentItems(EventTable.this).length <= 1) {
                EventTable.ra$detailPanel(EventTable.this).setVisible(true);
                EventTable.ra$sumPanel(EventTable.this).setVisible(false);
                EventTable.mav$setDetailPanelContent(EventTable.this);
            } else {
                EventTable.ra$detailPanel(EventTable.this).setVisible(false);
                EventTable.ra$sumPanel(EventTable.this).setVisible(true);
                EventTable.mav$setSumPanelContent(EventTable.this);
            }
        }
    }
}

