/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.controls.tree.CustomJTree;
import oracle.jdevimpl.runner.profile.BasicEvent;

public class EventsTreePanel
extends CustomJTree
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private BasicEvent top = BasicEvent.parseFromString("G(All events;());");
    private DragSource dragSource;

    public EventsTreePanel() {
        this.top.checkSelected();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel((TreeNode)((Object)this.top));
        this.setModel(defaultTreeModel);
        this.setSelectionRow(0);
        this.setShowsRootHandles(true);
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer((Component)((Object)this), 2, this);
        DropTarget dropTarget = new DropTarget((Component)((Object)this), 2, this);
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (dragGestureEvent.getDragAction() == 2) {
            Point point = dragGestureEvent.getDragOrigin();
            BasicEvent basicEvent = (BasicEvent)this.getClosestPathForLocation(point.x, point.y).getLastPathComponent();
            if (basicEvent != null && basicEvent != this.top) {
                try {
                    dragGestureEvent.startDrag(null, basicEvent, this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.checkDrag(dropTargetDragEvent);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.checkDrag(dropTargetDragEvent);
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (dropTargetDropEvent.isLocalTransfer() && dropTargetDropEvent.isDataFlavorSupported(BasicEvent.eventFlavor) && (dropTargetDropEvent.getSourceActions() & 2) != 0) {
            try {
                Point point = dropTargetDropEvent.getLocation();
                BasicEvent basicEvent = (BasicEvent)this.getClosestPathForLocation(point.x, point.y).getLastPathComponent();
                Transferable transferable = dropTargetDropEvent.getTransferable();
                BasicEvent basicEvent2 = (BasicEvent)transferable.getTransferData(BasicEvent.eventFlavor);
                if (basicEvent2 != basicEvent && !basicEvent2.isNodeDescendant((DefaultMutableTreeNode)((Object)basicEvent))) {
                    Object object;
                    dropTargetDropEvent.acceptDrop(2);
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)basicEvent2.getParent();
                    basicEvent2.removeFromParent();
                    if (basicEvent.getColor() == null) {
                        object = basicEvent;
                        basicEvent.insert((MutableTreeNode)((Object)basicEvent2), 0);
                    } else {
                        object = (DefaultMutableTreeNode)basicEvent.getParent();
                        ((DefaultMutableTreeNode)object).insert((MutableTreeNode)((Object)basicEvent2), ((DefaultMutableTreeNode)object).getIndex((TreeNode)((Object)basicEvent)) + 1);
                    }
                    this.checkSelected();
                    ((DefaultTreeModel)this.getModel()).nodeStructureChanged(defaultMutableTreeNode);
                    ((DefaultTreeModel)this.getModel()).nodeStructureChanged((TreeNode)object);
                    TreePath treePath = new TreePath(basicEvent2.getPath());
                    this.scrollPathToVisible(treePath);
                    this.setSelectionPath(treePath);
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        dropTargetDropEvent.rejectDrop();
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private void checkDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(BasicEvent.eventFlavor) && (dropTargetDragEvent.getSourceActions() & 2) != 0) {
            dropTargetDragEvent.acceptDrag(2);
            return;
        }
        dropTargetDragEvent.rejectDrag();
    }

    void checkSelected() {
        this.top.checkSelected();
    }

    void setValue(String string) {
        BasicEvent basicEvent;
        this.top = basicEvent = BasicEvent.parseFromString(string);
        this.checkSelected();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel((TreeNode)((Object)this.top));
        this.setModel(defaultTreeModel);
        this.setSelectionRow(0);
        this.repaint();
    }

    public String getValue() {
        String string = this.top.getStringValue();
        return string;
    }
}

