/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdevimpl.runner.profile.BaseSavable;
import oracle.jdevimpl.runner.profile.FileSavable;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.VMTypes;

public class FileSaver {
    private static URL lastSavedFile = null;
    private FileSavable _saved;

    public FileSaver(FileSavable fileSavable) {
        this._saved = fileSavable;
    }

    private static URL chooseFileName(Context context, boolean bl) {
        try {
            URL uRL;
            DefaultURLFilter defaultURLFilter = new DefaultURLFilter(ProfArb.getString(314), ".opr");
            URLChooser uRLChooser = DialogUtil.newURLChooser((Context)context);
            uRLChooser.setURLFilter((URLFilter)defaultURLFilter);
            if (lastSavedFile != null) {
                uRLChooser.setSelectedURL(lastSavedFile);
            }
            if (bl) {
                if (uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), ProfArb.getString(315)) != 0) {
                    URL uRL2 = null;
                    return uRL2;
                }
            } else if (uRLChooser.showOpenDialog((Component)Ide.getMainWindow(), ProfArb.getString(316)) != 0) {
                URL uRL3 = null;
                return uRL3;
            }
            if (!defaultURLFilter.accept(uRL = uRLChooser.getSelectedURL())) {
                uRL = new URL(uRL.toString() + ".opr");
            }
            URL uRL4 = uRL;
            return uRL4;
        }
        catch (IOException iOException) {
            System.out.println("Got exception " + iOException);
            return null;
        }
    }

    private static DataOutputStream getOutputFileStream(Context context) {
        try {
            URL uRL;
            lastSavedFile = uRL = FileSaver.chooseFileName(context, true);
            if (uRL != null) {
                DataOutputStream dataOutputStream;
                DataOutputStream dataOutputStream2 = dataOutputStream = new DataOutputStream(new BufferedOutputStream(URLFileSystem.openOutputStream((URL)uRL)));
                return dataOutputStream2;
            }
        }
        catch (IOException iOException) {
            System.out.println("Got exception " + iOException);
        }
        return null;
    }

    public static URL chooseFileName(Context context) {
        return FileSaver.chooseFileName(context, false);
    }

    private static DataInputStream getInputFileStream(URL uRL) {
        try {
            lastSavedFile = uRL;
            if (uRL != null) {
                DataInputStream dataInputStream;
                DataInputStream dataInputStream2 = dataInputStream = new DataInputStream(new BufferedInputStream(URLFileSystem.openInputStream((URL)uRL)));
                return dataInputStream2;
            }
        }
        catch (IOException iOException) {
            System.out.println("Got exception " + iOException);
        }
        return null;
    }

    public static DataInputStream selectResultStream(URL uRL) {
        DataInputStream dataInputStream = FileSaver.getInputFileStream(uRL);
        if (dataInputStream != null) {
            try {
                if (dataInputStream.readInt() != -20266753) {
                    dataInputStream.close();
                    System.out.println("Wrong magic number");
                    dataInputStream = null;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                dataInputStream = null;
            }
        }
        return dataInputStream;
    }

    public void save(Context context) {
        DataOutputStream dataOutputStream = FileSaver.getOutputFileStream(context);
        if (dataOutputStream != null) {
            try {
                dataOutputStream.writeInt(-20266753);
                this._saved.saveToFile(dataOutputStream);
                dataOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void saveVMObjectToFile(VMTypes[] vMTypesArray, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(vMTypesArray.length);
        int n = 0;
        while (n < vMTypesArray.length) {
            vMTypesArray[n].saveToFile(dataOutputStream);
            ++n;
        }
    }

    public static void saveVMObjectToFile(Collection collection, DataOutputStream dataOutputStream) throws IOException {
        int n = collection.size();
        dataOutputStream.writeInt(n);
        for (BaseSavable baseSavable : collection) {
            baseSavable.saveToFile(dataOutputStream);
        }
    }
}

