/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.IdeUtil;
import oracle.jdevimpl.runner.codecoach.CCArb;
import oracle.jdevimpl.runner.profile.CallCountItem;
import oracle.jdevimpl.runner.profile.HeapDetailStat;
import oracle.jdevimpl.runner.profile.HeapStat;
import oracle.jdevimpl.runner.profile.MemoryDetailTable;
import oracle.jdevimpl.runner.profile.MemoryTable;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfileEvent;
import oracle.jdevimpl.runner.profile.SampleTable;
import oracle.jdevimpl.runner.profile.SubCallCount;

public class HTMLSaver {
    private static URL lastSavedFile = null;
    static final String LINE_FEED = System.getProperty("line.separator");
    static final String HT_HEADER1 = "<!doctype html public \"-//w3c//dtd html 4.0 transitional//en\">" + LINE_FEED + "<html>" + LINE_FEED + "<head>" + LINE_FEED + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=";
    static final String HT_HEADER2 = "\">" + LINE_FEED + "<meta name=\"Author\" content=\"" + ProfArb.getString(144) + "\">" + LINE_FEED + "<title>";
    static final String HT_HEADER3 = "</title>" + LINE_FEED + "<STYLE>" + LINE_FEED + "A:link" + LINE_FEED + "{" + LINE_FEED + "    COLOR: blue;" + LINE_FEED + "    TEXT-DECORATION: none" + LINE_FEED + "}" + LINE_FEED + "A:visited" + LINE_FEED + "{" + LINE_FEED + "    COLOR: blue;" + LINE_FEED + "    TEXT-DECORATION: none" + LINE_FEED + "}" + LINE_FEED + "A:hover" + LINE_FEED + "{" + LINE_FEED + "    COLOR: blue;" + LINE_FEED + "    TEXT-DECORATION: underline" + LINE_FEED + "}" + LINE_FEED + "BODY" + LINE_FEED + "{" + LINE_FEED + "    BACKGROUND: white;" + LINE_FEED + "    COLOR: black" + LINE_FEED + "}" + LINE_FEED + "</STYLE>" + LINE_FEED + "</head>" + LINE_FEED + "<body>" + LINE_FEED;
    static final String HT_FOOTER = "</body>" + LINE_FEED + "</html>" + LINE_FEED;
    CallCountItem[] table;
    int nCalls;
    private MemoryTable memTable;
    private MemoryDetailTable[] memDetails;
    private int index;
    private HashMap detMap;
    private HashSet backLink;
    private HashMap mlMap;
    private int mlHash;
    private ProfileEvent[] events;
    private DefaultMutableTreeNode ccAdvRoot;

    public HTMLSaver(ProfileEvent[] profileEventArray) {
        this.events = profileEventArray;
    }

    public HTMLSaver(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.ccAdvRoot = defaultMutableTreeNode;
    }

    public HTMLSaver(CallCountItem[] callCountItemArray, int n) {
        this.table = callCountItemArray;
        this.nCalls = n;
    }

    public HTMLSaver(MemoryTable memoryTable, MemoryDetailTable[] memoryDetailTableArray, int n) {
        this.memTable = memoryTable;
        this.memDetails = memoryDetailTableArray;
        this.index = n;
    }

    private static String HTML_Escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 3 / 2);
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n]);
                }
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    private static String HTML_Escape_ln(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 3 / 2);
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\n': {
                    stringBuffer.append("<br>");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n]);
                }
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    private String URLLink(String string, String string2) {
        return "<a href=\"#" + string + "\">" + HTMLSaver.HTML_Escape(string2) + "</a>";
    }

    private String URLTag(String string) {
        return "<a NAME=\"" + string + "\"></a>";
    }

    private String TABLE_Cell(String string) {
        return "<td>" + string + "</td>" + LINE_FEED;
    }

    private String TABLE_Cell(String string, String string2) {
        return "<td " + string + ">" + string2 + "</td>" + LINE_FEED;
    }

    private String TABLE_Row(String string, String string2, String string3, String string4) {
        return "<tr>" + this.TABLE_Cell(string) + this.TABLE_Cell(string2) + this.TABLE_Cell("align=\"right\"", string3) + this.TABLE_Cell("align=\"right\"", string4) + "</tr>" + LINE_FEED;
    }

    private String TABLE_RowSampleMain(String string, String string2, String string3, String string4, String string5, String string6) {
        return "<tr>" + this.TABLE_Cell(string) + this.TABLE_Cell(string2) + this.TABLE_Cell("align=\"right\"", string3) + this.TABLE_Cell("align=\"right\"", string4) + this.TABLE_Cell("align=\"right\"", string5) + this.TABLE_Cell("align=\"right\"", string6) + "</tr>" + LINE_FEED;
    }

    private String TABLE_Row(String string, String string2, String string3, String string4, String string5, String string6) {
        return "<tr>" + this.TABLE_Cell(string) + this.TABLE_Cell(string2) + this.TABLE_Cell(string3) + this.TABLE_Cell("align=\"right\"", string4) + this.TABLE_Cell("align=\"right\"", string5) + this.TABLE_Cell("align=\"right\"", string6) + "</tr>" + LINE_FEED;
    }

    private String TABLE_Row(String string, String string2, String string3) {
        return "<tr>" + this.TABLE_Cell(string) + this.TABLE_Cell(string2) + this.TABLE_Cell("align=\"right\"", string3) + "</tr>" + LINE_FEED;
    }

    private static PrintWriter getPrintWriter(Context context) {
        try {
            PrintWriter printWriter;
            DefaultURLFilter defaultURLFilter = new DefaultURLFilter(ProfArb.getString(146), ".htm");
            defaultURLFilter.addExtension(".html");
            URLChooser uRLChooser = DialogUtil.newURLChooser((Context)context);
            uRLChooser.setURLFilter((URLFilter)defaultURLFilter);
            if (lastSavedFile != null) {
                uRLChooser.setSelectedURL(lastSavedFile);
            }
            if (uRLChooser.showSaveDialog((Component)Ide.getMainWindow(), ProfArb.getString(324)) != 0) {
                PrintWriter printWriter2 = null;
                return printWriter2;
            }
            URL uRL = uRLChooser.getSelectedURL();
            if (!defaultURLFilter.accept(uRL)) {
                uRL = new URL(uRL.toString() + ".html");
            }
            lastSavedFile = uRL;
            PrintWriter printWriter3 = printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(URLFileSystem.openOutputStream((URL)uRL), IdeUtil.getIdeEncoding())));
            return printWriter3;
        }
        catch (IOException iOException) {
            System.out.println("Got exception " + iOException);
            return null;
        }
    }

    private void printSampleIndex(PrintWriter printWriter, int n) {
        printWriter.print("<p><b><font size=\"4\">");
        printWriter.print(ProfArb.getString(159) + " ");
        while (--n >= 0) {
            printWriter.print(this.URLLink("smp" + n, Integer.toString(this.memTable.getSampleNumber(n))) + " ");
        }
        printWriter.print("</font></b></p>");
        printWriter.print(LINE_FEED);
    }

    private String getID(HeapStat heapStat) {
        return "t" + heapStat.getClassDesc() + "_";
    }

    private String getID(HeapDetailStat heapDetailStat, int n) {
        String string = (String)this.mlMap.get(heapDetailStat.getName());
        if (string == null) {
            string = "p" + this.mlHash++ + "_";
            this.mlMap.put(heapDetailStat.getName(), string);
        }
        return string + n + "_";
    }

    private void printOneSampleTable(PrintWriter printWriter, int n, int n2) {
        printWriter.print("<p><b><font size=\"4\">");
        if (n2 != -1) {
            printWriter.print(this.URLTag("smp" + n));
        }
        printWriter.print(ProfArb.format(325, Integer.toString(this.memTable.getSampleNumber(n)), Integer.toString(this.memTable.getTotalSampleNumber())) + " ");
        printWriter.print("</font></b></p>");
        printWriter.print(LINE_FEED);
        printWriter.print("<table border=\"1\">" + LINE_FEED);
        printWriter.print("  <tbody>" + LINE_FEED);
        printWriter.print("    <tr>" + LINE_FEED);
        if (n2 != -1) {
            printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"40\"></td>" + LINE_FEED);
        }
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">" + ProfArb.getString(216) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(217) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(219) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(220) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(221) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(222) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(223) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(224) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(225) + "</td>" + LINE_FEED);
        printWriter.print("    </tr>" + LINE_FEED);
        HeapDetailStat heapDetailStat = this.memTable.getSampleTotals(n);
        printWriter.print("    <tr>" + LINE_FEED);
        if (n2 != -1) {
            printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\">");
            if (n != n2) {
                printWriter.print(this.URLLink("smp" + (n + 1), "<<") + " ");
            }
            if (n != 0) {
                printWriter.print(this.URLLink("smp" + (n - 1), ">>"));
            }
            printWriter.print("</td>" + LINE_FEED);
        }
        printWriter.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + ProfArb.getString(326) + " " + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + heapDetailStat.nb + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + heapDetailStat.size + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + heapDetailStat.nballoc + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + heapDetailStat.sizealloc + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + heapDetailStat.nbfreed + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + heapDetailStat.sizefreed + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + heapDetailStat.getNbDiff() + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"right\" bgcolor=\"#C0C0C0\">" + heapDetailStat.getSizeDiff() + "</td>" + LINE_FEED);
        printWriter.print("    </tr>" + LINE_FEED);
        int n3 = this.memTable.getTableSize(n);
        HeapStat[] heapStatArray = this.memTable.getSampleArray(n);
        int n4 = 0;
        while (n4 < n3) {
            HeapStat heapStat = heapStatArray[n4];
            printWriter.print("    <tr>" + LINE_FEED);
            if (n2 != -1) {
                String string = this.getID(heapStat);
                printWriter.print("      <td align=\"center\">");
                printWriter.print(this.URLTag(string + n));
                if (this.backLink.contains(string)) {
                    printWriter.print(this.URLLink(string + (n + 1), "<<") + " ");
                }
                this.backLink.add(string);
                if (n > 0) {
                    printWriter.print(this.URLLink(string + (n - 1), ">>"));
                }
                printWriter.print("</td>" + LINE_FEED);
            }
            printWriter.print("      <td align=\"left\">");
            MemoryDetailTable memoryDetailTable = (MemoryDetailTable)this.detMap.get(heapStat.getClazz());
            if (memoryDetailTable != null) {
                HeapDetailStat[] heapDetailStatArray = memoryDetailTable.getSampleArray(n);
                if (heapDetailStatArray != null) {
                    printWriter.print(this.URLTag("m" + n + "_" + heapStat.getClassDesc()) + this.URLLink("d" + n + "_" + heapStat.getClassDesc(), heapStat.getName()));
                } else {
                    printWriter.print(heapStat.getName());
                }
            } else {
                printWriter.print(heapStat.getName());
            }
            printWriter.print("</td>" + LINE_FEED);
            printWriter.print("      <td align=\"right\">" + heapStat.nb + "</td>" + LINE_FEED);
            printWriter.print("      <td align=\"right\">" + heapStat.size + "</td>" + LINE_FEED);
            printWriter.print("      <td align=\"right\">" + heapStat.nballoc + "</td>" + LINE_FEED);
            printWriter.print("      <td align=\"right\">" + heapStat.sizealloc + "</td>" + LINE_FEED);
            printWriter.print("      <td align=\"right\">" + heapStat.nbfreed + "</td>" + LINE_FEED);
            printWriter.print("      <td align=\"right\">" + heapStat.sizefreed + "</td>" + LINE_FEED);
            printWriter.print("      <td align=\"right\">" + heapStat.getNbDiff() + "</td>" + LINE_FEED);
            printWriter.print("      <td align=\"right\">" + heapStat.getSizeDiff() + "</td>" + LINE_FEED);
            printWriter.print("    </tr>" + LINE_FEED);
            ++n4;
        }
        printWriter.print("  </tbody>" + LINE_FEED);
        printWriter.print("</table>" + LINE_FEED);
        n4 = 0;
        while (n4 < this.memDetails.length) {
            HeapDetailStat[] heapDetailStatArray = this.memDetails[n4].getSampleArray(n);
            if (heapDetailStatArray != null) {
                printWriter.print("<p><b><font size=\"4\">");
                printWriter.print(this.URLTag("d" + n + "_" + this.memDetails[n4].getClazz().classDescriptor));
                printWriter.print(ProfArb.format(327, Integer.toString(this.memTable.getSampleNumber(n)), Integer.toString(this.memTable.getTotalSampleNumber())) + " ");
                printWriter.print(this.URLLink("m" + n + "_" + this.memDetails[n4].getClazz().classDescriptor, this.memDetails[n4].getClazz().toString()));
                printWriter.print("</font></b></p>");
                printWriter.print(LINE_FEED);
                printWriter.print("<table border=\"1\">" + LINE_FEED);
                printWriter.print("  <tbody>" + LINE_FEED);
                printWriter.print("    <tr>" + LINE_FEED);
                printWriter.print("</td>" + LINE_FEED);
                if (n2 != -1) {
                    printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"40\">");
                    printWriter.print("</td>" + LINE_FEED);
                }
                printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">" + ProfArb.getString(328) + " " + "</td>" + LINE_FEED);
                printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(217) + "</td>" + LINE_FEED);
                printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(219) + "</td>" + LINE_FEED);
                printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(220) + "</td>" + LINE_FEED);
                printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(221) + "</td>" + LINE_FEED);
                printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(222) + "</td>" + LINE_FEED);
                printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(223) + "</td>" + LINE_FEED);
                printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(224) + "</td>" + LINE_FEED);
                printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(225) + "</td>" + LINE_FEED);
                printWriter.print("    </tr>" + LINE_FEED);
                n3 = this.memDetails[n4].getTableSize(n);
                int n5 = 0;
                while (n5 < n3) {
                    HeapDetailStat heapDetailStat2 = heapDetailStatArray[n5];
                    printWriter.print("    <tr>" + LINE_FEED);
                    if (n2 != -1) {
                        String string = this.getID(heapDetailStat2, n4);
                        printWriter.print("      <td align=\"center\">");
                        printWriter.print(this.URLTag(string + n));
                        if (this.backLink.contains(string)) {
                            printWriter.print(this.URLLink(string + (n + 1), "<<") + " ");
                        }
                        this.backLink.add(string);
                        if (n > 0) {
                            printWriter.print(this.URLLink(string + (n - 1), ">>"));
                        }
                        printWriter.print("</td>" + LINE_FEED);
                    }
                    printWriter.print("      <td align=\"left\">");
                    printWriter.print(heapDetailStat2.getName());
                    printWriter.print("</td>" + LINE_FEED);
                    printWriter.print("      <td align=\"right\">" + heapDetailStat2.nb + "</td>" + LINE_FEED);
                    printWriter.print("      <td align=\"right\">" + heapDetailStat2.size + "</td>" + LINE_FEED);
                    printWriter.print("      <td align=\"right\">" + heapDetailStat2.nballoc + "</td>" + LINE_FEED);
                    printWriter.print("      <td align=\"right\">" + heapDetailStat2.sizealloc + "</td>" + LINE_FEED);
                    printWriter.print("      <td align=\"right\">" + heapDetailStat2.nbfreed + "</td>" + LINE_FEED);
                    printWriter.print("      <td align=\"right\">" + heapDetailStat2.sizefreed + "</td>" + LINE_FEED);
                    printWriter.print("      <td align=\"right\">" + heapDetailStat2.getNbDiff() + "</td>" + LINE_FEED);
                    printWriter.print("      <td align=\"right\">" + heapDetailStat2.getSizeDiff() + "</td>" + LINE_FEED);
                    printWriter.print("    </tr>" + LINE_FEED);
                    ++n5;
                }
                printWriter.print("  </tbody>" + LINE_FEED);
                printWriter.print("</table>" + LINE_FEED);
            }
            ++n4;
        }
    }

    private void saveMemSampleTable(PrintWriter printWriter) {
        printWriter.print(HT_HEADER1);
        printWriter.print(IdeUtil.getIdeIanaEncoding());
        printWriter.print(HT_HEADER2);
        printWriter.print(ProfArb.getString(145));
        printWriter.print(HT_HEADER3);
        int n = 0;
        this.detMap = new HashMap(this.memDetails.length);
        this.mlMap = new HashMap(200);
        this.backLink = new HashSet(200);
        n = 0;
        while (n < this.memDetails.length) {
            this.detMap.put(this.memDetails[n].getClazz(), this.memDetails[n]);
            ++n;
        }
        if (this.index == -1) {
            HeapStat[] heapStatArray;
            int n2 = 0;
            while ((heapStatArray = this.memTable.getSampleArray(++n2)) != null) {
            }
            this.printSampleIndex(printWriter, n2);
            n = n2;
            do {
                this.printOneSampleTable(printWriter, --n, n2 - 1);
            } while (n != 0);
        } else {
            this.printOneSampleTable(printWriter, this.index, -1);
        }
        printWriter.print(HT_FOOTER);
    }

    private void saveSampleTable(PrintWriter printWriter) {
        CallCountItem callCountItem;
        printWriter.print(HT_HEADER1);
        printWriter.print(IdeUtil.getIdeIanaEncoding());
        printWriter.print(HT_HEADER2);
        printWriter.print(ProfArb.getString(145));
        printWriter.print(HT_HEADER3);
        printWriter.print("<table border=\"1\">" + LINE_FEED);
        printWriter.print("  <tbody>" + LINE_FEED);
        printWriter.print("    <tr>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">" + ProfArb.getString(147) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">" + ProfArb.getString(148) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(149) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(151) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(150) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(152) + "</td>" + LINE_FEED);
        printWriter.print("    </tr>" + LINE_FEED);
        int n = 0;
        while (n < this.table.length) {
            callCountItem = this.table[n];
            printWriter.print(this.TABLE_RowSampleMain(this.URLTag("lst" + callCountItem.getRef()) + HTMLSaver.HTML_Escape(callCountItem.getPseudoClass()), this.URLLink("det" + callCountItem.getRef(), callCountItem.getPseudoName() + callCountItem.getNiceSignature()), SampleTable.pFormat((double)callCountItem.getCallCount() / (double)this.nCalls), Integer.toString(callCountItem.getCallCount()), SampleTable.pFormat((double)callCountItem.getOnStackCount() / (double)this.nCalls), Integer.toString(callCountItem.getOnStackCount())));
            ++n;
        }
        printWriter.print("  </tbody>" + LINE_FEED);
        printWriter.print("</table>" + LINE_FEED);
        printWriter.print("<HR>");
        printWriter.print(LINE_FEED);
        n = 0;
        while (n < this.table.length) {
            SubCallCount subCallCount;
            callCountItem = this.table[n];
            printWriter.print("<p><b><font size=\"4\">");
            printWriter.print(ProfArb.getString(153));
            printWriter.print("&nbsp;");
            printWriter.print(this.URLTag("det" + callCountItem.getRef()));
            printWriter.print(HTMLSaver.HTML_Escape(callCountItem.getPseudoClass()) + ".");
            printWriter.print(this.URLLink("lst" + callCountItem.getRef(), callCountItem.getPseudoName() + callCountItem.getNiceSignature()));
            printWriter.print("</font></b></p>");
            printWriter.print(LINE_FEED);
            printWriter.print("<table border=\"0\">" + LINE_FEED);
            printWriter.print("  <tr>" + LINE_FEED);
            printWriter.print("    <td align=\"right\">" + LINE_FEED);
            printWriter.print("<p><font size=\"4\">");
            printWriter.print(ProfArb.getString(154));
            printWriter.print("&nbsp;");
            printWriter.print("</font></td>" + LINE_FEED);
            printWriter.print("    <td align=\"right\"><font color=\"#FF0000\" size=\"4\">");
            printWriter.print(SampleTable.pFormat((double)callCountItem.getCallCount() / (double)this.nCalls));
            printWriter.print("</font></td>" + LINE_FEED);
            printWriter.print("  </tr>" + LINE_FEED);
            printWriter.print("  <tr>" + LINE_FEED);
            printWriter.print("    <td align=\"right\"><font size=\"4\">");
            printWriter.print(ProfArb.getString(155));
            printWriter.print("&nbsp;");
            printWriter.print("</font></td>" + LINE_FEED);
            printWriter.print("    <td align=\"right\"><font color=\"#FF0000\" size=\"4\">");
            printWriter.print(SampleTable.pFormat((double)callCountItem.getOnStackCount() / (double)this.nCalls));
            printWriter.print("</font></td>" + LINE_FEED);
            printWriter.print("  </tr> " + LINE_FEED);
            printWriter.print("</table> " + LINE_FEED);
            callCountItem.sortCalls();
            printWriter.print("<table border=\"0\">" + LINE_FEED);
            printWriter.print("  <tr>" + LINE_FEED);
            printWriter.print("    <td valign=\"top\" width=\"100\">");
            printWriter.print(ProfArb.getString(156));
            printWriter.print("</td>" + LINE_FEED);
            printWriter.print("    <td>" + LINE_FEED);
            printWriter.print("<table border=\"1\">" + LINE_FEED);
            printWriter.print("  <tbody>" + LINE_FEED);
            printWriter.print("    <tr>" + LINE_FEED);
            printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">");
            printWriter.print(ProfArb.getString(160));
            printWriter.print("</td>" + LINE_FEED);
            printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">");
            printWriter.print(ProfArb.getString(161));
            printWriter.print("</td>" + LINE_FEED);
            printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">");
            printWriter.print(ProfArb.getString(162));
            printWriter.print("</td>" + LINE_FEED);
            printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(151) + "</td>" + LINE_FEED);
            printWriter.print("  </tr>" + LINE_FEED);
            ArrayList arrayList = callCountItem.getCallerList();
            int n2 = arrayList.size();
            int n3 = 0;
            while (n3 < n2) {
                subCallCount = (SubCallCount)arrayList.get(n3);
                CallCountItem callCountItem2 = (CallCountItem)subCallCount.ref;
                printWriter.print(this.TABLE_Row(HTMLSaver.HTML_Escape(callCountItem2.getPseudoClass()), this.URLLink("det" + callCountItem2.getRef(), callCountItem2.getPseudoName() + callCountItem2.getNiceSignature()), SampleTable.pFormat((double)subCallCount.count / (double)callCountItem.callerTotal), Integer.toString(subCallCount.count)));
                ++n3;
            }
            printWriter.print("</tbody>" + LINE_FEED);
            printWriter.print("</table>" + LINE_FEED);
            printWriter.print("    </td>" + LINE_FEED);
            printWriter.print("  </tr>" + LINE_FEED);
            printWriter.print("</table>" + LINE_FEED);
            printWriter.print("<p>");
            printWriter.print(LINE_FEED);
            printWriter.print(LINE_FEED);
            printWriter.print("<table border=\"0\">" + LINE_FEED);
            printWriter.print("  <tr>" + LINE_FEED);
            printWriter.print("    <td valign=\"top\" width=\"100\">");
            printWriter.print(ProfArb.getString(157));
            printWriter.print("</td>" + LINE_FEED);
            printWriter.print("    <td>" + LINE_FEED);
            printWriter.print("<table border=\"1\">" + LINE_FEED);
            printWriter.print("  <tbody>" + LINE_FEED);
            printWriter.print("    <tr>" + LINE_FEED);
            printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">");
            printWriter.print(ProfArb.getString(163));
            printWriter.print("</td>" + LINE_FEED);
            printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">");
            printWriter.print(ProfArb.getString(164));
            printWriter.print("</td>" + LINE_FEED);
            printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">");
            printWriter.print(ProfArb.getString(165));
            printWriter.print("</td>" + LINE_FEED);
            printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(151) + "</td>" + LINE_FEED);
            printWriter.print("  </tr>" + LINE_FEED);
            printWriter.print("    <tr>" + LINE_FEED);
            printWriter.print("      <td colspan=\"2\"><b>");
            printWriter.print(ProfArb.getString(158));
            printWriter.print("</b></td>" + LINE_FEED);
            printWriter.print("    <td align=\"right\">");
            printWriter.print(SampleTable.pFormat((double)callCountItem.getCallCount() / (double)callCountItem.calledTotal));
            printWriter.print("</td>" + LINE_FEED);
            printWriter.print("    <td align=\"right\">");
            printWriter.print(Integer.toString(callCountItem.getCallCount()));
            printWriter.print("</td>" + LINE_FEED);
            printWriter.print("  </tr>" + LINE_FEED);
            arrayList = callCountItem.getCalledList();
            n2 = arrayList.size();
            n3 = 0;
            while (n3 < n2) {
                subCallCount = (SubCallCount)arrayList.get(n3);
                CallCountItem callCountItem3 = (CallCountItem)subCallCount.ref;
                printWriter.print(this.TABLE_Row(HTMLSaver.HTML_Escape(callCountItem3.getPseudoClass()), this.URLLink("det" + callCountItem3.getRef(), callCountItem3.getPseudoName() + callCountItem3.getNiceSignature()), SampleTable.pFormat((double)subCallCount.count / (double)callCountItem.calledTotal), Integer.toString(subCallCount.count)));
                ++n3;
            }
            printWriter.print("</tbody>" + LINE_FEED);
            printWriter.print("</table>" + LINE_FEED);
            printWriter.print("    </td>" + LINE_FEED);
            printWriter.print("  </tr>" + LINE_FEED);
            printWriter.print("</table>" + LINE_FEED);
            printWriter.print("<HR>");
            printWriter.print(LINE_FEED);
            ++n;
        }
        printWriter.print(HT_FOOTER);
    }

    private void saveEventTable(PrintWriter printWriter) {
        ProfileEvent profileEvent;
        printWriter.print(HT_HEADER1);
        printWriter.print(IdeUtil.getIdeIanaEncoding());
        printWriter.print(HT_HEADER2);
        printWriter.print(ProfArb.getString(145));
        printWriter.print(HT_HEADER3);
        printWriter.print("<table border=\"1\">" + LINE_FEED);
        printWriter.print("  <tbody>" + LINE_FEED);
        printWriter.print("    <tr>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"100\">" + ProfArb.getString(257) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">" + ProfArb.getString(260) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"400\">" + ProfArb.getString(258) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(259) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(261) + "</td>" + LINE_FEED);
        printWriter.print("      <td align=\"center\" bgcolor=\"#C0C0C0\" width=\"80\">" + ProfArb.getString(262) + "</td>" + LINE_FEED);
        printWriter.print("    </tr>" + LINE_FEED);
        int n = 0;
        while (n < this.events.length) {
            String string;
            profileEvent = this.events[n];
            String string2 = profileEvent.getShortCommentS();
            string = string2.equals(string = profileEvent.getCommentS()) ? HTMLSaver.HTML_Escape(string2) : this.URLTag("l" + n) + HTMLSaver.HTML_Escape(string2) + " " + this.URLLink("d" + n, "+++");
            printWriter.print(this.TABLE_Row(HTMLSaver.HTML_Escape(profileEvent.getIdS()), string, HTMLSaver.HTML_Escape(profileEvent.getPosS()), profileEvent.getStartS(), profileEvent.getEndS(), profileEvent.getDurationS()));
            ++n;
        }
        printWriter.print("  </tbody>" + LINE_FEED);
        printWriter.print("</table>" + LINE_FEED);
        n = 0;
        while (n < this.events.length) {
            String string;
            profileEvent = this.events[n];
            String string3 = profileEvent.getShortCommentS();
            if (!string3.equals(string = profileEvent.getCommentS())) {
                printWriter.print("</p>" + this.URLTag("d" + n) + this.URLLink("l" + n, ProfArb.getString(329)) + "<br>" + ProfArb.getString(257) + " : " + HTMLSaver.HTML_Escape(profileEvent.getIdS()) + "<br>" + ProfArb.getString(258) + " : " + HTMLSaver.HTML_Escape(profileEvent.getPosS()) + "<br>" + ProfArb.getString(259) + " : " + HTMLSaver.HTML_Escape(profileEvent.getStartS()) + "<br>" + ProfArb.getString(261) + " : " + HTMLSaver.HTML_Escape(profileEvent.getEndS()) + "<br>" + ProfArb.getString(262) + " : " + HTMLSaver.HTML_Escape(profileEvent.getDurationS()) + "<br>" + ProfArb.getString(260) + " : <br>" + HTMLSaver.HTML_Escape_ln(string) + "</p> " + LINE_FEED);
                printWriter.print("<HR>");
            }
            ++n;
        }
    }

    private void saveCCResults(PrintWriter printWriter) {
        printWriter.print(HT_HEADER1);
        printWriter.print(IdeUtil.getIdeIanaEncoding());
        printWriter.print(HT_HEADER2);
        printWriter.print(CCArb.getString(39));
        printWriter.print(HT_HEADER3);
        int n = this.ccAdvRoot.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.ccAdvRoot.getChildAt(n2);
            printWriter.print("<HR><p>");
            printWriter.print(HTMLSaver.HTML_Escape(defaultMutableTreeNode.getUserObject().toString()));
            printWriter.print("</p><MENU>" + LINE_FEED);
            int n3 = defaultMutableTreeNode.getChildCount();
            int n4 = 0;
            while (n4 < n3) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n4);
                printWriter.print("<LI>");
                printWriter.print(HTMLSaver.HTML_Escape(defaultMutableTreeNode2.getUserObject().toString()));
                printWriter.print(LINE_FEED);
                ++n4;
            }
            printWriter.print("</MENU>" + LINE_FEED);
            ++n2;
        }
    }

    public void SaveToFile(Context context) {
        PrintWriter printWriter = HTMLSaver.getPrintWriter(context);
        if (printWriter != null) {
            if (this.table != null) {
                this.saveSampleTable(printWriter);
            } else if (this.memTable != null) {
                this.saveMemSampleTable(printWriter);
            } else if (this.events != null) {
                this.saveEventTable(printWriter);
            } else if (this.ccAdvRoot != null) {
                this.saveCCResults(printWriter);
            }
            printWriter.flush();
            printWriter.close();
        }
    }
}

