/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.ide.util.IntHashMap;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.VMMethod;

class HeapDetailStat {
    VMMethod method;
    int line;
    int nb;
    int nballoc;
    int nbfreed;
    int size;
    int sizealloc;
    int sizefreed;
    String name;

    void $init$() {
        this.name = null;
    }

    public HeapDetailStat(VMMethod vMMethod, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.$init$();
        this.method = vMMethod;
        this.line = n;
        this.nb = n2;
        this.nballoc = n3;
        this.nbfreed = n4;
        this.size = n5;
        this.sizealloc = n6;
        this.sizefreed = n7;
    }

    public HeapDetailStat(HeapDetailStat heapDetailStat) {
        this.$init$();
        this.method = heapDetailStat.method;
        this.line = heapDetailStat.line;
        this.nb = heapDetailStat.nb;
        this.nballoc = heapDetailStat.nballoc;
        this.nbfreed = heapDetailStat.nbfreed;
        this.size = heapDetailStat.size;
        this.sizealloc = heapDetailStat.sizealloc;
        this.sizefreed = heapDetailStat.sizefreed;
    }

    void saveToFile(DataOutputStream dataOutputStream) throws IOException {
        if (this.method == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(this.method.methodDescriptor);
        }
        dataOutputStream.writeInt(this.line);
        dataOutputStream.writeInt(this.nb);
        dataOutputStream.writeInt(this.nballoc);
        dataOutputStream.writeInt(this.nbfreed);
        dataOutputStream.writeInt(this.size);
        dataOutputStream.writeInt(this.sizealloc);
        dataOutputStream.writeInt(this.sizefreed);
    }

    static HeapDetailStat readFromFile(DataInputStream dataInputStream, IntHashMap intHashMap) throws IOException {
        int n = dataInputStream.readInt();
        VMMethod vMMethod = null;
        if (n != 0) {
            vMMethod = (VMMethod)intHashMap.get(n);
        }
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        int n4 = dataInputStream.readInt();
        int n5 = dataInputStream.readInt();
        int n6 = dataInputStream.readInt();
        int n7 = dataInputStream.readInt();
        int n8 = dataInputStream.readInt();
        return new HeapDetailStat(vMMethod, n2, n3, n4, n5, n6, n7, n8);
    }

    public void clearDiffs() {
        this.nballoc = 0;
        this.nbfreed = 0;
        this.sizealloc = 0;
        this.sizefreed = 0;
    }

    public void clearValues() {
        this.nb = 0;
        this.size = 0;
    }

    public void update(int n, int n2, int n3, int n4, int n5, int n6) {
        this.nb += n;
        this.nballoc += n2;
        this.nbfreed += n3;
        this.size += n4;
        this.sizealloc += n5;
        this.sizefreed += n6;
    }

    public int getNbDiff() {
        return this.nballoc - this.nbfreed;
    }

    public int getSizeDiff() {
        return this.sizealloc - this.sizefreed;
    }

    String getFileName() {
        return this.method.clazz.fileName;
    }

    int getLine() {
        return this.line;
    }

    String getPackage() {
        return this.method.clazz.packageName;
    }

    public String getName() {
        if (this.name == null) {
            this.name = ProfArb.format(322, this.method.toString(), Integer.toString(this.line));
        }
        return this.name;
    }

    public void subtract(int n, int n2, int n3, int n4, int n5, int n6) {
        this.nb -= n;
        this.nballoc -= n2;
        this.nbfreed -= n3;
        this.size -= n4;
        this.sizealloc -= n5;
        this.sizefreed -= n6;
    }
}

