/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.ide.util.IntHashMap;
import oracle.jdevimpl.runner.profile.VMClass;

class HeapStat {
    VMClass clazz;
    int nb;
    int nballoc;
    int nbfreed;
    int size;
    int sizealloc;
    int sizefreed;

    public int getClassDesc() {
        return this.clazz.classDescriptor;
    }

    public VMClass getClazz() {
        return this.clazz;
    }

    public HeapStat(HeapStat heapStat) {
        this.clazz = heapStat.clazz;
        this.nb = heapStat.nb;
        this.nballoc = heapStat.nballoc;
        this.nbfreed = heapStat.nbfreed;
        this.size = heapStat.size;
        this.sizealloc = heapStat.sizealloc;
        this.sizefreed = heapStat.sizefreed;
    }

    public HeapStat(VMClass vMClass, int n, int n2, int n3, int n4, int n5, int n6) {
        this.clazz = vMClass;
        this.nb = n;
        this.nballoc = n2;
        this.nbfreed = n3;
        this.size = n4;
        this.sizealloc = n5;
        this.sizefreed = n6;
    }

    void saveToFile(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.clazz.classDescriptor);
        dataOutputStream.writeInt(this.nb);
        dataOutputStream.writeInt(this.nballoc);
        dataOutputStream.writeInt(this.nbfreed);
        dataOutputStream.writeInt(this.size);
        dataOutputStream.writeInt(this.sizealloc);
        dataOutputStream.writeInt(this.sizefreed);
    }

    static HeapStat readFromFile(DataInputStream dataInputStream, IntHashMap intHashMap) throws IOException {
        int n = dataInputStream.readInt();
        VMClass vMClass = (VMClass)intHashMap.get(n);
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        int n4 = dataInputStream.readInt();
        int n5 = dataInputStream.readInt();
        int n6 = dataInputStream.readInt();
        int n7 = dataInputStream.readInt();
        return new HeapStat(vMClass, n2, n3, n4, n5, n6, n7);
    }

    public void clearDiffs() {
        this.nballoc = 0;
        this.nbfreed = 0;
        this.sizealloc = 0;
        this.sizefreed = 0;
    }

    public void update(int n, int n2, int n3, int n4, int n5, int n6) {
        this.nb = n;
        this.nballoc = n2;
        this.nbfreed = n3;
        this.size = n4;
        this.sizealloc = n5;
        this.sizefreed = n6;
    }

    public int getNbDiff() {
        return this.nballoc - this.nbfreed;
    }

    public int getSizeDiff() {
        return this.sizealloc - this.sizefreed;
    }

    public String getName() {
        return this.clazz.toString();
    }
}

