/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Component;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.compiler.Compiler;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.panels.Navigable;
import oracle.ide.runner.Profiler;
import oracle.ide.runner.Runner;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.profile.EventTable;
import oracle.jdevimpl.runner.profile.EventsConfigurationPanel;
import oracle.jdevimpl.runner.profile.FileSavable;
import oracle.jdevimpl.runner.profile.HTMLSavable;
import oracle.jdevimpl.runner.profile.LocationProvider;
import oracle.jdevimpl.runner.profile.MemoryConfigurationPanel;
import oracle.jdevimpl.runner.profile.MemoryDetailTable;
import oracle.jdevimpl.runner.profile.MemoryTable;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfWindow;
import oracle.jdevimpl.runner.profile.ProfileConfiguration;
import oracle.jdevimpl.runner.profile.ProfileConfigurationPanel;
import oracle.jdevimpl.runner.profile.ProfilerDockableFactory;
import oracle.jdevimpl.runner.profile.ProfilerSettings;
import oracle.jdevimpl.runner.profile.ProfilerSettingsPanel;
import oracle.jdevimpl.runner.profile.ProfilingProcess;
import oracle.jdevimpl.runner.profile.SampleConfigurationPanel;
import oracle.jdevimpl.runner.profile.SampleTable;
import oracle.jdevimpl.runner.profile.UpdatableSettings;
import oracle.jdevimpl.runner.profile.VMClass;
import oracle.jdevimpl.runner.profile.VMMethod;

public class JProfiler
extends Profiler
implements BuildSystemListener,
Addin,
Observer,
ContextMenuListener,
Controller {
    ProfilerDockableFactory dockFactory;
    static IdeAction actionStart;
    static IdeAction actionStartEvent;
    static JMenuItem startEventMenu;
    static IdeAction actionStartSample;
    static JMenuItem startSampleMenu;
    static IdeAction actionStartMemory;
    static JMenuItem startMemoryMenu;
    static IdeAction actionStartFromFile;
    static JMenuItem startFromFileMenu;
    static ContextMenu contextMenu;
    private static IdeAction actionHTMLSave;
    private static IdeAction actionFileSave;
    private static IdeAction actionFindSource;
    private static IdeAction actionHTMLSaveAll;
    private static IdeAction actionGetDetail;
    private static IdeAction actionSetSettings;
    private static JMenuItem menuHTMLSave;
    private static JMenuItem menuFileSave;
    private static JMenuItem menuFindSource;
    private static JMenuItem menuHTMLSaveAll;
    private static JMenuItem menuGetDetail;
    private static JMenuItem menuSetSettings;
    private Project activeProject;
    private static final int PROFILE_START_CMD_ID;
    private static final int PROFILE_START_SAMPLE_CMD_ID;
    private static final int PROFILE_START_EVENT_CMD_ID;
    private static final int PROFILE_START_MEMORY_CMD_ID;
    private static final int PROFILE_START_FROMFILE_CMD_ID;
    private static final int HTML_SAVE_CMD_ID;
    private static final int FILE_SAVE_CMD_ID;
    private static final int HTML_FIND_SRC_CMD_ID;
    private static final int HTML_SAVE_ALL_CMD_ID;
    private static final int GET_DETAIL_CMD_ID;
    private static final int SET_SETTINGS_CMD_ID;
    static final int PROFTYPE_SAMPLE = 0;
    static final int PROFTYPE_EVENT = 1;
    static final int PROFTYPE_MEMORY = 2;
    static final int PROFTYPE_FILE = 10;
    private static int _runCount;
    private int _currentProfType;
    private boolean _popupActive;

    static {
        PROFILE_START_CMD_ID = Ide.findOrCreateCmdID((String)"ProfileStartCommand");
        PROFILE_START_SAMPLE_CMD_ID = Ide.findOrCreateCmdID((String)"ProfileStartSampleCommand");
        PROFILE_START_EVENT_CMD_ID = Ide.findOrCreateCmdID((String)"ProfileStartEventCommand");
        PROFILE_START_MEMORY_CMD_ID = Ide.findOrCreateCmdID((String)"ProfileStartMemoryCommand");
        PROFILE_START_FROMFILE_CMD_ID = Ide.findOrCreateCmdID((String)"ProfileStartFromFileCommand");
        HTML_SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"ProfilerSaveToHTML");
        FILE_SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"ProfilerSaveToFile");
        HTML_FIND_SRC_CMD_ID = Ide.findOrCreateCmdID((String)"ProfilerFindSource");
        HTML_SAVE_ALL_CMD_ID = Ide.findOrCreateCmdID((String)"ProfilerSaveAllToHTML");
        GET_DETAIL_CMD_ID = Ide.findOrCreateCmdID((String)"ProfilerMemoryGetDetail");
        SET_SETTINGS_CMD_ID = Ide.findOrCreateCmdID((String)"ProfilerSetSettings");
        _runCount = 0;
    }

    void $init$() {
        this._currentProfType = 0;
        this._popupActive = false;
    }

    public JProfiler() {
        this.$init$();
        VMMethod.compareField = 4;
        VMClass.compareField = 3;
    }

    public void addInitialEvent(String string) {
        ProfileConfiguration.addInitialEvent(string);
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PROFILE_START_CMD_ID) {
            this.startProcess(this._currentProfType);
            return true;
        }
        if (n == PROFILE_START_SAMPLE_CMD_ID) {
            this._currentProfType = 0;
            actionStart.putValue("SmallIcon", (Object)ProfArb.getIcon(15));
            this.updateStartAction();
            this.startProcess(0);
            return true;
        }
        if (n == PROFILE_START_EVENT_CMD_ID) {
            this._currentProfType = 1;
            actionStart.putValue("SmallIcon", (Object)ProfArb.getIcon(18));
            this.updateStartAction();
            this.startProcess(1);
            return true;
        }
        if (n == PROFILE_START_FROMFILE_CMD_ID) {
            this.startProcess(10);
            return true;
        }
        if (n == PROFILE_START_MEMORY_CMD_ID) {
            this._currentProfType = 2;
            actionStart.putValue("SmallIcon", (Object)ProfArb.getIcon(23));
            this.updateStartAction();
            this.startProcess(2);
            return true;
        }
        if (n == FILE_SAVE_CMD_ID) {
            FileSavable fileSavable = (FileSavable)context.getView();
            if (fileSavable != null) {
                this._popupActive = true;
                fileSavable.saveToFile();
                this._popupActive = false;
            }
            return true;
        }
        if (n == HTML_SAVE_CMD_ID) {
            HTMLSavable hTMLSavable = (HTMLSavable)context.getView();
            if (hTMLSavable != null) {
                this._popupActive = true;
                hTMLSavable.saveToHTML(false);
                this._popupActive = false;
            }
            return true;
        }
        if (n == HTML_FIND_SRC_CMD_ID) {
            LocationProvider locationProvider = (LocationProvider)context.getView();
            if (locationProvider != null) {
                locationProvider.findSource();
            }
            return true;
        }
        if (n == HTML_SAVE_ALL_CMD_ID) {
            HTMLSavable hTMLSavable = (HTMLSavable)context.getView();
            if (hTMLSavable != null) {
                this._popupActive = true;
                hTMLSavable.saveToHTML(true);
                this._popupActive = false;
            }
            return true;
        }
        if (n == GET_DETAIL_CMD_ID) {
            MemoryTable memoryTable = (MemoryTable)context.getView();
            memoryTable.showDetail();
            return true;
        }
        if (n == SET_SETTINGS_CMD_ID) {
            UpdatableSettings updatableSettings = (UpdatableSettings)context.getView();
            this._popupActive = true;
            updatableSettings.changeSettings();
            this._popupActive = false;
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == PROFILE_START_CMD_ID || n == PROFILE_START_EVENT_CMD_ID || n == PROFILE_START_SAMPLE_CMD_ID || n == PROFILE_START_MEMORY_CMD_ID) {
            ideAction.setEnabled(this.canStartProcess());
            return true;
        }
        if (n == PROFILE_START_FROMFILE_CMD_ID) {
            ideAction.setEnabled(Ide.getActiveWorkspace() != null && this.activeProject != null);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        View view = context.getView();
        if (view instanceof LocationProvider) {
            LocationProvider locationProvider = (LocationProvider)view;
            contextMenu.add((Component)menuFindSource, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
            menuFindSource.setEnabled(locationProvider.canFindSource());
        }
        if (view instanceof SampleTable || view instanceof EventTable) {
            contextMenu.add((Component)menuHTMLSave, 1.0f);
        }
        if (view instanceof MemoryDetailTable) {
            contextMenu.add((Component)menuHTMLSave, 1.0f);
            contextMenu.add((Component)menuHTMLSaveAll, 1.0f);
        }
        if (view instanceof MemoryTable) {
            MemoryTable memoryTable = (MemoryTable)view;
            contextMenu.add((Component)menuGetDetail, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
            menuGetDetail.setEnabled(memoryTable.canShowDetail());
            contextMenu.add((Component)menuHTMLSave, 1.0f);
            contextMenu.add((Component)menuHTMLSaveAll, 1.0f);
        }
        if (view instanceof FileSavable) {
            contextMenu.add((Component)menuFileSave, 1.0f);
        }
        if (view instanceof UpdatableSettings) {
            contextMenu.add((Component)menuSetSettings, JDeveloperMenuConstants.SECTION_TOOLS_CTXT_MENU);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean isPopupActive() {
        return this._popupActive;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void activeProjectChanged() {
        if (this.activeProject != null) {
            this.activeProject.detach((Observer)this);
        }
        this.activeProject = Ide.getActiveProject();
        if (this.activeProject != null) {
            this.activeProject.attach((Observer)this);
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        4 var3_3 = new 4(this, updateMessage, object);
        if (SwingUtilities.isEventDispatchThread()) {
            var3_3.run();
        } else {
            SwingUtilities.invokeLater(var3_3);
        }
    }

    public void initialize() {
        Ide.getSystem().attach((Observer)this);
        Compiler.getCompiler().addBuildSystemListener((BuildSystemListener)this);
        this.dockFactory = new ProfilerDockableFactory();
        this.createMenus();
        actionStart.setEnabled(false);
        actionStartEvent.setEnabled(false);
        actionStartSample.setEnabled(false);
        actionStartMemory.setEnabled(false);
        JProfiler.initializeIDESettings();
        JProfiler.registerSettingsPanels();
        Profiler.setProfiler((Profiler)this);
    }

    public void buildWillStart(Context context) throws BuildSystemVetoException {
        SwingUtilities.invokeLater(new 3());
    }

    public void buildFinished(int n, int n2, int n3) throws BuildSystemVetoException {
        new 2("JProfilerWaitForCompiler").start();
    }

    private IdeAction myGetAction(int n, String string) {
        IdeAction ideAction = IdeAction.get((int)n, null, (String)string);
        int n2 = string.indexOf("&");
        if (n2 != -1) {
            ideAction.putValue("MnemonicKey", (Object)new Integer(string.charAt(n2 + 1)));
        }
        return ideAction;
    }

    private void createMenus() {
        Menubar menubar = Ide.getMenubar();
        JMenu jMenu = MenuManager.getJMenu((String)"Run");
        String string = jMenu.getText();
        actionStart = IdeAction.get((int)PROFILE_START_CMD_ID, null, (String)ProfArb.getString(10), (String)string, (Integer)ProfArb.getInteger(11), (ArrayResourceBundle)ProfArb.getInstance(), (int)15, null, (boolean)false);
        actionStart.addController((Controller)this);
        actionStart.putValue("NoCtxName", (Object)ProfArb.getString(10));
        actionStartEvent = IdeAction.get((int)PROFILE_START_EVENT_CMD_ID, null, (String)ProfArb.getString(16), (String)string, (Integer)ProfArb.getInteger(17), (ArrayResourceBundle)ProfArb.getInstance(), (int)18, null, (boolean)false);
        actionStartEvent.addController((Controller)this);
        actionStartEvent.putValue("NoCtxName", (Object)ProfArb.getString(16));
        startEventMenu = menubar.createMenuItem((ToggleAction)actionStartEvent, JDeveloperMenuConstants.WEIGHT_RUN_PROFILE_EVENTS);
        menubar.add((Component)startEventMenu, jMenu, JDeveloperMenuConstants.SECTION_RUN_PROFILE);
        actionStartSample = IdeAction.get((int)PROFILE_START_SAMPLE_CMD_ID, null, (String)ProfArb.getString(13), (String)string, (Integer)ProfArb.getInteger(14), (ArrayResourceBundle)ProfArb.getInstance(), (int)15, null, (boolean)false);
        actionStartSample.addController((Controller)this);
        actionStartSample.putValue("NoCtxName", (Object)ProfArb.getString(13));
        startSampleMenu = menubar.createMenuItem((ToggleAction)actionStartSample, JDeveloperMenuConstants.WEIGHT_RUN_PROFILE_EXECUTION);
        menubar.add((Component)startSampleMenu, jMenu, JDeveloperMenuConstants.SECTION_RUN_PROFILE);
        actionStartMemory = IdeAction.get((int)PROFILE_START_MEMORY_CMD_ID, null, (String)ProfArb.getString(19), (String)string, (Integer)ProfArb.getInteger(22), (ArrayResourceBundle)ProfArb.getInstance(), (int)23, null, (boolean)false);
        actionStartMemory.addController((Controller)this);
        actionStartMemory.putValue("NoCtxName", (Object)ProfArb.getString(19));
        startMemoryMenu = menubar.createMenuItem((ToggleAction)actionStartMemory, JDeveloperMenuConstants.WEIGHT_RUN_PROFILE_MEMORY);
        menubar.add((Component)startMemoryMenu, jMenu, JDeveloperMenuConstants.SECTION_RUN_PROFILE);
        actionStartFromFile = IdeAction.get((int)PROFILE_START_FROMFILE_CMD_ID, null, (String)ProfArb.getString(20), (String)string, (Integer)ProfArb.getInteger(21), null, null, (boolean)false);
        actionStartFromFile.addController((Controller)this);
        actionStartFromFile.putValue("NoCtxName", (Object)ProfArb.getString(20));
        startFromFileMenu = menubar.createMenuItem((ToggleAction)actionStartFromFile, JDeveloperMenuConstants.WEIGHT_RUN_PROFILE_LOAD);
        menubar.add((Component)startFromFileMenu, jMenu, JDeveloperMenuConstants.SECTION_RUN_PROFILE);
        actionHTMLSave = this.myGetAction(HTML_SAVE_CMD_ID, ProfArb.getString(166));
        actionHTMLSave.addController((Controller)this);
        actionFileSave = this.myGetAction(FILE_SAVE_CMD_ID, ProfArb.getString(167));
        actionFileSave.addController((Controller)this);
        actionFindSource = this.myGetAction(HTML_FIND_SRC_CMD_ID, ProfArb.getString(168));
        actionFindSource.addController((Controller)this);
        actionHTMLSaveAll = this.myGetAction(HTML_SAVE_ALL_CMD_ID, ProfArb.getString(169));
        actionHTMLSaveAll.addController((Controller)this);
        actionGetDetail = this.myGetAction(GET_DETAIL_CMD_ID, ProfArb.getString(170));
        actionGetDetail.addController((Controller)this);
        actionSetSettings = this.myGetAction(SET_SETTINGS_CMD_ID, ProfArb.getString(171));
        actionSetSettings.addController((Controller)this);
        contextMenu = new ContextMenu();
        contextMenu.addContextMenuListener((ContextMenuListener)this);
        menuHTMLSave = contextMenu.createMenuItem((ToggleAction)actionHTMLSave);
        menuFileSave = contextMenu.createMenuItem((ToggleAction)actionFileSave);
        menuFindSource = contextMenu.createMenuItem((ToggleAction)actionFindSource);
        menuHTMLSaveAll = contextMenu.createMenuItem((ToggleAction)actionHTMLSaveAll);
        menuGetDetail = contextMenu.createMenuItem((ToggleAction)actionGetDetail);
        menuSetSettings = contextMenu.createMenuItem((ToggleAction)actionSetSettings);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/runner/profile/accelerators.xml");
    }

    private static void initializeIDESettings() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        if (!clientSetting.hasData("ProfilerSettings")) {
            clientSetting.putData("ProfilerSettings", (Copyable)new ProfilerSettings());
        }
        ProfilerSettings profilerSettings = ProfilerSettings.getInstance();
        profilerSettings.addChangeListener(new 1());
    }

    private static void registerSettingsPanels() {
        Navigable[] navigableArray = new Navigable[]{new Navigable(ProfArb.getString(79), EventsConfigurationPanel.class), new Navigable(ProfArb.getString(78), SampleConfigurationPanel.class), new Navigable(ProfArb.getString(80), MemoryConfigurationPanel.class)};
        Navigable navigable = new Navigable(ProfArb.getString(77), ProfileConfigurationPanel.class, navigableArray);
        Runner.getRunner().addRunConfigurationToolNavigable(navigable);
        navigable = new Navigable(ProfArb.getString(77), ProfilerSettingsPanel.class);
        IdeSettings.registerUI((Navigable)navigable);
    }

    private void updateProfileActions() {
        Context context = Ide.getMainWindow().getLastActiveView().getContext();
        this.update(actionStart, context);
        this.update(actionStartEvent, context);
        this.update(actionStartSample, context);
        this.update(actionStartMemory, context);
    }

    private void updateStartMenu() {
        Context context = Ide.getMainWindow().getLastActiveView().getContext();
        this.update(actionStart, context);
        this.updateStartAction();
    }

    private void updateStartAction() {
        String string = "";
        if (this.activeProject != null) {
            string = this.activeProject.getShortLabel();
        }
        String string2 = ProfArb.getString(16) + string;
        actionStartEvent.putValue("Name", (Object)string2);
        if (this._currentProfType == 1) {
            actionStart.putValue("Name", (Object)string2);
        }
        string2 = ProfArb.getString(13) + string;
        actionStartSample.putValue("Name", (Object)string2);
        if (this._currentProfType == 0) {
            actionStart.putValue("Name", (Object)string2);
        }
        string2 = ProfArb.getString(19) + string;
        actionStartMemory.putValue("Name", (Object)string2);
        if (this._currentProfType == 2) {
            actionStart.putValue("Name", (Object)string2);
        }
    }

    private boolean canStartProcess() {
        if (Compiler.getCompiler().isBusy(null)) {
            return false;
        }
        if (Ide.getActiveWorkspace() != null && this.activeProject != null) {
            RunConfiguration runConfiguration;
            if (this.activeProject.isOpen() && !(runConfiguration = RunConfiguration.getInstance((PropertyStorage)this.activeProject)).isRemoteDebuggingProfiling()) {
                JDK jDK = Helpers.getActiveJdkDefinition(this.activeProject);
                return runConfiguration.usingOJVM(jDK);
            }
            return true;
        }
        return false;
    }

    void reStartProcess(int n, ProfWindow profWindow, Map map) {
        if (Ide.getActiveWorkspace() != null && this.activeProject != null) {
            ProfilingProcess profilingProcess = new ProfilingProcess(this, n, ++_runCount, profWindow, map);
            profilingProcess.start();
        }
    }

    private void startProcess(int n) {
        if (Ide.getActiveWorkspace() != null && this.activeProject != null) {
            ProfilingProcess profilingProcess = new ProfilingProcess(this, n, ++_runCount);
            profilingProcess.start();
        }
    }

    static void mav$activeProjectChanged(JProfiler jProfiler) {
        jProfiler.activeProjectChanged();
    }

    static void mav$updateStartMenu(JProfiler jProfiler) {
        jProfiler.updateStartMenu();
    }

    static void mav$updateProfileActions(JProfiler jProfiler) {
        jProfiler.updateProfileActions();
    }

    public final class 4
    implements Runnable {
        private final /* synthetic */ UpdateMessage v$change;
        private final /* synthetic */ Object v$observed;
        final /* synthetic */ JProfiler this$0;

        public void run() {
            int n = this.v$change.getMessageID();
            if (this.v$observed == Ide.getSystem()) {
                if (n == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                    JProfiler.mav$activeProjectChanged(this.this$0);
                    JProfiler.mav$updateStartMenu(this.this$0);
                }
            } else if (this.v$observed instanceof Project && n == UpdateMessage.PROPERTY_SET) {
                JProfiler.mav$updateStartMenu(this.this$0);
                ProfilerDockableFactory.enumerateProfWindow();
            }
        }

        public 4(JProfiler jProfiler, UpdateMessage updateMessage, Object object) {
            this.v$observed = object;
            this.v$change = updateMessage;
            this.this$0 = jProfiler;
        }
    }

    public final class 3
    implements Runnable {
        public void run() {
            JProfiler.mav$updateProfileActions(JProfiler.this);
        }
    }

    public final class 2
    extends Thread {
        public void run() {
            try {
                UnifiedBuildSystem.getInstance().join(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new 1());
        }

        public 2(String string) {
            super(string);
        }

        public final class 1
        implements Runnable {
            public void run() {
                JProfiler.mav$updateProfileActions(JProfiler.this);
            }
        }
    }

    public static final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            ProfilerDockableFactory.enumerateProfWindow();
        }
    }
}

