/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.jdevimpl.runner.profile.GenerateDiffDialog;
import oracle.jdevimpl.runner.profile.MemoryUseTable;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.VMClass;

final class MemoryAllocTable
extends JPanel {
    private static final int COLUMN_PACKAGENAME = 0;
    private static final int COLUMN_CLASSNAME = 1;
    private static final int COLUMN_INSTANCES = 2;
    private static final int COLUMN_SIZE = 3;
    private static final int N_COLUMNS = 4;
    private static final int TABLE_DYNAMIC = 0;
    private static final int TABLE_SNAPSHOT = 1;
    private static final int TABLE_DIFF = 2;
    private List classArray;
    private JTable table;
    private MemoryUseTable parent;
    private JButton diffButton;
    private int nAllocations;
    private int allocSize;
    private int tableType;
    private String title;
    static final String PACKAGE_TITLE = ProfArb.getString(119);
    static final String NAME_TITLE = ProfArb.getString(120);
    static final String INSTANCES_TITLE = ProfArb.getString(121);
    static final String SIZE_TITLE = ProfArb.getString(122);

    public MemoryAllocTable(MemoryUseTable memoryUseTable, Object[] objectArray, int n) {
        this.parent = memoryUseTable;
        if (objectArray == null) {
            n = 0;
            this.classArray = new ArrayList();
        } else {
            this.tableType = n;
            Arrays.sort(objectArray);
            int n2 = objectArray.length;
            this.classArray = new ArrayList(n2);
            int n3 = 0;
            while (n3 < n2) {
                this.classArray.add(objectArray[n3]);
                ++n3;
            }
            this.nAllocations = 0;
            this.allocSize = 0;
        }
        this.initialize();
    }

    public MemoryAllocTable(MemoryUseTable memoryUseTable) {
        this(memoryUseTable, null, 0);
    }

    public MemoryAllocTable(MemoryUseTable memoryUseTable, Object[] objectArray) {
        this(memoryUseTable, objectArray, 1);
    }

    private void initialize() {
        4 var1_1 = new 4();
        this.table = new JTable(var1_1);
        this.addMouseListenerToHeaderInTable();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setPreferredWidth((int)((double)tableColumn.getWidth() * 2.0));
        tableColumn = tableColumnModel.getColumn(2);
        tableColumn.setPreferredWidth((int)((double)tableColumn.getWidth() * 0.5));
        tableColumn = tableColumnModel.getColumn(3);
        tableColumn.setPreferredWidth((int)((double)tableColumn.getWidth() * 0.5));
        Dimension dimension = new Dimension(0, 0);
        this.table.setIntercellSpacing(dimension);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        if (this.tableType == 1) {
            this.diffButton = new JButton(ProfArb.getString(125));
            this.enableGenerateDiff();
            this.diffButton.addActionListener(new 3());
            jPanel.add(this.diffButton);
            jPanel.add(new JLabel("  "));
        } else if (this.tableType == 0) {
            JButton jButton = new JButton(ProfArb.getString(124));
            jButton.addActionListener(new 2());
            jPanel.add(jButton);
            jPanel.add(new JLabel("  "));
        }
        JComboBox jComboBox = new JComboBox();
        jPanel.add(new JLabel(ProfArb.getString(126)));
        jPanel.add(jComboBox);
        this.setLayout(new BoxLayout(this, 1));
        this.add(jPanel);
        this.add(new JScrollPane(this.table));
    }

    private void addMouseListenerToHeaderInTable() {
        JTable jTable = this.table;
        jTable.setColumnSelectionAllowed(false);
        1 var2_2 = new 1(this, jTable);
        JTableHeader jTableHeader = jTable.getTableHeader();
        jTableHeader.addMouseListener(var2_2);
    }

    private void SortArray(int n) {
        if (VMClass.compareField == n) {
            VMClass.ascending ^= true;
        } else {
            VMClass.compareField = n;
        }
        Object[] objectArray = this.classArray.toArray();
        Arrays.sort(objectArray);
        int n2 = this.classArray.size();
        this.classArray = new ArrayList(n2);
        int n3 = 0;
        while (n3 < n2) {
            this.classArray.add(objectArray[n3]);
            ++n3;
        }
    }

    private synchronized void generateSnapshot() {
        MemoryAllocTable memoryAllocTable = new MemoryAllocTable(this.parent, this.classArray.toArray());
        memoryAllocTable.title = this.parent.addSnaphotTable(memoryAllocTable);
    }

    public void enableGenerateDiff() {
        this.diffButton.setEnabled(this.parent.getNMemorySnapshots() > 1);
    }

    private synchronized void generateDiff() {
        String[] stringArray = this.parent.getMemorySnapshotNames();
        if (stringArray != null && stringArray.length > 1) {
            int n = stringArray.length;
            String[] stringArray2 = new String[n - 1];
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                if (stringArray[n3].compareTo(this.title) != 0) {
                    stringArray2[n2++] = stringArray[n3];
                }
                ++n3;
            }
            GenerateDiffDialog generateDiffDialog = new GenerateDiffDialog(stringArray2);
            boolean bl = GenerateDiffDialog.runDialog(generateDiffDialog);
            if (bl) {
                String string = generateDiffDialog.getSelected();
                MemoryAllocTable memoryAllocTable = this.parent.getMemorySnapshot(string);
                List list = memoryAllocTable.classArray;
                int n4 = list.size();
                int n5 = this.classArray.size();
                int n6 = Math.max(n5, n4);
                ArrayList<VMClass> arrayList = new ArrayList<VMClass>(n6);
                int n7 = 0;
                while (n7 < n4) {
                    VMClass vMClass = (VMClass)list.get(n7);
                    VMClass vMClass2 = new VMClass();
                    vMClass2.packageName = vMClass.packageName;
                    vMClass2.name = vMClass.name;
                    vMClass2.fileName = vMClass.fileName;
                    int n8 = this.classArray.indexOf(vMClass);
                    if (n8 > -1) {
                        VMClass vMClass3 = (VMClass)this.classArray.get(n8);
                        vMClass2.nAllocations = vMClass.nAllocations - vMClass3.nAllocations;
                        vMClass2.allocSize = vMClass.allocSize - vMClass3.allocSize;
                    } else {
                        vMClass2.nAllocations = vMClass.nAllocations;
                        vMClass2.allocSize = vMClass.allocSize;
                    }
                    if (vMClass2.nAllocations != 0) {
                        arrayList.add(vMClass2);
                    }
                    ++n7;
                }
                int n9 = 0;
                while (n9 < n5) {
                    VMClass vMClass = (VMClass)this.classArray.get(n9);
                    VMClass vMClass4 = new VMClass();
                    vMClass4.packageName = vMClass.packageName;
                    vMClass4.name = vMClass.name;
                    vMClass4.fileName = vMClass.fileName;
                    if (arrayList.indexOf(vMClass) == -1) {
                        int n10 = list.indexOf(vMClass);
                        if (n10 > -1) {
                            VMClass vMClass5 = (VMClass)list.get(n10);
                            vMClass4.nAllocations = vMClass.nAllocations - vMClass5.nAllocations;
                            vMClass4.allocSize = vMClass.allocSize - vMClass5.allocSize;
                        } else {
                            vMClass4.nAllocations = vMClass.nAllocations;
                            vMClass4.allocSize = vMClass.allocSize;
                        }
                        if (vMClass4.nAllocations != 0) {
                            arrayList.add(vMClass4);
                        }
                    }
                    ++n9;
                }
                MemoryAllocTable memoryAllocTable2 = new MemoryAllocTable(this.parent, arrayList.toArray(), 2);
                memoryAllocTable2.title = this.parent.addDiffTable(memoryAllocTable2);
            }
        }
    }

    public void update(VMClass vMClass) {
        if (vMClass.nAllocations == 1) {
            this.classArray.add(vMClass);
        } else {
            int n = this.classArray.indexOf(vMClass);
            this.classArray.set(n, vMClass);
        }
    }

    public void updateList(Object[] objectArray, int n, int n2) {
        Arrays.sort(objectArray);
        int n3 = objectArray.length;
        this.classArray = new ArrayList(n3);
        int n4 = 0;
        while (n4 < n3) {
            this.classArray.add(objectArray[n4]);
            ++n4;
        }
        this.nAllocations = n;
        this.allocSize = n2;
        this.table.tableChanged(new TableModelEvent(this.table.getModel()));
    }

    static List ra$classArray(MemoryAllocTable memoryAllocTable) {
        return memoryAllocTable.classArray;
    }

    static int ra$tableType(MemoryAllocTable memoryAllocTable) {
        return memoryAllocTable.tableType;
    }

    static int ra$nAllocations(MemoryAllocTable memoryAllocTable) {
        return memoryAllocTable.nAllocations;
    }

    static int ra$allocSize(MemoryAllocTable memoryAllocTable) {
        return memoryAllocTable.allocSize;
    }

    static void mav$generateDiff(MemoryAllocTable memoryAllocTable) {
        memoryAllocTable.generateDiff();
    }

    static void mav$generateSnapshot(MemoryAllocTable memoryAllocTable) {
        memoryAllocTable.generateSnapshot();
    }

    static void mav$SortArray(MemoryAllocTable memoryAllocTable, int n) {
        memoryAllocTable.SortArray(n);
    }

    final class 4
    extends AbstractTableModel {
        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            return MemoryAllocTable.ra$classArray(MemoryAllocTable.this).size();
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return PACKAGE_TITLE;
                }
                case 1: {
                    return NAME_TITLE;
                }
                case 2: {
                    return INSTANCES_TITLE;
                }
                case 3: {
                    return SIZE_TITLE;
                }
            }
            return "Error";
        }

        public Object getValueAt(int n, int n2) {
            VMClass vMClass = (VMClass)MemoryAllocTable.ra$classArray(MemoryAllocTable.this).get(n);
            switch (n2) {
                case 0: {
                    return vMClass.packageName;
                }
                case 1: {
                    return vMClass.name;
                }
                case 2: {
                    if (MemoryAllocTable.ra$tableType(MemoryAllocTable.this) != 0) {
                        return new Integer(vMClass.nAllocations);
                    }
                    return new String(new Integer(vMClass.nAllocations) + " (" + new Double((double)vMClass.nAllocations / (double)MemoryAllocTable.ra$nAllocations(MemoryAllocTable.this) * 100.0) + " %)");
                }
                case 3: {
                    if (MemoryAllocTable.ra$tableType(MemoryAllocTable.this) != 0) {
                        return new Long(vMClass.allocSize);
                    }
                    return new String(new Long(vMClass.allocSize) + " (" + new Double((double)vMClass.allocSize / (double)MemoryAllocTable.ra$allocSize(MemoryAllocTable.this) * 100.0) + ")%");
                }
            }
            return vMClass;
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MemoryAllocTable.mav$generateDiff(MemoryAllocTable.this);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MemoryAllocTable.mav$generateSnapshot(MemoryAllocTable.this);
        }
    }

    final class 1
    extends MouseAdapter {
        private final /* synthetic */ JTable v$tableView;
        final /* synthetic */ MemoryAllocTable this$0;

        public void mouseClicked(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = this.v$tableView.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = this.v$tableView.convertColumnIndexToModel(n);
            if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                MemoryAllocTable.mav$SortArray(this.this$0, n2);
            }
        }

        public 1(MemoryAllocTable memoryAllocTable, JTable jTable) {
            this.v$tableView = jTable;
            this.this$0 = memoryAllocTable;
        }
    }
}

