/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurationEditorUtil;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfileConfiguration;

public class MemoryConfigurationPanel
extends DefaultTraversablePanel
implements ChangeListener {
    private JSpinner sliderDepthSpinBoxField;
    private JSpinner memoryIntervalSpinBoxField;
    private JTextField excludedInstances;
    private JTextField includedInstances;
    private JLabel message;
    private JCheckBox manualSamplingCheckBox;
    private final Color messageColor;

    void $init$() {
        this.messageColor = new Color(192, 0, 0);
    }

    public MemoryConfigurationPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.manualSamplingCheckBox.isSelected()) {
            this.memoryIntervalSpinBoxField.setEnabled(false);
        } else {
            this.memoryIntervalSpinBoxField.setEnabled(true);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        ProfileConfiguration profileConfiguration = MemoryConfigurationPanel.getProfileConfiguration(traversableContext);
        this.loadFrom(profileConfiguration);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (!this.checkValues()) {
            throw new TraversalException(this.getErrorMessage());
        }
        ProfileConfiguration profileConfiguration = MemoryConfigurationPanel.getProfileConfiguration(traversableContext);
        this.commitTo(profileConfiguration);
    }

    private static ProfileConfiguration getProfileConfiguration(TraversableContext traversableContext) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)traversableContext);
        return ProfileConfiguration.getInstance(runConfiguration);
    }

    private void loadFrom(ProfileConfiguration profileConfiguration) {
        this.sliderDepthSpinBoxField.setValue(new Integer(profileConfiguration.getSliderDepth()));
        int n = profileConfiguration.getMemoryUpdateInterval();
        if (n != 0) {
            this.manualSamplingCheckBox.setSelected(false);
            this.memoryIntervalSpinBoxField.setEnabled(true);
            this.memoryIntervalSpinBoxField.setValue(new Double((double)profileConfiguration.getMemoryUpdateInterval() / 10.0));
        } else {
            this.manualSamplingCheckBox.setSelected(true);
            this.memoryIntervalSpinBoxField.setEnabled(false);
        }
        String string = profileConfiguration.getExcludedInstances();
        this.excludedInstances.setText(string != null ? string : "");
        string = profileConfiguration.getIncludedInstances();
        this.includedInstances.setText(string != null ? string : "");
    }

    private void commitTo(ProfileConfiguration profileConfiguration) {
        Number number = (Number)this.sliderDepthSpinBoxField.getValue();
        profileConfiguration.setSliderDepth(number.intValue());
        if (this.manualSamplingCheckBox.isSelected()) {
            profileConfiguration.setMemoryUpdateInterval(0);
        } else {
            number = (Number)this.memoryIntervalSpinBoxField.getValue();
            int n = (int)(number.doubleValue() * 10.0);
            profileConfiguration.setMemoryUpdateInterval(n);
        }
        profileConfiguration.setExcludedInstances(this.excludedInstances.getText());
        profileConfiguration.setIncludedInstances(this.includedInstances.getText());
    }

    private void jbInit() throws Exception {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), ProfArb.getString(3));
        this.setLayout(new GridBagLayout());
        this.manualSamplingCheckBox = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.manualSamplingCheckBox, (String)ProfArb.getString(85));
        this.manualSamplingCheckBox.addChangeListener(this);
        JLabel jLabel = new JLabel();
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1.0, 0.5, 100000.0, 0.1);
        this.memoryIntervalSpinBoxField = new JSpinner(spinnerNumberModel);
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.memoryIntervalSpinBoxField, "0.0");
        this.memoryIntervalSpinBoxField.setEditor(numberEditor);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.memoryIntervalSpinBoxField, (String)ProfArb.getString(90));
        JLabel jLabel2 = new JLabel();
        spinnerNumberModel = new SpinnerNumberModel(20, 2, 500, 1);
        this.sliderDepthSpinBoxField = new JSpinner(spinnerNumberModel);
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.sliderDepthSpinBoxField, (String)ProfArb.getString(100));
        JLabel jLabel3 = new JLabel();
        this.includedInstances = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.includedInstances, (String)ProfArb.getString(99));
        JLabel jLabel4 = new JLabel();
        this.excludedInstances = new JTextField();
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.excludedInstances, (String)ProfArb.getString(98));
        this.message = new JLabel(" ");
        this.message.setForeground(this.messageColor);
        int n = 0;
        int n2 = 0;
        this.add(this.manualSamplingCheckBox, new GridBagConstraints(n++, n2, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        n = 0;
        this.add(jLabel, new GridBagConstraints(n++, ++n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.memoryIntervalSpinBoxField, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.add(jLabel2, new GridBagConstraints(n++, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
        this.add(this.sliderDepthSpinBoxField, new GridBagConstraints(n, n2++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.add(jLabel3, new GridBagConstraints(0, n2++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.add(this.includedInstances, new GridBagConstraints(0, n2++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(jLabel4, new GridBagConstraints(0, n2++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.add(this.excludedInstances, new GridBagConstraints(0, n2++, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.message, new GridBagConstraints(0, n2, 0, 1, 1.0, 1.0, 16, 1, new Insets(10, 0, 0, 0), 0, 0));
    }

    private boolean checkValues() {
        return true;
    }

    private String getErrorMessage() {
        return " ";
    }
}

