/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.help.HelpInfo;
import oracle.ide.resource.ControlsArb;
import oracle.ide.util.IntHashMap;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.jdeveloper.runner.Source;
import oracle.jdevimpl.runner.profile.DefaultAllignRenderer;
import oracle.jdevimpl.runner.profile.HTMLSavable;
import oracle.jdevimpl.runner.profile.HeapDetailStat;
import oracle.jdevimpl.runner.profile.JProfiler;
import oracle.jdevimpl.runner.profile.LocationProvider;
import oracle.jdevimpl.runner.profile.MemoryTable;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfWindow;
import oracle.jdevimpl.runner.profile.ProfilerSettings;
import oracle.jdevimpl.runner.profile.ProfilingProcess;
import oracle.jdevimpl.runner.profile.RightAllignRenderer;
import oracle.jdevimpl.runner.profile.UpdatableSettings;
import oracle.jdevimpl.runner.profile.VMClass;
import oracle.jdevimpl.runner.profile.VMMethod;

public final class MemoryDetailTable
extends ProfWindow
implements UpdatableSettings,
HTMLSavable,
LocationProvider {
    private static final int INITIAL_HEAPSTATSIZE = 20;
    private static final String PROFILES_MEMORY_DETAIL_TABLE_ID = "Profiler.MemoryDetailTable";
    private static final int MAX_TABLE_COL = 9;
    private static final int[] _colToIndex = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    private ProfilingProcess process;
    private String title;
    private JPanel mainPanel;
    private IntHashMap methodMap;
    private Map localDetailMap;
    private VMClass clazz;
    private int heapStatSize;
    private int heapStatSizeUsed;
    private HeapDetailStat[] heapStatArray;
    private int compareField;
    private boolean ascending;
    private int currentTableSize;
    private HeapDetailStat[] currentHeapStatArray;
    private HeapDetailStat[][] heapStatArray_Hist;
    private int[] compareField_Hist;
    private boolean[] ascending_Hist;
    private int currentCompareField;
    private boolean currentAscending;
    private int lastHistorySelected;
    private JTable table;
    private JLabel noDataLabel;
    private JScrollPane mainScrollPane;
    private AbstractTableModel tableModel;
    private boolean[] columnShowing;
    private TableColumn[] column;
    heapDetailComparator hcomp;
    int currentSize;
    int maxSize;
    private MethodKey mkey;
    static final String LOCATION_TITLE = ProfArb.getString(218);
    static final String COUNT_TITLE = ProfArb.getString(217);
    static final String SIZE_TITLE = ProfArb.getString(219);
    static final String ALLOC_COUNT_TITLE = ProfArb.getString(220);
    static final String ALLOC_SIZE_TITLE = ProfArb.getString(221);
    static final String FREED_COUNT_TITLE = ProfArb.getString(222);
    static final String FREED_SIZE_TITLE = ProfArb.getString(223);
    static final String DIFF_COUNT_TITLE = ProfArb.getString(224);
    static final String DIFF_SIZE_TITLE = ProfArb.getString(225);
    private static final HelpInfo HELP_TOPIC = new HelpInfo("prf_aanalyze_mem_results.html");
    private static final Icon ARROW_UP = ControlsArb.getIcon((int)2);
    private static final Icon ARROW_DOWN = ControlsArb.getIcon((int)1);

    void $init$() {
        this.columnShowing = new boolean[10];
        this.column = new TableColumn[9];
    }

    public MemoryDetailTable(ProfilingProcess profilingProcess, VMClass vMClass, IntHashMap intHashMap) {
        this.$init$();
        this.hcomp = new heapDetailComparator();
        this.currentCompareField = 2;
        this.currentAscending = false;
        this.setClazz(vMClass);
        this.initValues(profilingProcess, intHashMap);
        this.initialize();
        this.updateSettings();
    }

    private void initValues(ProfilingProcess profilingProcess, IntHashMap intHashMap) {
        this.process = profilingProcess;
        this.methodMap = intHashMap;
        this.heapStatSize = 20;
        this.heapStatSizeUsed = 0;
        this.heapStatArray = new HeapDetailStat[20];
        this.localDetailMap = new HashMap(20);
        this.mkey = new MethodKey(0, 0);
        this.maxSize = this.maxSize = profilingProcess.getSliderDepth();
        this.currentSize = 0;
        this.heapStatArray_Hist = new HeapDetailStat[this.maxSize][];
        this.compareField_Hist = new int[this.maxSize];
        this.ascending_Hist = new boolean[this.maxSize];
    }

    void resetProcess(ProfilingProcess profilingProcess, IntHashMap intHashMap) {
        this.initValues(profilingProcess, intHashMap);
    }

    public Component getGUI() {
        return this.mainPanel;
    }

    public Controller getController() {
        return null;
    }

    public Context getContext(EventObject eventObject) {
        Context context = this.process.getContext();
        context.setView((View)this);
        context.setEvent(eventObject);
        return context;
    }

    public void initialize() {
        this.title = ProfArb.getString(175) + this.process.getRunTitle();
        this.mainPanel = this.createGUI();
    }

    public String getTabName() {
        return ProfArb.getString(175);
    }

    public Icon getTabIcon() {
        return this.process.getIcon();
    }

    public String getTitleName() {
        return this.title;
    }

    public void findSource() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            return;
        }
        HeapDetailStat heapDetailStat = this.currentHeapStatArray[n];
        int n2 = heapDetailStat.getLine();
        if (n2 == -1) {
            return;
        }
        Context context = this.getContext();
        Source.showSourceFile(context.getWorkspace(), context.getProject(), heapDetailStat.getPackage(), null, heapDetailStat.getFileName(), n2, true);
    }

    public boolean canFindSource() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            return false;
        }
        HeapDetailStat heapDetailStat = this.currentHeapStatArray[n];
        int n2 = heapDetailStat.getLine();
        return n2 != -1;
    }

    public void changeSettings() {
        this.process.showSettings();
    }

    public void updateSettings() {
        ProfilerSettings profilerSettings = ProfilerSettings.getInstance();
        boolean[] blArray = profilerSettings.getMemColumnVisible();
        boolean bl = false;
        int n = 0;
        while (n < 9) {
            if (this.columnShowing[_colToIndex[n]] != blArray[_colToIndex[n]]) {
                bl = true;
                this.columnShowing[MemoryDetailTable._colToIndex[n]] = blArray[_colToIndex[n]];
                if (blArray[_colToIndex[n]]) {
                    this.table.addColumn(this.column[n]);
                } else {
                    this.table.removeColumn(this.column[n]);
                }
            }
            ++n;
        }
        if (bl) {
            this.tableModel.fireTableChanged(new TableModelEvent(this.tableModel, 0, this.currentTableSize - 1, -1));
        }
    }

    public void saveToHTML(boolean bl) {
        this.process.saveMemSampleToHTML(bl);
    }

    private JPanel createGUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(ProfArb.getString(248) + " " + this.clazz.toString());
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont(1);
        jLabel.setFont(font2);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.tableModel = new 5();
        this.table = new JTable(this.tableModel);
        this.table.addMouseListener(new 4());
        this.addMouseListenerToHeaderInTable();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = 0;
        while (n < 9) {
            this.column[n] = tableColumnModel.getColumn(n);
            this.columnShowing[MemoryDetailTable._colToIndex[n]] = true;
            ++n;
        }
        DefaultAllignRenderer defaultAllignRenderer = new DefaultAllignRenderer(this.process);
        this.column[0].setPreferredWidth(600);
        this.column[0].setCellRenderer(defaultAllignRenderer);
        RightAllignRenderer rightAllignRenderer = new RightAllignRenderer(this.process);
        int n2 = 1;
        while (n2 < 9) {
            this.column[n2].setPreferredWidth(100);
            this.column[n2].setCellRenderer(rightAllignRenderer);
            ++n2;
        }
        Dimension dimension = new Dimension(0, 0);
        this.table.setIntercellSpacing(dimension);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new 3());
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainScrollPane = new JScrollPane(this.table);
        jPanel.add((Component)this.mainScrollPane, gridBagConstraints);
        this.noDataLabel = new JLabel(ProfArb.getString(318));
        font = this.noDataLabel.getFont();
        font2 = font.deriveFont(1, 20.0f);
        this.noDataLabel.setFont(font2);
        this.noDataLabel.setForeground(Color.red);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.noDataLabel);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    public HelpInfo getHelpInfo() {
        return HELP_TOPIC;
    }

    HeapDetailStat[] checkCapacity(int n) {
        if (n < this.heapStatSize) {
            return this.heapStatArray;
        }
        HeapDetailStat[] heapDetailStatArray = new HeapDetailStat[this.heapStatSize * 2];
        System.arraycopy(this.heapStatArray, 0, heapDetailStatArray, 0, this.heapStatSize);
        this.heapStatSize *= 2;
        return heapDetailStatArray;
    }

    void historySelect(int n) {
        if (n == 0) {
            this.currentTableSize = this.heapStatSizeUsed;
            this.currentHeapStatArray = this.heapStatArray;
            this.mainScrollPane.setVisible(true);
            this.noDataLabel.setVisible(false);
            if (this.currentAscending != this.ascending || this.currentCompareField != this.compareField) {
                this.ascending = this.currentAscending;
                this.compareField = this.currentCompareField;
                Arrays.sort(this.currentHeapStatArray, 0, this.currentTableSize, this.hcomp);
            }
            this.tableModel.fireTableDataChanged();
        } else {
            int n2 = n - 1;
            this.currentHeapStatArray = this.heapStatArray_Hist[n2];
            this.currentTableSize = this.currentHeapStatArray != null ? this.currentHeapStatArray.length : 0;
            if (this.currentTableSize == 0) {
                this.mainScrollPane.setVisible(false);
                this.noDataLabel.setVisible(true);
            } else {
                this.mainScrollPane.setVisible(true);
                this.noDataLabel.setVisible(false);
                if (this.currentAscending != this.ascending_Hist[n2] || this.currentCompareField != this.compareField_Hist[n2]) {
                    this.ascending_Hist[n2] = this.currentAscending;
                    this.compareField_Hist[n2] = this.currentCompareField;
                    Arrays.sort(this.currentHeapStatArray, 0, this.currentTableSize, this.hcomp);
                }
                this.tableModel.fireTableDataChanged();
            }
        }
        this.lastHistorySelected = n;
    }

    int getTableSize(int n) {
        if (n == 0) {
            return this.heapStatSizeUsed;
        }
        int n2 = n - 1;
        if (this.heapStatArray_Hist[n2] != null) {
            return this.heapStatArray_Hist[n2].length;
        }
        return 0;
    }

    HeapDetailStat[] getSampleArray(int n) {
        HeapDetailStat[] heapDetailStatArray = null;
        if (n == 0) {
            heapDetailStatArray = this.heapStatArray;
            if (this.currentAscending != this.ascending || this.currentCompareField != this.compareField) {
                this.ascending = this.currentAscending;
                this.compareField = this.currentCompareField;
                Arrays.sort(heapDetailStatArray, 0, this.currentTableSize, this.hcomp);
            }
        } else {
            int n2 = n - 1;
            heapDetailStatArray = this.heapStatArray_Hist[n2];
            if (heapDetailStatArray != null) {
                if (heapDetailStatArray.length == 0) {
                    heapDetailStatArray = null;
                } else if (this.currentAscending != this.ascending_Hist[n2] || this.currentCompareField != this.compareField_Hist[n2]) {
                    this.ascending_Hist[n2] = this.currentAscending;
                    this.compareField_Hist[n2] = this.currentCompareField;
                    Arrays.sort(heapDetailStatArray, 0, heapDetailStatArray.length, this.hcomp);
                }
            }
        }
        return heapDetailStatArray;
    }

    VMClass getClazz() {
        return this.clazz;
    }

    void setClazz(VMClass vMClass) {
        this.clazz = vMClass;
    }

    private void saveCurrentArray() {
        System.arraycopy(this.heapStatArray_Hist, 0, this.heapStatArray_Hist, 1, this.maxSize - 1);
        System.arraycopy(this.compareField_Hist, 0, this.compareField_Hist, 1, this.maxSize - 1);
        System.arraycopy(this.ascending_Hist, 0, this.ascending_Hist, 1, this.maxSize - 1);
        this.heapStatArray_Hist[0] = new HeapDetailStat[this.heapStatSizeUsed];
        this.compareField_Hist[0] = this.currentCompareField;
        this.ascending_Hist[0] = this.currentAscending;
        HeapDetailStat[] heapDetailStatArray = this.heapStatArray_Hist[0];
        HeapDetailStat[] heapDetailStatArray2 = this.heapStatArray;
        int n = 0;
        while (n < heapDetailStatArray.length) {
            heapDetailStatArray[n] = new HeapDetailStat(heapDetailStatArray2[n]);
            ++n;
        }
    }

    void setDataAtPosition(int n, HeapDetailStat[] heapDetailStatArray) {
        if (n == 0) {
            this.heapStatSizeUsed = heapDetailStatArray.length;
            this.heapStatArray = heapDetailStatArray;
        } else {
            this.heapStatArray_Hist[--n] = heapDetailStatArray;
            this.compareField_Hist[n] = -1;
        }
    }

    void setCurrentSize(int n) {
        this.currentSize = n;
    }

    void startUpdate() {
        this.saveCurrentArray();
        HeapDetailStat[] heapDetailStatArray = this.heapStatArray;
        int n = this.heapStatSizeUsed;
        int n2 = 0;
        while (n2 < n) {
            heapDetailStatArray[n2].clearDiffs();
            ++n2;
        }
        if (this.currentSize < this.maxSize - 1) {
            ++this.currentSize;
        }
    }

    void clearValues() {
        HeapDetailStat[] heapDetailStatArray = this.heapStatArray;
        int n = this.heapStatSizeUsed;
        int n2 = 0;
        while (n2 < n) {
            heapDetailStatArray[n2].clearValues();
            ++n2;
        }
    }

    void addOrUpdateHeapData(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        MethodKey methodKey = this.mkey;
        methodKey.m = n;
        methodKey.ln = n2;
        HeapDetailStat heapDetailStat = (HeapDetailStat)this.localDetailMap.get(methodKey);
        if (heapDetailStat == null) {
            VMMethod vMMethod = (VMMethod)this.methodMap.get(n);
            heapDetailStat = new HeapDetailStat(vMMethod, n2, n3, n5, n7, n4, n6, n8);
            methodKey = new MethodKey(n, n2);
            this.localDetailMap.put(methodKey, heapDetailStat);
            int n9 = this.heapStatSizeUsed;
            HeapDetailStat[] heapDetailStatArray = this.checkCapacity(n9);
            heapDetailStatArray[n9] = heapDetailStat;
            this.heapStatArray = heapDetailStatArray;
            this.heapStatSizeUsed = ++n9;
            return;
        }
        heapDetailStat.update(n3, n5, n7, n4, n6, n8);
    }

    void endUpdate() {
        this.compareField = -1;
        this.historySelect(0);
    }

    private String toolTipFromCol(int n) {
        switch (n) {
            case 0: {
                return ProfArb.getString(228);
            }
            case 1: {
                return ProfArb.getString(227);
            }
            case 2: {
                return ProfArb.getString(229);
            }
            case 3: {
                return ProfArb.getString(230);
            }
            case 4: {
                return ProfArb.getString(231);
            }
            case 5: {
                return ProfArb.getString(232);
            }
            case 6: {
                return ProfArb.getString(233);
            }
            case 7: {
                return ProfArb.getString(234);
            }
            case 8: {
                return ProfArb.getString(235);
            }
        }
        return "";
    }

    private void addMouseListenerToHeaderInTable() {
        JTable jTable = this.table;
        jTable.setColumnSelectionAllowed(false);
        2 var2_2 = new 2(this, jTable);
        1 var3_3 = new 1();
        var3_3.setHorizontalAlignment(0);
        JTableHeader jTableHeader = jTable.getTableHeader();
        jTableHeader.addMouseListener(var2_2);
        jTableHeader.setDefaultRenderer(var3_3);
    }

    private void switchSort(int n) {
        if (this.currentCompareField == n) {
            this.currentAscending ^= true;
        } else {
            this.currentCompareField = n;
        }
        this.table.getTableHeader().repaint();
    }

    public void loadLayout(PropertyAccess propertyAccess) {
    }

    public void saveLayout(PropertyAccess propertyAccess) {
    }

    public int getType() {
        return 1;
    }

    public void stateChange(int n) {
        switch (n) {
            case 3: {
                this.process.stopMethodDetails(this.clazz);
                this.currentHeapStatArray = null;
                this.heapStatArray = null;
                this.heapStatArray_Hist = null;
                this.methodMap = null;
                this.localDetailMap = null;
            }
        }
        super.stateChange(n);
    }

    static HeapDetailStat[] ra$currentHeapStatArray(MemoryDetailTable memoryDetailTable) {
        return memoryDetailTable.currentHeapStatArray;
    }

    static int ra$currentTableSize(MemoryDetailTable memoryDetailTable) {
        return memoryDetailTable.currentTableSize;
    }

    static void mav$switchSort(MemoryDetailTable memoryDetailTable, int n) {
        memoryDetailTable.switchSort(n);
    }

    static int ra$lastHistorySelected(MemoryDetailTable memoryDetailTable) {
        return memoryDetailTable.lastHistorySelected;
    }

    static int ra$currentCompareField(MemoryDetailTable memoryDetailTable) {
        return memoryDetailTable.currentCompareField;
    }

    static boolean ra$currentAscending(MemoryDetailTable memoryDetailTable) {
        return memoryDetailTable.currentAscending;
    }

    static Icon ra$ARROW_UP() {
        return ARROW_UP;
    }

    static Icon ra$ARROW_DOWN() {
        return ARROW_DOWN;
    }

    static ProfilingProcess ra$process(MemoryDetailTable memoryDetailTable) {
        return memoryDetailTable.process;
    }

    static String mav$toolTipFromCol(MemoryDetailTable memoryDetailTable, int n) {
        return memoryDetailTable.toolTipFromCol(n);
    }

    public final class 5
    extends AbstractTableModel {
        public int getColumnCount() {
            return 9;
        }

        public int getRowCount() {
            return MemoryDetailTable.ra$currentTableSize(MemoryDetailTable.this);
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return LOCATION_TITLE;
                }
                case 1: {
                    return COUNT_TITLE;
                }
                case 2: {
                    return SIZE_TITLE;
                }
                case 3: {
                    return ALLOC_COUNT_TITLE;
                }
                case 4: {
                    return ALLOC_SIZE_TITLE;
                }
                case 5: {
                    return FREED_COUNT_TITLE;
                }
                case 6: {
                    return FREED_SIZE_TITLE;
                }
                case 7: {
                    return DIFF_COUNT_TITLE;
                }
                case 8: {
                    return DIFF_SIZE_TITLE;
                }
            }
            return "Error";
        }

        public Object getValueAt(int n, int n2) {
            HeapDetailStat heapDetailStat = MemoryDetailTable.ra$currentHeapStatArray(MemoryDetailTable.this)[n];
            switch (n2) {
                case 0: {
                    return heapDetailStat.getName();
                }
                case 1: {
                    return String.valueOf(heapDetailStat.nb);
                }
                case 2: {
                    return MemoryTable.numberFormat.format(heapDetailStat.size);
                }
                case 3: {
                    return String.valueOf(heapDetailStat.nballoc);
                }
                case 4: {
                    return MemoryTable.numberFormat.format(heapDetailStat.sizealloc);
                }
                case 5: {
                    return String.valueOf(heapDetailStat.nbfreed);
                }
                case 6: {
                    return MemoryTable.numberFormat.format(heapDetailStat.sizefreed);
                }
                case 7: {
                    return String.valueOf(heapDetailStat.getNbDiff());
                }
                case 8: {
                    return MemoryTable.numberFormat.format(heapDetailStat.getSizeDiff());
                }
            }
            return "Error";
        }
    }

    public final class 4
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                Context context = MemoryDetailTable.this.getContext(mouseEvent);
                JProfiler.contextMenu.show(context);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                MemoryDetailTable.this.findSource();
            }
        }
    }

    public final class 3
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.isSelectionEmpty()) {
                int n = listSelectionModel.getMinSelectionIndex();
            }
        }
    }

    public static class MethodKey {
        int m;
        int ln;

        public MethodKey(int n, int n2) {
            this.m = n;
            this.ln = n2;
        }

        public boolean equals(Object object) {
            MethodKey methodKey = (MethodKey)object;
            return methodKey.m == this.m && methodKey.ln == this.ln;
        }

        public int hashCode() {
            return this.m + this.ln;
        }
    }

    public final class 2
    extends MouseAdapter {
        private final /* synthetic */ JTable v$tableView;
        final /* synthetic */ MemoryDetailTable this$0;

        public void mouseClicked(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = this.v$tableView.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = this.v$tableView.convertColumnIndexToModel(n);
            if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                MemoryDetailTable.mav$switchSort(this.this$0, n2);
                this.this$0.historySelect(MemoryDetailTable.ra$lastHistorySelected(this.this$0));
            }
        }

        public 2(MemoryDetailTable memoryDetailTable, JTable jTable) {
            this.v$tableView = jTable;
            this.this$0 = memoryDetailTable;
        }
    }

    public final class 1
    extends DefaultTableCellRenderer {
        private int _col;

        public String getToolTipText(MouseEvent mouseEvent) {
            if (MemoryDetailTable.ra$process(MemoryDetailTable.this).isPopupActive()) {
                return null;
            }
            return MemoryDetailTable.mav$toolTipFromCol(MemoryDetailTable.this, this._col);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3;
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
            }
            this._col = n3 = jTable.convertColumnIndexToModel(n2);
            if (n3 == MemoryDetailTable.ra$currentCompareField(MemoryDetailTable.this)) {
                if (MemoryDetailTable.ra$currentAscending(MemoryDetailTable.this)) {
                    this.setIcon(MemoryDetailTable.ra$ARROW_UP());
                } else {
                    this.setIcon(MemoryDetailTable.ra$ARROW_DOWN());
                }
            } else {
                this.setIcon(null);
            }
            this.setText((String)object);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    public class heapDetailComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n;
            HeapDetailStat heapDetailStat = (HeapDetailStat)object;
            HeapDetailStat heapDetailStat2 = (HeapDetailStat)object2;
            switch (MemoryDetailTable.ra$currentCompareField(MemoryDetailTable.this)) {
                default: {
                    n = heapDetailStat.getName().compareTo(heapDetailStat2.getName());
                    break;
                }
                case 1: {
                    n = heapDetailStat.nb - heapDetailStat2.nb;
                    break;
                }
                case 2: {
                    n = heapDetailStat.size - heapDetailStat2.size;
                    break;
                }
                case 3: {
                    n = heapDetailStat.nballoc - heapDetailStat2.nballoc;
                    break;
                }
                case 4: {
                    n = heapDetailStat.sizealloc - heapDetailStat2.sizealloc;
                    break;
                }
                case 5: {
                    n = heapDetailStat.nbfreed - heapDetailStat2.nbfreed;
                    break;
                }
                case 6: {
                    n = heapDetailStat.sizefreed - heapDetailStat2.sizefreed;
                    break;
                }
                case 7: {
                    n = heapDetailStat.getNbDiff() - heapDetailStat2.getNbDiff();
                    break;
                }
                case 8: {
                    n = heapDetailStat.getSizeDiff() - heapDetailStat2.getSizeDiff();
                }
            }
            if (!MemoryDetailTable.ra$currentAscending(MemoryDetailTable.this)) {
                n = 0 - n;
            }
            return n;
        }

        heapDetailComparator() {
        }
    }
}

