/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import oracle.javatools.util.SwingUtils;
import oracle.jdevimpl.runner.profile.ProfArb;

class MemoryGraph
extends JPanel
implements Runnable {
    private static final String memAvailStr = ProfArb.getString(105);
    private static final String memUsedStr = ProfArb.getString(106);
    private static final float blockWidth = 20.0f;
    private static final int maxMonitorAmount = 300;
    private static final Color graphColor = new Color(10, 100, 50);
    private static final Font font = new Font("Times New Roman", 0, 11);
    private boolean started;
    public Thread thread;
    private int sleepAmount;
    private int timeDelta;
    private int monitorAmount;
    private int width;
    private int height;
    private BufferedImage bimg;
    private Graphics2D bmp;
    private int columnInc;
    private int ptNum;
    private int[] pts;
    private boolean[] gcs;
    private int[] mms;
    private int[] ptPoints;
    private int[] mmPoints;
    private int ascent;
    private int descent;
    private float graphH;
    private int graphY;
    private final int nGaugeBlocks;
    private boolean gcOccurred;
    private float maxMemory;
    private float totalMemory;
    private float usedMemory;
    private float freeMemory;

    void $init$() {
        this.sleepAmount = 1000;
        this.timeDelta = 1;
        this.nGaugeBlocks = 20;
    }

    public MemoryGraph() {
        this.$init$();
        this.setBackground(Color.black);
        this.gcOccurred = false;
        this.started = false;
        this.monitorAmount = 60;
        this.pts = new int[300];
        this.gcs = new boolean[300];
        this.mms = new int[300];
        this.ptPoints = new int[300];
        this.mmPoints = new int[300];
        this.ptNum = 0;
    }

    public synchronized void gcOccurred() {
        this.gcOccurred = true;
    }

    public synchronized void gcUpdate(int n, int n2) {
        this.setUsedMemory(n);
        this.setTotalMemory(n2);
        this.freeMemory = this.totalMemory - this.usedMemory;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.thread.setName("MemoryMonitor");
        this.thread.start();
    }

    public synchronized void stop() {
        this.sleepAmount = -1;
        this.thread = null;
        this.notify();
    }

    public synchronized void setSleepAmount(int n) {
        this.sleepAmount = n;
        this.timeDelta = n / 1000;
        this.update();
        this.repaint();
    }

    public synchronized void setTotalMemory(int n) {
        this.totalMemory = n;
        if (this.totalMemory > this.maxMemory) {
            this.maxMemory = this.totalMemory;
            this.recalcPoints();
        }
    }

    public synchronized void setUsedMemory(int n) {
        this.usedMemory = n;
    }

    public synchronized void setMonitorAmount(int n) {
        this.monitorAmount = n * 60;
        this.update();
        this.repaint();
    }

    private void recalcPoints() {
        int n = 0;
        while (n < this.ptNum) {
            this.ptPoints[n] = (int)((float)this.graphY + (this.graphH - this.graphH * ((float)this.pts[n] / this.maxMemory)));
            this.mmPoints[n] = (int)((float)this.graphY + (this.graphH - this.graphH * ((float)this.mms[n] / this.maxMemory)));
            ++n;
        }
    }

    private synchronized void updatePoints() {
        this.pts[this.ptNum] = (int)this.usedMemory;
        this.gcs[this.ptNum] = this.gcOccurred;
        this.gcOccurred = false;
        this.mms[this.ptNum] = (int)this.totalMemory;
        this.ptPoints[this.ptNum] = (int)((float)this.graphY + (this.graphH - this.graphH * (this.usedMemory / this.maxMemory)));
        this.mmPoints[this.ptNum] = (int)((float)this.graphY + (this.graphH - this.graphH * (this.totalMemory / this.maxMemory)));
        if (this.ptNum + 2 >= 300) {
            int n = 1;
            while (n < this.ptNum) {
                this.pts[n - 1] = this.pts[n];
                this.gcs[n - 1] = this.gcs[n];
                this.mms[n - 1] = this.mms[n];
                this.ptPoints[n - 1] = this.ptPoints[n];
                this.mmPoints[n - 1] = this.mmPoints[n];
                ++n;
            }
            --this.ptNum;
        } else {
            ++this.ptNum;
        }
    }

    private synchronized void update() {
        int n;
        this.bmp.clearRect(0, 0, this.width, this.height);
        this.bmp.setColor(Color.green);
        SwingUtils.drawString((Graphics2D)this.bmp, (String)(String.valueOf((int)this.totalMemory / 1024) + memAvailStr), (float)4.0f, (float)((float)this.ascent + 0.5f));
        SwingUtils.drawString((Graphics)this.bmp, (String)(String.valueOf((int)this.usedMemory / 1024) + memUsedStr), (int)4, (int)(this.height - this.descent));
        float f = this.ascent + this.descent;
        float f2 = (float)this.height - f * 2.0f - 0.5f;
        float f3 = f2 / 20.0f;
        float f4 = (float)this.width - 20.0f - 10.0f;
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        this.bmp.setColor(Color.red);
        int n2 = (int)(this.freeMemory / this.totalMemory * 20.0f);
        int n3 = 0;
        while (n3 < n2) {
            ((Rectangle2D)float_).setRect(5.0, f + (float)n3 * f3, 20.0, f3 - 1.0f);
            this.bmp.fill(float_);
            ++n3;
        }
        this.bmp.setColor(Color.green);
        while (n3 < 20) {
            ((Rectangle2D)float_).setRect(5.0, f + (float)n3 * f3, 20.0, f3 - 1.0f);
            this.bmp.fill(float_);
            ++n3;
        }
        this.bmp.setColor(graphColor);
        int n4 = 30;
        this.graphY = (int)f;
        int n5 = this.width - n4 - 5;
        this.bmp.drawRect(n4, this.graphY, n5, (int)this.graphH);
        int n6 = (int)this.graphH / 10;
        int n7 = this.graphY;
        while ((float)n7 <= this.graphH + (float)this.graphY) {
            this.bmp.drawLine(n4, n7, n4 + n5, n7);
            n7 += n6;
        }
        int n8 = this.ptNum / this.timeDelta;
        int n9 = n5 / this.monitorAmount;
        int n10 = n = n9 * 10;
        if (this.columnInc <= 0) {
            this.columnInc = n10;
        }
        int n11 = n4 + this.columnInc;
        while (n11 < n5 + n4) {
            this.bmp.drawLine(n11, this.graphY, n11, this.graphY + (int)this.graphH);
            n11 += n10;
        }
        this.columnInc -= n9 * this.timeDelta;
        int n12 = this.mms[1];
        int n13 = n4 + n5 - this.ptNum;
        int n14 = Math.max(this.ptNum - this.monitorAmount, 0);
        int n15 = Math.max(n4, n4 + n5 - n8 * (n9 *= this.timeDelta));
        int n16 = n14;
        while (n16 < this.ptNum) {
            int n17 = Math.min(n15 + n9, n4 + n5);
            int n18 = this.mmPoints[n16];
            this.bmp.setColor(Color.white);
            this.bmp.drawLine(n15, n18, n17, n18);
            if (n16 >= this.timeDelta) {
                if (this.mms[n16 - this.timeDelta] != this.mms[n16]) {
                    int n19 = this.mmPoints[n16 - this.timeDelta];
                    int n20 = this.mmPoints[n16];
                    this.bmp.setColor(Color.white);
                    this.bmp.drawLine(n15, n19, n15, n20);
                }
                boolean bl = false;
                int n21 = n16 - this.timeDelta;
                while (n21 < n16) {
                    if (this.gcs[n21]) {
                        bl = true;
                        break;
                    }
                    ++n21;
                }
                if (bl) {
                    this.bmp.setColor(Color.red);
                    this.bmp.drawLine(n15, this.graphY, n15, (int)((float)this.graphY + this.graphH));
                }
                this.bmp.setColor(Color.yellow);
                int n22 = this.ptPoints[n16 - this.timeDelta];
                int n23 = this.ptPoints[n16];
                this.bmp.drawLine(n15, n22, n17, n23);
            } else {
                this.bmp.setColor(Color.yellow);
                int n24 = this.ptPoints[n16];
                this.bmp.drawLine(n15, n24, n17, n24);
            }
            n16 += this.timeDelta;
            n15 += n9;
        }
        if (n15 < n4 + n5) {
            n16 = this.ptPoints[n16 - this.timeDelta];
            this.bmp.drawLine(n15, n16, n4 + n5, n16);
        }
    }

    public void paint(Graphics graphics) {
        if (!this.started || this.bmp == null) {
            return;
        }
        graphics.drawImage(this.bimg, 0, 0, this);
    }

    private synchronized void resized() {
        Dimension dimension = this.getSize();
        if (dimension.width != this.width || dimension.height != this.height) {
            this.width = dimension.width;
            if (dimension.height != this.height) {
                this.height = dimension.height;
                this.graphH = (float)(this.height - this.graphY * 2) - 0.5f;
                this.recalcPoints();
            }
            this.bimg = (BufferedImage)this.createImage(this.width, this.height);
            if (this.bimg != null) {
                this.bmp = this.bimg.createGraphics();
                if (this.bmp != null) {
                    this.bmp.setFont(font);
                    this.bmp.setBackground(this.getBackground());
                    this.update();
                    this.repaint();
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public void run() {
        this.started = true;
        do {
            this.resized();
            if (this.bimg != null) continue;
            try {
                Thread.sleep(100);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (this.bimg == null);
        FontMetrics fontMetrics = this.bmp.getFontMetrics();
        this.ascent = fontMetrics.getAscent();
        this.descent = fontMetrics.getDescent();
        this.graphY = this.ascent + this.descent;
        this.graphH = (float)(this.height - this.graphY * 2) - 0.5f;
        this.addComponentListener(new 1());
        block5: while (true) {
            if (this.height > 50 && this.width > 50) {
                this.update();
                this.repaint();
            }
            if (this.sleepAmount < 0) {
                return;
            }
            int n = 0;
            while (true) {
                if (n >= this.sleepAmount) continue block5;
                Thread.sleep(1000L);
                this.updatePoints();
                n += 1000;
            }
            break;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    static void mav$resized(MemoryGraph memoryGraph) {
        memoryGraph.resized();
    }

    final class 1
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            MemoryGraph.mav$resized(MemoryGraph.this);
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }
    }
}

