/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.docking.DockableWindow;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.jdevimpl.runner.profile.MemoryGraph;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfilingProcess;

public class MemoryMonitor
extends DockableWindow {
    static final String PROFILER_WINDOW_ID = "ProfilerGCGraph";
    private Project project;
    private String title;
    private MemoryGraph graph;
    private JScrollPane scrollPane;
    private ProfilingProcess process;

    public MemoryMonitor(ProfilingProcess profilingProcess) {
        super(PROFILER_WINDOW_ID);
        this.process = profilingProcess;
        this.project = profilingProcess.getJProject();
        this.setType(32);
        this.initialize();
    }

    public Component getGUI() {
        return this.scrollPane;
    }

    public Controller getController() {
        return null;
    }

    public Context getContext(EventObject eventObject) {
        Context context = Context.newIdeContext((Node)this.project);
        context.setView((View)this);
        return context;
    }

    public void initialize() {
        this.title = ProfArb.getString(101) + this.process.getRunTitle();
        this.scrollPane = this.createGUI();
        this.graph.start();
    }

    public String getTabName() {
        return this.title;
    }

    public String getTitleName() {
        return this.title;
    }

    private JScrollPane createGUI() {
        this.graph = new MemoryGraph();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), ProfArb.getString(101)));
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.graph);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        String[] stringArray = new String[]{"1", "5", "10", "30", "60"};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedIndex(0);
        jComboBox.addActionListener(new 3());
        jPanel2.add(new JLabel(ProfArb.getString(102)));
        jPanel2.add(jComboBox);
        String[] stringArray2 = new String[]{"1", "2", "3", "4", "5"};
        JComboBox<String> jComboBox2 = new JComboBox<String>(stringArray2);
        jComboBox2.setSelectedIndex(0);
        jComboBox2.addActionListener(new 2());
        jPanel2.add(new JLabel(ProfArb.getString(103)));
        jPanel2.add(jComboBox2);
        JButton jButton = new JButton(ProfArb.getString(104));
        jButton.addActionListener(new 1());
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        return new JScrollPane(jPanel);
    }

    public void GCInit(int n) {
        this.graph.setTotalMemory(n);
    }

    public void GCUpdate(int n, int n2) {
        this.graph.gcUpdate(n, n2);
    }

    public void GCStart() {
    }

    public void GCEnd(int n, int n2) {
        this.graph.gcOccurred();
        this.graph.setTotalMemory(n2);
        this.graph.setUsedMemory(n);
    }

    public void GCAlloc(int n, int n2) {
        this.graph.setUsedMemory(n2);
    }

    public void stop() {
        if (this.graph != null) {
            this.graph.stop();
        }
    }

    public void loadLayout(PropertyAccess propertyAccess) {
    }

    public void saveLayout(PropertyAccess propertyAccess) {
    }

    static MemoryGraph ra$graph(MemoryMonitor memoryMonitor) {
        return memoryMonitor.graph;
    }

    static ProfilingProcess ra$process(MemoryMonitor memoryMonitor) {
        return memoryMonitor.process;
    }

    public final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            String string = (String)jComboBox.getSelectedItem();
            MemoryMonitor.ra$graph(MemoryMonitor.this).setSleepAmount(Integer.parseInt(string) * 1000);
        }
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            String string = (String)jComboBox.getSelectedItem();
            MemoryMonitor.ra$graph(MemoryMonitor.this).setMonitorAmount(Integer.parseInt(string));
        }
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MemoryMonitor.ra$process(MemoryMonitor.this).performGC();
        }
    }
}

