/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.config.DTCache;
import oracle.ide.controller.Controller;
import oracle.ide.help.HelpInfo;
import oracle.ide.resource.ControlsArb;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.IntHashMap;
import oracle.ide.view.View;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.profile.DefaultAllignRenderer;
import oracle.jdevimpl.runner.profile.FileSavable;
import oracle.jdevimpl.runner.profile.FileSaver;
import oracle.jdevimpl.runner.profile.HTMLSavable;
import oracle.jdevimpl.runner.profile.HeapDetailStat;
import oracle.jdevimpl.runner.profile.HeapStat;
import oracle.jdevimpl.runner.profile.JProfiler;
import oracle.jdevimpl.runner.profile.MemoryDetailTable;
import oracle.jdevimpl.runner.profile.PatternError;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfWindow;
import oracle.jdevimpl.runner.profile.ProfilerSettings;
import oracle.jdevimpl.runner.profile.ProfilingProcess;
import oracle.jdevimpl.runner.profile.RightAllignRenderer;
import oracle.jdevimpl.runner.profile.UpdatableSettings;
import oracle.jdevimpl.runner.profile.VMClass;
import oracle.jdevimpl.runner.profile.Wild;
import oracle.jdevimpl.runner.run.RunArb;

public final class MemoryTable
extends ProfWindow
implements FileSavable,
UpdatableSettings,
HTMLSavable,
ActionListener {
    static final DecimalFormat numberFormat = new DecimalFormat("#,##0");
    static final String SAVED_FILTER_KEY = "MemoryTable.SAVED_FILTER_KEY";
    static final int MAX_SAVED_FILTERS = 10;
    public static final int MAX_COLUMNS = 10;
    public static final int COL_CLASS = 0;
    public static final int COL_LOC = 1;
    public static final int COL_NB = 2;
    public static final int COL_SIZE = 3;
    public static final int COL_NB_ALLOC = 4;
    public static final int COL_ALLOC = 5;
    public static final int COL_NB_FREED = 6;
    public static final int COL_FREED = 7;
    public static final int COL_NB_DIFF = 8;
    public static final int COL_DIFF = 9;
    private static final int INITIAL_HEAPSTATSIZE = 20;
    private static final int MAX_TABLE_COL = 9;
    private static final int[] _colToIndex = new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9};
    private ProfilingProcess process;
    private String title;
    private JPanel mainPanel;
    private IntHashMap classMap;
    private IntHashMap localClassMap;
    private int heapStatSize;
    private int heapStatSizeUsed;
    private HeapStat[] heapStatArray;
    private int compareField;
    private boolean ascending;
    private HeapDetailStat totals;
    private int currentTableSize;
    private HeapStat[] currentHeapStatArray;
    private HeapDetailStat currentTotals;
    private HeapStat[][] heapStatArray_Hist;
    private HeapDetailStat[] totals_Hist;
    private int[] compareField_Hist;
    private boolean[] ascending_Hist;
    private int currentCompareField;
    private boolean currentAscending;
    private JTable table;
    private JLabel sampleLabel;
    private JSlider slider;
    private JButton sliderUp;
    private JButton sliderDown;
    private JButton buttonRestart;
    private JButton buttonSnapshot;
    private JButton buttonTerminate;
    private JButton buttonRun;
    private JButton buttonPause;
    private AbstractTableModel tableModel;
    private boolean[] columnShowing;
    private TableColumn[] column;
    heapComparator hcomp;
    private int currentSize;
    private int maxSize;
    private int totalSample;
    private String filterString;
    private Wild filterMatcher;
    static final JLabel ON_LABEL = new JLabel(DbgArb.getIcon(401));
    static final JLabel OFF_LABEL = new JLabel(DbgArb.getIcon(400));
    static final String CLASS_NAME_TITLE = ProfArb.getString(216);
    static final String COUNT_TITLE = ProfArb.getString(217);
    static final String SIZE_TITLE = ProfArb.getString(219);
    static final String ALLOC_COUNT_TITLE = ProfArb.getString(220);
    static final String ALLOC_SIZE_TITLE = ProfArb.getString(221);
    static final String FREED_COUNT_TITLE = ProfArb.getString(222);
    static final String FREED_SIZE_TITLE = ProfArb.getString(223);
    static final String DIFF_COUNT_TITLE = ProfArb.getString(224);
    static final String DIFF_SIZE_TITLE = ProfArb.getString(225);
    private static final HelpInfo HELP_TOPIC = new HelpInfo(ProfArb.getString(4));
    private static final Icon ARROW_UP = ControlsArb.getIcon((int)2);
    private static final Icon ARROW_DOWN = ControlsArb.getIcon((int)1);

    void $init$() {
        this.columnShowing = new boolean[10];
        this.column = new TableColumn[9];
        this.filterString = "";
        this.filterMatcher = new Wild();
    }

    public MemoryTable(ProfilingProcess profilingProcess, IntHashMap intHashMap) {
        this.$init$();
        this.hcomp = new heapComparator();
        this.currentCompareField = 2;
        this.currentAscending = false;
        this.initValues(profilingProcess, intHashMap);
        this.initialize();
    }

    public void saveToFile() {
        FileSaver fileSaver = new FileSaver(this);
        fileSaver.save(this.getContext());
    }

    public void saveToFile(DataOutputStream dataOutputStream) throws IOException {
        HeapStat[] heapStatArray;
        dataOutputStream.writeInt(2);
        this.process.saveMapsToFile(dataOutputStream);
        dataOutputStream.writeInt(this.totalSample);
        int n = 0;
        while ((heapStatArray = this.getSampleArray(++n)) != null) {
        }
        if (n > this.maxSize) {
            n = this.maxSize;
        }
        dataOutputStream.writeInt(n);
        int n2 = n;
        do {
            this.saveOneSampleTable(dataOutputStream, --n2);
        } while (n2 != 0);
    }

    void saveOneSampleTable(DataOutputStream dataOutputStream, int n) throws IOException {
        this.getSampleTotals(n).saveToFile(dataOutputStream);
        int n2 = this.getTableSize(n);
        HeapStat[] heapStatArray = this.getSampleArray(n);
        dataOutputStream.writeInt(n2);
        int n3 = 0;
        while (n3 < n2) {
            heapStatArray[n3].saveToFile(dataOutputStream);
            ++n3;
        }
        int n4 = 0;
        Iterator iterator = this.process.getMemoryDetailTableIterator();
        while (iterator.hasNext()) {
            MemoryDetailTable memoryDetailTable = (MemoryDetailTable)iterator.next();
            HeapDetailStat[] heapDetailStatArray = memoryDetailTable.getSampleArray(n);
            if (heapDetailStatArray == null) continue;
            ++n4;
        }
        dataOutputStream.writeInt(n4);
        if (n4 != 0) {
            iterator = this.process.getMemoryDetailTableIterator();
            while (iterator.hasNext()) {
                MemoryDetailTable memoryDetailTable = (MemoryDetailTable)iterator.next();
                HeapDetailStat[] heapDetailStatArray = memoryDetailTable.getSampleArray(n);
                if (heapDetailStatArray == null) continue;
                dataOutputStream.writeInt(memoryDetailTable.getClazz().classDescriptor);
                n2 = memoryDetailTable.getTableSize(n);
                dataOutputStream.writeInt(n2);
                n3 = 0;
                while (n3 < n2) {
                    heapDetailStatArray[n3].saveToFile(dataOutputStream);
                    ++n3;
                }
            }
        }
    }

    void initValues(ProfilingProcess profilingProcess, IntHashMap intHashMap) {
        this.process = profilingProcess;
        this.classMap = intHashMap;
        this.heapStatSize = 20;
        this.heapStatSizeUsed = 0;
        this.heapStatArray = new HeapStat[20];
        this.localClassMap = new IntHashMap(20);
        this.totals = new HeapDetailStat(null, 0, 0, 0, 0, 0, 0, 0);
        this.maxSize = profilingProcess.getSliderDepth();
        this.currentSize = 0;
        this.totalSample = 0;
        this.heapStatArray_Hist = new HeapStat[this.maxSize][];
        this.totals_Hist = new HeapDetailStat[this.maxSize];
        this.compareField_Hist = new int[this.maxSize];
        this.ascending_Hist = new boolean[this.maxSize];
    }

    public void resetProcess(ProfilingProcess profilingProcess, IntHashMap intHashMap) {
        this.initValues(profilingProcess, intHashMap);
        this.buttonRestart.setEnabled(true);
        this.buttonSnapshot.setEnabled(true);
        this.buttonTerminate.setEnabled(true);
        this.buttonRun.setEnabled(false);
        this.buttonPause.setEnabled(true);
        this.slider.setValue(this.currentSize);
        if (this.slider.getMaximum() != this.maxSize - 1) {
            this.slider.setMaximum(this.maxSize - 1);
        }
    }

    public Component getGUI() {
        return this.mainPanel;
    }

    public Controller getController() {
        return null;
    }

    public Context getContext(EventObject eventObject) {
        Context context = this.process.getContext();
        context.setView((View)this);
        context.setEvent(eventObject);
        return context;
    }

    public void initialize() {
        this.title = ProfArb.getString(174) + this.process.getRunTitle();
        this.mainPanel = this.createGUI();
        this.updateSettings();
    }

    public String getTabName() {
        return this.process.getTabName();
    }

    public Icon getTabIcon() {
        return this.process.getIcon();
    }

    public String getTitleName() {
        return this.title;
    }

    void showDetail() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            return;
        }
        HeapStat heapStat = this.currentHeapStatArray[n];
        if (heapStat.getClassDesc() != 0) {
            this.slider.setValue(this.currentSize);
            this.process.askMethodDetails(heapStat);
        }
    }

    boolean canShowDetail() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            return false;
        }
        if (!this.process.isProcessActive()) {
            return false;
        }
        HeapStat heapStat = this.currentHeapStatArray[n];
        return heapStat.getClassDesc() != 0;
    }

    public void changeSettings() {
        this.process.showSettings();
    }

    public void updateSettings() {
        ProfilerSettings profilerSettings = ProfilerSettings.getInstance();
        boolean[] blArray = profilerSettings.getMemColumnVisible();
        boolean bl = false;
        int n = 0;
        while (n < 9) {
            if (this.columnShowing[_colToIndex[n]] != blArray[_colToIndex[n]]) {
                bl = true;
                this.columnShowing[MemoryTable._colToIndex[n]] = blArray[_colToIndex[n]];
                if (blArray[_colToIndex[n]]) {
                    this.table.addColumn(this.column[n]);
                } else {
                    this.table.removeColumn(this.column[n]);
                }
            }
            ++n;
        }
        if (bl) {
            this.tableModel.fireTableChanged(new TableModelEvent(this.tableModel, 0, this.currentTableSize - 1, -1));
        }
        this.process.updateChildSettings();
    }

    public void saveToHTML(boolean bl) {
        this.process.saveMemSampleToHTML(bl);
    }

    int getCurrentPos() {
        return this.currentSize - this.slider.getValue();
    }

    public void notifyProcessEnd() {
        SwingUtilities.invokeLater(new EventRunner(0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.whenActionPerformed(object);
    }

    private void whenActionPerformed(Object object) {
        if (object == this.buttonRun) {
            this.process.performRunCommand();
            this.buttonRun.setEnabled(false);
            this.slider.setEnabled(false);
            this.sliderUp.setEnabled(false);
            this.sliderDown.setEnabled(false);
            this.buttonPause.setEnabled(true);
            this.buttonPause.requestFocus();
            this.buttonSnapshot.setEnabled(true);
        } else if (object == this.buttonPause) {
            this.process.performPauseCommand();
            this.buttonRun.setEnabled(true);
            this.buttonRun.requestFocus();
            this.slider.setEnabled(true);
            this.sliderUp.setEnabled(true);
            this.sliderDown.setEnabled(true);
            this.buttonPause.setEnabled(false);
            this.buttonSnapshot.setEnabled(false);
        } else if (object == this.sliderUp) {
            int n = this.slider.getValue();
            if (n < this.currentSize) {
                this.slider.setValue(n + 1);
            }
        } else if (object == this.sliderDown) {
            int n = this.slider.getValue();
            if (n > 0) {
                this.slider.setValue(n - 1);
            }
        } else if (object == this.buttonSnapshot) {
            this.process.performSnapshotCommand();
        } else if (object == this.buttonRestart) {
            this.process.performRestartCommand();
        } else if (object == this.buttonTerminate) {
            this.process.performTerminateCommand();
        }
    }

    private void setAllSizes(JComponent jComponent, Dimension dimension) {
        jComponent.setMinimumSize(dimension);
        jComponent.setMaximumSize(dimension);
        jComponent.setPreferredSize(dimension);
    }

    private JPanel createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        Dimension dimension = new Dimension(24, 24);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        JToolBar jToolBar2 = new JToolBar();
        jPanel2.add((Component)jToolBar, "West");
        jPanel2.add((Component)jToolBar2, "East");
        jPanel.add((Component)jPanel2, "North");
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        jToolBar.setBorder(IdeConstants.TOOLBAR_EMPTY_BORDER);
        jToolBar2.setFloatable(false);
        jToolBar2.setRollover(true);
        jToolBar2.setBorder(IdeConstants.TOOLBAR_EMPTY_BORDER);
        this.buttonRestart = new JButton(RunArb.getIcon(3));
        this.buttonRestart.setToolTipText(ProfArb.getString(25));
        this.registerActionMnemonic(jPanel, this.buttonRestart, ProfArb.getMnemonic(31));
        this.buttonRestart.addActionListener(this);
        jToolBar.add(this.buttonRestart);
        this.buttonRestart.setEnabled(true);
        this.buttonRun = new JButton(DbgArb.getIcon(15));
        this.buttonRun.setToolTipText(ProfArb.getString(28));
        this.registerActionMnemonic(jPanel, this.buttonRun, ProfArb.getMnemonic(34));
        this.buttonRun.addActionListener(this);
        jToolBar.add(this.buttonRun);
        this.buttonRun.setEnabled(false);
        this.buttonPause = new JButton(DbgArb.getIcon(12));
        this.buttonPause.setToolTipText(ProfArb.getString(29));
        this.registerActionMnemonic(jPanel, this.buttonPause, ProfArb.getMnemonic(35));
        this.buttonPause.addActionListener(this);
        jToolBar.add(this.buttonPause);
        this.buttonPause.setEnabled(true);
        this.buttonSnapshot = new JButton(IdeArb.getIcon((int)387));
        this.buttonSnapshot.setToolTipText(ProfArb.getString(26));
        this.registerActionMnemonic(jPanel, this.buttonSnapshot, ProfArb.getMnemonic(32));
        this.buttonSnapshot.addActionListener(this);
        jToolBar.add(this.buttonSnapshot);
        this.buttonSnapshot.setEnabled(true);
        this.buttonTerminate = new JButton(IdeArb.getIcon((int)150));
        this.buttonTerminate.setToolTipText(ProfArb.getString(27));
        this.registerActionMnemonic(jPanel, this.buttonTerminate, ProfArb.getMnemonic(33));
        this.buttonTerminate.addActionListener(this);
        jToolBar.add(this.buttonTerminate);
        this.buttonTerminate.setEnabled(true);
        this.sliderDown = new JButton(ProfArb.getIcon(37));
        this.sliderDown.setToolTipText(ProfArb.getString(39));
        this.registerActionMnemonic(jPanel, this.sliderDown, ProfArb.getMnemonic(41));
        this.sliderDown.addActionListener(this);
        jToolBar.add(this.sliderDown);
        this.sliderDown.setEnabled(false);
        this.slider = new JSlider(0, this.maxSize - 1, this.currentSize);
        this.slider.setToolTipText(ProfArb.getString(74));
        this.slider.setPaintTrack(true);
        this.slider.setPaintLabels(true);
        this.slider.setSnapToTicks(true);
        MySliderLabels mySliderLabels = new MySliderLabels();
        this.slider.addChangeListener(mySliderLabels);
        this.slider.setLabelTable(mySliderLabels);
        this.slider.setEnabled(false);
        jPanel2.add((Component)this.slider, "Center");
        this.sliderUp = new JButton(ProfArb.getIcon(38));
        this.sliderUp.setToolTipText(ProfArb.getString(40));
        this.registerActionMnemonic(jPanel, this.sliderUp, ProfArb.getMnemonic(42));
        this.sliderUp.addActionListener(this);
        jToolBar2.add(this.sliderUp);
        this.sliderUp.setEnabled(false);
        this.sampleLabel = new JLabel("99999/99999", 0);
        Font font = this.sampleLabel.getFont();
        Font font2 = font.deriveFont(1, 20.0f);
        this.sampleLabel.setFont(font2);
        this.setAllSizes(this.sampleLabel, this.sampleLabel.getPreferredSize());
        this.sampleLabel.setText("0/0");
        jToolBar2.add(this.sampleLabel);
        this.tableModel = new 5();
        this.table = new JTable(this.tableModel);
        this.table.addMouseListener(new 4());
        this.addMouseListenerToHeaderInTable();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = 0;
        while (n < 9) {
            this.column[n] = tableColumnModel.getColumn(n);
            this.columnShowing[MemoryTable._colToIndex[n]] = true;
            ++n;
        }
        DefaultAllignRenderer defaultAllignRenderer = new DefaultAllignRenderer(this.process);
        this.column[0].setPreferredWidth(600);
        this.column[0].setCellRenderer(defaultAllignRenderer);
        RightAllignRenderer rightAllignRenderer = new RightAllignRenderer(this.process);
        int n2 = 1;
        while (n2 < 9) {
            this.column[n2].setPreferredWidth(100);
            this.column[n2].setCellRenderer(rightAllignRenderer);
            ++n2;
        }
        Dimension dimension2 = new Dimension(0, 0);
        this.table.setIntercellSpacing(dimension2);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new 3());
        jPanel.add((Component)new JScrollPane(this.table), "Center");
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        JLabel jLabel = new JLabel(ProfArb.getString(249));
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        jPanel3.add((Component)jLabel, gridBagConstraints);
        List list = this.getSavedFilters();
        JComboBox<Object> jComboBox = new JComboBox<Object>(list.toArray());
        jComboBox.setEditable(true);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add(jComboBox, gridBagConstraints);
        jPanel.add((Component)jPanel3, "South");
        jComboBox.addActionListener(new 2(this, jComboBox));
        if (list.size() > 0) {
            this.setFilter((String)list.get(0));
        }
        return jPanel;
    }

    void addUniqueItem(JComboBox jComboBox, String string) {
        int n = -1;
        int n2 = jComboBox.getItemCount();
        int n3 = 0;
        while (n3 < n2) {
            String string2 = (String)jComboBox.getItemAt(n3);
            if (string2.equals(string)) {
                n = n3;
                break;
            }
            ++n3;
        }
        if (n > 0) {
            jComboBox.removeItemAt(n);
        }
        if (n != 0) {
            jComboBox.insertItemAt(string, 0);
        }
        jComboBox.setSelectedIndex(0);
        while (jComboBox.getItemCount() > 10) {
            jComboBox.removeItemAt(jComboBox.getItemCount() - 1);
        }
        int n4 = jComboBox.getItemCount();
        ArrayList arrayList = new ArrayList(n4);
        int n5 = 0;
        while (n5 < n4) {
            arrayList.add(jComboBox.getItemAt(n5));
            ++n5;
        }
        this.saveFilters(arrayList);
    }

    List getSavedFilters() {
        DTCache dTCache = Ide.getDTCache();
        ArrayList arrayList = (ArrayList)dTCache.getData(SAVED_FILTER_KEY);
        if (arrayList == null) {
            arrayList = new ArrayList(0);
        }
        return arrayList;
    }

    void saveFilters(List list) {
        DTCache dTCache = Ide.getDTCache();
        dTCache.putData(SAVED_FILTER_KEY, list);
    }

    void registerActionMnemonic(JPanel jPanel, JButton jButton, char c) {
        InputMap inputMap = jPanel.getInputMap(1);
        ActionMap actionMap = jPanel.getActionMap();
        MyAction myAction = new MyAction(jButton);
        KeyStroke keyStroke = KeyStroke.getKeyStroke((int)c, 2);
        inputMap.put(keyStroke, myAction);
        actionMap.put(myAction, myAction);
    }

    public HelpInfo getHelpInfo() {
        return HELP_TOPIC;
    }

    HeapStat[] checkCapacity(int n) {
        if (n < this.heapStatSize) {
            return this.heapStatArray;
        }
        HeapStat[] heapStatArray = new HeapStat[this.heapStatSize * 2];
        System.arraycopy(this.heapStatArray, 0, heapStatArray, 0, this.heapStatSize);
        this.heapStatSize *= 2;
        return heapStatArray;
    }

    private void setFilter(String string) {
        if (!string.equals(this.filterString)) {
            this.filterString = string;
            try {
                this.filterMatcher.parse(string);
            }
            catch (PatternError patternError) {
                this.filterMatcher.reset();
            }
            this.tableUpdate();
        }
    }

    private void dynamicFilter() {
        ArrayList<HeapStat> arrayList = new ArrayList<HeapStat>();
        HeapDetailStat heapDetailStat = new HeapDetailStat(this.currentTotals);
        int n = 0;
        while (n < this.currentTableSize) {
            HeapStat heapStat = this.currentHeapStatArray[n];
            if (this.filterMatcher.match(heapStat.getName())) {
                arrayList.add(heapStat);
            } else {
                heapDetailStat.subtract(heapStat.nb, heapStat.nballoc, heapStat.nbfreed, heapStat.size, heapStat.sizealloc, heapStat.sizefreed);
            }
            ++n;
        }
        if (arrayList.size() != this.currentTableSize) {
            this.currentHeapStatArray = arrayList.toArray(new HeapStat[arrayList.size()]);
            this.currentTableSize = arrayList.size();
            this.currentTotals = heapDetailStat;
        }
    }

    private void tableUpdate() {
        this.historySelect(this.currentSize - this.slider.getValue());
    }

    private void historySelect(int n) {
        if (n == 0) {
            this.currentTableSize = this.heapStatSizeUsed;
            this.currentHeapStatArray = this.heapStatArray;
            this.currentTotals = this.totals;
            if (this.filterMatcher.canFail()) {
                this.dynamicFilter();
            }
            if (this.currentAscending != this.ascending || this.currentCompareField != this.compareField) {
                this.ascending = this.currentAscending;
                this.compareField = this.currentCompareField;
                Arrays.sort(this.currentHeapStatArray, 0, this.currentTableSize, this.hcomp);
            }
            this.sampleLabel.setText(this.totalSample + "/" + this.totalSample);
            this.tableModel.fireTableDataChanged();
            this.table.getTableHeader().repaint();
        } else {
            int n2 = n - 1;
            this.currentHeapStatArray = this.heapStatArray_Hist[n2];
            this.currentTotals = this.totals_Hist[n2];
            this.currentTableSize = this.currentHeapStatArray.length;
            if (this.filterMatcher.canFail()) {
                this.dynamicFilter();
            }
            if (this.currentAscending != this.ascending_Hist[n2] || this.currentCompareField != this.compareField_Hist[n2]) {
                this.ascending_Hist[n2] = this.currentAscending;
                this.compareField_Hist[n2] = this.currentCompareField;
                Arrays.sort(this.currentHeapStatArray, 0, this.currentTableSize, this.hcomp);
            }
            this.sampleLabel.setText(this.totalSample - n + "/" + this.totalSample);
            this.tableModel.fireTableDataChanged();
            this.table.getTableHeader().repaint();
        }
    }

    int getTableSize(int n) {
        if (n == 0) {
            return this.heapStatSizeUsed;
        }
        int n2 = n - 1;
        return this.heapStatArray_Hist[n2].length;
    }

    HeapDetailStat getSampleTotals(int n) {
        if (n == 0) {
            return this.totals;
        }
        int n2 = n - 1;
        return this.totals_Hist[n2];
    }

    HeapStat[] getSampleArray(int n) {
        HeapStat[] heapStatArray = null;
        if (n == 0) {
            heapStatArray = this.heapStatArray;
            if (this.currentAscending != this.ascending || this.currentCompareField != this.compareField) {
                this.ascending = this.currentAscending;
                this.compareField = this.currentCompareField;
                Arrays.sort(heapStatArray, 0, this.heapStatSizeUsed, this.hcomp);
            }
        } else {
            int n2 = n - 1;
            if (n2 < this.maxSize) {
                heapStatArray = this.heapStatArray_Hist[n2];
            }
            if (heapStatArray != null && (this.currentAscending != this.ascending_Hist[n2] || this.currentCompareField != this.compareField_Hist[n2])) {
                this.ascending_Hist[n2] = this.currentAscending;
                this.compareField_Hist[n2] = this.currentCompareField;
                Arrays.sort(heapStatArray, 0, heapStatArray.length, this.hcomp);
            }
        }
        return heapStatArray;
    }

    int getSampleNumber(int n) {
        return this.totalSample - n;
    }

    int getTotalSampleNumber() {
        return this.totalSample;
    }

    private void saveCurrentArray() {
        System.arraycopy(this.heapStatArray_Hist, 0, this.heapStatArray_Hist, 1, this.maxSize - 1);
        System.arraycopy(this.totals_Hist, 0, this.totals_Hist, 1, this.maxSize - 1);
        System.arraycopy(this.compareField_Hist, 0, this.compareField_Hist, 1, this.maxSize - 1);
        System.arraycopy(this.ascending_Hist, 0, this.ascending_Hist, 1, this.maxSize - 1);
        this.heapStatArray_Hist[0] = new HeapStat[this.heapStatSizeUsed];
        this.totals_Hist[0] = this.totals;
        this.compareField_Hist[0] = this.currentCompareField;
        this.ascending_Hist[0] = this.currentAscending;
        HeapStat[] heapStatArray = this.heapStatArray_Hist[0];
        HeapStat[] heapStatArray2 = this.heapStatArray;
        int n = 0;
        while (n < heapStatArray.length) {
            heapStatArray[n] = new HeapStat(heapStatArray2[n]);
            ++n;
        }
    }

    void setDataAtPosition(int n, HeapDetailStat heapDetailStat, HeapStat[] heapStatArray) {
        if (n == 0) {
            this.heapStatSizeUsed = heapStatArray.length;
            this.heapStatArray = heapStatArray;
            this.totals = heapDetailStat;
        } else {
            this.heapStatArray_Hist[--n] = heapStatArray;
            this.totals_Hist[n] = heapDetailStat;
            this.compareField_Hist[n] = -1;
        }
    }

    void setCurrentSize(int n) {
        this.currentSize = n;
    }

    void setTotalSample(int n) {
        this.totalSample = n;
    }

    void finishedLoading() {
        this.slider.setValue(this.currentSize);
    }

    void startUpdate() {
        this.saveCurrentArray();
        this.totals = new HeapDetailStat(null, 0, this.totals.nb, 0, 0, this.totals.size, 0, 0);
        HeapStat[] heapStatArray = this.heapStatArray;
        int n = this.heapStatSizeUsed;
        int n2 = 0;
        while (n2 < n) {
            heapStatArray[n2].clearDiffs();
            ++n2;
        }
        if (this.currentSize < this.maxSize - 1) {
            ++this.currentSize;
        }
    }

    void addOrUpdateHeapData(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.totals.update(n2, n4, n6, n3, n5, n7);
        HeapStat heapStat = (HeapStat)this.localClassMap.get(n);
        if (heapStat == null) {
            heapStat = new HeapStat((VMClass)this.classMap.get(n), n2, n4, n6, n3, n5, n7);
            this.localClassMap.put(n, (Object)heapStat);
            int n8 = this.heapStatSizeUsed;
            HeapStat[] heapStatArray = this.checkCapacity(n8);
            heapStatArray[n8] = heapStat;
            this.heapStatArray = heapStatArray;
            this.heapStatSizeUsed = ++n8;
            return;
        }
        this.totals.nb -= heapStat.nb;
        this.totals.size -= heapStat.size;
        heapStat.update(n2, n4, n6, n3, n5, n7);
    }

    void endUpdate() {
        ++this.totalSample;
        this.compareField = -1;
        if (this.slider.getValue() != this.currentSize) {
            this.slider.setValue(this.currentSize);
        } else {
            this.tableUpdate();
        }
    }

    private String toolTipFromCol(int n) {
        switch (n) {
            case 0: {
                return ProfArb.getString(226);
            }
            case 1: {
                return ProfArb.getString(227);
            }
            case 2: {
                return ProfArb.getString(229);
            }
            case 3: {
                return ProfArb.getString(230);
            }
            case 4: {
                return ProfArb.getString(231);
            }
            case 5: {
                return ProfArb.getString(232);
            }
            case 6: {
                return ProfArb.getString(233);
            }
            case 7: {
                return ProfArb.getString(234);
            }
            case 8: {
                return ProfArb.getString(235);
            }
        }
        return "";
    }

    private void addMouseListenerToHeaderInTable() {
        JTable jTable = this.table;
        jTable.setColumnSelectionAllowed(false);
        1 var2_2 = new 1(this, jTable);
        HeaderRenderer headerRenderer = new HeaderRenderer();
        JTableHeader jTableHeader = jTable.getTableHeader();
        jTableHeader.addMouseListener(var2_2);
        jTableHeader.setDefaultRenderer(headerRenderer);
    }

    private void switchSort(int n) {
        if (this.currentCompareField == n) {
            this.currentAscending ^= true;
        } else {
            this.currentCompareField = n;
        }
        this.table.getTableHeader().repaint();
    }

    public void stateChange(int n) {
        switch (n) {
            case 3: {
                this.process.stopAllMethodDetails();
                this.currentHeapStatArray = null;
                this.heapStatArray = null;
                this.heapStatArray_Hist = null;
                this.classMap = null;
                this.localClassMap = null;
            }
        }
        super.stateChange(n);
    }

    static JButton ra$buttonRestart(MemoryTable memoryTable) {
        return memoryTable.buttonRestart;
    }

    static JButton ra$buttonSnapshot(MemoryTable memoryTable) {
        return memoryTable.buttonSnapshot;
    }

    static JButton ra$buttonTerminate(MemoryTable memoryTable) {
        return memoryTable.buttonTerminate;
    }

    static JButton ra$buttonRun(MemoryTable memoryTable) {
        return memoryTable.buttonRun;
    }

    static JButton ra$buttonPause(MemoryTable memoryTable) {
        return memoryTable.buttonPause;
    }

    static JSlider ra$slider(MemoryTable memoryTable) {
        return memoryTable.slider;
    }

    static JButton ra$sliderUp(MemoryTable memoryTable) {
        return memoryTable.sliderUp;
    }

    static JButton ra$sliderDown(MemoryTable memoryTable) {
        return memoryTable.sliderDown;
    }

    static int ra$currentSize(MemoryTable memoryTable) {
        return memoryTable.currentSize;
    }

    static int ra$maxSize(MemoryTable memoryTable) {
        return memoryTable.maxSize;
    }

    static void mav$historySelect(MemoryTable memoryTable, int n) {
        memoryTable.historySelect(n);
    }

    static ProfilingProcess ra$process(MemoryTable memoryTable) {
        return memoryTable.process;
    }

    static HeapStat[] ra$currentHeapStatArray(MemoryTable memoryTable) {
        return memoryTable.currentHeapStatArray;
    }

    static int ra$currentTableSize(MemoryTable memoryTable) {
        return memoryTable.currentTableSize;
    }

    static JTable ra$table(MemoryTable memoryTable) {
        return memoryTable.table;
    }

    static void mav$setFilter(MemoryTable memoryTable, String string) {
        memoryTable.setFilter(string);
    }

    static void mav$whenActionPerformed(MemoryTable memoryTable, Object object) {
        memoryTable.whenActionPerformed(object);
    }

    static int ra$currentCompareField(MemoryTable memoryTable) {
        return memoryTable.currentCompareField;
    }

    static boolean ra$currentAscending(MemoryTable memoryTable) {
        return memoryTable.currentAscending;
    }

    static Icon ra$ARROW_UP() {
        return ARROW_UP;
    }

    static Icon ra$ARROW_DOWN() {
        return ARROW_DOWN;
    }

    static HeapDetailStat ra$currentTotals(MemoryTable memoryTable) {
        return memoryTable.currentTotals;
    }

    static String mav$toolTipFromCol(MemoryTable memoryTable, int n) {
        return memoryTable.toolTipFromCol(n);
    }

    static void mav$switchSort(MemoryTable memoryTable, int n) {
        memoryTable.switchSort(n);
    }

    static void mav$tableUpdate(MemoryTable memoryTable) {
        memoryTable.tableUpdate();
    }

    public class EventRunner
    implements Runnable {
        static final int PROC_END_ACTION = 0;
        int _type;

        EventRunner(int n) {
            this._type = n;
        }

        public void run() {
            switch (this._type) {
                case 0: {
                    MemoryTable.ra$buttonRestart(MemoryTable.this).setEnabled(true);
                    MemoryTable.ra$buttonSnapshot(MemoryTable.this).setEnabled(false);
                    MemoryTable.ra$buttonTerminate(MemoryTable.this).setEnabled(false);
                    MemoryTable.ra$buttonRun(MemoryTable.this).setEnabled(false);
                    MemoryTable.ra$buttonPause(MemoryTable.this).setEnabled(false);
                    MemoryTable.ra$slider(MemoryTable.this).setEnabled(true);
                    MemoryTable.ra$sliderUp(MemoryTable.this).setEnabled(true);
                    MemoryTable.ra$sliderDown(MemoryTable.this).setEnabled(true);
                }
            }
        }
    }

    public class MySliderLabels
    extends Dictionary
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            if (!jSlider.getValueIsAdjusting()) {
                int n = jSlider.getValue();
                if (n > MemoryTable.ra$currentSize(MemoryTable.this)) {
                    jSlider.setValue(MemoryTable.ra$currentSize(MemoryTable.this));
                } else {
                    MemoryTable.mav$historySelect(MemoryTable.this, MemoryTable.ra$currentSize(MemoryTable.this) - n);
                    MemoryTable.ra$process(MemoryTable.this).setChildHistoryPos(MemoryTable.ra$currentSize(MemoryTable.this) - n);
                }
            }
        }

        public int size() {
            return MemoryTable.ra$maxSize(MemoryTable.this);
        }

        public boolean isEmpty() {
            return MemoryTable.ra$maxSize(MemoryTable.this) == 0;
        }

        public Enumeration keys() {
            return new MyEnum();
        }

        public Enumeration elements() {
            return null;
        }

        public Object get(Object object) {
            Integer n = (Integer)object;
            if (n <= MemoryTable.ra$currentSize(MemoryTable.this)) {
                return ON_LABEL;
            }
            return OFF_LABEL;
        }

        public Object put(Object object, Object object2) {
            return null;
        }

        public Object remove(Object object) {
            return null;
        }

        public class MyEnum
        implements Enumeration {
            int curpos = 0;

            public boolean hasMoreElements() {
                return this.curpos < MemoryTable.ra$maxSize(MemoryTable.this);
            }

            public Object nextElement() {
                return new Integer(this.curpos++);
            }
        }
    }

    public final class 5
    extends AbstractTableModel {
        public int getColumnCount() {
            return 9;
        }

        public int getRowCount() {
            return MemoryTable.ra$currentTableSize(MemoryTable.this);
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return CLASS_NAME_TITLE;
                }
                case 1: {
                    return COUNT_TITLE;
                }
                case 2: {
                    return SIZE_TITLE;
                }
                case 3: {
                    return ALLOC_COUNT_TITLE;
                }
                case 4: {
                    return ALLOC_SIZE_TITLE;
                }
                case 5: {
                    return FREED_COUNT_TITLE;
                }
                case 6: {
                    return FREED_SIZE_TITLE;
                }
                case 7: {
                    return DIFF_COUNT_TITLE;
                }
                case 8: {
                    return DIFF_SIZE_TITLE;
                }
            }
            return "Error";
        }

        public Object getValueAt(int n, int n2) {
            HeapStat heapStat = MemoryTable.ra$currentHeapStatArray(MemoryTable.this)[n];
            switch (n2) {
                case 0: {
                    return heapStat.getName();
                }
                case 1: {
                    return String.valueOf(heapStat.nb);
                }
                case 2: {
                    return numberFormat.format(heapStat.size);
                }
                case 3: {
                    return String.valueOf(heapStat.nballoc);
                }
                case 4: {
                    return numberFormat.format(heapStat.sizealloc);
                }
                case 5: {
                    return String.valueOf(heapStat.nbfreed);
                }
                case 6: {
                    return numberFormat.format(heapStat.sizefreed);
                }
                case 7: {
                    return String.valueOf(heapStat.getNbDiff());
                }
                case 8: {
                    return numberFormat.format(heapStat.getSizeDiff());
                }
            }
            return "Error";
        }
    }

    public final class 4
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MemoryTable.ra$table(MemoryTable.this).requestFocus();
                Context context = MemoryTable.this.getContext(mouseEvent);
                JProfiler.contextMenu.show(context);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                MemoryTable.this.showDetail();
            }
        }
    }

    public final class 3
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (!listSelectionModel.isSelectionEmpty()) {
                int n = listSelectionModel.getMinSelectionIndex();
            }
        }
    }

    public final class 2
    implements ActionListener {
        private final /* synthetic */ JComboBox v$filterText;
        final /* synthetic */ MemoryTable this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)this.v$filterText.getSelectedItem();
            MemoryTable.mav$setFilter(this.this$0, string);
            this.this$0.addUniqueItem(this.v$filterText, string);
        }

        public 2(MemoryTable memoryTable, JComboBox jComboBox) {
            this.v$filterText = jComboBox;
            this.this$0 = memoryTable;
        }
    }

    public class MyAction
    extends AbstractAction {
        JButton _src;

        MyAction(JButton jButton) {
            this._src = jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MemoryTable.mav$whenActionPerformed(MemoryTable.this, this._src);
        }
    }

    public class HeaderRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel _label1;
        private JLabel _label2;
        private int _col;

        void $init$() {
            this._label1 = new JLabel("");
            this._label2 = new JLabel("");
        }

        public HeaderRenderer() {
            super(new BorderLayout());
            this.$init$();
            this._label1.setHorizontalAlignment(0);
            this._label1.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this._label2.setHorizontalAlignment(4);
            this._label2.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.add((Component)this._label1, "North");
            this.add((Component)this._label2, "South");
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            if (MemoryTable.ra$process(MemoryTable.this).isPopupActive()) {
                return null;
            }
            return MemoryTable.mav$toolTipFromCol(MemoryTable.this, this._col);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3;
            this._col = n3 = jTable.convertColumnIndexToModel(n2);
            if (n3 == MemoryTable.ra$currentCompareField(MemoryTable.this)) {
                if (MemoryTable.ra$currentAscending(MemoryTable.this)) {
                    this._label1.setIcon(MemoryTable.ra$ARROW_UP());
                } else {
                    this._label1.setIcon(MemoryTable.ra$ARROW_DOWN());
                }
            } else {
                this._label1.setIcon(null);
            }
            this._label1.setText((String)object);
            if (MemoryTable.ra$currentTotals(MemoryTable.this) != null) {
                switch (n3) {
                    case 0: {
                        this._label2.setText(ProfArb.getString(247));
                        break;
                    }
                    case 1: {
                        this._label2.setText(String.valueOf(MemoryTable.ra$currentTotals((MemoryTable)MemoryTable.this).nb));
                        break;
                    }
                    case 2: {
                        this._label2.setText(numberFormat.format(MemoryTable.ra$currentTotals((MemoryTable)MemoryTable.this).size));
                        break;
                    }
                    case 3: {
                        this._label2.setText(String.valueOf(MemoryTable.ra$currentTotals((MemoryTable)MemoryTable.this).nballoc));
                        break;
                    }
                    case 4: {
                        this._label2.setText(numberFormat.format(MemoryTable.ra$currentTotals((MemoryTable)MemoryTable.this).sizealloc));
                        break;
                    }
                    case 5: {
                        this._label2.setText(String.valueOf(MemoryTable.ra$currentTotals((MemoryTable)MemoryTable.this).nbfreed));
                        break;
                    }
                    case 6: {
                        this._label2.setText(numberFormat.format(MemoryTable.ra$currentTotals((MemoryTable)MemoryTable.this).sizefreed));
                        break;
                    }
                    case 7: {
                        this._label2.setText(String.valueOf(MemoryTable.ra$currentTotals(MemoryTable.this).getNbDiff()));
                        break;
                    }
                    case 8: {
                        this._label2.setText(numberFormat.format(MemoryTable.ra$currentTotals(MemoryTable.this).getSizeDiff()));
                        break;
                    }
                    default: {
                        this._label2.setText(" ");
                        break;
                    }
                }
            } else {
                this._label2.setText(" ");
            }
            return this;
        }
    }

    public final class 1
    extends MouseAdapter {
        private final /* synthetic */ JTable v$tableView;
        final /* synthetic */ MemoryTable this$0;

        public void mouseClicked(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = this.v$tableView.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = this.v$tableView.convertColumnIndexToModel(n);
            if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                MemoryTable.mav$switchSort(this.this$0, n2);
                MemoryTable.mav$tableUpdate(this.this$0);
            }
        }

        public 1(MemoryTable memoryTable, JTable jTable) {
            this.v$tableView = jTable;
            this.this$0 = memoryTable;
        }
    }

    public class heapComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n;
            HeapStat heapStat = (HeapStat)object;
            HeapStat heapStat2 = (HeapStat)object2;
            switch (MemoryTable.ra$currentCompareField(MemoryTable.this)) {
                default: {
                    n = heapStat.getName().compareTo(heapStat2.getName());
                    break;
                }
                case 1: {
                    n = heapStat.nb - heapStat2.nb;
                    break;
                }
                case 2: {
                    n = heapStat.size - heapStat2.size;
                    break;
                }
                case 3: {
                    n = heapStat.nballoc - heapStat2.nballoc;
                    break;
                }
                case 4: {
                    n = heapStat.sizealloc - heapStat2.sizealloc;
                    break;
                }
                case 5: {
                    n = heapStat.nbfreed - heapStat2.nbfreed;
                    break;
                }
                case 6: {
                    n = heapStat.sizefreed - heapStat2.sizefreed;
                    break;
                }
                case 7: {
                    n = heapStat.getNbDiff() - heapStat2.getNbDiff();
                    break;
                }
                case 8: {
                    n = heapStat.getSizeDiff() - heapStat2.getSizeDiff();
                }
            }
            if (!MemoryTable.ra$currentAscending(MemoryTable.this)) {
                n = 0 - n;
            }
            return n;
        }

        heapComparator() {
        }
    }
}

