/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Component;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTabbedPane;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.docking.DockableWindow;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.util.PropertyAccess;
import oracle.ide.view.View;
import oracle.jdevimpl.runner.profile.MemoryAllocTable;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfilingProcess;
import oracle.jdevimpl.runner.profile.VMClass;

final class MemoryUseTable
extends DockableWindow {
    private static final String PROFILER_MEMORY_TABLE_ID = "ProfilerMemoryTable";
    private Map memorySnapshots;
    private ProfilingProcess process;
    private Project project;
    private String title;
    private JTabbedPane uiPanel;
    private MemoryAllocTable tablePanel;
    private int nSnapshots;
    private int nDiffs;

    public MemoryUseTable(ProfilingProcess profilingProcess) {
        this(profilingProcess, null);
    }

    public MemoryUseTable(ProfilingProcess profilingProcess, Object[] objectArray) {
        super(PROFILER_MEMORY_TABLE_ID);
        this.process = profilingProcess;
        this.project = profilingProcess.getJProject();
        this.title = ProfArb.getString(128) + this.process.getRunTitle();
        this.setType(32);
        this.initialize();
    }

    public Component getGUI() {
        return this.uiPanel;
    }

    public Controller getController() {
        return null;
    }

    public Context getContext(EventObject eventObject) {
        Context context = Context.newIdeContext((Node)this.project);
        context.setView((View)this);
        return context;
    }

    public void initialize() {
        this.uiPanel = this.createGUI();
    }

    public String getTabName() {
        return this.title;
    }

    public String getTitleName() {
        return this.title;
    }

    private JTabbedPane createGUI() {
        JTabbedPane jTabbedPane = new JTabbedPane(3);
        this.tablePanel = new MemoryAllocTable(this, null);
        jTabbedPane.addTab(ProfArb.getString(129), null, this.tablePanel, ProfArb.getString(130));
        return jTabbedPane;
    }

    public String addSnaphotTable(MemoryAllocTable memoryAllocTable) {
        if (this.memorySnapshots == null) {
            this.memorySnapshots = new HashMap(10);
        }
        ++this.nSnapshots;
        String string = ProfArb.getString(131) + this.nSnapshots;
        this.uiPanel.addTab(string, null, memoryAllocTable, ProfArb.getString(132));
        this.memorySnapshots.put(string, memoryAllocTable);
        Object[] objectArray = this.memorySnapshots.values().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryAllocTable memoryAllocTable2 = (MemoryAllocTable)objectArray[n2];
            memoryAllocTable2.enableGenerateDiff();
            ++n2;
        }
        return string;
    }

    public String[] getMemorySnapshotNames() {
        if (this.memorySnapshots == null) {
            return null;
        }
        Object[] objectArray = this.memorySnapshots.keySet().toArray();
        int n = objectArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = new String((String)objectArray[n2]);
            ++n2;
        }
        return stringArray;
    }

    public int getNMemorySnapshots() {
        if (this.memorySnapshots == null) {
            return 0;
        }
        return this.memorySnapshots.size();
    }

    public MemoryAllocTable getMemorySnapshot(String string) {
        if (this.memorySnapshots == null) {
            return null;
        }
        return (MemoryAllocTable)this.memorySnapshots.get(string);
    }

    public String addDiffTable(MemoryAllocTable memoryAllocTable) {
        ++this.nDiffs;
        String string = ProfArb.getString(133) + this.nDiffs;
        this.uiPanel.addTab(string, null, memoryAllocTable, ProfArb.getString(134));
        return string;
    }

    public void update(VMClass vMClass) {
        this.tablePanel.update(vMClass);
    }

    public void updateList(Object[] objectArray, int n, int n2) {
        this.tablePanel.updateList(objectArray, n, n2);
    }

    public void loadLayout(PropertyAccess propertyAccess) {
    }

    public void saveLayout(PropertyAccess propertyAccess) {
    }
}

