/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.ide.util.IntHashMap;
import oracle.jdevimpl.runner.profile.CallCountItem;
import oracle.jdevimpl.runner.profile.VMMethod;

class MethodCallCountItem
extends CallCountItem {
    VMMethod m;
    int callCount;
    int onStackCount;

    public MethodCallCountItem(int n, VMMethod vMMethod, int n2, int n3) {
        super(n);
        this.m = vMMethod;
        this.callCount = n2;
        this.onStackCount = n3;
        this.name = "";
    }

    public MethodCallCountItem() {
    }

    public void saveToFile(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(0);
        super.saveToFile(dataOutputStream);
        dataOutputStream.writeInt(this.m.methodDescriptor);
        dataOutputStream.writeInt(this.callCount);
        dataOutputStream.writeInt(this.onStackCount);
    }

    public void initFromFile(DataInputStream dataInputStream, IntHashMap intHashMap) throws IOException {
        super.initFromFile(dataInputStream);
        this.m = (VMMethod)intHashMap.get(dataInputStream.readInt());
        this.callCount = dataInputStream.readInt();
        this.onStackCount = dataInputStream.readInt();
    }

    String getPseudoClass() {
        return this.m.clazz.toString();
    }

    String getPseudoName() {
        return this.m.name;
    }

    int getCallCount() {
        return this.callCount;
    }

    int getOnStackCount() {
        return this.onStackCount;
    }

    String getNiceSignature() {
        return this.m.getNiceSignature();
    }

    String getFileName() {
        return this.m.clazz.fileName;
    }

    int getLine() {
        return this.m.firstLine;
    }

    String getPackage() {
        return this.m.clazz.packageName;
    }
}

