/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import oracle.jdevimpl.runner.profile.VMMethod;
import oracle.jdevimpl.runner.profile.VMThread;
import oracle.jdevimpl.runner.profile.VMTypes;

class MethodEnterItem
extends VMTypes {
    private VMMethod method;
    private VMThread thread;
    private MethodEnterItem parent;
    private long startTime;
    private long endTime;
    private long executionTime;
    private long startExecutionTime;

    public MethodEnterItem(VMThread vMThread, VMMethod vMMethod, long l) {
        this.thread = vMThread;
        this.method = vMMethod;
        this.startExecutionTime = this.startTime = l;
        this.name = "Method entered " + vMMethod.toString();
    }

    public MethodEnterItem getParent() {
        return this.parent;
    }

    public VMMethod getMethod() {
        return this.method;
    }

    public VMThread getThread() {
        return this.thread;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public String toString() {
        return this.name;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long l) {
        this.endTime = l;
    }

    public long getElapsedTime() {
        return this.endTime - this.startTime;
    }

    public void stopExecution(long l) {
        this.executionTime += l - this.startExecutionTime;
    }

    public void startExecution(long l) {
        this.startExecutionTime = l;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }
}

