/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPanel;
import oracle.jdevimpl.runner.profile.ProfHistModel;

public class ProfHist
extends JPanel {
    public static final int SCALE_SIZE = 100;
    private static Color COLOR_HIGHLIGHT = new Color(0, 0, 0, 35);
    public static final String SELECTION = "selection";
    private static final boolean LABEL_IN_RECT = false;
    private static final boolean DRAW_FOCUS = false;
    private ProfHistModel _model;
    private int _nRowHeight;
    private int[] _nSelected;
    private int _nScaleM;
    private int _nScaleD;
    private int _nCurrentCursor;
    private int _maxX;
    private ArrayList _listeners;
    private static TexturePaint EVENT_HIGHLIGHT;

    static {
        BufferedImage bufferedImage = new BufferedImage(6, 6, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, 6, 6);
        graphics2D.setColor(Color.black);
        graphics2D.drawLine(0, 0, 5, 5);
        graphics2D.setColor(Color.white);
        graphics2D.drawLine(0, 1, 4, 5);
        graphics2D.drawLine(5, 0, 5, 0);
        EVENT_HIGHLIGHT = new TexturePaint(bufferedImage, new Rectangle(6, 6));
    }

    void $init$() {
        this._nRowHeight = 18;
        this._nSelected = null;
        this._nScaleM = 1;
        this._nScaleD = 100;
    }

    public ProfHist(ProfHistModel profHistModel) {
        this.$init$();
        this._model = profHistModel;
        this.setBackground(Color.white);
        this.setRowHeight(18);
        this.addMouseListener(new 2());
        this.addMouseMotionListener(new 1());
    }

    public void addSelectionListener(PropertyChangeListener propertyChangeListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(propertyChangeListener);
    }

    public void removeSelectionListener(PropertyChangeListener propertyChangeListener) {
        if (this._listeners != null) {
            this._listeners.remove(propertyChangeListener);
        }
    }

    private void fireSelectionChangeEvent(int[] nArray, int[] nArray2) {
        PropertyChangeEvent propertyChangeEvent = null;
        int n = this._listeners.size() - 1;
        while (n >= 0) {
            if (propertyChangeEvent == null) {
                propertyChangeEvent = new PropertyChangeEvent(this, SELECTION, nArray, nArray2);
            }
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this._listeners.get(n);
            propertyChangeListener.propertyChange(propertyChangeEvent);
            --n;
        }
    }

    public void setScale(int n, int n2) {
        this._nScaleM = n;
        this._nScaleD = n2;
        this.setPreferredSize(null);
    }

    private int scaler(int n) {
        return n * this._nScaleM / this._nScaleD;
    }

    public int getRowHeight() {
        return this._nRowHeight;
    }

    public void setRowHeight(int n) {
        this._nRowHeight = n;
        this.setPreferredSize(null);
    }

    private void whenMousePressed(MouseEvent mouseEvent) {
        this.grabFocus();
        Point point = mouseEvent.getPoint();
        int n = this._model.getRowCount();
        Rectangle rectangle = new Rectangle();
        int n2 = Math.max(0, point.y / this._nRowHeight - 2);
        int n3 = Math.min(n, point.y / this._nRowHeight + 2);
        int n4 = n2;
        while (n4 < n3) {
            this.getFullRect(n4, rectangle);
            if (rectangle.contains(point)) {
                int[] nArray = new int[]{n4};
                this.setSelected(nArray, true);
                break;
            }
            ++n4;
        }
    }

    private void whenMouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this._model.getRowCount();
        Rectangle rectangle = new Rectangle();
        int n2 = 13;
        int n3 = Math.max(0, point.y / this._nRowHeight - 2);
        int n4 = Math.min(n, point.y / this._nRowHeight + 2);
        int n5 = n3;
        while (n5 < n4) {
            this.getEventRect(n5, rectangle);
            if (rectangle.y <= point.y && point.y <= rectangle.y + rectangle.width) {
                this.getFullRect(n5, rectangle);
                if (rectangle.contains(point)) {
                    n2 = 12;
                    break;
                }
            }
            ++n5;
        }
        if (this._nCurrentCursor != n2) {
            this.setCursor(Cursor.getPredefinedCursor(n2));
            this._nCurrentCursor = n2;
        }
    }

    public void setSelected(int[] nArray, boolean bl) {
        if (nArray != null) {
            Arrays.sort(nArray);
        }
        if (bl && this._nSelected != null && nArray != null) {
            this.fireSelectionChangeEvent(this._nSelected, nArray);
        }
        this._nSelected = nArray;
        this.repaint();
    }

    public int[] getSelected() {
        return this._nSelected;
    }

    public void setModel(ProfHistModel profHistModel) {
        this._model = profHistModel;
        this.invalidate();
    }

    public ProfHistModel getModel() {
        return this._model;
    }

    private int getEventMaxBound(int n) {
        int n2 = this._model.getEventElapsed(n);
        int n3 = n2 != Integer.MAX_VALUE ? this._model.getEventStart(n) + n2 : this._model.getEventStart(n);
        return n3;
    }

    private int getLastEvent() {
        int n = this._model.getRowCount();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5 = this.getEventMaxBound(n4);
            if (n5 > n2) {
                n3 = n4;
                n2 = n5;
            }
            ++n4;
        }
        return n3;
    }

    private Rectangle getFullRect(int n, Rectangle rectangle) {
        this.getEventRect(n, rectangle);
        return rectangle;
    }

    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            int n = this.getLastEvent();
            this._maxX = this.scaler(this.getEventMaxBound(n));
            this.setPreferredSize(new Dimension(this._maxX, this._model.getRowCount() * this.getRowHeight()));
        }
        return super.getPreferredSize();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Rectangle getEventBounds(int n) {
        Rectangle rectangle = new Rectangle();
        return this.getFullRect(n, rectangle);
    }

    private Rectangle getEventRect(int n, Rectangle rectangle) {
        int n2;
        int n3;
        int n4 = this._model.getRowCount();
        if (n < n4) {
            n3 = this._model.getEventStart(n);
            n2 = this._model.getEventElapsed(n);
        } else {
            n3 = 0;
            n2 = 0;
        }
        if (n2 == Integer.MAX_VALUE) {
            rectangle.setRect(this.scaler(n3), n * this.getRowHeight(), this._maxX - this.scaler(n3), this.getRowHeight());
        } else {
            rectangle.setRect(this.scaler(n3), n * this.getRowHeight(), Math.max(1, this.scaler(n2)), this.getRowHeight());
        }
        return rectangle;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        int n = this._model.getRowCount();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = graphics2D.getClipBounds();
        int n2 = rectangle2.x;
        int n3 = rectangle2.x + rectangle2.width;
        n2 = Math.max(0, n2 / 100 - 1);
        n2 *= 100;
        graphics2D.setColor(Color.gray);
        while (n2 <= n3) {
            graphics2D.drawLine(n2, 0, n2, dimension.height);
            n2 += 50;
        }
        int n4 = Math.max(0, rectangle2.y / this._nRowHeight - 2);
        int n5 = Math.min(n, (rectangle2.y + rectangle2.height) / this._nRowHeight + 2);
        int n6 = n4;
        while (n6 < n5) {
            this.getEventRect(n6, rectangle);
            if (graphics2D.hitClip(0, rectangle.y, dimension.width, rectangle.y)) {
                graphics2D.drawLine(0, rectangle.y, dimension.width, rectangle.y);
                rectangle.y += this._nRowHeight;
                graphics2D.drawLine(0, rectangle.y, dimension.width, rectangle.y);
            }
            ++n6;
        }
        int n7 = n4;
        while (n7 < n5) {
            Color color = this._model.getEventColor(n7);
            this.getEventRect(n7, rectangle);
            if (graphics2D.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                graphics2D.setColor(color);
                ++rectangle.width;
                ++rectangle.height;
                graphics2D.fillRect(rectangle.x, rectangle.y + 1, rectangle.width, rectangle.height - 2);
            }
            ++n7;
        }
        if (this._nSelected != null) {
            int n8 = 0;
            while (n8 < this._nSelected.length) {
                this.getEventRect(this._nSelected[n8], rectangle);
                graphics2D.setPaint(EVENT_HIGHLIGHT);
                ++rectangle.y;
                --rectangle.height;
                graphics2D.fill(rectangle);
                rectangle.y = 0;
                rectangle.height = dimension.height;
                graphics2D.setColor(COLOR_HIGHLIGHT);
                ++rectangle.width;
                graphics2D.fillRect(rectangle.x, 0, rectangle.width, dimension.height);
                ++n8;
            }
        }
    }

    private void paintSelection(Graphics2D graphics2D, Rectangle rectangle) {
        graphics2D.setColor(Color.black);
        graphics2D.draw(rectangle);
    }

    static void mav$whenMousePressed(ProfHist profHist, MouseEvent mouseEvent) {
        profHist.whenMousePressed(mouseEvent);
    }

    static void mav$whenMouseMoved(ProfHist profHist, MouseEvent mouseEvent) {
        profHist.whenMouseMoved(mouseEvent);
    }

    public final class 2
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            ProfHist.mav$whenMousePressed(ProfHist.this, mouseEvent);
        }
    }

    public final class 1
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            ProfHist.mav$whenMouseMoved(ProfHist.this, mouseEvent);
        }
    }
}

