/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import oracle.ide.resource.IdeArb;
import oracle.jdevimpl.runner.profile.HorzRule;
import oracle.jdevimpl.runner.profile.ProfHist;
import oracle.jdevimpl.runner.profile.ProfHistModel;

public class ProfHistPanel
extends JPanel
implements ActionListener {
    private ProfHist _hist;
    private JButton _butScaleIn;
    private JButton _butScaleOut;
    private Point _ptLastDrag;
    private int _nScale;
    private JScrollPane _graphScrollPane;

    void $init$() {
        this._nScale = 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._butScaleIn) {
            this.whenButScalePressed(actionEvent, true);
        }
        if (actionEvent.getSource() == this._butScaleOut) {
            this.whenButScalePressed(actionEvent, false);
        }
    }

    public ProfHistPanel(ProfHistModel profHistModel) {
        this.$init$();
        this.setLayout(new GridBagLayout());
        this._graphScrollPane = new JScrollPane();
        this._graphScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this._hist = new ProfHist(profHistModel);
        this._graphScrollPane.setViewportView(this._hist);
        this._graphScrollPane.setHorizontalScrollBarPolicy(32);
        this._graphScrollPane.setVerticalScrollBarPolicy(22);
        this.setHorzRuler(new HorzRule());
        this._butScaleIn = new JButton(IdeArb.getIcon((int)385));
        this._butScaleIn.setRequestFocusEnabled(false);
        this._butScaleIn.setBorder(BorderFactory.createBevelBorder(0));
        this._butScaleIn.addActionListener(this);
        this._butScaleOut = new JButton(IdeArb.getIcon((int)386));
        this._butScaleOut.setRequestFocusEnabled(false);
        this._butScaleOut.setBorder(BorderFactory.createBevelBorder(0));
        this._butScaleOut.addActionListener(this);
        JScrollBar jScrollBar = new JScrollBar(0);
        this._graphScrollPane.setHorizontalScrollBar(jScrollBar);
        this._hist.addMouseMotionListener(new 2());
        this._hist.addMouseListener(new 1());
        this.setScale(1, 1000, 1.0f);
        this._nScale = 1;
        this.add((Component)this._graphScrollPane, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jScrollBar, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._butScaleIn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._butScaleOut, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    void setVerticalScrollBar(JScrollBar jScrollBar) {
        this._graphScrollPane.setVerticalScrollBar(jScrollBar);
    }

    JViewport getColumnHeader() {
        return this._graphScrollPane.getColumnHeader();
    }

    public void addSelectionListener(PropertyChangeListener propertyChangeListener) {
        this._hist.addSelectionListener(propertyChangeListener);
    }

    public void removeSelectionListener(PropertyChangeListener propertyChangeListener) {
        this._hist.removeSelectionListener(propertyChangeListener);
    }

    public HorzRule getHorzRuler() {
        HorzRule horzRule = null;
        JViewport jViewport = this._graphScrollPane.getColumnHeader();
        if (jViewport != null) {
            horzRule = (HorzRule)jViewport.getView();
        }
        return horzRule;
    }

    public void setHorzRuler(HorzRule horzRule) {
        this._graphScrollPane.setColumnHeaderView(horzRule);
    }

    public void setScale(int n, int n2, float f) {
        HorzRule horzRule = this.getHorzRuler();
        this._hist.setScale(n, n2);
        horzRule.setScale(f);
        this.updateScrollbars();
    }

    public int getRowHeight() {
        return this._hist.getRowHeight();
    }

    public void setRowHeight(int n) {
        this._hist.setRowHeight(n);
    }

    public void updateDatas() {
        this._hist.setPreferredSize(null);
        this.updateScrollbars();
    }

    public void setSelected(int[] nArray) {
        this._hist.setSelected(nArray, false);
    }

    public int[] getSelected() {
        return this._hist.getSelected();
    }

    public Rectangle getEventBounds(int n) {
        return this._hist.getEventBounds(n);
    }

    public void addNotify() {
        super.addNotify();
        Dimension dimension = new Dimension(this._hist.getPreferredSize().width, 20);
        this.getHorzRuler().setPreferredSize(dimension);
    }

    private void whenMousePressed(MouseEvent mouseEvent) {
        Point point = this._graphScrollPane.getViewport().getViewPosition();
        this._ptLastDrag = new Point(mouseEvent.getPoint());
        this._ptLastDrag.x -= point.x;
        this._ptLastDrag.y -= point.y;
    }

    private void whenMouseDragged(MouseEvent mouseEvent) {
        Point point = this._graphScrollPane.getViewport().getViewPosition();
        Dimension dimension = this._graphScrollPane.getViewport().getSize();
        Dimension dimension2 = this._graphScrollPane.getViewport().getViewSize();
        Point point2 = mouseEvent.getPoint();
        point2.x -= point.x;
        point2.y -= point.y;
        point.translate(this._ptLastDrag.x - point2.x, this._ptLastDrag.y - point2.y);
        if (point.x < 0) {
            point.x = 0;
        }
        if (dimension2.width > dimension.width) {
            if (point.x + dimension.width > dimension2.width) {
                point.x = dimension2.width - dimension.width;
            }
        } else {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        if (dimension2.height > dimension.height) {
            if (point.y + dimension.height > dimension2.height) {
                point.y = dimension2.height - dimension.height;
            }
        } else {
            point.y = 0;
        }
        this._graphScrollPane.getViewport().setViewPosition(point);
        this._ptLastDrag = point2;
    }

    private void whenMouseReleased(MouseEvent mouseEvent) {
        this._ptLastDrag = null;
    }

    private void whenButScalePressed(ActionEvent actionEvent, boolean bl) {
        if (bl && this._nScale != 4) {
            this._nScale = (this._nScale + 1) % 5;
        } else if (this._nScale != 0) {
            this._nScale = (this._nScale + 4) % 5;
        }
        this._butScaleIn.setEnabled(this._nScale != 4);
        this._butScaleOut.setEnabled(this._nScale != 0);
        switch (this._nScale) {
            case 1: {
                this.setScale(1, 1000, 1.0f);
                break;
            }
            case 2: {
                this.setScale(1, 100, 0.1f);
                break;
            }
            case 3: {
                this.setScale(1, 10, 0.01f);
                break;
            }
            case 4: {
                this.setScale(1, 1, 0.001f);
                break;
            }
            case 0: {
                this.setScale(1, 10000, 10.0f);
            }
        }
        this.scrollGraphToVisible();
    }

    void updateScrollbars() {
        this._graphScrollPane.getViewport().setView(this._hist);
        this.addNotify();
    }

    public void scrollGraphToVisible() {
        JViewport jViewport = this._graphScrollPane.getViewport();
        int[] nArray = this.getSelected();
        if (nArray != null && nArray.length != 0) {
            Rectangle rectangle = this.getEventBounds(nArray[0]);
            Dimension dimension = jViewport.getViewSize();
            Rectangle rectangle2 = jViewport.getViewRect();
            if (!rectangle2.contains(rectangle)) {
                int n = Math.min(rectangle.x - 5, dimension.width - rectangle2.width);
                n = Math.max(n, 0);
                jViewport.setViewPosition(new Point(n, rectangle2.y));
            }
        }
    }

    static void mav$whenMouseDragged(ProfHistPanel profHistPanel, MouseEvent mouseEvent) {
        profHistPanel.whenMouseDragged(mouseEvent);
    }

    static void mav$whenMouseReleased(ProfHistPanel profHistPanel, MouseEvent mouseEvent) {
        profHistPanel.whenMouseReleased(mouseEvent);
    }

    static void mav$whenMousePressed(ProfHistPanel profHistPanel, MouseEvent mouseEvent) {
        profHistPanel.whenMousePressed(mouseEvent);
    }

    public final class 2
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent mouseEvent) {
            ProfHistPanel.mav$whenMouseDragged(ProfHistPanel.this, mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    public final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            ProfHistPanel.mav$whenMousePressed(ProfHistPanel.this, mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ProfHistPanel.mav$whenMouseReleased(ProfHistPanel.this, mouseEvent);
        }
    }
}

