/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.dialogs.ClassPackageListBrowser;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurationEditorUtil;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfileConfiguration;

public class ProfileConfigurationPanel
extends DefaultTraversablePanel
implements ActionListener {
    private JTextField includedClasses;
    private JButton includedClassesButton;
    private JTextField excludedClasses;
    private JButton excludedClassesButton;
    private JCheckBox useAPICheckBox;
    private JTextField remoteHostTextField;
    private JTextField remotePortTextField;
    private JCheckBox promptCheckBox;

    public ProfileConfigurationPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        ProfileConfiguration profileConfiguration = ProfileConfigurationPanel.getProfileConfiguration(traversableContext);
        this.loadFrom(profileConfiguration);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        ProfileConfiguration profileConfiguration = ProfileConfigurationPanel.getProfileConfiguration(traversableContext);
        this.commitTo(profileConfiguration);
    }

    private static ProfileConfiguration getProfileConfiguration(TraversableContext traversableContext) {
        RunConfiguration runConfiguration = RunConfigurationEditorUtil.getRunConfiguration((Namespace)traversableContext);
        return ProfileConfiguration.getInstance(runConfiguration);
    }

    private void loadFrom(ProfileConfiguration profileConfiguration) {
        String string = profileConfiguration.getExcludedClasses();
        this.excludedClasses.setText(string != null ? string : "");
        string = profileConfiguration.getIncludedClasses();
        this.includedClasses.setText(string != null ? string : "");
        this.useAPICheckBox.setSelected(profileConfiguration.isUseAPI());
        this.remoteHostTextField.setText(profileConfiguration.getRemoteHost());
        this.remotePortTextField.setText(Integer.toString(profileConfiguration.getRemotePort()));
        this.promptCheckBox.setSelected(profileConfiguration.isPromptForRemoteProfiling());
    }

    private void commitTo(ProfileConfiguration profileConfiguration) throws TraversalException {
        int n;
        try {
            n = Integer.parseInt(this.remotePortTextField.getText());
        }
        catch (Exception exception) {
            throw new TraversalException(ProfArb.getString(295));
        }
        profileConfiguration.setExcludedClasses(this.excludedClasses.getText());
        profileConfiguration.setIncludedClasses(this.includedClasses.getText());
        profileConfiguration.setUseAPI(this.useAPICheckBox.isSelected());
        profileConfiguration.setRemoteHost(this.remoteHostTextField.getText());
        profileConfiguration.setRemotePort(n);
        profileConfiguration.setPromptForRemoteProfiling(this.promptCheckBox.isSelected());
    }

    private void jbInit() throws Exception {
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), ProfArb.getString(0));
        JLabel jLabel = new JLabel();
        this.includedClasses = new JTextField();
        this.includedClassesButton = new JButton();
        JLabel jLabel2 = new JLabel();
        this.excludedClasses = new JTextField();
        this.excludedClassesButton = new JButton();
        this.useAPICheckBox = new JCheckBox();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        this.remoteHostTextField = new JTextField();
        JLabel jLabel5 = new JLabel();
        this.remotePortTextField = new JTextField();
        this.promptCheckBox = new JCheckBox();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.includedClasses, (String)ProfArb.getString(91));
        ResourceUtils.resButton((AbstractButton)this.includedClassesButton, (String)ProfArb.getString(92));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.excludedClasses, (String)ProfArb.getString(94));
        ResourceUtils.resButton((AbstractButton)this.excludedClassesButton, (String)ProfArb.getString(95));
        ResourceUtils.resButton((AbstractButton)this.useAPICheckBox, (String)ProfArb.getString(97));
        jLabel3.setText(ProfArb.getString(291));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.remoteHostTextField, (String)ProfArb.getString(292));
        ResourceUtils.resLabel((JLabel)jLabel5, (Component)this.remotePortTextField, (String)ProfArb.getString(293));
        ResourceUtils.resButton((AbstractButton)this.promptCheckBox, (String)ProfArb.getString(294));
        this.setLayout(new GridBagLayout());
        int n = 0;
        this.add(jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add(this.includedClasses, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.includedClassesButton, new GridBagConstraints(1, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.add(jLabel2, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 2, 5), 0, 0));
        this.add(this.excludedClasses, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.excludedClassesButton, new GridBagConstraints(1, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.add(this.useAPICheckBox, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this.makeRemotePanel(jLabel3, jLabel4, jLabel5), new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, n++, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.includedClassesButton.addActionListener(this);
        this.excludedClassesButton.addActionListener(this);
        if (Ide.getActiveProject() == null) {
            this.includedClassesButton.setEnabled(false);
            this.excludedClassesButton.setEnabled(false);
        }
    }

    private JPanel makeRemotePanel(JLabel jLabel, JLabel jLabel2, JLabel jLabel3) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 20, 0, 0), 0, 0));
        jPanel.add((Component)this.remoteHostTextField, new GridBagConstraints(1, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 20, 0, 0), 0, 0));
        jPanel.add((Component)this.remotePortTextField, new GridBagConstraints(1, n++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.promptCheckBox, new GridBagConstraints(0, n++, 0, 1, 1.0, 0.0, 17, 0, new Insets(2, 20, 0, 0), 0, 0));
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.includedClassesButton) {
            String string = ProfArb.getString(93);
            String string2 = this.includedClasses.getText();
            ArrayList arrayList = new ArrayList();
            IdeUtil.string2List((String)string2, arrayList);
            String string3 = "f1_idedclasspkginclexcl_html";
            Project project = Ide.getActiveProject();
            if (ClassPackageListBrowser.browseClassPackageList((Component)((Object)this), string, project, true, true, arrayList, "f1_idedclasspkginclexcl_html")) {
                string2 = IdeUtil.list2String(arrayList);
                this.includedClasses.setText(string2);
            }
        } else if (object == this.excludedClassesButton) {
            String string = ProfArb.getString(96);
            String string4 = this.excludedClasses.getText();
            ArrayList arrayList = new ArrayList();
            IdeUtil.string2List((String)string4, arrayList);
            String string5 = "f1_idedclasspkginclexcl_html";
            Project project = Ide.getActiveProject();
            if (ClassPackageListBrowser.browseClassPackageList((Component)((Object)this), string, project, true, true, arrayList, "f1_idedclasspkginclexcl_html")) {
                string4 = IdeUtil.list2String(arrayList);
                this.excludedClasses.setText(string4);
            }
        }
    }
}

