/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Color;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import oracle.jdevimpl.runner.profile.BaseSavable;
import oracle.jdevimpl.runner.profile.BasicEvent;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.VMMethod;

class ProfileEvent
implements BaseSavable {
    private static DecimalFormat timeFormat = new DecimalFormat("###0.00000");
    private int _id;
    private VMMethod _method;
    private int _line;
    private String _comment;
    private int _start;
    private int _end;
    private BasicEvent _ev;
    private String s_id;
    private String s_start;
    private String s_pos;
    private String s_end;
    private String s_duration;
    private boolean _commentSplited;
    private String s_shortcomment;
    private String s_helperclass;
    private String s_detail;
    private String s_comment;

    public ProfileEvent(BasicEvent basicEvent, int n, int n2, VMMethod vMMethod, int n3, String string) {
        this._ev = basicEvent;
        this._id = basicEvent.getId();
        this._method = vMMethod;
        this._line = n3;
        this._comment = string;
        this._start = n;
        this._end = n2;
        this._commentSplited = false;
    }

    public void saveToFile(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this._id);
        if (this._method != null) {
            dataOutputStream.writeInt(this._method.methodDescriptor);
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeUTF(this._comment);
        dataOutputStream.writeInt(this._line);
        dataOutputStream.writeInt(this._start);
        dataOutputStream.writeInt(this._end);
    }

    public static String timeFormater(int n) {
        return timeFormat.format((double)n / 100000.0);
    }

    boolean isCodePosition() {
        return this._method != null;
    }

    String getFileName() {
        if (this._method != null) {
            return this._method.clazz.fileName;
        }
        return null;
    }

    int getLine() {
        return this._line;
    }

    Color getColor() {
        return this._ev.getColor();
    }

    BasicEvent getEvent() {
        return this._ev;
    }

    String getPackage() {
        if (this._method != null) {
            return this._method.clazz.packageName;
        }
        return null;
    }

    public int getDuration() {
        if (this._end != -1) {
            return this._end - this._start;
        }
        return Integer.MAX_VALUE;
    }

    public int getEnd() {
        return this._end;
    }

    public int getStart() {
        return this._start;
    }

    public String getIdS() {
        if (this.s_id == null) {
            this.s_id = this._ev.getName();
        }
        return this.s_id;
    }

    public int getId() {
        return this._id;
    }

    private void splitComment() {
        if (this._commentSplited) {
            return;
        }
        int n = this._comment.indexOf("{ActionTag}");
        if (n == -1) {
            this.s_comment = this._comment;
        } else {
            int n2;
            this.s_comment = this._comment.substring(0, n);
            ++n;
            if ((n = this._comment.indexOf(123, n)) != -1 && (n2 = this._comment.indexOf(125, ++n)) != -1) {
                this.s_helperclass = this._comment.substring(n, n2);
                this.s_detail = this._comment.substring(n2 + 1);
            }
        }
        n = this._comment.indexOf(10);
        this.s_shortcomment = n == -1 ? this._comment : this._comment.substring(0, n);
        this._commentSplited = true;
    }

    public String getCommentS() {
        this.splitComment();
        return this.s_comment;
    }

    public String getShortCommentS() {
        this.splitComment();
        return this.s_shortcomment;
    }

    public String getHelperClassS() {
        this.splitComment();
        return this.s_helperclass;
    }

    public String getDetailS() {
        this.splitComment();
        return this.s_detail;
    }

    public String getPosS() {
        if (this.s_pos == null) {
            this.s_pos = this._method == null ? ProfArb.getString(323) : ProfArb.format(322, this._method, Integer.toString(this._line));
        }
        return this.s_pos;
    }

    public String getStartS() {
        if (this.s_start == null) {
            this.s_start = timeFormat.format((double)this._start / 100000.0);
        }
        return this.s_start;
    }

    public String getEndS() {
        if (this.s_end == null) {
            this.s_end = this._end == -1 ? ProfArb.getString(309) : timeFormat.format((double)this._end / 100000.0);
        }
        return this.s_end;
    }

    public float getStartF() {
        return (float)this._start / 100000.0f;
    }

    public float getEndF() {
        if (this._end == -1) {
            return -1.0f;
        }
        return (float)this._end / 100000.0f;
    }

    public String getDurationS() {
        if (this.s_duration == null) {
            int n = this.getDuration();
            this.s_duration = n == Integer.MAX_VALUE ? ProfArb.getString(309) : timeFormat.format((double)n / 100000.0);
        }
        return this.s_duration;
    }
}

