/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Rectangle;
import java.util.ArrayList;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.docking.DockingParam;
import oracle.ide.layout.ViewId;
import oracle.jdevimpl.runner.profile.ProfDockWindowStub;
import oracle.jdevimpl.runner.profile.ProfWindow;
import oracle.jdevimpl.runner.profile.UpdatableSettings;

public final class ProfilerDockableFactory
implements DockableFactory {
    private static ArrayList memoryTables = new ArrayList(2);
    private static ArrayList sampleTables = new ArrayList(2);
    private static ArrayList eventTables = new ArrayList(2);
    private static ArrayList memDetTables = new ArrayList(2);
    private static Object reserved = new Object();
    private static final String profWindowPrefix = "Profiler.";
    private static final String profSampleWindowId = "samples_";
    private static final String profEventWindowId = "events_";
    private static final String profMemoryWindowId = "memory_";
    private static final String profMemDetWindowId = "memdet_";

    public ProfilerDockableFactory() {
        DockStation.getDockStation().registerDockableFactory("Profiler", (DockableFactory)this);
    }

    private void defaultDock(Dockable dockable) {
        DockingParam dockingParam = new DockingParam();
        dockingParam.setFloatingPosition(new Rectangle(10, 10, 800, 400));
        dockingParam.setFloating(true);
        dockingParam.setFloatOnTop(false);
        DockStation.getDockStation().dock(dockable, dockingParam);
    }

    private ProfDockWindowStub getFreeWindow(ArrayList arrayList, String string, ProfWindow profWindow) {
        ProfDockWindowStub profDockWindowStub;
        int n = 0;
        while (n < arrayList.size()) {
            profDockWindowStub = (ProfDockWindowStub)((Object)arrayList.get(n));
            if (profDockWindowStub == null) {
                String string2 = profWindowPrefix + string + n;
                profDockWindowStub = new ProfDockWindowStub(string2);
                if (!string.equals(profMemDetWindowId)) {
                    this.defaultDock((Dockable)profDockWindowStub);
                }
                arrayList.set(n, profDockWindowStub);
                profDockWindowStub.setContent(profWindow);
                return profDockWindowStub;
            }
            if (profDockWindowStub.getGUI() == null) {
                profDockWindowStub.setContent(profWindow);
                return profDockWindowStub;
            }
            ++n;
        }
        String string3 = profWindowPrefix + string + n;
        profDockWindowStub = new ProfDockWindowStub(string3);
        arrayList.add(profDockWindowStub);
        profDockWindowStub.setContent(profWindow);
        if (!string.equals(profMemDetWindowId)) {
            this.defaultDock((Dockable)profDockWindowStub);
        }
        return profDockWindowStub;
    }

    public void install() {
    }

    ProfDockWindowStub getSampleWindow(ProfWindow profWindow) {
        ProfDockWindowStub profDockWindowStub = this.getFreeWindow(sampleTables, profSampleWindowId, profWindow);
        return profDockWindowStub;
    }

    ProfDockWindowStub getEventWindow(ProfWindow profWindow) {
        ProfDockWindowStub profDockWindowStub = this.getFreeWindow(eventTables, profEventWindowId, profWindow);
        return profDockWindowStub;
    }

    ProfDockWindowStub getMemoryWindow(ProfWindow profWindow) {
        ProfDockWindowStub profDockWindowStub = this.getFreeWindow(memoryTables, profMemoryWindowId, profWindow);
        return profDockWindowStub;
    }

    ProfDockWindowStub getMemoryDetailWindow(ProfWindow profWindow) {
        ProfDockWindowStub profDockWindowStub = this.getFreeWindow(memDetTables, profMemDetWindowId, profWindow);
        return profDockWindowStub;
    }

    public Dockable getDockable(ViewId viewId) {
        String string = viewId.getName();
        ArrayList arrayList = null;
        if (string.startsWith(profSampleWindowId)) {
            arrayList = sampleTables;
        } else if (string.startsWith(profEventWindowId)) {
            arrayList = eventTables;
        } else if (string.startsWith(profMemoryWindowId)) {
            arrayList = memoryTables;
        } else if (string.startsWith(profMemDetWindowId)) {
            arrayList = memDetTables;
        }
        if (arrayList == null) {
            return null;
        }
        int n = Integer.parseInt(string.substring(string.lastIndexOf(95) + 1));
        while (arrayList.size() <= n) {
            arrayList.add(null);
        }
        ProfDockWindowStub profDockWindowStub = (ProfDockWindowStub)((Object)arrayList.get(n));
        if (profDockWindowStub == null) {
            profDockWindowStub = new ProfDockWindowStub(viewId.getId());
            profDockWindowStub.setDockableVisible(false);
            arrayList.set(n, profDockWindowStub);
        }
        return profDockWindowStub;
    }

    private static void enumeratePool(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            ProfWindow profWindow;
            ProfDockWindowStub profDockWindowStub = (ProfDockWindowStub)((Object)arrayList.get(n));
            if (profDockWindowStub != null && profDockWindowStub.getGUI() != null && (profWindow = profDockWindowStub.getContent()) instanceof UpdatableSettings) {
                ((UpdatableSettings)((Object)profWindow)).updateSettings();
            }
            ++n;
        }
    }

    static void enumerateProfWindow() {
        ProfilerDockableFactory.enumeratePool(memoryTables);
        ProfilerDockableFactory.enumeratePool(sampleTables);
        ProfilerDockableFactory.enumeratePool(eventTables);
        ProfilerDockableFactory.enumeratePool(memDetTables);
    }
}

