/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.io.DataInputStream;

public class ProfilerMessage {
    int messageId;
    byte[] buffer;
    int offset;
    int size;
    public ProfilerMessage next;

    ProfilerMessage(int n, DataInputStream dataInputStream) {
        this.size = n;
        this.buffer = new byte[n];
        try {
            dataInputStream.readFully(this.buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.messageId = this.getByte();
    }

    public int getByte() {
        return this.buffer[this.offset++];
    }

    public int getUByte() {
        int n = this.getByte();
        if (n < 0) {
            n = 256 + n;
        }
        return n;
    }

    public int getInt() {
        return (this.getUByte() << 24) + (this.getUByte() << 16) + (this.getUByte() << 8) + this.getUByte();
    }

    public String getString() {
        String string = "";
        int n = this.getInt();
        if (n != 0) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, this.offset, byArray, 0, n);
            this.offset += n;
            try {
                string = new String(byArray, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public long getLong() {
        return (this.getInt() << 32) + this.getInt();
    }

    public int getMessageId() {
        return this.messageId;
    }

    public Object readObject(char c) {
        switch (c) {
            case 'L': 
            case '[': {
                int n = this.getInt();
                if (n == 0) {
                    return "null";
                }
                return Integer.toString(n, 16);
            }
            case 'X': {
                return this.getString();
            }
            case 'V': {
                return "void";
            }
            case 'Z': {
                return new Boolean(this.getInt() != 0);
            }
            case 'B': {
                return new Byte((byte)this.getInt());
            }
            case 'C': {
                return new Character((char)this.getInt());
            }
            case 'S': {
                return new Short((short)this.getInt());
            }
            case 'I': {
                return new Integer(this.getInt());
            }
            case 'D': {
                return new Double(this.getLong());
            }
            case 'F': {
                return new Float(this.getInt());
            }
            case 'J': {
                return new Long(this.getLong());
            }
        }
        System.out.println("Unknown type" + c);
        return null;
    }
}

