/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import oracle.ide.Ide;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfilerMessage;
import oracle.jdevimpl.runner.profile.ProfilingProcess;

class ProfilerMessageReader
implements Runnable {
    private static final boolean DEBUG = false;
    private DataInputStream inputStream;
    private DataOutputStream outputStream;
    private Socket clientSock;
    private ProfilerMessage head;
    private ProfilerMessage tail;
    private ProfilingProcess process;
    private int port;
    private String host;
    private boolean connected;

    public ProfilerMessageReader(ProfilingProcess profilingProcess, String string, int n) {
        this.process = profilingProcess;
        this.host = string;
        this.port = n;
        this.connected = true;
    }

    public void openConnection() throws IOException {
        InetAddress inetAddress = InetAddress.getByName(this.host);
        this.clientSock = new Socket(inetAddress, this.port);
        this.clientSock.setTcpNoDelay(true);
        this.clientSock.setSoTimeout(250);
    }

    public void closeConnection() {
        this.connected = false;
        this.clientSock = null;
    }

    public synchronized void connect() throws Exception {
        boolean bl = false;
        int n = 5;
        int n2 = 100;
        boolean bl2 = this.process.getRunConfiguration().isRemoteDebuggingProfiling();
        if (bl2) {
            String string = this.process.getConfiguration().isPromptForRemoteProfiling() ? ProfArb.format(303, this.host, Integer.toString(this.port)) : ProfArb.format(304, this.host, Integer.toString(this.port));
            this.process.getLogPage().log((Object)string);
        }
        while (true) {
            try {
                Thread.sleep(n2);
                this.openConnection();
                this.inputStream = new DataInputStream(new BufferedInputStream(this.clientSock.getInputStream(), 32768));
                this.outputStream = new DataOutputStream(new BufferedOutputStream(this.clientSock.getOutputStream()));
                this.connected = true;
                if (bl2) {
                    this.process.getLogPage().log((Object)"\n");
                }
                Ide.getStatusBar().setText("");
                return;
            }
            catch (Exception exception) {
                this.process.getLogPage().log((Object)".");
                Ide.getStatusBar().setText(ProfArb.getString(306));
                if (n-- == 0) {
                    if (bl2) {
                        this.process.getLogPage().log((Object)"\n");
                        this.process.getLogPage().log((Object)ProfArb.getString(305));
                    }
                    this.closeConnection();
                    Ide.getStatusBar().setText("");
                    this.disconnect();
                    if (bl) {
                        throw (Exception)exception.fillInStackTrace();
                    }
                    throw new Exception();
                }
                n2 *= 2;
                continue;
            }
            break;
        }
    }

    public synchronized void disconnect() throws Exception {
        throw new Exception("Socket error");
    }

    public synchronized void disconnectLow(Exception exception) throws Exception {
        this.disconnect();
    }

    private ProfilerMessage receiveProfilerMessage() {
        try {
            int n = this.inputStream.readInt();
            this.clientSock.setSoTimeout(0);
            ProfilerMessage profilerMessage = new ProfilerMessage(n, this.inputStream);
            return profilerMessage;
        }
        catch (Exception exception) {
            ProfilerMessage profilerMessage = null;
            return profilerMessage;
        }
    }

    private synchronized void sendByte(int n) throws Exception {
        if (this.outputStream == null) {
            System.out.println("null outputstream");
            return;
        }
        try {
            this.outputStream.writeByte(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.disconnectLow(exception);
        }
    }

    private synchronized void sendInt(int n) throws Exception {
        if (this.outputStream == null) {
            return;
        }
        try {
            this.outputStream.writeInt(n);
        }
        catch (Exception exception) {
            this.disconnectLow(exception);
        }
    }

    public void sendMessage(int n) throws Exception {
        this.sendByte(n);
        this.flush();
    }

    public synchronized void sendMessageInt(int n, int n2) throws Exception {
        this.sendByte(n);
        this.sendInt(n2);
        this.flush();
    }

    public synchronized void sendMessageString(int n, String string) {
        try {
            this.sendByte(n);
            this.sendString(string);
            this.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private synchronized void sendString(String string) throws Exception {
        if (this.outputStream == null) {
            return;
        }
        try {
            if (string != null) {
                this.outputStream.writeInt(string.length());
                this.outputStream.writeBytes(string);
            } else {
                this.outputStream.writeInt(0);
            }
        }
        catch (Exception exception) {
            this.disconnectLow(exception);
        }
    }

    private synchronized void flush() throws Exception {
        try {
            this.outputStream.flush();
        }
        catch (Exception exception) {
            this.disconnectLow(exception);
        }
    }

    private synchronized void postMessage(ProfilerMessage profilerMessage) {
        if (this.tail == null) {
            this.tail = profilerMessage;
            if (this.head != null) {
                System.out.println("postMessage error");
            }
        }
        if (this.head != null) {
            this.head.next = profilerMessage;
        }
        this.head = profilerMessage;
    }

    public synchronized ProfilerMessage getMessage() throws Exception {
        if (this.tail != null) {
            ProfilerMessage profilerMessage = this.tail;
            this.tail = this.tail.next;
            if (this.tail == null) {
                this.head = null;
            }
            return profilerMessage;
        }
        if (!this.connected) {
            throw new Exception();
        }
        return null;
    }

    private void read() throws Exception {
        try {
            while (true) {
                if (this.inputStream.available() > 0) {
                    ProfilerMessage profilerMessage = this.receiveProfilerMessage();
                    if (profilerMessage == null) continue;
                    this.postMessage(profilerMessage);
                    continue;
                }
                if (this.process.hasFinished()) {
                    this.connected = false;
                }
                Thread.sleep(10);
                if (!this.connected) break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        try {
            this.connect();
            this.read();
        }
        catch (Exception exception) {
            this.process.terminateProcess();
        }
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }
}

