/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.util.Arrays;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.config.ClientSetting;
import oracle.javatools.util.Copyable;

public class ProfilerSettings
extends ChangeEventSource
implements Copyable {
    public static final String KEY_SETTINGS = "ProfilerSettings";
    private final boolean[] _memColumnVisible;
    private final boolean[] _eventColumnVisible;
    private final boolean[] _sampleColumnVisible;

    static ProfilerSettings getInstance() {
        return (ProfilerSettings)ClientSetting.findOrCreate((String)"oracle.jdeveloper").getData(KEY_SETTINGS);
    }

    void $init$() {
        this._memColumnVisible = new boolean[10];
        this._eventColumnVisible = new boolean[6];
        this._sampleColumnVisible = new boolean[7];
    }

    public ProfilerSettings() {
        this.$init$();
        this.defaultInit();
    }

    public ProfilerSettings(ProfilerSettings profilerSettings) {
        this.$init$();
        if (profilerSettings == null) {
            this.defaultInit();
        } else {
            profilerSettings.copyToImpl(this);
        }
    }

    private void defaultInit() {
        Arrays.fill(this._memColumnVisible, true);
        Arrays.fill(this._eventColumnVisible, true);
        Arrays.fill(this._sampleColumnVisible, true);
    }

    public Object copyTo(Object object) {
        ProfilerSettings profilerSettings = object != null ? (ProfilerSettings)((Object)object) : new ProfilerSettings();
        this.copyToImpl(profilerSettings);
        return profilerSettings;
    }

    protected final void copyToImpl(ProfilerSettings profilerSettings) {
        System.arraycopy(this._memColumnVisible, 0, profilerSettings._memColumnVisible, 0, this._memColumnVisible.length);
        System.arraycopy(this._eventColumnVisible, 0, profilerSettings._eventColumnVisible, 0, this._eventColumnVisible.length);
        System.arraycopy(this._sampleColumnVisible, 0, profilerSettings._sampleColumnVisible, 0, this._sampleColumnVisible.length);
        profilerSettings.fireChangeEvent();
    }

    public boolean[] getMemColumnVisible() {
        return this._memColumnVisible;
    }

    public void setMemColumnVisible(boolean[] blArray) {
        System.arraycopy(blArray, 0, this._memColumnVisible, 0, this._memColumnVisible.length);
    }

    public boolean[] getEventColumnVisible() {
        return this._eventColumnVisible;
    }

    public void setEventColumnVisible(boolean[] blArray) {
        System.arraycopy(blArray, 0, this._eventColumnVisible, 0, this._eventColumnVisible.length);
    }

    public boolean[] getSampleColumnVisible() {
        return this._sampleColumnVisible;
    }

    public void setSampleColumnVisible(boolean[] blArray) {
        System.arraycopy(blArray, 0, this._sampleColumnVisible, 0, this._sampleColumnVisible.length);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((ProfilerSettings)((Object)object));
    }

    protected final boolean equalsImpl(ProfilerSettings profilerSettings) {
        return Arrays.equals(this._memColumnVisible, profilerSettings._memColumnVisible) && Arrays.equals(this._eventColumnVisible, profilerSettings._eventColumnVisible) && Arrays.equals(this._sampleColumnVisible, profilerSettings._sampleColumnVisible);
    }
}

