/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.Frame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.model.Node;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.IntHashMap;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.profiler.ProfilerAPI;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarterFactory;
import oracle.jdeveloper.runner.RemoteConnectDialog;
import oracle.jdevimpl.runner.Helpers;
import oracle.jdevimpl.runner.profile.BasicEvent;
import oracle.jdevimpl.runner.profile.CallCountItem;
import oracle.jdevimpl.runner.profile.EventTable;
import oracle.jdevimpl.runner.profile.FileSaver;
import oracle.jdevimpl.runner.profile.HTMLSaver;
import oracle.jdevimpl.runner.profile.HeapDetailStat;
import oracle.jdevimpl.runner.profile.HeapStat;
import oracle.jdevimpl.runner.profile.JProfiler;
import oracle.jdevimpl.runner.profile.MemoryDetailTable;
import oracle.jdevimpl.runner.profile.MemoryMonitor;
import oracle.jdevimpl.runner.profile.MemoryTable;
import oracle.jdevimpl.runner.profile.MethodCallCountItem;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfDockWindowStub;
import oracle.jdevimpl.runner.profile.ProfWindow;
import oracle.jdevimpl.runner.profile.ProfileConfiguration;
import oracle.jdevimpl.runner.profile.ProfileEvent;
import oracle.jdevimpl.runner.profile.ProfilerMessage;
import oracle.jdevimpl.runner.profile.ProfilerMessageReader;
import oracle.jdevimpl.runner.profile.RootCallCountItem;
import oracle.jdevimpl.runner.profile.SampleTable;
import oracle.jdevimpl.runner.profile.SubCallCount;
import oracle.jdevimpl.runner.profile.ThreadCallCountItem;
import oracle.jdevimpl.runner.profile.VMClass;
import oracle.jdevimpl.runner.profile.VMMethod;
import oracle.jdevimpl.runner.profile.VMThread;
import oracle.jdevimpl.runner.profile.VMTypes;

final class ProfilingProcess
extends JRunProcess {
    static final String PROFILES_MEMORY_TABLE_ID = "Profiler.MemoryTable";
    private JProfiler jprofiler;
    private boolean expectMethodCallTracking;
    private ProfDockWindowStub winStub;
    private IntHashMap methodMap;
    private IntHashMap classMap;
    private IntHashMap threadMap;
    private int runNumber;
    private int localport;
    private String host;
    private String runTitle;
    private String tabName;
    private ProfilerMessageReader messageReader;
    private VMMethod lastMethod;
    private SampleTable sampleTable;
    private MemoryMonitor memoryMonitor;
    private MemoryTable memoryTable;
    private EventTable eventTable;
    private Map memoryDetailMap;
    private boolean processIsActive;
    private int sliderDepth;
    private int _profType;
    private ProfWindow lastWindow;
    private static final boolean DEBUG = false;
    private static final int PRF_FIRST_EVENT_ID = 1200;
    private static final int PRF_RECEIVE_ID = 1200;
    private static final int PRF_SEND_ID = 1201;
    private static final boolean PRF_RECEIVE_ON = ProfilerAPI.isActive && ProfilerAPI.isEventActive(1200);
    private static final boolean PRF_SEND_ON = ProfilerAPI.isActive && ProfilerAPI.isEventActive(1201);
    private static final int PROFMSG_ACK_PROCESS_END = 1;
    private static final int PROFMSG_PERFORM_GC = 2;
    private static final int PROFMSG_DUMP_GC = 3;
    private static final int PROFMSG_TERMINATE = 4;
    private static final int PROFMSG_RUN = 5;
    private static final int PROFMSG_PAUSE = 7;
    private static final int PROFMSG_ASK_ALLOC_DETAIL = 8;
    private static final int PROFMSG_STOP_ALLOC_DETAIL = 9;
    private static final int PROFMSG_CLEAR_SAMPLES = 10;
    private static final int PROFMSG_SEND_OPTIONS = 11;
    private static final int PROFMSG_PROCESS_START = 0;
    private static final int PROFMSG_CLASS_LOAD = 1;
    private static final int PROFMSG_CLASS_DATA = 2;
    private static final int PROFMSG_METHOD_DATA = 3;
    private static final int PROFMSG_METHOD_START = 4;
    private static final int PROFMSG_METHOD_END = 5;
    private static final int PROFMSG_METHOD_ENTER = 6;
    private static final int PROFMSG_METHOD_EXIT = 7;
    private static final int PROFMSG_METHOD_RETURNVALUE = 8;
    private static final int PROFMSG_THREAD_START = 9;
    private static final int PROFMSG_THREAD_END = 10;
    private static final int PROFMSG_PROCESS_END = 11;
    private static final int PROFMSG_TIME_DUMP_START = 12;
    private static final int PROFMSG_GC_INIT = 13;
    private static final int PROFMSG_GC_UPDATE = 14;
    private static final int PROFMSG_GC_START = 15;
    private static final int PROFMSG_GC_END = 16;
    private static final int PROFMSG_GC_ALLOC = 17;
    private static final int PROFMSG_GC_OBJ_ALLOC = 18;
    private static final int PROFMSG_GC_OBJ_DUMP_START = 19;
    private static final int PROFMSG_GC_OBJ_DUMP_END = 20;
    private static final int PROFMSG_PARAM_LIST_START = 21;
    private static final int PROFMSG_CALLCOUNT_SAMPLE_DUMP_START = 22;
    private static final int PROFMSG_METHOD_LINES_DUMP_START = 23;
    private static final int PROFMSG_GC_SNAPSHOT_START = 24;
    private static final int PROFMSG_GC_SNAPSHOT_END = 25;
    private static final int PROFMSG_STACKDUMP_START = 26;
    private static final int PROFMSG_STACKDUMP_END = 27;
    private static final int PROFMSG_METHOD_MEMORY_DUMP_START = 28;
    private static final int PROFMSG_SEND_ALLOCATION_DIFF = 29;
    private static final int PROFMSG_SEND_ALLOCATION_DETAIL_DIFF = 30;
    private static final int PROFMSG_SEND_ALLOCATION_DIFF_P = 31;
    private static final int PROFMSG_SEND_ALLOCATION_DETAIL_DIFF_P = 32;
    private static final int PROFMSG_START_ALLOC_DUMP = 33;
    private static final int PROFMSG_END_ALLOC_DUMP = 34;
    private static final int PROFMSG_DUMP_EVENTS = 35;

    void $init$() {
        this.host = "";
    }

    ProfilingProcess(JProfiler jProfiler, int n, int n2) {
        this(jProfiler, n, n2, null, null);
    }

    ProfilingProcess(JProfiler jProfiler, int n, int n2, ProfWindow profWindow, Map map) {
        this.$init$();
        this.lastWindow = profWindow;
        this.jprofiler = jProfiler;
        this._profType = n;
        this.runNumber = n2;
        this.expectMethodCallTracking = false;
        if (n == 10) {
            return;
        }
        this.methodMap = new IntHashMap(10000);
        this.classMap = new IntHashMap(1000);
        this.threadMap = new IntHashMap(25);
        if (n == 2) {
            this.memoryDetailMap = map == null ? new HashMap(5) : map;
        }
        VMClass vMClass = new VMClass();
        vMClass.classDescriptor = 0;
        vMClass.packageName = "";
        vMClass.name = ProfArb.getString(319);
        vMClass.fileName = "";
        vMClass.methodCount = 0;
        Object var7_7 = null;
        vMClass.methodArray = null;
        this.classMap.put(0, (Object)vMClass);
        ProfileConfiguration profileConfiguration = this.getConfiguration();
        this.sliderDepth = profileConfiguration.getSliderDepth();
    }

    ProfileConfiguration getConfiguration() {
        return ProfileConfiguration.getInstance((PropertyStorage)this.getJProject());
    }

    void saveMapToFile(IntHashMap intHashMap, DataOutputStream dataOutputStream) throws IOException {
        int n = intHashMap.size();
        dataOutputStream.writeInt(n);
        for (VMTypes vMTypes : intHashMap) {
            vMTypes.saveToFile(dataOutputStream);
        }
    }

    void saveMapsToFile(DataOutputStream dataOutputStream) throws IOException {
        this.saveMapToFile(this.threadMap, dataOutputStream);
        this.saveMapToFile(this.classMap, dataOutputStream);
        this.saveMapToFile(this.methodMap, dataOutputStream);
    }

    void readMapsFromFile(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        this.threadMap = new IntHashMap(n);
        int n2 = 0;
        while (n2 < n) {
            VMThread vMThread = VMThread.readFromFile(dataInputStream);
            this.threadMap.put(vMThread.threadDescriptor, (Object)vMThread);
            ++n2;
        }
        n = dataInputStream.readInt();
        this.classMap = new IntHashMap(n);
        n2 = 0;
        while (n2 < n) {
            VMClass vMClass = VMClass.readFromFile(dataInputStream);
            this.classMap.put(vMClass.classDescriptor, (Object)vMClass);
            ++n2;
        }
        n = dataInputStream.readInt();
        this.methodMap = new IntHashMap(n);
        n2 = 0;
        while (n2 < n) {
            VMMethod vMMethod = VMMethod.readFromFile(dataInputStream, this.classMap);
            this.methodMap.put(vMMethod.methodDescriptor, (Object)vMMethod);
            ++n2;
        }
    }

    void readSampleArrayFromFile(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        IntHashMap intHashMap = new IntHashMap(n2 * 2);
        ArrayList<CallCountItem> arrayList = new ArrayList<CallCountItem>(n2);
        int n3 = 0;
        while (n3 < n2) {
            CallCountItem callCountItem = CallCountItem.readFromFile(dataInputStream, this.methodMap);
            intHashMap.put(callCountItem.ref, (Object)callCountItem);
            arrayList.add(callCountItem);
            ++n3;
        }
        n3 = 0;
        while (n3 < arrayList.size()) {
            CallCountItem callCountItem = (CallCountItem)arrayList.get(n3);
            ArrayList arrayList2 = callCountItem.getCalledList();
            callCountItem.calledTotal = callCountItem.getCallCount();
            int n4 = 0;
            while (n4 < arrayList2.size()) {
                SubCallCount subCallCount = (SubCallCount)arrayList2.get(n4);
                callCountItem.calledTotal += subCallCount.count;
                CallCountItem callCountItem2 = (CallCountItem)intHashMap.get(((Integer)subCallCount.ref).intValue());
                SubCallCount subCallCount2 = new SubCallCount(subCallCount.count, callCountItem);
                callCountItem2.callerTotal += subCallCount.count;
                callCountItem2.getCallerList().add(subCallCount2);
                subCallCount.ref = callCountItem2;
                ++n4;
            }
            ++n3;
        }
        SampleTable sampleTable = this.getSampleTable();
        sampleTable.setData(n, arrayList);
        sampleTable.notifyProcessEnd();
    }

    void readEventsArrayFromFile(DataInputStream dataInputStream) throws IOException {
        ProfileConfiguration profileConfiguration = this.getConfiguration();
        int n = dataInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            BasicEvent basicEvent = BasicEvent.readFromFile(dataInputStream);
            profileConfiguration.eventFromId(basicEvent._id, basicEvent);
            ++n2;
        }
        n = dataInputStream.readInt();
        ProfileEvent[] profileEventArray = new ProfileEvent[n];
        int n3 = 0;
        while (n3 < n) {
            int n4 = dataInputStream.readInt();
            int n5 = dataInputStream.readInt();
            String string = dataInputStream.readUTF();
            int n6 = dataInputStream.readInt();
            int n7 = dataInputStream.readInt();
            int n8 = dataInputStream.readInt();
            profileEventArray[n3] = new ProfileEvent(profileConfiguration.eventFromId(n4), n7, n8, (VMMethod)this.methodMap.get(n5), n6, string);
            ++n3;
        }
        EventTable eventTable = this.getEventTable();
        eventTable.setData(profileEventArray);
        eventTable.notifyProcessEnd();
    }

    void readMemorySessionFromFile(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2 = dataInputStream.readInt();
        this.sliderDepth = n = dataInputStream.readInt();
        this.memoryDetailMap = new HashMap(5);
        MemoryTable memoryTable = this.getMemoryTable();
        memoryTable.setCurrentSize(n - 1);
        memoryTable.setTotalSample(n2);
        int n3 = n;
        while (--n3 >= 0) {
            HeapDetailStat heapDetailStat = HeapDetailStat.readFromFile(dataInputStream, this.methodMap);
            int n4 = dataInputStream.readInt();
            HeapStat[] heapStatArray = new HeapStat[n4];
            int n5 = 0;
            while (n5 < n4) {
                heapStatArray[n5] = HeapStat.readFromFile(dataInputStream, this.classMap);
                ++n5;
            }
            memoryTable.setDataAtPosition(n3, heapDetailStat, heapStatArray);
            int n6 = dataInputStream.readInt();
            while (--n6 >= 0) {
                int n7 = dataInputStream.readInt();
                VMClass vMClass = (VMClass)this.classMap.get(n7);
                MemoryDetailTable memoryDetailTable = this.getMemoryDetailTable(vMClass, false);
                memoryDetailTable.setCurrentSize(n - 1);
                n4 = dataInputStream.readInt();
                HeapDetailStat[] heapDetailStatArray = new HeapDetailStat[n4];
                n5 = 0;
                while (n5 < n4) {
                    heapDetailStatArray[n5] = HeapDetailStat.readFromFile(dataInputStream, this.methodMap);
                    ++n5;
                }
                memoryDetailTable.setDataAtPosition(n3, heapDetailStatArray);
            }
        }
        memoryTable.notifyProcessEnd();
        memoryTable.finishedLoading();
    }

    int getSliderDepth() {
        return this.sliderDepth;
    }

    public boolean canRun(String string, Object object, Node node, List list) {
        if ("Java".equals(string)) {
            return this.canRunJava(node, list);
        }
        if ("Database".equals(string)) {
            list.add(ProfArb.format(296, node.getShortLabel()));
            return false;
        }
        if ("XSLT".equals(string)) {
            list.add(ProfArb.format(297, node.getShortLabel()));
            return false;
        }
        if ("XQuery".equals(string)) {
            list.add(ProfArb.format(298, node.getShortLabel()));
            return false;
        }
        return false;
    }

    private boolean canRunJava(Node node, List list) {
        if (!this.runConfiguration.isRemoteDebuggingProfiling()) {
            JDK jDK = this.getJdkDefinition();
            if (this.runConfiguration.usingOJVM(jDK)) {
                return true;
            }
            list.add(ProfArb.format(299, node.getShortLabel()));
            return false;
        }
        return true;
    }

    public Object getValue(String string, Object object, String string2) {
        if ("Java".equals(string) && "FirstJavaCommandOptions".equals(string2)) {
            return this.getFirstJavaCommandOptions();
        }
        if ("Database".equals(string)) {
            // empty if block
        }
        if ("XSLT".equals(string)) {
            // empty if block
        }
        return null;
    }

    private String[] getFirstJavaCommandOptions() {
        String string = "-XXtimeport" + this.localport;
        return IdeUtil.convertStringToStringArray((String)string);
    }

    public String getExtraOptions() {
        String string = null;
        ProfileConfiguration profileConfiguration = this.getConfiguration();
        switch (this._profType) {
            case 0: {
                string = new String("execution,");
                string = string + "sample" + profileConfiguration.getSampleInterval();
                break;
            }
            case 1: {
                string = new String("events,useapi");
                string = string + ",evex(" + profileConfiguration.exclEventList() + ")";
                string = string + ",dmsid( " + profileConfiguration.buildDMSEvList() + ")";
                break;
            }
            case 2: {
                string = new String("monitormemory,");
                string = string + "update" + profileConfiguration.getMemoryUpdateInterval();
                string = string + ",excli(" + profileConfiguration.getExcludedInstances() + ")";
                string = string + ",incli(" + profileConfiguration.getIncludedInstances() + ")";
                if (this.memoryDetailMap.size() == 0) break;
                string = string + ",memdet(";
                Iterator iterator = this.getMemoryDetailTableIterator();
                while (iterator.hasNext()) {
                    MemoryDetailTable memoryDetailTable = (MemoryDetailTable)iterator.next();
                    string = string + memoryDetailTable.getClazz().getInternalName() + ';';
                }
                string = string + ')';
            }
        }
        if (profileConfiguration.isUseAPI()) {
            string = string + ",useapi";
        }
        string = string + ",excl(" + profileConfiguration.getExcludedClasses() + ")";
        string = string + ",incl(" + profileConfiguration.getIncludedClasses() + ")";
        return string;
    }

    public String getTabName() {
        return this.tabName;
    }

    public String getProcessLabelPrefix() {
        return ProfArb.getString(75);
    }

    public Icon getIcon() {
        switch (this._profType) {
            case 0: {
                return ProfArb.getIcon(15);
            }
            case 1: {
                return ProfArb.getIcon(18);
            }
            case 2: {
                return ProfArb.getIcon(23);
            }
        }
        return null;
    }

    private void superTerminate() {
        super.terminate();
    }

    protected Class getStarterFactorySubClass() {
        return JStarterFactory.class;
    }

    protected void determineTargetAndStarter(Class clazz) {
        if (this._profType != 10 && !this.runConfiguration.isRemoteDebuggingProfiling()) {
            super.determineTargetAndStarter(clazz);
        }
    }

    protected boolean compile() {
        if (this._profType == 10 || this.runConfiguration.isRemoteDebuggingProfiling()) {
            return true;
        }
        return super.compile();
    }

    protected boolean startTarget() {
        ProfileConfiguration profileConfiguration = this.getConfiguration();
        if (this._profType == 10) {
            URL uRL = FileSaver.chooseFileName(this.getContext());
            if (uRL != null) {
                this.runTitle = new File(uRL.getFile()).getName();
                DataInputStream dataInputStream = FileSaver.selectResultStream(uRL);
                if (dataInputStream != null) {
                    this.readDataFromStream(dataInputStream);
                }
            }
            return false;
        }
        if (this.runConfiguration.isRemoteDebuggingProfiling()) {
            this.host = profileConfiguration.getRemoteHost();
            this.localport = profileConfiguration.getRemotePort();
            if (profileConfiguration.isPromptForRemoteProfiling()) {
                String[] stringArray = new String[2];
                String[] stringArray2 = new String[2];
                boolean[] blArray = new boolean[2];
                boolean[] blArray2 = new boolean[1];
                stringArray[0] = ProfArb.getString(301);
                stringArray2[0] = this.host;
                blArray[0] = true;
                stringArray[1] = ProfArb.getString(302);
                stringArray2[1] = Integer.toString(this.localport);
                blArray[1] = false;
                boolean bl = RemoteConnectDialog.showRemoteConnectDialog(ProfArb.getString(290), stringArray, stringArray2, blArray, blArray2, ProfArb.getString(7));
                if (!bl) {
                    return false;
                }
                this.host = stringArray2[0];
                try {
                    this.localport = Integer.parseInt(stringArray2[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (blArray2[0] || this.runConfiguration.isCustom()) {
                    profileConfiguration.setRemoteHost(stringArray2[0]);
                    profileConfiguration.setRemotePort(this.localport);
                }
                if (blArray2[0]) {
                    profileConfiguration.setPromptForRemoteProfiling(false);
                }
            }
        } else {
            this.host = "";
            this.localport = Helpers.getLocalPort();
            if (!super.startTarget()) {
                return false;
            }
        }
        this.runTitle = ProfArb.format(83, Integer.toString(this.runNumber), this.getShortLabel());
        this.tabName = "#" + this.runNumber + " " + this.getShortLabel();
        2 var10_10 = new 2();
        var10_10.start();
        if (this.runConfiguration.isRemoteDebuggingProfiling()) {
            super.started();
        }
        return true;
    }

    public boolean canTerminate() {
        return true;
    }

    public void terminate() {
        if (this.starter != null && this.starter.canTerminateGracefully()) {
            this.starter.terminateGracefully();
            return;
        }
        this.terminateProcess();
    }

    private MemoryTable getMemoryTable() {
        if (this.memoryTable == null) {
            if (this.lastWindow == null) {
                this.memoryTable = new MemoryTable(this, this.classMap);
                this.winStub = this.jprofiler.dockFactory.getMemoryWindow(this.memoryTable);
                DockStation.getDockStation().setDockableVisible(this.winStub.getId(), true);
                this.memoryTable.setStub(this.winStub);
            } else {
                Iterator iterator = this.getMemoryDetailTableIterator();
                while (iterator.hasNext()) {
                    MemoryDetailTable memoryDetailTable = (MemoryDetailTable)iterator.next();
                    memoryDetailTable.resetProcess(this, this.methodMap);
                }
                this.memoryTable = (MemoryTable)this.lastWindow;
                this.memoryTable.resetProcess(this, this.classMap);
                this.winStub = this.memoryTable.getStub();
            }
            this.lastWindow = this.memoryTable;
        }
        return this.memoryTable;
    }

    private EventTable getEventTable() {
        if (this.eventTable == null) {
            if (this.lastWindow == null) {
                this.eventTable = new EventTable(this);
                this.winStub = this.jprofiler.dockFactory.getEventWindow(this.eventTable);
                DockStation.getDockStation().setDockableVisible(this.winStub.getId(), true);
                this.eventTable.setStub(this.winStub);
            } else {
                this.eventTable = (EventTable)this.lastWindow;
                this.eventTable.resetProcess(this);
            }
            this.lastWindow = this.eventTable;
        }
        return this.eventTable;
    }

    private SampleTable getSampleTable() {
        if (this.sampleTable == null) {
            if (this.lastWindow == null) {
                this.sampleTable = new SampleTable(this);
                this.winStub = this.jprofiler.dockFactory.getSampleWindow(this.sampleTable);
                DockStation.getDockStation().setDockableVisible(this.winStub.getId(), true);
                this.sampleTable.setStub(this.winStub);
            } else {
                this.sampleTable = (SampleTable)this.lastWindow;
                this.sampleTable.resetProcess(this);
            }
            this.lastWindow = this.sampleTable;
        }
        return this.sampleTable;
    }

    private synchronized MemoryDetailTable getMemoryDetailTable(VMClass vMClass, boolean bl) {
        MemoryDetailTable memoryDetailTable = (MemoryDetailTable)this.memoryDetailMap.get(vMClass.toString());
        if (memoryDetailTable == null && !bl) {
            memoryDetailTable = new MemoryDetailTable(this, vMClass, this.methodMap);
            this.memoryDetailMap.put(vMClass.toString(), memoryDetailTable);
            ProfDockWindowStub profDockWindowStub = this.jprofiler.dockFactory.getMemoryDetailWindow(memoryDetailTable);
            memoryDetailTable.setStub(profDockWindowStub);
            DockingParam dockingParam = new DockingParam();
            dockingParam.setPosition((Dockable)this.winStub, 3);
            DockStation dockStation = DockStation.getDockStation();
            dockStation.dock((Dockable)profDockWindowStub, dockingParam);
            dockStation.setDockableVisible((Dockable)profDockWindowStub, true);
        }
        memoryDetailTable.setClazz(vMClass);
        return memoryDetailTable;
    }

    synchronized Iterator getMemoryDetailTableIterator() {
        return this.memoryDetailMap.values().iterator();
    }

    boolean isProcessActive() {
        return this.processIsActive;
    }

    boolean askMethodDetails(HeapStat heapStat) {
        try {
            if (this.processIsActive) {
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent(1201, "PROFMSG_ASK_ALLOC_DETAIL " + heapStat.getClassDesc());
                }
                this.messageReader.sendMessageInt(8, heapStat.getClassDesc());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
    }

    boolean stopMethodDetails(VMClass vMClass) {
        try {
            Object v = this.memoryDetailMap.remove(vMClass.toString());
            if (v != null && this.processIsActive) {
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent(1201, "PROFMSG_STOP_ALLOC_DETAIL " + vMClass.getInternalName());
                }
                this.messageReader.sendMessageString(9, vMClass.getInternalName());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
    }

    void stopAllMethodDetails() {
        boolean bl;
        do {
            bl = false;
            try {
                Iterator iterator = this.getMemoryDetailTableIterator();
                while (iterator.hasNext()) {
                    MemoryDetailTable memoryDetailTable = (MemoryDetailTable)iterator.next();
                    DockStation.getDockStation().undock((Dockable)memoryDetailTable.getStub());
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (bl);
        this.terminateProcess();
    }

    void terminateProcess() {
        try {
            if (this.processIsActive) {
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent(1201, "PROFMSG_TERMINATE ");
                }
                this.messageReader.sendMessage(4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.processEnded();
    }

    boolean performGC() {
        try {
            if (this.processIsActive) {
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent(1201, "PROFMSG_PERFORM_GC ");
                }
                this.messageReader.sendMessage(2);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
    }

    boolean performRunCommand() {
        try {
            if (this.processIsActive) {
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent(1201, "PROFMSG_RUN ");
                }
                this.messageReader.sendMessage(5);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
    }

    boolean performPauseCommand() {
        try {
            if (this.processIsActive) {
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent(1201, "PROFMSG_PAUSE ");
                }
                this.messageReader.sendMessage(7);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
    }

    boolean performSnapshotCommand() {
        try {
            if (this.processIsActive) {
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent(1201, "PROFMSG_PAUSE (Snapshot)");
                }
                this.messageReader.sendMessage(7);
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent(1201, "PROFMSG_RUN (Snapshot)");
                }
                this.messageReader.sendMessage(5);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
    }

    boolean performRestartCommand() {
        try {
            if (this.processIsActive) {
                this.terminate();
            }
            this.jprofiler.reStartProcess(this._profType, this.lastWindow, this.memoryDetailMap);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
    }

    boolean performTerminateCommand() {
        try {
            if (this.processIsActive) {
                this.terminate();
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
    }

    boolean performClearSampleCommand() {
        try {
            if (this.processIsActive) {
                if (PRF_SEND_ON) {
                    ProfilerAPI.pulseEvent(1201, "PROFMSG_CLEAR_SAMPLES");
                }
                this.messageReader.sendMessage(10);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
    }

    public boolean isPopupActive() {
        return this.jprofiler.isPopupActive();
    }

    private void processEnded() {
        this.processIsActive = false;
        if (this.memoryMonitor != null) {
            this.memoryMonitor.stop();
        }
        if (this.memoryTable != null) {
            this.memoryTable.notifyProcessEnd();
        }
        if (this.sampleTable != null) {
            this.sampleTable.notifyProcessEnd();
        }
        if (this.eventTable != null) {
            this.eventTable.notifyProcessEnd();
        }
        if (this.runConfiguration.isRemoteDebuggingProfiling()) {
            SwingUtilities.invokeLater(new 1());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void read() {
        while (this.messageReader.isConnected()) {
            block24: while (true) {
                block25: while (true) {
                    ProfilerMessage profilerMessage;
                    ProfilingProcess profilingProcess = this;
                    synchronized (profilingProcess) {
                        profilerMessage = this.messageReader.getMessage();
                    }
                    if (profilerMessage != null) {
                        int n = -1;
                        switch (profilerMessage.getMessageId()) {
                            case 0: {
                                if (PRF_RECEIVE_ON) {
                                    n = ProfilerAPI.startEvent(1200, "PROFMSG_PROCESS_START");
                                }
                                this.ProcessStart(profilerMessage);
                                if (!PRF_RECEIVE_ON) continue block25;
                                ProfilerAPI.endEvent(n);
                                continue block24;
                            }
                            case 1: {
                                if (PRF_RECEIVE_ON) {
                                    n = ProfilerAPI.startEvent(1200, "PROFMSG_CLASS_LOAD");
                                }
                                this.LoadClass(profilerMessage);
                                if (!PRF_RECEIVE_ON) continue block25;
                                ProfilerAPI.endEvent(n);
                                continue block24;
                            }
                            case 2: {
                                if (PRF_RECEIVE_ON) {
                                    n = ProfilerAPI.startEvent(1200, "PROFMSG_CLASS_DATA");
                                }
                                this.ClassData(profilerMessage);
                                if (!PRF_RECEIVE_ON) continue block25;
                                ProfilerAPI.endEvent(n);
                                continue block24;
                            }
                            case 3: {
                                if (PRF_RECEIVE_ON) {
                                    n = ProfilerAPI.startEvent(1200, "PROFMSG_METHOD_DATA");
                                }
                                this.MethodData(profilerMessage);
                                if (!PRF_RECEIVE_ON) continue block25;
                                ProfilerAPI.endEvent(n);
                                continue block24;
                            }
                            case 9: {
                                if (PRF_RECEIVE_ON) {
                                    n = ProfilerAPI.startEvent(1200, "PROFMSG_THREAD_START");
                                }
                                this.ThreadStart(profilerMessage);
                                if (!PRF_RECEIVE_ON) continue block25;
                                ProfilerAPI.endEvent(n);
                                continue block24;
                            }
                            case 10: {
                                if (PRF_RECEIVE_ON) {
                                    n = ProfilerAPI.startEvent(1200, "PROFMSG_THREAD_END");
                                }
                                this.ThreadEnd(profilerMessage);
                                if (!PRF_RECEIVE_ON) continue block25;
                                ProfilerAPI.endEvent(n);
                                continue block24;
                            }
                            case 11: {
                                if (PRF_RECEIVE_ON) {
                                    n = ProfilerAPI.startEvent(1200, "PROFMSG_PROCESS_END");
                                }
                                this.processEnded();
                                this.messageReader.sendMessage(1);
                                this.messageReader.closeConnection();
                                if (PRF_RECEIVE_ON) {
                                    ProfilerAPI.endEvent(n);
                                }
                                return;
                            }
                            case 22: {
                                if (PRF_RECEIVE_ON) {
                                    n = ProfilerAPI.startEvent(1200, "PROFMSG_CALLCOUNT_SAMPLE_DUMP_START");
                                }
                                this.CallCountSampleDump(profilerMessage);
                                if (!PRF_RECEIVE_ON) continue block25;
                                ProfilerAPI.endEvent(n);
                                continue block24;
                            }
                            case 23: {
                                if (PRF_RECEIVE_ON) {
                                    n = ProfilerAPI.startEvent(1200, "PROFMSG_METHOD_LINES_DUMP_START");
                                }
                                this.MethodLinesDump(profilerMessage);
                                if (!PRF_RECEIVE_ON) continue block25;
                                ProfilerAPI.endEvent(n);
                                continue block24;
                            }
                            case 29: {
                                if (PRF_RECEIVE_ON) {
                                    n = ProfilerAPI.startEvent(1200, "PROFMSG_SEND_ALLOCATION_DIFF");
                                }
                                this.getHeapDiff(profilerMessage, false);
                                if (!PRF_RECEIVE_ON) continue block25;
                                ProfilerAPI.endEvent(n);
                                continue block24;
                            }
                            case 30: {
                                if (PRF_RECEIVE_ON) {
                                    n = ProfilerAPI.startEvent(1200, "PROFMSG_SEND_ALLOCATION_DETAIL_DIFF");
                                }
                                this.getHeapDetailDiff(profilerMessage, false);
                                if (!PRF_RECEIVE_ON) continue block25;
                                ProfilerAPI.endEvent(n);
                                continue block24;
                            }
                            case 31: {
                                if (PRF_RECEIVE_ON) {
                                    n = ProfilerAPI.startEvent(1200, "PROFMSG_SEND_ALLOCATION_DIFF_P");
                                }
                                this.getHeapDiff(profilerMessage, true);
                                if (!PRF_RECEIVE_ON) continue block25;
                                ProfilerAPI.endEvent(n);
                                continue block24;
                            }
                            case 32: {
                                if (PRF_RECEIVE_ON) {
                                    n = ProfilerAPI.startEvent(1200, "PROFMSG_SEND_ALLOCATION_DETAIL_DIFF_P");
                                }
                                this.getHeapDetailDiff(profilerMessage, true);
                                if (!PRF_RECEIVE_ON) continue block25;
                                ProfilerAPI.endEvent(n);
                                continue block24;
                            }
                            case 33: {
                                if (PRF_RECEIVE_ON) {
                                    n = ProfilerAPI.startEvent(1200, "PROFMSG_START_ALLOC_DUMP");
                                }
                                this.startPulseDump();
                                if (!PRF_RECEIVE_ON) continue block25;
                                ProfilerAPI.endEvent(n);
                                continue block24;
                            }
                            case 34: {
                                if (PRF_RECEIVE_ON) {
                                    n = ProfilerAPI.startEvent(1200, "PROFMSG_END_ALLOC_DUMP");
                                }
                                this.endPulseDump();
                                if (!PRF_RECEIVE_ON) continue block25;
                                ProfilerAPI.endEvent(n);
                                continue block24;
                            }
                            case 35: {
                                if (PRF_RECEIVE_ON) {
                                    n = ProfilerAPI.startEvent(1200, "PROFMSG_DUMP_EVENTS");
                                }
                                this.getEventsArray(profilerMessage);
                                if (!PRF_RECEIVE_ON) continue block25;
                                ProfilerAPI.endEvent(n);
                                continue block24;
                            }
                        }
                        System.out.println("Invalid response: " + profilerMessage.getMessageId());
                        continue;
                    }
                    Thread.sleep(10);
                }
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void ProcessStart(ProfilerMessage profilerMessage) {
        this.messageReader.sendMessageString(11, this.getExtraOptions());
        this.processIsActive = true;
        if (this._profType == 2) {
            this.getMemoryTable();
        }
    }

    void showSettings() {
        String[] stringArray = new String[]{ProfArb.getString(77)};
        Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), stringArray);
    }

    void saveMemSampleToHTML(boolean bl) {
        MemoryTable memoryTable = this.getMemoryTable();
        int n = bl ? -1 : memoryTable.getCurrentPos();
        HTMLSaver hTMLSaver = new HTMLSaver(memoryTable, this.memoryDetailMap.values().toArray(new MemoryDetailTable[0]), n);
        hTMLSaver.SaveToFile(memoryTable.getContext());
    }

    void setChildHistoryPos(int n) {
        Iterator iterator = this.getMemoryDetailTableIterator();
        while (iterator.hasNext()) {
            MemoryDetailTable memoryDetailTable = (MemoryDetailTable)iterator.next();
            memoryDetailTable.historySelect(n);
        }
    }

    void updateChildSettings() {
        Iterator iterator = this.getMemoryDetailTableIterator();
        while (iterator.hasNext()) {
            MemoryDetailTable memoryDetailTable = (MemoryDetailTable)iterator.next();
            memoryDetailTable.updateSettings();
        }
    }

    private void startPulseDump() {
        MemoryTable memoryTable = this.getMemoryTable();
        memoryTable.startUpdate();
        Iterator iterator = this.getMemoryDetailTableIterator();
        while (iterator.hasNext()) {
            MemoryDetailTable memoryDetailTable = (MemoryDetailTable)iterator.next();
            memoryDetailTable.startUpdate();
        }
    }

    private void endPulseDump() {
        Iterator iterator = this.getMemoryDetailTableIterator();
        while (iterator.hasNext()) {
            MemoryDetailTable memoryDetailTable = (MemoryDetailTable)iterator.next();
            memoryDetailTable.endUpdate();
        }
        MemoryTable memoryTable = this.getMemoryTable();
        memoryTable.endUpdate();
    }

    private void getEventsArray(ProfilerMessage profilerMessage) throws Exception {
        ProfileConfiguration profileConfiguration = this.getConfiguration();
        int n = profilerMessage.getInt();
        ProfileEvent[] profileEventArray = new ProfileEvent[n];
        while (--n >= 0) {
            int n2 = profilerMessage.getInt();
            int n3 = profilerMessage.getInt();
            int n4 = profilerMessage.getInt();
            int n5 = profilerMessage.getInt();
            int n6 = profilerMessage.getInt();
            String string = profilerMessage.getString();
            VMMethod vMMethod = (VMMethod)this.methodMap.get(n5);
            profileEventArray[n] = n2 != -99 ? new ProfileEvent(profileConfiguration.eventFromId(n2), n3, n4, vMMethod, n6, string) : new ProfileEvent(profileConfiguration.eventFromDMS(string), n3, n4, vMMethod, n6, string);
        }
        EventTable eventTable = this.getEventTable();
        eventTable.setData(profileEventArray);
    }

    private void getHeapDiff(ProfilerMessage profilerMessage, boolean bl) throws Exception {
        MemoryTable memoryTable = this.getMemoryTable();
        int n = profilerMessage.getInt();
        if (!bl) {
            memoryTable.startUpdate();
        }
        while (--n >= 0) {
            int n2 = profilerMessage.getInt();
            int n3 = profilerMessage.getInt();
            int n4 = profilerMessage.getInt();
            int n5 = profilerMessage.getInt();
            int n6 = profilerMessage.getInt();
            int n7 = profilerMessage.getInt();
            int n8 = profilerMessage.getInt();
            memoryTable.addOrUpdateHeapData(n2, n3, n4, n5, n6, n7, n8);
        }
        if (!bl) {
            memoryTable.endUpdate();
        }
    }

    private void getHeapDetailDiff(ProfilerMessage profilerMessage, boolean bl) throws Exception {
        int n = profilerMessage.getInt();
        VMClass vMClass = (VMClass)this.classMap.get(n);
        MemoryDetailTable memoryDetailTable = this.getMemoryDetailTable(vMClass, bl);
        if (memoryDetailTable == null) {
            return;
        }
        int n2 = profilerMessage.getInt();
        if (!bl) {
            memoryDetailTable.startUpdate();
        }
        memoryDetailTable.clearValues();
        while (--n2 >= 0) {
            int n3 = profilerMessage.getInt();
            int n4 = profilerMessage.getInt();
            int n5 = profilerMessage.getInt();
            int n6 = profilerMessage.getInt();
            int n7 = profilerMessage.getInt();
            int n8 = profilerMessage.getInt();
            int n9 = profilerMessage.getInt();
            int n10 = profilerMessage.getInt();
            memoryDetailTable.addOrUpdateHeapData(n3, n4, n5, n6, n7, n8, n9, n10);
        }
        if (!bl) {
            memoryDetailTable.endUpdate();
        }
    }

    private void LoadClass(ProfilerMessage profilerMessage) throws Exception {
        int n;
        VMClass vMClass = new VMClass();
        vMClass.classDescriptor = n = profilerMessage.getInt();
        vMClass.packageName = profilerMessage.getString().replace('/', '.');
        vMClass.name = profilerMessage.getString();
        vMClass.fileName = profilerMessage.getString();
        vMClass.methodCount = profilerMessage.getInt();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = 0;
        while (n2 < vMClass.methodCount) {
            int n3 = profilerMessage.getInt();
            VMMethod vMMethod = new VMMethod(vMClass, profilerMessage.getString(), profilerMessage.getString(), profilerMessage.getInt());
            vMMethod.methodDescriptor = n3;
            vMMethod.firstLine = profilerMessage.getInt();
            vMMethod.lastLine = profilerMessage.getInt();
            arrayList.add(vMMethod);
            this.methodMap.put(n3, (Object)vMMethod);
            ++n2;
        }
        vMClass.methodArray = arrayList;
        this.classMap.put(n, (Object)vMClass);
    }

    private void ClassData(ProfilerMessage profilerMessage) throws Exception {
        int n;
        VMClass vMClass = new VMClass();
        vMClass.classDescriptor = n = profilerMessage.getInt();
        vMClass.packageName = profilerMessage.getString().replace('/', '.');
        vMClass.name = profilerMessage.getString();
        vMClass.fileName = profilerMessage.getString();
        vMClass.methodArray = new ArrayList(1);
        this.classMap.put(n, (Object)vMClass);
    }

    private void MethodData(ProfilerMessage profilerMessage) throws Exception {
        int n = profilerMessage.getInt();
        int n2 = profilerMessage.getInt();
        VMClass vMClass = (VMClass)this.classMap.get(n2);
        VMMethod vMMethod = new VMMethod(vMClass, profilerMessage.getString(), profilerMessage.getString(), profilerMessage.getInt());
        vMMethod.methodDescriptor = n;
        vMMethod.firstLine = profilerMessage.getInt();
        vMMethod.lastLine = profilerMessage.getInt();
        vMClass.methodArray.add((Object)vMMethod);
        this.methodMap.put(n, (Object)vMMethod);
    }

    private ArrayList ReadCallElem(ProfilerMessage profilerMessage) throws Exception {
        int n = profilerMessage.getInt();
        ArrayList<SubCallCount> arrayList = new ArrayList<SubCallCount>(n);
        while (--n >= 0) {
            Integer n2 = new Integer(profilerMessage.getInt());
            int n3 = profilerMessage.getInt();
            SubCallCount subCallCount = new SubCallCount(n3, n2);
            arrayList.add(subCallCount);
        }
        return arrayList;
    }

    private void CallCountSampleDump(ProfilerMessage profilerMessage) throws Exception {
        int n;
        int n2 = profilerMessage.getInt();
        int n3 = profilerMessage.getInt();
        int n4 = profilerMessage.getInt();
        IntHashMap intHashMap = new IntHashMap((n2 + n3 + 1) * 2);
        ArrayList<CallCountItem> arrayList = new ArrayList<CallCountItem>(n2 + n3 + 1);
        int n5 = 0;
        while (n5 < n2) {
            n = profilerMessage.getInt();
            int n6 = profilerMessage.getInt();
            int n7 = profilerMessage.getInt();
            MethodCallCountItem methodCallCountItem = new MethodCallCountItem(n, (VMMethod)this.methodMap.get(n), n6, n7);
            methodCallCountItem.setCalledList(this.ReadCallElem(profilerMessage));
            intHashMap.put(n, (Object)methodCallCountItem);
            arrayList.add(methodCallCountItem);
            ++n5;
        }
        n5 = 0;
        while (n5 < n3) {
            n = profilerMessage.getInt();
            String string = profilerMessage.getString();
            int n8 = profilerMessage.getInt();
            int n9 = profilerMessage.getInt();
            ThreadCallCountItem threadCallCountItem = new ThreadCallCountItem(n, string, n8, n9);
            threadCallCountItem.setCalledList(this.ReadCallElem(profilerMessage));
            intHashMap.put(n, (Object)threadCallCountItem);
            arrayList.add(threadCallCountItem);
            ++n5;
        }
        RootCallCountItem rootCallCountItem = new RootCallCountItem(0, n4);
        rootCallCountItem.setCalledList(this.ReadCallElem(profilerMessage));
        intHashMap.put(0, (Object)rootCallCountItem);
        arrayList.add(rootCallCountItem);
        n5 = 0;
        while (n5 < arrayList.size()) {
            CallCountItem callCountItem = (CallCountItem)arrayList.get(n5);
            ArrayList arrayList2 = callCountItem.getCalledList();
            callCountItem.calledTotal = callCountItem.getCallCount();
            int n10 = 0;
            while (n10 < arrayList2.size()) {
                SubCallCount subCallCount = (SubCallCount)arrayList2.get(n10);
                callCountItem.calledTotal += subCallCount.count;
                CallCountItem callCountItem2 = (CallCountItem)intHashMap.get(((Integer)subCallCount.ref).intValue());
                SubCallCount subCallCount2 = new SubCallCount(subCallCount.count, callCountItem);
                callCountItem2.callerTotal += subCallCount.count;
                callCountItem2.getCallerList().add(subCallCount2);
                subCallCount.ref = callCountItem2;
                ++n10;
            }
            ++n5;
        }
        SampleTable sampleTable = this.getSampleTable();
        sampleTable.setData(n4, arrayList);
    }

    private void MethodLinesDump(ProfilerMessage profilerMessage) throws Exception {
        int n = profilerMessage.getInt();
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            VMMethod vMMethod = (VMMethod)this.methodMap.get(profilerMessage.getInt());
            int n3 = profilerMessage.getInt();
            int n4 = 0;
            while (n4 < n3) {
                int n5 = profilerMessage.getInt();
                int n6 = profilerMessage.getInt();
                ++n4;
            }
            ++n2;
        }
    }

    private void ThreadStart(ProfilerMessage profilerMessage) throws Exception {
        VMThread vMThread = new VMThread();
        vMThread.threadDescriptor = profilerMessage.getInt();
        vMThread.name = profilerMessage.getString();
        vMThread.groupName = profilerMessage.getString();
        vMThread.callStackTreeNode = null;
        vMThread.callStackTop = null;
        this.threadMap.put(vMThread.threadDescriptor, (Object)vMThread);
    }

    private void ThreadEnd(ProfilerMessage profilerMessage) throws Exception {
        VMThread vMThread = (VMThread)this.threadMap.get(profilerMessage.getInt());
    }

    String getRunTitle() {
        return this.runTitle;
    }

    void readDataFromStream(DataInputStream dataInputStream) {
        try {
            this._profType = dataInputStream.readInt();
            switch (this._profType) {
                case 0: {
                    this.readMapsFromFile(dataInputStream);
                    this.readSampleArrayFromFile(dataInputStream);
                    break;
                }
                case 1: {
                    this.readMapsFromFile(dataInputStream);
                    this.readEventsArrayFromFile(dataInputStream);
                    break;
                }
                case 2: {
                    this.readMapsFromFile(dataInputStream);
                    this.readMemorySessionFromFile(dataInputStream);
                    break;
                }
                default: {
                    System.out.println("Profiler type " + this._profType + " not supported yet");
                }
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static String ra$host(ProfilingProcess profilingProcess) {
        return profilingProcess.host;
    }

    static int ra$localport(ProfilingProcess profilingProcess) {
        return profilingProcess.localport;
    }

    static void wa$messageReader(ProfilingProcess profilingProcess, ProfilerMessageReader profilerMessageReader) {
        profilingProcess.messageReader = profilerMessageReader;
    }

    static ProfilerMessageReader ra$messageReader(ProfilingProcess profilingProcess) {
        return profilingProcess.messageReader;
    }

    static void mav$read(ProfilingProcess profilingProcess) {
        profilingProcess.read();
    }

    static MemoryMonitor ra$memoryMonitor(ProfilingProcess profilingProcess) {
        return profilingProcess.memoryMonitor;
    }

    final class 2
    extends Thread {
        public void run() {
            try {
                ProfilingProcess.wa$messageReader(ProfilingProcess.this, new ProfilerMessageReader(ProfilingProcess.this, ProfilingProcess.ra$host(ProfilingProcess.this), ProfilingProcess.ra$localport(ProfilingProcess.this)));
                Thread thread = new Thread(ProfilingProcess.ra$messageReader(ProfilingProcess.this));
                thread.setPriority(6);
                thread.start();
                ProfilingProcess.mav$read(ProfilingProcess.this);
            }
            catch (Exception exception) {
                System.out.println("Profiling process terminating");
                System.out.println(exception);
            }
            if (ProfilingProcess.ra$memoryMonitor(ProfilingProcess.this) != null) {
                ProfilingProcess.ra$memoryMonitor(ProfilingProcess.this).stop();
            }
        }
    }

    final class 1
    implements Runnable {
        public void run() {
            ProfilingProcess.this.finished();
        }
    }
}

