/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Context;
import oracle.ide.IdeConstants;
import oracle.ide.controller.Controller;
import oracle.ide.controls.CustomJSplitPane;
import oracle.ide.help.HelpInfo;
import oracle.ide.resource.ControlsArb;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.ideimpl.controls.OneLineBorder;
import oracle.jdeveloper.runner.Source;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdevimpl.runner.debug.DbgArb;
import oracle.jdevimpl.runner.profile.CallCountItem;
import oracle.jdevimpl.runner.profile.DefaultAllignRenderer;
import oracle.jdevimpl.runner.profile.FileSavable;
import oracle.jdevimpl.runner.profile.FileSaver;
import oracle.jdevimpl.runner.profile.HTMLSavable;
import oracle.jdevimpl.runner.profile.HTMLSaver;
import oracle.jdevimpl.runner.profile.JProfiler;
import oracle.jdevimpl.runner.profile.LocationProvider;
import oracle.jdevimpl.runner.profile.ProfArb;
import oracle.jdevimpl.runner.profile.ProfWindow;
import oracle.jdevimpl.runner.profile.ProfilerSettings;
import oracle.jdevimpl.runner.profile.ProfilingProcess;
import oracle.jdevimpl.runner.profile.RightAllignRenderer;
import oracle.jdevimpl.runner.profile.SubCallCount;
import oracle.jdevimpl.runner.profile.UpdatableSettings;
import oracle.jdevimpl.runner.run.RunArb;

public final class SampleTable
extends ProfWindow
implements FileSavable,
UpdatableSettings,
LocationProvider,
HTMLSavable,
ActionListener {
    public static final int MAX_COLUMNS = 7;
    public static final int COL_CLASS = 0;
    public static final int COL_METHOD = 1;
    public static final int COL_SIGNATURE = 2;
    public static final int COL_HIT_P = 3;
    public static final int COL_HIT_TIME = 4;
    public static final int COL_STACK_P = 5;
    public static final int COL_STACK_TIME = 6;
    private static final int INITIAL_HEAPSTATSIZE = 20;
    private static final int MAX_TABLE_DET = 5;
    private ProfilingProcess process;
    private int nCalls;
    private String title;
    private JScrollPane mainScrollPane;
    private JScrollPane callerScrollPane;
    private JScrollPane calledScrollPane;
    private JLabel methodNameLabel;
    private JLabel methodFreq;
    private JLabel methodCumFreq;
    private JLabel onTopFreq;
    private JLabel methodTime;
    private JLabel methodCumTime;
    private JLabel onTopTime;
    private JSplitPane mainSplitPane;
    private JPanel detailPanel;
    private CallCountItem[] methodArray;
    private CallCountItem currentItem;
    private JTable table;
    private JTable callerTable;
    private JTable calledTable;
    private AbstractTableModel dataModel;
    private AbstractTableModel callerDataModel;
    private AbstractTableModel calledDataModel;
    int compareField;
    boolean ascending;
    SampleComparator scomp;
    private JButton buttonRestart;
    private JButton buttonSnapshot;
    private JButton buttonTerminate;
    private JButton buttonRun;
    private JButton buttonPause;
    private JButton buttonClear;
    private JLabel samplesLabel;
    private boolean[] columnShowing;
    private TableColumn[] column;
    private TableColumn[] calledColumn;
    private TableColumn[] callerColumn;
    private static DecimalFormat percentformat = new DecimalFormat("  ##0.00%");
    RightAllignRenderer rightAllignRenderer;
    DefaultAllignRenderer defaultAllignRenderer;
    private static final HelpInfo HELP_TOPIC = new HelpInfo(ProfArb.getString(6));
    static final String CLASS_TITLE = ProfArb.getString(176);
    static final String METHOD_TITLE = ProfArb.getString(177);
    static final String SIGNATURE_TITLE = ProfArb.getString(178);
    static final String HITP_TITLE = ProfArb.getString(179);
    static final String HITT_TITLE = ProfArb.getString(180);
    static final String ONSTACKP_TITLE = ProfArb.getString(181);
    static final String ONSTACKT_TITLE = ProfArb.getString(182);
    private static final Icon arrowUp = ControlsArb.getIcon((int)2);
    private static final Icon arrowDown = ControlsArb.getIcon((int)1);

    void $init$() {
        this.columnShowing = new boolean[7];
        this.column = new TableColumn[7];
        this.calledColumn = new TableColumn[5];
        this.callerColumn = new TableColumn[5];
    }

    static String pFormat(double d) {
        Double d2 = new Double(d);
        if (d2.isNaN() || d2.isInfinite()) {
            return ProfArb.getString(172);
        }
        return percentformat.format(d);
    }

    public SampleTable(ProfilingProcess profilingProcess) {
        this.$init$();
        this.rightAllignRenderer = new RightAllignRenderer(profilingProcess);
        this.defaultAllignRenderer = new DefaultAllignRenderer(profilingProcess);
        this.process = profilingProcess;
        this.nCalls = 0;
        this.methodArray = new CallCountItem[0];
        this.scomp = new SampleComparator();
        this.ascending = false;
        this.compareField = 3;
        this.initialize();
    }

    public void setData(int n, List list) {
        this.nCalls = n;
        this.samplesLabel.setText(Integer.toString(n));
        this.methodArray = new CallCountItem[list.size()];
        int n2 = 0;
        while (n2 < list.size()) {
            this.methodArray[n2] = (CallCountItem)list.get(n2);
            ++n2;
        }
        Arrays.sort(this.methodArray, this.scomp);
        this.dataModel.fireTableDataChanged();
        this.selectByRow(0);
    }

    public void resetProcess(ProfilingProcess profilingProcess) {
        this.process = profilingProcess;
        this.buttonRestart.setEnabled(true);
        this.buttonSnapshot.setEnabled(true);
        this.buttonTerminate.setEnabled(true);
        this.buttonRun.setEnabled(false);
        this.buttonPause.setEnabled(true);
        this.buttonClear.setEnabled(true);
        this.setData(0, new ArrayList(0));
    }

    public void notifyProcessEnd() {
        this.buttonRestart.setEnabled(true);
        this.buttonSnapshot.setEnabled(false);
        this.buttonTerminate.setEnabled(false);
        this.buttonRun.setEnabled(false);
        this.buttonPause.setEnabled(false);
        this.buttonClear.setEnabled(false);
    }

    public void saveToHTML(boolean bl) {
        HTMLSaver hTMLSaver = new HTMLSaver(this.methodArray, this.nCalls);
        hTMLSaver.SaveToFile(this.getContext());
    }

    public void saveToFile() {
        FileSaver fileSaver = new FileSaver(this);
        fileSaver.save(this.getContext());
    }

    public void saveToFile(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(0);
        this.process.saveMapsToFile(dataOutputStream);
        dataOutputStream.writeInt(this.nCalls);
        FileSaver.saveVMObjectToFile(this.methodArray, dataOutputStream);
    }

    public Component getGUI() {
        return this.mainSplitPane;
    }

    public Controller getController() {
        return null;
    }

    public Context getContext(EventObject eventObject) {
        Context context = this.process.getContext();
        context.setView((View)this);
        context.setEvent(eventObject);
        return context;
    }

    public void initialize() {
        this.title = ProfArb.getString(173) + this.process.getRunTitle();
        JPanel jPanel = this.createGUI();
        this.detailPanel = this.createDetailPanel();
        this.mainSplitPane = new CustomJSplitPane(1, true, (Component)jPanel, (Component)this.detailPanel);
        this.mainSplitPane.setBorder(BorderFactory.createEmptyBorder());
        this.mainSplitPane.setDividerLocation(0.6);
        this.updateSettings();
    }

    public HelpInfo getHelpInfo() {
        return HELP_TOPIC;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.whenActionPerformed(object);
    }

    private void whenActionPerformed(Object object) {
        if (object == this.buttonRun) {
            this.process.performRunCommand();
            this.buttonRun.setEnabled(false);
            this.buttonClear.setEnabled(true);
            this.buttonPause.setEnabled(true);
            this.buttonPause.requestFocus();
        } else if (object == this.buttonPause) {
            this.process.performPauseCommand();
            this.buttonRun.setEnabled(true);
            this.buttonRun.requestFocus();
            this.buttonClear.setEnabled(true);
            this.buttonPause.setEnabled(false);
        } else if (object == this.buttonClear) {
            this.process.performClearSampleCommand();
        } else if (object == this.buttonSnapshot) {
            this.process.performSnapshotCommand();
        } else if (object == this.buttonRestart) {
            this.process.performRestartCommand();
        } else if (object == this.buttonTerminate) {
            this.process.performTerminateCommand();
        }
    }

    private JPanel createDetailPanel() {
        this.callerDataModel = new 9();
        8 var1_1 = new 8();
        this.calledDataModel = new 7();
        6 var2_2 = new 6();
        this.callerTable = new JTable(this.callerDataModel);
        this.callerTable.addMouseListener(new subTreeMouseAdapter(this.callerTable, true));
        TableColumnModel tableColumnModel = this.callerTable.getColumnModel();
        int n = 0;
        while (n < 5) {
            this.callerColumn[n] = tableColumnModel.getColumn(n);
            ++n;
        }
        this.callerColumn[0].setCellRenderer(this.defaultAllignRenderer);
        this.callerColumn[0].setPreferredWidth(500);
        this.callerColumn[1].setCellRenderer(this.defaultAllignRenderer);
        this.callerColumn[1].setPreferredWidth(400);
        this.callerColumn[2].setCellRenderer(this.defaultAllignRenderer);
        this.callerColumn[2].setPreferredWidth(300);
        this.callerColumn[3].setCellRenderer(this.rightAllignRenderer);
        this.callerColumn[3].setPreferredWidth(100);
        this.callerColumn[4].setCellRenderer(this.rightAllignRenderer);
        this.callerColumn[4].setPreferredWidth(100);
        var1_1.setHorizontalAlignment(0);
        JTableHeader jTableHeader = this.callerTable.getTableHeader();
        jTableHeader.setDefaultRenderer(var1_1);
        this.calledTable = new JTable(this.calledDataModel);
        this.calledTable.addMouseListener(new subTreeMouseAdapter(this.calledTable, false));
        tableColumnModel = this.calledTable.getColumnModel();
        int n2 = 0;
        while (n2 < 5) {
            this.calledColumn[n2] = tableColumnModel.getColumn(n2);
            ++n2;
        }
        this.calledColumn[0].setCellRenderer(this.defaultAllignRenderer);
        this.calledColumn[0].setPreferredWidth(500);
        this.calledColumn[1].setCellRenderer(this.defaultAllignRenderer);
        this.calledColumn[1].setPreferredWidth(400);
        this.calledColumn[2].setCellRenderer(this.defaultAllignRenderer);
        this.calledColumn[2].setPreferredWidth(300);
        this.calledColumn[3].setCellRenderer(this.rightAllignRenderer);
        this.calledColumn[3].setPreferredWidth(100);
        this.calledColumn[4].setCellRenderer(this.rightAllignRenderer);
        this.calledColumn[4].setPreferredWidth(100);
        var2_2.setHorizontalAlignment(0);
        jTableHeader = this.calledTable.getTableHeader();
        jTableHeader.setDefaultRenderer(var2_2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n3 = 0;
        int n4 = 0;
        JLabel jLabel = new JLabel(ProfArb.getString(212));
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont(1);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n4++, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        JScrollPane jScrollPane = new JScrollPane(this.callerTable);
        jScrollPane.setBorder((Border)new OneLineBorder(3, null));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, n4++, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.methodNameLabel = new JLabel(" ");
        this.methodNameLabel.setFont(font2);
        Dimension dimension = this.methodNameLabel.getPreferredSize();
        dimension.width = 1;
        this.methodNameLabel.setMinimumSize(dimension);
        jPanel.add((Component)this.methodNameLabel, new GridBagConstraints(n3, n4++, 0, 1, 1.0, 0.0, 17, 1, new Insets(3, 5, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel();
        jLabel = new JLabel(ProfArb.getString(210));
        jPanel2.add(jLabel);
        this.methodTime = new JLabel("");
        this.methodTime.setFont(font2);
        this.methodFreq = new JLabel("");
        this.methodFreq.setFont(font2);
        jPanel2.add(this.methodTime);
        jPanel2.add(this.methodFreq);
        jLabel = new JLabel(ProfArb.getString(211));
        jPanel2.add(jLabel);
        this.methodCumTime = new JLabel("");
        this.methodCumTime.setFont(font2);
        this.methodCumFreq = new JLabel("");
        this.methodCumFreq.setFont(font2);
        jPanel2.add(this.methodCumTime);
        jPanel2.add(this.methodCumFreq);
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, n4, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        n3 = 0;
        jLabel = new JLabel(ProfArb.getString(213));
        jPanel.add((Component)jLabel, new GridBagConstraints(n3++, ++n4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        jLabel = new JLabel(ProfArb.getString(214));
        jLabel.setHorizontalAlignment(4);
        jPanel.add((Component)jLabel, new GridBagConstraints(n3++, n4, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 0, 0), 0, 0));
        this.onTopFreq = new JLabel("");
        this.onTopFreq.setFont(font2);
        this.onTopTime = new JLabel("");
        this.onTopTime.setFont(font2);
        jPanel.add((Component)this.onTopTime, new GridBagConstraints(n3++, n4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        jPanel.add((Component)this.onTopFreq, new GridBagConstraints(n3++, n4++, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        n3 = 0;
        jScrollPane = new JScrollPane(this.calledTable);
        jScrollPane.setBorder((Border)new OneLineBorder(1, null));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, n4++, 0, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public void changeSettings() {
        this.process.showSettings();
    }

    public void updateSettings() {
        ProfilerSettings profilerSettings = ProfilerSettings.getInstance();
        boolean[] blArray = profilerSettings.getSampleColumnVisible();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < 7) {
            if (this.columnShowing[n] != blArray[n]) {
                bl = true;
                this.columnShowing[n] = blArray[n];
                if (blArray[n]) {
                    this.table.addColumn(this.column[n]);
                } else {
                    this.table.removeColumn(this.column[n]);
                }
                if (n < 5) {
                    bl2 = true;
                    if (blArray[n]) {
                        this.callerTable.addColumn(this.callerColumn[n]);
                        this.calledTable.addColumn(this.calledColumn[n]);
                    } else {
                        this.callerTable.removeColumn(this.callerColumn[n]);
                        this.calledTable.removeColumn(this.calledColumn[n]);
                    }
                }
            }
            ++n;
        }
        if (bl) {
            this.dataModel.fireTableChanged(new TableModelEvent(this.dataModel, 0, this.dataModel.getRowCount() - 1, -1));
        }
        if (bl2) {
            this.callerDataModel.fireTableChanged(new TableModelEvent(this.callerDataModel, 0, this.callerDataModel.getRowCount() - 1, -1));
            this.calledDataModel.fireTableChanged(new TableModelEvent(this.calledDataModel, 0, this.calledDataModel.getRowCount() - 1, -1));
        }
    }

    public void findSource() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            return;
        }
        CallCountItem callCountItem = this.methodArray[n];
        int n2 = callCountItem.getLine();
        if (n2 == -1) {
            return;
        }
        Context context = this.getContext();
        Source.showSourceFile(context.getWorkspace(), context.getProject(), callCountItem.getPackage(), null, callCountItem.getFileName(), callCountItem.getLine(), true);
    }

    public boolean canFindSource() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            return false;
        }
        CallCountItem callCountItem = this.methodArray[n];
        int n2 = callCountItem.getLine();
        return n2 != -1;
    }

    private JPanel createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar();
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        Dimension dimension = new Dimension(24, 24);
        jPanel.add((Component)jPanel2, "North");
        jPanel2.add((Component)jToolBar, "West");
        jPanel2.add((Component)jPanel3, "East");
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        jToolBar.setBorder(IdeConstants.TOOLBAR_EMPTY_BORDER);
        this.buttonRestart = new JButton(RunArb.getIcon(3));
        this.buttonRestart.setToolTipText(ProfArb.getString(25));
        this.registerActionMnemonic(jPanel, this.buttonRestart, ProfArb.getMnemonic(31));
        this.buttonRestart.addActionListener(this);
        jToolBar.add(this.buttonRestart);
        this.buttonRestart.setEnabled(true);
        this.buttonRun = new JButton(DbgArb.getIcon(15));
        this.buttonRun.setToolTipText(ProfArb.getString(28));
        this.registerActionMnemonic(jPanel, this.buttonRun, ProfArb.getMnemonic(34));
        this.buttonRun.addActionListener(this);
        jToolBar.add(this.buttonRun);
        this.buttonRun.setEnabled(false);
        this.buttonPause = new JButton(DbgArb.getIcon(12));
        this.buttonPause.setToolTipText(ProfArb.getString(29));
        this.registerActionMnemonic(jPanel, this.buttonPause, ProfArb.getMnemonic(35));
        this.buttonPause.addActionListener(this);
        jToolBar.add(this.buttonPause);
        this.buttonPause.setEnabled(true);
        this.buttonSnapshot = new JButton(IdeArb.getIcon((int)387));
        this.buttonSnapshot.setToolTipText(ProfArb.getString(26));
        this.registerActionMnemonic(jPanel, this.buttonSnapshot, ProfArb.getMnemonic(32));
        this.buttonSnapshot.addActionListener(this);
        jToolBar.add(this.buttonSnapshot);
        this.buttonSnapshot.setEnabled(true);
        this.buttonClear = new JButton(VCSIconArb.getIcon((int)8));
        this.buttonClear.setToolTipText(ProfArb.getString(30));
        this.registerActionMnemonic(jPanel, this.buttonClear, ProfArb.getMnemonic(36));
        this.buttonClear.addActionListener(this);
        jToolBar.add(this.buttonClear);
        this.buttonClear.setEnabled(true);
        this.buttonTerminate = new JButton(IdeArb.getIcon((int)150));
        this.buttonTerminate.setToolTipText(ProfArb.getString(27));
        this.registerActionMnemonic(jPanel, this.buttonTerminate, ProfArb.getMnemonic(33));
        this.buttonTerminate.addActionListener(this);
        jToolBar.add(this.buttonTerminate);
        this.buttonTerminate.setEnabled(true);
        JLabel jLabel = new JLabel(ProfArb.getString(215));
        jLabel.setHorizontalAlignment(4);
        jPanel3.add(jLabel);
        this.samplesLabel = new JLabel("1000");
        jPanel3.add(this.samplesLabel);
        this.dataModel = new 5();
        this.table = new JTable(this.dataModel);
        this.table.addMouseListener(new 4());
        this.addMouseListenerToHeaderInTable();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = 0;
        while (n < 7) {
            this.column[n] = tableColumnModel.getColumn(n);
            this.columnShowing[n] = true;
            ++n;
        }
        this.column[0].setCellRenderer(this.defaultAllignRenderer);
        this.column[0].setPreferredWidth(500);
        this.column[1].setCellRenderer(this.defaultAllignRenderer);
        this.column[1].setPreferredWidth(400);
        this.column[2].setCellRenderer(this.defaultAllignRenderer);
        this.column[2].setPreferredWidth(300);
        this.column[3].setCellRenderer(this.rightAllignRenderer);
        this.column[3].setPreferredWidth(100);
        this.column[5].setCellRenderer(this.rightAllignRenderer);
        this.column[5].setPreferredWidth(100);
        this.column[4].setCellRenderer(this.rightAllignRenderer);
        this.column[4].setPreferredWidth(100);
        this.column[6].setCellRenderer(this.rightAllignRenderer);
        this.column[6].setPreferredWidth(100);
        Dimension dimension2 = new Dimension(0, 0);
        this.table.setIntercellSpacing(dimension2);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new 3());
        this.mainScrollPane = new JScrollPane(this.table);
        this.mainScrollPane.setBorder((Border)new OneLineBorder(1, null));
        jPanel.add((Component)this.mainScrollPane, "Center");
        return jPanel;
    }

    void registerActionMnemonic(JPanel jPanel, JButton jButton, char c) {
        InputMap inputMap = jPanel.getInputMap(1);
        ActionMap actionMap = jPanel.getActionMap();
        MyAction myAction = new MyAction(jButton);
        KeyStroke keyStroke = KeyStroke.getKeyStroke((int)c, 2);
        inputMap.put(keyStroke, myAction);
        actionMap.put(myAction, myAction);
    }

    private void addMouseListenerToHeaderInTable() {
        JTable jTable = this.table;
        jTable.setColumnSelectionAllowed(false);
        2 var2_2 = new 2(this, jTable);
        1 var3_3 = new 1();
        var3_3.setHorizontalAlignment(0);
        JTableHeader jTableHeader = jTable.getTableHeader();
        jTableHeader.addMouseListener(var2_2);
        jTableHeader.setDefaultRenderer(var3_3);
    }

    private void selectByRow(int n) {
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.clearSelection();
        listSelectionModel.addSelectionInterval(n, n);
        JViewport jViewport = this.mainScrollPane.getViewport();
        Rectangle rectangle = this.table.getCellRect(n, 0, true);
        Rectangle rectangle2 = jViewport.getViewRect();
        rectangle.y -= rectangle2.y;
        jViewport.scrollRectToVisible(rectangle);
    }

    private void selectByObject(CallCountItem callCountItem) {
        int n = 0;
        while (n < this.methodArray.length) {
            if (callCountItem == this.methodArray[n]) {
                this.selectByRow(n);
                return;
            }
            ++n;
        }
    }

    private void sortArray(int n) {
        if (this.compareField == n) {
            this.ascending ^= true;
        } else {
            this.compareField = n;
        }
        Arrays.sort(this.methodArray, this.scomp);
    }

    public String getTabName() {
        return this.process.getTabName();
    }

    public Icon getTabIcon() {
        return this.process.getIcon();
    }

    public String getTitleName() {
        return this.title;
    }

    public void stateChange(int n) {
        switch (n) {
            case 3: {
                this.process.terminateProcess();
                this.methodArray = null;
                this.currentItem = null;
            }
        }
        super.stateChange(n);
    }

    static CallCountItem ra$currentItem(SampleTable sampleTable) {
        return sampleTable.currentItem;
    }

    static void mav$selectByObject(SampleTable sampleTable, CallCountItem callCountItem) {
        sampleTable.selectByObject(callCountItem);
    }

    static ProfilingProcess ra$process(SampleTable sampleTable) {
        return sampleTable.process;
    }

    static CallCountItem[] ra$methodArray(SampleTable sampleTable) {
        return sampleTable.methodArray;
    }

    static int ra$nCalls(SampleTable sampleTable) {
        return sampleTable.nCalls;
    }

    static JTable ra$table(SampleTable sampleTable) {
        return sampleTable.table;
    }

    static void wa$currentItem(SampleTable sampleTable, CallCountItem callCountItem) {
        sampleTable.currentItem = callCountItem;
    }

    static JLabel ra$methodNameLabel(SampleTable sampleTable) {
        return sampleTable.methodNameLabel;
    }

    static JLabel ra$onTopFreq(SampleTable sampleTable) {
        return sampleTable.onTopFreq;
    }

    static JLabel ra$onTopTime(SampleTable sampleTable) {
        return sampleTable.onTopTime;
    }

    static JLabel ra$methodFreq(SampleTable sampleTable) {
        return sampleTable.methodFreq;
    }

    static JLabel ra$methodTime(SampleTable sampleTable) {
        return sampleTable.methodTime;
    }

    static JLabel ra$methodCumFreq(SampleTable sampleTable) {
        return sampleTable.methodCumFreq;
    }

    static JLabel ra$methodCumTime(SampleTable sampleTable) {
        return sampleTable.methodCumTime;
    }

    static AbstractTableModel ra$callerDataModel(SampleTable sampleTable) {
        return sampleTable.callerDataModel;
    }

    static AbstractTableModel ra$calledDataModel(SampleTable sampleTable) {
        return sampleTable.calledDataModel;
    }

    static void mav$whenActionPerformed(SampleTable sampleTable, Object object) {
        sampleTable.whenActionPerformed(object);
    }

    static void mav$sortArray(SampleTable sampleTable, int n) {
        sampleTable.sortArray(n);
    }

    static Icon ra$arrowUp() {
        return arrowUp;
    }

    static Icon ra$arrowDown() {
        return arrowDown;
    }

    public class subTreeMouseAdapter
    extends MouseAdapter {
        private JTable tbl;
        private boolean iscaller;

        public subTreeMouseAdapter(JTable jTable, boolean bl) {
            this.tbl = jTable;
            this.iscaller = bl;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            if (mouseEvent.getClickCount() != 2) {
                return;
            }
            int n = this.tbl.getSelectedRow();
            if (n == -1) {
                return;
            }
            SubCallCount subCallCount = this.iscaller ? (SubCallCount)SampleTable.ra$currentItem(SampleTable.this).getCallerList().get(n) : (SubCallCount)SampleTable.ra$currentItem(SampleTable.this).getCalledList().get(n);
            SampleTable.mav$selectByObject(SampleTable.this, (CallCountItem)subCallCount.ref);
        }
    }

    public final class 9
    extends AbstractTableModel {
        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            if (SampleTable.ra$currentItem(SampleTable.this) != null && SampleTable.ra$currentItem(SampleTable.this).getCallerList() != null) {
                return SampleTable.ra$currentItem(SampleTable.this).getCallerList().size();
            }
            return 0;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return CLASS_TITLE;
                }
                case 1: {
                    return METHOD_TITLE;
                }
                case 2: {
                    return SIGNATURE_TITLE;
                }
                case 3: {
                    return HITP_TITLE;
                }
                case 4: {
                    return HITT_TITLE;
                }
            }
            return "Error";
        }

        public Object getValueAt(int n, int n2) {
            SubCallCount subCallCount = (SubCallCount)SampleTable.ra$currentItem(SampleTable.this).getCallerList().get(n);
            CallCountItem callCountItem = (CallCountItem)subCallCount.ref;
            switch (n2) {
                case 0: {
                    return callCountItem.getPseudoClass();
                }
                case 1: {
                    return callCountItem.getPseudoName();
                }
                case 2: {
                    return callCountItem.getNiceSignature();
                }
                case 3: {
                    return SampleTable.pFormat((double)subCallCount.count / (double)SampleTable.ra$currentItem((SampleTable)SampleTable.this).callerTotal);
                }
                case 4: {
                    return Integer.toString(subCallCount.count);
                }
            }
            return "Error";
        }
    }

    public final class 8
    extends DefaultTableCellRenderer {
        private int _col;

        public String getToolTipText(MouseEvent mouseEvent) {
            if (SampleTable.ra$process(SampleTable.this).isPopupActive()) {
                return null;
            }
            switch (this._col) {
                case 0: {
                    return ProfArb.getString(190);
                }
                case 1: {
                    return ProfArb.getString(191);
                }
                case 2: {
                    return ProfArb.getString(192);
                }
                case 3: {
                    return ProfArb.getString(193);
                }
                case 4: {
                    return ProfArb.getString(194);
                }
            }
            return "";
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3;
            this._col = n3 = jTable.convertColumnIndexToModel(n2);
            this.setText((String)object);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    public final class 7
    extends AbstractTableModel {
        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            if (SampleTable.ra$currentItem(SampleTable.this) != null && SampleTable.ra$currentItem(SampleTable.this).getCalledList() != null) {
                return SampleTable.ra$currentItem(SampleTable.this).getCalledList().size();
            }
            return 0;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return CLASS_TITLE;
                }
                case 1: {
                    return METHOD_TITLE;
                }
                case 2: {
                    return SIGNATURE_TITLE;
                }
                case 3: {
                    return HITP_TITLE;
                }
                case 4: {
                    return HITT_TITLE;
                }
            }
            return "Error";
        }

        public Object getValueAt(int n, int n2) {
            SubCallCount subCallCount = (SubCallCount)SampleTable.ra$currentItem(SampleTable.this).getCalledList().get(n);
            CallCountItem callCountItem = (CallCountItem)subCallCount.ref;
            switch (n2) {
                case 0: {
                    return callCountItem.getPseudoClass();
                }
                case 1: {
                    return callCountItem.getPseudoName();
                }
                case 2: {
                    return callCountItem.getNiceSignature();
                }
                case 3: {
                    return SampleTable.pFormat((double)subCallCount.count / (double)SampleTable.ra$currentItem((SampleTable)SampleTable.this).calledTotal);
                }
                case 4: {
                    return Integer.toString(subCallCount.count);
                }
            }
            return "Error";
        }
    }

    public final class 6
    extends DefaultTableCellRenderer {
        private int _col;

        public String getToolTipText(MouseEvent mouseEvent) {
            if (SampleTable.ra$process(SampleTable.this).isPopupActive()) {
                return null;
            }
            switch (this._col) {
                case 0: {
                    return ProfArb.getString(195);
                }
                case 1: {
                    return ProfArb.getString(196);
                }
                case 2: {
                    return ProfArb.getString(197);
                }
                case 3: {
                    return ProfArb.getString(198);
                }
                case 4: {
                    return ProfArb.getString(199);
                }
            }
            return "";
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3;
            this._col = n3 = jTable.convertColumnIndexToModel(n2);
            this.setText((String)object);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    public final class 5
    extends AbstractTableModel {
        public int getColumnCount() {
            return 7;
        }

        public int getRowCount() {
            if (SampleTable.ra$methodArray(SampleTable.this) == null) {
                return 0;
            }
            return SampleTable.ra$methodArray(SampleTable.this).length;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return CLASS_TITLE;
                }
                case 1: {
                    return METHOD_TITLE;
                }
                case 2: {
                    return SIGNATURE_TITLE;
                }
                case 3: {
                    return HITP_TITLE;
                }
                case 4: {
                    return HITT_TITLE;
                }
                case 5: {
                    return ONSTACKP_TITLE;
                }
                case 6: {
                    return ONSTACKT_TITLE;
                }
            }
            return "Error";
        }

        public Object getValueAt(int n, int n2) {
            CallCountItem callCountItem = SampleTable.ra$methodArray(SampleTable.this)[n];
            switch (n2) {
                case 0: {
                    return callCountItem.getPseudoClass();
                }
                case 1: {
                    return callCountItem.getPseudoName();
                }
                case 2: {
                    return callCountItem.getNiceSignature();
                }
                case 3: {
                    return SampleTable.pFormat((double)callCountItem.getCallCount() / (double)SampleTable.ra$nCalls(SampleTable.this));
                }
                case 4: {
                    return Integer.toString(callCountItem.getCallCount());
                }
                case 5: {
                    return SampleTable.pFormat((double)callCountItem.getOnStackCount() / (double)SampleTable.ra$nCalls(SampleTable.this));
                }
                case 6: {
                    return Integer.toString(callCountItem.getOnStackCount());
                }
            }
            return null;
        }
    }

    public final class 4
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                SampleTable.ra$table(SampleTable.this).requestFocus();
                Context context = SampleTable.this.getContext(mouseEvent);
                JProfiler.contextMenu.show(context);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                SampleTable.this.findSource();
            }
        }
    }

    public final class 3
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (listSelectionModel.isSelectionEmpty()) {
                SampleTable.wa$currentItem(SampleTable.this, null);
                SampleTable.ra$methodNameLabel(SampleTable.this).setText("");
                SampleTable.ra$onTopFreq(SampleTable.this).setText("");
                SampleTable.ra$onTopTime(SampleTable.this).setText("");
                SampleTable.ra$methodFreq(SampleTable.this).setText("");
                SampleTable.ra$methodTime(SampleTable.this).setText("");
                SampleTable.ra$methodCumFreq(SampleTable.this).setText("");
                SampleTable.ra$methodCumTime(SampleTable.this).setText("");
                SampleTable.ra$callerDataModel(SampleTable.this).fireTableDataChanged();
                SampleTable.ra$calledDataModel(SampleTable.this).fireTableDataChanged();
            } else {
                int n = listSelectionModel.getMinSelectionIndex();
                SampleTable.wa$currentItem(SampleTable.this, SampleTable.ra$methodArray(SampleTable.this)[n]);
                SampleTable.ra$currentItem(SampleTable.this).sortCalls();
                SampleTable.ra$methodNameLabel(SampleTable.this).setText(SampleTable.ra$currentItem(SampleTable.this).getPseudoClass() + "." + SampleTable.ra$currentItem(SampleTable.this).getPseudoName() + SampleTable.ra$currentItem(SampleTable.this).getNiceSignature());
                SampleTable.ra$onTopFreq(SampleTable.this).setText(SampleTable.pFormat((double)SampleTable.ra$currentItem(SampleTable.this).getCallCount() / (double)SampleTable.ra$currentItem((SampleTable)SampleTable.this).calledTotal));
                SampleTable.ra$onTopTime(SampleTable.this).setText(ProfArb.format(320, Integer.toString(SampleTable.ra$currentItem(SampleTable.this).getCallCount())));
                SampleTable.ra$methodFreq(SampleTable.this).setText(SampleTable.pFormat((double)SampleTable.ra$currentItem(SampleTable.this).getCallCount() / (double)SampleTable.ra$nCalls(SampleTable.this)));
                SampleTable.ra$methodTime(SampleTable.this).setText(ProfArb.format(320, Integer.toString(SampleTable.ra$currentItem(SampleTable.this).getCallCount())));
                SampleTable.ra$methodCumFreq(SampleTable.this).setText(SampleTable.pFormat((double)SampleTable.ra$currentItem(SampleTable.this).getOnStackCount() / (double)SampleTable.ra$nCalls(SampleTable.this)));
                SampleTable.ra$methodCumTime(SampleTable.this).setText(ProfArb.format(320, Integer.toString(SampleTable.ra$currentItem(SampleTable.this).getOnStackCount())));
                SampleTable.ra$callerDataModel(SampleTable.this).fireTableDataChanged();
                SampleTable.ra$calledDataModel(SampleTable.this).fireTableDataChanged();
            }
        }
    }

    public class MyAction
    extends AbstractAction {
        JButton _src;

        MyAction(JButton jButton) {
            this._src = jButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SampleTable.mav$whenActionPerformed(SampleTable.this, this._src);
        }
    }

    public final class 2
    extends MouseAdapter {
        private final /* synthetic */ JTable v$tableView;
        final /* synthetic */ SampleTable this$0;

        public void mouseClicked(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = this.v$tableView.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = this.v$tableView.convertColumnIndexToModel(n);
            if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                SampleTable.mav$sortArray(this.this$0, n2);
                SampleTable.mav$selectByObject(this.this$0, SampleTable.ra$currentItem(this.this$0));
            }
        }

        public 2(SampleTable sampleTable, JTable jTable) {
            this.v$tableView = jTable;
            this.this$0 = sampleTable;
        }
    }

    public final class 1
    extends DefaultTableCellRenderer {
        private int _col;

        public String getToolTipText(MouseEvent mouseEvent) {
            if (SampleTable.ra$process(SampleTable.this).isPopupActive()) {
                return null;
            }
            switch (this._col) {
                case 0: {
                    return ProfArb.getString(183);
                }
                case 1: {
                    return ProfArb.getString(184);
                }
                case 2: {
                    return ProfArb.getString(185);
                }
                case 3: {
                    return ProfArb.getString(186);
                }
                case 4: {
                    return ProfArb.getString(187);
                }
                case 5: {
                    return ProfArb.getString(188);
                }
                case 6: {
                    return ProfArb.getString(189);
                }
            }
            return "";
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3;
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
            }
            this._col = n3 = jTable.convertColumnIndexToModel(n2);
            if (n3 == SampleTable.this.compareField) {
                if (SampleTable.this.ascending) {
                    this.setIcon(SampleTable.ra$arrowUp());
                } else {
                    this.setIcon(SampleTable.ra$arrowDown());
                }
            } else {
                this.setIcon(null);
            }
            this.setText((String)object);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    public class SampleComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            int n;
            CallCountItem callCountItem = (CallCountItem)object;
            CallCountItem callCountItem2 = (CallCountItem)object2;
            switch (SampleTable.this.compareField) {
                default: {
                    n = callCountItem.getPseudoClass().compareTo(callCountItem2.getPseudoClass());
                    break;
                }
                case 1: {
                    n = callCountItem.getPseudoName().compareTo(callCountItem2.getPseudoName());
                    break;
                }
                case 2: {
                    n = callCountItem.getNiceSignature().compareTo(callCountItem2.getNiceSignature());
                    break;
                }
                case 3: 
                case 4: {
                    n = callCountItem.getCallCount() - callCountItem2.getCallCount();
                    break;
                }
                case 5: 
                case 6: {
                    n = callCountItem.getOnStackCount() - callCountItem2.getOnStackCount();
                }
            }
            if (!SampleTable.this.ascending) {
                n = 0 - n;
            }
            return n;
        }

        SampleComparator() {
        }
    }
}

