/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import javax.swing.tree.DefaultMutableTreeNode;
import oracle.jdevimpl.runner.profile.VMMethod;
import oracle.jdevimpl.runner.profile.VMTypes;

class VMCallStackItem
extends VMTypes {
    private VMMethod method;
    private VMCallStackItem parent;
    private long startTime;
    private long endTime;
    private long executionTime;
    private long startExecutionTime;
    public DefaultMutableTreeNode node;

    public VMCallStackItem(VMCallStackItem vMCallStackItem, VMMethod vMMethod, long l) {
        this.parent = vMCallStackItem;
        this.method = vMMethod;
        this.startExecutionTime = this.startTime = l;
        this.node = new DefaultMutableTreeNode(vMMethod);
    }

    public VMCallStackItem getParent() {
        return this.parent;
    }

    public VMMethod getMethod() {
        return this.method;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public String toString() {
        return this.method.toString();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long l) {
        this.endTime = l;
    }

    public long getElapsedTime() {
        return this.endTime - this.startTime;
    }

    public void stopExecution(long l) {
        this.executionTime += l - this.startExecutionTime;
    }

    public void startExecution(long l) {
        this.startExecutionTime = l;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }
}

