/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import oracle.jdevimpl.runner.profile.VMTypes;

class VMClass
extends VMTypes
implements Comparable {
    public int classDescriptor;
    public String packageName;
    public String fullName;
    public String fileName;
    public int methodCount;
    public List methodArray;
    public int nAllocations;
    public int allocSize;
    static int compareField;
    static boolean ascending;

    public String getInternalName() {
        if (!this.packageName.equals("")) {
            return this.packageName + '.' + this.name;
        }
        return this.name;
    }

    public void saveToFile(DataOutputStream dataOutputStream) throws IOException {
        super.saveToFile(dataOutputStream);
        dataOutputStream.writeInt(this.classDescriptor);
        dataOutputStream.writeUTF(this.packageName);
        dataOutputStream.writeUTF(this.fileName);
    }

    void initFromFile(DataInputStream dataInputStream) throws IOException {
        super.initFromFile(dataInputStream);
        this.classDescriptor = dataInputStream.readInt();
        this.packageName = dataInputStream.readUTF();
        this.fileName = dataInputStream.readUTF();
    }

    public static VMClass readFromFile(DataInputStream dataInputStream) throws IOException {
        VMClass vMClass = new VMClass();
        vMClass.initFromFile(dataInputStream);
        return vMClass;
    }

    public String toString() {
        if (this.fullName == null) {
            String string = this.getInternalName();
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer2 = new StringBuffer();
            if (cArray[0] != '[') {
                this.fullName = string;
            } else {
                int n = 0;
                while (cArray[n] == '[') {
                    stringBuffer2.append("[]");
                    ++n;
                }
                switch (cArray[n]) {
                    case 'Z': {
                        stringBuffer.append("boolean");
                        break;
                    }
                    case 'B': {
                        stringBuffer.append("byte");
                        break;
                    }
                    case 'C': {
                        stringBuffer.append("char");
                        break;
                    }
                    case 'S': {
                        stringBuffer.append("short");
                        break;
                    }
                    case 'I': {
                        stringBuffer.append("int");
                        break;
                    }
                    case 'F': {
                        stringBuffer.append("float");
                        break;
                    }
                    case 'J': {
                        stringBuffer.append("long");
                        break;
                    }
                    case 'D': {
                        stringBuffer.append("double");
                        break;
                    }
                    case 'L': {
                        ++n;
                        while (cArray[n] != ';') {
                            stringBuffer.append(cArray[n]);
                            ++n;
                        }
                        break;
                    }
                }
                stringBuffer.append(stringBuffer2);
                this.fullName = new String(stringBuffer);
            }
        }
        return this.fullName;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public Iterator getChildren() {
        if (this.methodArray == null || this.methodArray.size() == 0) {
            return null;
        }
        return this.methodArray.iterator();
    }

    public int compareTo(Object object) {
        VMClass vMClass = (VMClass)object;
        int n = 0;
        switch (compareField) {
            case 0: {
                n = this.packageName.compareTo(vMClass.packageName);
                if (n != 0) break;
            }
            case 1: {
                n = this.name.compareTo(vMClass.name);
                break;
            }
            case 2: {
                n = this.nAllocations - vMClass.nAllocations;
                break;
            }
            case 3: {
                n = this.allocSize - vMClass.allocSize;
            }
        }
        if (!ascending) {
            n = 0 - n;
        }
        return n;
    }

    VMClass() {
    }
}

