/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.profile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.ide.util.IntHashMap;
import oracle.jdevimpl.runner.profile.VMClass;
import oracle.jdevimpl.runner.profile.VMTypes;

class VMMethod
extends VMTypes
implements Comparable {
    public VMClass clazz;
    public int methodDescriptor;
    public String signature;
    public String niceSignature;
    public int firstLine;
    public int lastLine;
    public int callCount;
    public long cumulativeTime;
    public long executionTime;
    public long memoryUsed;
    public char returnType;
    static int compareField;
    static boolean ascending;

    public VMMethod() {
    }

    public VMMethod(VMClass vMClass, String string, String string2, int n) {
        this.clazz = vMClass;
        this.name = string;
        this.signature = string2;
        this.returnType = (char)n;
    }

    public void saveToFile(DataOutputStream dataOutputStream) throws IOException {
        super.saveToFile(dataOutputStream);
        dataOutputStream.writeInt(this.methodDescriptor);
        dataOutputStream.writeInt(this.clazz.classDescriptor);
        dataOutputStream.writeUTF(this.signature);
        dataOutputStream.writeInt(this.firstLine);
        dataOutputStream.writeInt(this.lastLine);
        dataOutputStream.writeChar(this.returnType);
    }

    void initFromFile(DataInputStream dataInputStream, IntHashMap intHashMap) throws IOException {
        super.initFromFile(dataInputStream);
        this.methodDescriptor = dataInputStream.readInt();
        this.clazz = (VMClass)intHashMap.get(dataInputStream.readInt());
        this.signature = dataInputStream.readUTF();
        this.firstLine = dataInputStream.readInt();
        this.lastLine = dataInputStream.readInt();
        this.returnType = dataInputStream.readChar();
    }

    public static VMMethod readFromFile(DataInputStream dataInputStream, IntHashMap intHashMap) throws IOException {
        VMMethod vMMethod = new VMMethod();
        vMMethod.initFromFile(dataInputStream, intHashMap);
        return vMMethod;
    }

    public String toString() {
        String string = this.clazz.toString();
        if (string.length() > 0) {
            return this.clazz.toString() + "." + this.name;
        }
        return this.name;
    }

    public String getNiceSignature() {
        if (this.niceSignature == null) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            StringBuffer stringBuffer3 = new StringBuffer(this.signature);
            boolean bl = true;
            String string = "";
            while (bl) {
                char c = stringBuffer3.charAt(0);
                switch (c) {
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'L': 
                    case 'S': 
                    case 'Z': {
                        stringBuffer.append(string);
                    }
                }
                switch (c) {
                    case '(': 
                    case ')': {
                        stringBuffer.append(c);
                        break;
                    }
                    case 'L': {
                        stringBuffer3.deleteCharAt(0);
                        String string2 = new String(stringBuffer3);
                        int n = string2.indexOf(59);
                        int n2 = string2.lastIndexOf(47, n) + 1;
                        stringBuffer.append(string2.substring(n2, n));
                        stringBuffer3.delete(0, n + 1);
                        break;
                    }
                    case '[': {
                        stringBuffer2.append("[]");
                        break;
                    }
                    case ';': {
                        break;
                    }
                    case 'Z': {
                        stringBuffer.append("boolean");
                        break;
                    }
                    case 'B': {
                        stringBuffer.append("byte");
                        break;
                    }
                    case 'C': {
                        stringBuffer.append("char");
                        break;
                    }
                    case 'S': {
                        stringBuffer.append("short");
                        break;
                    }
                    case 'I': {
                        stringBuffer.append("int");
                        break;
                    }
                    case 'F': {
                        stringBuffer.append("float");
                        break;
                    }
                    case 'J': {
                        stringBuffer.append("long");
                        break;
                    }
                    case 'D': {
                        stringBuffer.append("double");
                    }
                }
                switch (c) {
                    case 'L': {
                        stringBuffer.append(stringBuffer2);
                        stringBuffer2 = new StringBuffer();
                        string = ",";
                        break;
                    }
                    case ')': {
                        bl = false;
                        break;
                    }
                    case '(': 
                    case '[': {
                        stringBuffer3.deleteCharAt(0);
                        break;
                    }
                    case ';': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'Z': {
                        stringBuffer.append(stringBuffer2);
                        stringBuffer2 = new StringBuffer();
                        stringBuffer3.deleteCharAt(0);
                        string = ",";
                    }
                }
            }
            this.niceSignature = new String(stringBuffer);
        }
        return this.niceSignature;
    }

    public int compareTo(Object object) {
        int n;
        VMMethod vMMethod = (VMMethod)object;
        switch (compareField) {
            default: {
                n = this.clazz.toString().compareTo(vMMethod.clazz.toString());
                break;
            }
            case 1: {
                n = this.name.compareTo(vMMethod.name);
                break;
            }
            case 2: {
                n = this.callCount - vMMethod.callCount;
                break;
            }
            case 3: {
                n = (int)(this.cumulativeTime - vMMethod.cumulativeTime);
                break;
            }
            case 4: {
                n = (int)(this.executionTime - vMMethod.executionTime);
                break;
            }
            case 5: {
                n = (int)(this.memoryUsed - vMMethod.memoryUsed);
            }
        }
        if (!ascending) {
            n = 0 - n;
        }
        return n;
    }
}

