/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.run;

import java.awt.Component;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeConstants;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.compiler.BuildSystemListener;
import oracle.ide.compiler.BuildSystemVetoException;
import oracle.ide.compiler.Compiler;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.RunnableItem;
import oracle.ide.runner.Runner;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideri.util.Product;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdevimpl.runner.RunManager;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.run.RunArb;
import oracle.jdevimpl.runner.run.RunningProcess;

public final class JRunner
implements MenuListener,
BuildSystemListener,
ViewSelectionListener,
ActiveViewListener,
IdeListener,
Addin,
Observer,
Controller,
ContextMenuListener {
    private static JRunner instance;
    private View activeView;
    private Project activeProject;
    private static final String RUN_PROJECT_CMD_PREFIX = "RunProjectCommand";
    private static final int RUN_PROJECT_CMD_ID;
    private static IdeAction actionRunProject;
    private static IdeAction actionEmpty;
    private static int[] runProjectCmdIds;
    private static final int RUN_SELECTION_CMD_ID;
    private static IdeAction actionRunSelection;
    private static final int CONTEXTMENU_RUN_CMD_ID;
    private static IdeAction actionContextMenuRun;
    public static Component runContextMenu;

    static {
        RUN_PROJECT_CMD_ID = Ide.findOrCreateCmdID((String)RUN_PROJECT_CMD_PREFIX);
        runProjectCmdIds = new int[0];
        RUN_SELECTION_CMD_ID = Ide.findOrCreateCmdID((String)"RunSelectionCommand");
        CONTEXTMENU_RUN_CMD_ID = Ide.findOrCreateCmdID((String)"ContextMenuRun");
    }

    public JRunner() throws SingletonClassException {
        if (instance != null) {
            throw new SingletonClassException("oracle.jdevimpl.runner.run.JRunner");
        }
        instance = this;
    }

    public static JRunner getInstance() {
        return instance;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Context context = contextMenu.getContext();
        View view = context.getView();
        if (view instanceof NavigatorWindow) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            this.insertRunnableItems(contextMenu, context);
        } else if (view instanceof Editor) {
            if (context.getElement() == null && context.getNode() == null) {
                return;
            }
            this.insertRunnableItems(contextMenu, context);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
        RunnableItem.reset();
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void insertRunnableItems(ContextMenu contextMenu, Context context) {
        if (actionContextMenuRun == null) {
            actionContextMenuRun = IdeAction.get((int)CONTEXTMENU_RUN_CMD_ID, null, (String)RunArb.getString(8), null, (Integer)RunArb.getInteger(9), (ArrayResourceBundle)RunArb.getInstance(), (int)10, null, (boolean)false);
            actionContextMenuRun.addController((Controller)this);
        }
        actionContextMenuRun.putValue("UserData", (Object)context);
        this.update(actionContextMenuRun, context);
        if (actionContextMenuRun.isEnabled()) {
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)actionContextMenuRun, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE);
            contextMenu.add((Component)jMenuItem, JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
        } else {
            actionContextMenuRun.putValue("UserData", null);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == RUN_PROJECT_CMD_ID) {
            this.startProcess(null);
            return true;
        }
        if (RunManager.arrayContains(runProjectCmdIds, n)) {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)ideAction.getValue("UserData"));
            RunConfigurations.setActiveRunConfiguration(this.activeProject, runConfiguration);
            this.startProcess(null);
            return true;
        }
        if (n == RUN_SELECTION_CMD_ID) {
            this.startProcess(context);
            return true;
        }
        if (n == CONTEXTMENU_RUN_CMD_ID) {
            context = (Context)ideAction.getValue("UserData");
            ideAction.putValue("UserData", null);
            this.startProcess(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == RUN_PROJECT_CMD_ID) {
            this.updateRunProjectAction(ideAction);
            return true;
        }
        if (RunManager.arrayContains(runProjectCmdIds, n)) {
            RunConfiguration runConfiguration = (RunConfiguration)((Object)ideAction.getValue("UserData"));
            boolean bl = RunConfigurations.isActiveRunConfiguration(this.activeProject, runConfiguration);
            ideAction.setState(bl);
            return true;
        }
        if (n == RUN_SELECTION_CMD_ID) {
            this.updateRunSelectionAction(ideAction, context);
            return true;
        }
        if (n == CONTEXTMENU_RUN_CMD_ID) {
            context = (Context)ideAction.getValue("UserData");
            this.updateContextMenuRunAction(ideAction, context);
            return true;
        }
        return false;
    }

    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        if (this.activeView != null) {
            this.activeView.removeViewSelectionListener((ViewSelectionListener)this);
        }
        this.activeView = Ide.getMainWindow().getLastActiveView();
        if (this.activeView != null) {
            this.activeView.addViewSelectionListener((ViewSelectionListener)this);
        }
        this.updateRunActions();
    }

    public void viewSelectionChanged(ViewSelectionEvent viewSelectionEvent) {
        this.updateRunActions();
    }

    public void update(Object object, UpdateMessage updateMessage) {
        4 var3_3 = new 4(this, updateMessage, object);
        if (SwingUtilities.isEventDispatchThread()) {
            var3_3.run();
        } else {
            SwingUtilities.invokeLater(var3_3);
        }
    }

    public void addinsLoaded(IdeEvent ideEvent) {
    }

    public void mainWindowOpened(IdeEvent ideEvent) {
        Ide.removeIdeListener((IdeListener)this);
        this.activeViewChanged(null);
        this.activeProjectChanged();
        Ide.getSystem().attach((Observer)this);
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            compiler.addBuildSystemListener((BuildSystemListener)this);
        }
        NavigatorManager.getWorkspaceNavigatorManager().addContextMenuListener((ContextMenuListener)this, null);
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)this);
        Project.addProjectChangeListener((String)"", (ProjectChangeListener)new 3());
    }

    public void mainWindowClosing(IdeEvent ideEvent) {
        Ide.getSystem().detach((Observer)this);
        Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null) {
            compiler.removeBuildSystemListener((BuildSystemListener)this);
        }
        NavigatorManager.getWorkspaceNavigatorManager().removeContextMenuListener((ContextMenuListener)this);
        EditorManager.getEditorManager().getContextMenu().removeContextMenuListener((ContextMenuListener)this);
    }

    public void initialize() {
        this.makeActionsAndMenus();
        this.declareShortcuts();
        Runner.getRunner().getRunMenu().addMenuListener(this);
        Ide.addIdeListener((IdeListener)this);
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuSelected(MenuEvent menuEvent) {
        JMenu jMenu;
        Object object = menuEvent.getSource();
        if (object == (jMenu = Runner.getRunner().getRunMenu())) {
            jMenu.removeMenuListener(this);
            JRunner.addRunMenuItems(jMenu);
        }
    }

    public void buildWillStart(Context context) throws BuildSystemVetoException {
        SwingUtilities.invokeLater(new 2());
    }

    public void buildFinished(int n, int n2, int n3) throws BuildSystemVetoException {
        new 1("JRunnerWaitForCompiler").start();
    }

    private void makeActionsAndMenus() {
        JMenu jMenu = Runner.getRunner().getRunMenu();
        String string = jMenu.getText();
        Menubar menubar = Ide.getMenubar();
        int n = Ide.findOrCreateCmdID((String)"RunProjectCommandEmpty");
        actionEmpty = IdeAction.get((int)n, null, (String)RunMgrArb.getString(2), (String)string, null, null, null, (boolean)false);
        actionRunProject = IdeAction.get((int)RUN_PROJECT_CMD_ID, null, (String)RunArb.getString(0), (String)string, (Integer)RunArb.getInteger(2), (ArrayResourceBundle)RunArb.getInstance(), (int)3, null, (boolean)false);
        actionRunProject.putValue("NoCtxName", (Object)RunArb.getString(0));
        actionRunProject.addController((Controller)this);
        actionRunProject.putValue("ActionMenuActions", (Object)new IdeAction[]{actionEmpty});
        actionRunSelection = IdeAction.get((int)RUN_SELECTION_CMD_ID, null, (String)RunArb.getString(4), (String)string, (Integer)RunArb.getInteger(6), null, null, (boolean)false);
        actionRunSelection.putValue("NoCtxName", (Object)RunArb.getString(4));
        actionRunSelection.addController((Controller)this);
    }

    private static void addRunMenuItems(JMenu jMenu) {
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)actionRunProject, JDeveloperMenuConstants.WEIGHT_RUN_RUN_PROJECT);
        if (!Product.isRaptor()) {
            menubar.add((Component)jMenuItem, jMenu, 1.0f);
        }
        JMenuItem jMenuItem2 = menubar.createMenuItem((ToggleAction)actionRunSelection, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE);
        menubar.add((Component)jMenuItem2, jMenu, 1.0f);
    }

    private void declareShortcuts() {
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/runner/run/accelerators.xml");
    }

    private void updateIfVisible(IdeAction ideAction, Context[] contextArray) {
        int n = ideAction.getCommandId();
        if (n == RUN_PROJECT_CMD_ID) {
            if (contextArray[0] == null) {
                contextArray[0] = Ide.getMainWindow().getLastActiveView().getContext();
            }
            this.update(ideAction, contextArray[0]);
        }
    }

    private void updateRunActions() {
        Context[] contextArray = new Context[1];
        this.updateIfVisible(actionRunProject, contextArray);
        this.updateIfVisible(actionRunSelection, contextArray);
    }

    private void updateRunProjectAction(IdeAction ideAction) {
        String string;
        ideAction.setEnabled(this.canStartProcess(null));
        Project project = Ide.getActiveProject();
        if (project != null) {
            String string2 = project.getShortLabel();
            string = RunArb.format(1, string2);
        } else {
            string = RunArb.getString(0);
        }
        ideAction.putValue("Name", (Object)string);
    }

    private void updateRunSelectionAction(IdeAction ideAction, Context context) {
        String string;
        Node node = RunProcess.getContextNodeForRun((Context)context);
        if (node instanceof Project) {
            ideAction.setEnabled(false);
            ideAction.putValue("Name", (Object)RunArb.getString(4));
            return;
        }
        ideAction.setEnabled(this.canStartProcess(context));
        if (node != null && Runner.getRunner().couldNodeBeRunnable(node)) {
            String string2 = node.getShortLabel();
            string = RunArb.format(5, string2);
        } else {
            string = RunArb.getString(4);
        }
        ideAction.putValue("Name", (Object)string);
    }

    private void updateContextMenuRunAction(IdeAction ideAction, Context context) {
        ideAction.setEnabled(Runner.getRunner().enableRunDebugActions(context, null) && this.canStartProcess(context));
    }

    private boolean canStartProcess(Context context) {
        Node node;
        Compiler compiler = Compiler.getCompiler();
        if (compiler != null && compiler.isBusy(null)) {
            return false;
        }
        if (context != null && (node = RunProcess.getContextNodeForRun((Context)context)) instanceof Project && node == context.getProject()) {
            context = null;
        }
        boolean bl = false;
        if (context != null) {
            bl = this.isContextNodeRunnable(context);
        } else if (Ide.getActiveProject() != null) {
            bl = true;
        } else {
            Context context2 = new Context(Ide.getMainWindow().getLastActiveView().getContext());
            if (context2 != null) {
                bl = this.isContextNodeRunnable(context2);
            }
        }
        return bl;
    }

    private boolean isContextNodeRunnable(Context context) {
        Node node = RunProcess.getContextNodeForRun((Context)context);
        return node != null && Runner.getRunner().couldNodeBeRunnable(node);
    }

    public void startProcess() {
        System.out.println("Please use oracle.jdeveloper.runner.EmbeddedServer instead of JRunner.startProcess");
        this.startProcess(null);
    }

    public void startProcess(Context context) {
        RunningProcess runningProcess = this.createRunningProcess(context);
        runningProcess.start();
    }

    private RunningProcess createRunningProcess(Context context) {
        Project project = Ide.getActiveProject();
        if (project != null && context != null && RunProcess.getContextNodeForRun((Context)context) == project) {
            context = null;
        }
        if (context != null) {
            Workspace workspace = context.getWorkspace();
            Project project2 = context.getProject();
            if (workspace == null || project2 == null) {
                workspace = Ide.getActiveWorkspace();
                project2 = project;
            }
            context.setWorkspace(workspace);
            context.setProject(project2);
        }
        RunningProcess runningProcess = new RunningProcess(context);
        return runningProcess;
    }

    private void activeProjectChanged() {
        this.activeProject = Ide.getActiveProject();
        this.updateRunConfigurationList();
        this.updateRunActions();
    }

    private void updateRunConfigurationList() {
        RunConfigurations runConfigurations;
        RunConfiguration[] runConfigurationArray;
        int n;
        IdeAction[] ideActionArray = null;
        if (this.activeProject != null && this.activeProject.isOpen() && (n = (runConfigurationArray = (runConfigurations = RunConfigurations.getInstance((PropertyStorage)this.activeProject)).getVisibleRunConfigurations()).length) > 0) {
            runProjectCmdIds = new int[n];
            ideActionArray = new IdeAction[n];
            String string = Runner.getRunner().getRunMenu().getText();
            Context context = Ide.getMainWindow().getLastActiveView().getContext();
            int n2 = 0;
            while (n2 < n) {
                RunConfiguration runConfiguration = runConfigurationArray[n2];
                String string2 = runConfiguration.getName();
                int n3 = Ide.findOrCreateCmdID((String)(RUN_PROJECT_CMD_PREFIX + n2));
                IdeAction ideAction = IdeAction.get((int)n3, null, (String)string2, (String)string, null, null, (Object)((Object)runConfiguration), (boolean)true);
                ideAction.putValue("Name", (Object)string2);
                ideAction.putValue("UserData", (Object)runConfiguration);
                ideAction.putValue("Radio", (Object)Boolean.TRUE);
                ideAction.addController((Controller)this);
                JRunner.runProjectCmdIds[n2] = n3;
                ideActionArray[n2] = ideAction;
                this.update(ideAction, context);
                ++n2;
            }
        }
        if (ideActionArray == null) {
            runProjectCmdIds = new int[0];
            ideActionArray = new IdeAction[]{actionEmpty};
        }
        int n4 = ideActionArray.length;
        IdeAction[] ideActionArray2 = new IdeAction[n4 + 2];
        System.arraycopy(ideActionArray, 0, ideActionArray2, 0, n4);
        ideActionArray = ideActionArray2;
        ideActionArray[n4++] = null;
        ideActionArray[n4++] = RunManager.getManageRunConfigurationsAction();
        actionRunProject.putValue("ActionMenuActions", (Object)ideActionArray);
    }

    public Action getActionRunProject() {
        return actionRunProject;
    }

    static void mav$activeProjectChanged(JRunner jRunner) {
        jRunner.activeProjectChanged();
    }

    static Project ra$activeProject(JRunner jRunner) {
        return jRunner.activeProject;
    }

    static void mav$updateRunConfigurationList(JRunner jRunner) {
        jRunner.updateRunConfigurationList();
    }

    static void mav$updateRunActions(JRunner jRunner) {
        jRunner.updateRunActions();
    }

    public final class 4
    implements Runnable {
        private final /* synthetic */ UpdateMessage v$change;
        private final /* synthetic */ Object v$observed;
        final /* synthetic */ JRunner this$0;

        public void run() {
            int n = this.v$change.getMessageID();
            if (this.v$observed == Ide.getSystem() && n == IdeConstants.ACTIVE_PROJECT_CHANGED) {
                JRunner.mav$activeProjectChanged(this.this$0);
            }
        }

        public 4(JRunner jRunner, UpdateMessage updateMessage, Object object) {
            this.v$observed = object;
            this.v$change = updateMessage;
            this.this$0 = jRunner;
        }
    }

    public final class 3
    extends ProjectChangeListener {
        public void projectOpened(Project project) {
            if (project == JRunner.ra$activeProject(JRunner.this)) {
                this.updateNowOrLater();
            }
        }

        public void projectPropertiesChanged(ProjectChangeEvent projectChangeEvent) {
            if (projectChangeEvent.getProject() == JRunner.ra$activeProject(JRunner.this)) {
                this.updateNowOrLater();
            }
        }

        private void updateNowOrLater() {
            1 var1_1 = new 1();
            if (SwingUtilities.isEventDispatchThread()) {
                var1_1.run();
            } else {
                SwingUtilities.invokeLater(var1_1);
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                JRunner.mav$updateRunConfigurationList(JRunner.this);
            }
        }
    }

    public final class 2
    implements Runnable {
        public void run() {
            JRunner.mav$updateRunActions(JRunner.this);
        }
    }

    public final class oracle.jdevimpl.runner.run.JRunner$1
    extends Thread {
        public void run() {
            try {
                UnifiedBuildSystem.getInstance().join(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new 1());
        }

        public oracle.jdevimpl.runner.run.JRunner$1(String string) {
            super(string);
        }

        public final class 1
        implements Runnable {
            public void run() {
                JRunner.mav$updateRunActions(JRunner.this);
            }
        }
    }
}

