/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.run;

import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.help.HelpInfo;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.model.Node;
import oracle.ide.resource.IdeArb;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdevimpl.runner.debug.DebugWindowSettings;
import oracle.jdevimpl.runner.run.RunArb;

public class RunningProcess
extends JRunProcess {
    private static Controller controller;
    private static IdeAction actionTerminate;
    private static final int TERMINATE_CMD_ID;
    private DebugWindowSettings debugWindowSettings;
    private ChangeListener changeListener;
    private Toolbar logPageToolbar;
    private boolean logPageToolbarSet;
    private static HelpInfo helpInfo;

    static {
        TERMINATE_CMD_ID = Ide.findOrCreateCmdID((String)"RunTerminateProcessCommand");
    }

    public RunningProcess(Context context) {
        super(context);
    }

    public boolean canRun(String string, Object object, Node node, List list) {
        return true;
    }

    public String getProcessLabelPrefix() {
        return RunArb.getString(16);
    }

    public Icon getIcon() {
        return RunArb.getIcon(17);
    }

    public HelpInfo getHelpInfo() {
        if (helpInfo == null) {
            helpInfo = new HelpInfo("f1_run_log_runnerprocess_html");
        }
        return helpInfo;
    }

    protected boolean startTarget() {
        if (super.startTarget()) {
            RunningProcess.makeActions();
            this.setToolbar();
            return true;
        }
        return false;
    }

    public void finished() {
        this.removeToolbar();
        super.finished();
    }

    private static Controller makeController() {
        return new 2();
    }

    private static synchronized void makeActions() {
        if (controller != null) {
            return;
        }
        controller = RunningProcess.makeController();
        actionTerminate = IdeAction.get((int)TERMINATE_CMD_ID, null, (String)IdeArb.getString((int)148), null, (Integer)IdeArb.getInteger((int)149), (ArrayResourceBundle)IdeArb.getInstance(), (int)150, null, (boolean)false);
        actionTerminate.addController(controller);
    }

    private void setToolbar() {
        this.debugWindowSettings = DebugWindowSettings.getInstance();
        this.changeListener = new 1();
        this.debugWindowSettings.addChangeListener(this.changeListener);
        this.logPageToolbarSet = true;
        LogPage logPage = this.getLogPage();
        if (logPage instanceof RunLogPage) {
            RunLogPage runLogPage = (RunLogPage)logPage;
            boolean bl = this.debugWindowSettings.isShowToolbarInLogWindow();
            runLogPage.setNorthComponent((Component)(bl ? this.getLogPageToolbar() : null));
        }
    }

    private void removeToolbar() {
        this.debugWindowSettings.removeChangeListener(this.changeListener);
        this.changeListener = null;
        this.debugWindowSettings = null;
        this.logPageToolbarSet = false;
        LogPage logPage = this.getLogPage();
        if (logPage instanceof RunLogPage) {
            RunLogPage runLogPage = (RunLogPage)logPage;
            runLogPage.setNorthComponent(null);
        }
        this.clearLogPageToolbar();
    }

    private void updateToolbarVisibility() {
        LogPage logPage;
        if (this.logPageToolbarSet && (logPage = this.getLogPage()) instanceof RunLogPage) {
            RunLogPage runLogPage = (RunLogPage)logPage;
            boolean bl = this.debugWindowSettings.isShowToolbarInLogWindow();
            runLogPage.setNorthComponent((Component)(bl ? this.getLogPageToolbar() : null));
        }
    }

    private Toolbar getLogPageToolbar() {
        if (this.logPageToolbar == null) {
            this.logPageToolbar = new Toolbar();
            this.logPageToolbar.add((ToggleAction)actionTerminate);
            this.logPageToolbar.validate();
        }
        return this.logPageToolbar;
    }

    private void clearLogPageToolbar() {
        if (this.logPageToolbar != null) {
            this.logPageToolbar.dispose();
            this.logPageToolbar.removeAll();
            this.logPageToolbar.validate();
            this.logPageToolbar = null;
        }
    }

    static int ra$TERMINATE_CMD_ID() {
        return TERMINATE_CMD_ID;
    }

    static void mav$updateToolbarVisibility(RunningProcess runningProcess) {
        runningProcess.updateToolbarVisibility();
    }

    public static final class 2
    implements Controller {
        public boolean update(IdeAction ideAction, Context context) {
            int n;
            RunningProcess runningProcess = this.getRunningProcess(context);
            if (runningProcess != null && (n = ideAction.getCommandId()) == RunningProcess.ra$TERMINATE_CMD_ID()) {
                ideAction.setEnabled(runningProcess.canTerminate());
                return true;
            }
            ideAction.setEnabled(false);
            return true;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n;
            RunningProcess runningProcess = this.getRunningProcess(context);
            if (runningProcess != null && (n = ideAction.getCommandId()) == RunningProcess.ra$TERMINATE_CMD_ID()) {
                runningProcess.terminate();
                return true;
            }
            return true;
        }

        private RunningProcess getRunningProcess(Context context) {
            RunProcess runProcess;
            LogPage logPage;
            LogWindow logWindow;
            View view;
            RunLogPage runLogPage = null;
            if (context != null && (view = context.getView()) instanceof RunLogPage) {
                runLogPage = (RunLogPage)view;
            }
            if (runLogPage == null && (logWindow = LogManager.getLogManager().getLogWindow()) != null && (logPage = logWindow.getPage()) instanceof RunLogPage) {
                runLogPage = (RunLogPage)logPage;
            }
            if (runLogPage != null && (runProcess = runLogPage.getRunProcess()) instanceof RunningProcess) {
                return (RunningProcess)runProcess;
            }
            return null;
        }
    }

    public final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            RunningProcess.mav$updateToolbarVisibility(RunningProcess.this);
        }
    }
}

