/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.comm;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.jdevimpl.runner.uidebug.comm.codec.BufferedImageReader;
import oracle.jdevimpl.runner.uidebug.comm.codec.BufferedImageWriter;

public class DebugStream {
    private static final boolean DEBUG_DATA = false;
    private static final boolean DEBUG_SIZE = false;
    private static final boolean DEBUG_IMAGE = false;
    private static final boolean DEBUG_THREAD = false;
    private static final boolean DEBUG = false;
    private DataInputStream _dis;
    private DataOutputStream _dos;
    private boolean _outputLocked;
    private HashMap _sentClasses;
    private ArrayList _receivedClasses;
    private boolean _rightSide;
    private long _read;
    private long _written;
    private int _nextClassID;

    void $init$() {
        this._sentClasses = new HashMap();
        this._receivedClasses = new ArrayList();
        this._nextClassID = 0;
    }

    public DebugStream(InputStream inputStream, OutputStream outputStream) {
        this.$init$();
        this._dis = new DataInputStream(inputStream);
        this._dos = new DataOutputStream(new BufferedOutputStream(outputStream));
    }

    public void writeHandshake() throws IOException {
        this.writeInt(91765);
        this.writeInt(3);
        this.flush();
    }

    public void readHandshake() throws IOException {
        int n = this.readInt();
        if (n != 91765) {
            throw new IllegalStateException("Invalid magic number");
        }
        int n2 = this.readInt();
        if (n2 != 3) {
            throw new IllegalStateException("Invalid protocol version");
        }
    }

    private void debugPrint(String string) {
        this.debugPrint(string, 0, 0);
    }

    private void debugPrint(String string, int n, int n2) {
        boolean bl = false;
    }

    private void checkThread() {
    }

    public void setSide(boolean bl) {
        this._rightSide = bl;
    }

    public synchronized void beginWriteTransaction() {
        if (this._outputLocked) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._outputLocked = true;
    }

    public synchronized void endWriteTransaction() {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this._outputLocked = false;
        this.notify();
    }

    public final void flush() throws IOException {
        this.debugPrint("flush()");
        this._dos.flush();
    }

    public final int readInt() throws IOException {
        this.debugPrint("readInt()...");
        this.checkThread();
        int n = this._dis.readInt();
        this.debugPrint("readInt() = " + n, 4, 0);
        return n;
    }

    public final void writeInt(int n) throws IOException {
        this.debugPrint("writeInt(" + n + ")", 0, 4);
        this._dos.writeInt(n);
    }

    public final boolean readBoolean() throws IOException {
        this.debugPrint("readBoolean()...");
        this.checkThread();
        boolean bl = this._dis.readBoolean();
        this.debugPrint("readBoolean() = " + bl, 1, 0);
        return bl;
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.debugPrint("writeBoolean(" + bl + ")", 0, 1);
        this._dos.writeBoolean(bl);
    }

    public final String readUTF() throws IOException {
        this.debugPrint("readUTF()...");
        this.checkThread();
        String string = this._dis.readUTF();
        this.debugPrint("readUTF() = " + string, string.length() * 2, 0);
        return string;
    }

    public final void writeUTF(String string) throws IOException {
        this.debugPrint("writeUTF(" + string + ")", 0, string.length() * 2);
        this._dos.writeUTF(string);
    }

    public final byte[] readBytes() throws IOException {
        int n = this.readInt();
        byte[] byArray = new byte[n];
        this._dis.readFully(byArray);
        return byArray;
    }

    public final void writeBytes(byte[] byArray) throws IOException {
        this._dos.writeInt(byArray.length);
        this._dos.write(byArray);
    }

    public final String readClass() throws IOException {
        String string;
        int n = this.readInt();
        if (n >= this._receivedClasses.size()) {
            string = this.readUTF();
            this._receivedClasses.add(string);
        } else {
            string = (String)this._receivedClasses.get(n);
        }
        return string;
    }

    public final void writeClass(String string) throws IOException {
        Integer n = (Integer)this._sentClasses.get(string);
        if (n == null) {
            n = new Integer(this._nextClassID++);
            this._sentClasses.put(string, n);
            this.writeInt(n);
            this.writeUTF(string);
        } else {
            this.writeInt(n);
        }
    }

    public final void writeImage(BufferedImage bufferedImage) throws IOException {
        BufferedImageWriter bufferedImageWriter = new BufferedImageWriter(this._dos);
        bufferedImageWriter.write(bufferedImage);
    }

    public final BufferedImage readImage() throws IOException {
        BufferedImage bufferedImage = null;
        BufferedImageReader bufferedImageReader = new BufferedImageReader(this._dis);
        bufferedImage = bufferedImageReader.read();
        return bufferedImage;
    }
}

